/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.sound;

import com.turborilla.mule.MuleMath;
import com.turborilla.mule.Properties;
import com.turborilla.mule.model.util.AbstractTimer;
import java.util.ArrayList;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lwjgl.openal.AL;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.openal.SoundStore;

public class SoundPlayer {
    private static Logger logger = Logger.getLogger("mule");
    private static SoundPlayer instance;
    private Sound tick;
    private Sound[] transactions;
    private int currentTransaction;
    private Sound auctionStarted;
    private Sound auctionSkipped;
    private Sound transactionEnded;
    private Sound spoilage;
    private Sound claimLand;
    private Sound build;
    private Sound unbuild;
    private Sound countdownTick;
    private Sound countdownGo;
    private Sound buy;
    private Sound sell;
    private Sound buyAssay;
    private Sound buyMule;
    private Sound muleWhinny;
    private Sound outfitMule;
    private Sound stepsMap;
    private Sound stepsShop;
    private Sound pub;
    private Sound assay;
    private Sound assayFinding;
    private Sound assayDigUp;
    private Sound catchWampus;
    private ArrayList<Sound> production;
    private int productionIndex;
    private Sound beginPhase;
    private Sound collectUp;
    private Sound collectDown;
    private Sound showCritical;
    private Sound auctionEnded;
    private Sound playerMessageGood;
    private Sound playerMessageBad;
    private Sound powerUp;
    private Sound powerDown;
    private Sound[] buttonPress;
    private Sound buttonPressFailed;
    private Sound joinGame;
    private Sound shipLanding;
    private Sound shipTakeoff;
    private Sound storm;
    private Sound pest;
    private Sound radiation;
    private Sound fire;
    private Sound meteorTail;
    private Sound meteorImpact;
    private Sound earthquake;
    private Sound pirates;
    private Sound solarWind;
    private Sound moveLandGrant;
    private Sound wampusAppears;
    private Sound newGame;
    private AbstractTimer timer;
    private long lastTickTime = 0L;
    private boolean pitchTick;
    private AbstractTimer countdown;
    private int countdownCount;
    private int countdownStop;
    private float startTickTime = 10.0f;
    private Music introTheme;
    private Music theme;
    private boolean soundOn;
    private long lastUpdateTime = 0L;
    private Random random;

    public static void initialize(boolean bl) throws SlickException {
        logger.info("Initializing Sound System");
        instance = new SoundPlayer(bl, new Random());
    }

    public static SoundPlayer get() {
        return instance;
    }

    public void shutdown() {
        logger.info("Shutting down Sound System");
        org.newdawn.slick.Music.poll(1);
        this.stopAllSounds();
        SoundStore.get().clear();
        AL.destroy();
    }

    private SoundPlayer(boolean bl, Random random) throws SlickException {
        int n;
        SoundStore.get().init();
        SoundStore.get().setDeferredLoading(false);
        this.setSoundsOn(bl);
        this.random = random;
        this.introTheme = new Music("music/mule_theme.ogg");
        this.theme = new Music("music/mule_theme_short.ogg");
        this.tick = new Sound("sounds/klick3.wav");
        this.transactions = new Sound[3];
        for (n = 0; n < this.transactions.length; ++n) {
            this.transactions[n] = new Sound("sounds/found_crystal3.ogg");
        }
        this.currentTransaction = 0;
        this.auctionStarted = new Sound("sounds/auction_hammer.ogg");
        this.auctionSkipped = new Sound("sounds/error_sound1.ogg");
        this.transactionEnded = new Sound("sounds/transaction_ended.ogg");
        this.spoilage = new Sound("sounds/spoilage_sfx.wav");
        this.claimLand = new Sound("sounds/claim_land.ogg");
        this.build = new Sound("sounds/build.ogg");
        this.unbuild = new Sound("sounds/unbuild.ogg");
        this.countdownTick = new Sound("sounds/count.wav");
        this.countdownGo = new Sound("sounds/count_go.wav");
        this.sell = this.buy = new Sound("sounds/buy_registrer.ogg");
        this.buyAssay = new Sound("sounds/buy_assay.ogg");
        this.buyMule = new Sound("sounds/robo_mule1.ogg");
        this.muleWhinny = new Sound("sounds/robo_mule2.ogg");
        this.outfitMule = new Sound("sounds/outfitting_mule_sound_layer_warning.ogg");
        this.stepsMap = new Sound("sounds/steps_outside_loop.ogg");
        this.stepsShop = new Sound("sounds/steps_inside_loop.ogg");
        this.production = new ArrayList();
        for (n = 0; n < 1; ++n) {
            this.production.add(new Sound("sounds/production_alt2.wav"));
        }
        this.beginPhase = new Sound("sounds/error_sound2.ogg");
        this.collectUp = new Sound("sounds/bars_up.ogg");
        this.collectDown = new Sound("sounds/bars_down.ogg");
        this.showCritical = new Sound("sounds/timer_ticking_alt_3.wav");
        this.auctionEnded = new Sound("sounds/auction_bell_ended.wav");
        this.playerMessageGood = new Sound("sounds/winning_tune_1.ogg");
        this.playerMessageBad = new Sound("sounds/loosing_tune_2.ogg");
        this.powerUp = new Sound("sounds/buy_energy.ogg");
        this.powerDown = new Sound("sounds/power_down.ogg");
        this.buttonPress = new Sound[5];
        for (n = 0; n < this.buttonPress.length; ++n) {
            this.buttonPress[n] = new Sound("sounds/press_button.wav");
        }
        this.buttonPressFailed = new Sound("sounds/blip_blop_error_sfx.ogg");
        this.joinGame = new Sound("sounds/found_crystal3.ogg");
        this.pub = new Sound("sounds/pub_gambling_alt.wav");
        this.assay = new Sound("sounds/spinning_flying_bot.ogg");
        this.assayFinding = new Sound("sounds/finding_sfx.ogg");
        this.assayDigUp = new Sound("sounds/found_crystal1.ogg");
        this.catchWampus = new Sound("sounds/catch_wumpus_2.ogg");
        this.shipLanding = new Sound("sounds/ship_landing.ogg");
        this.shipTakeoff = new Sound("sounds/ship_takeoff.ogg");
        this.storm = new Sound("sounds/storm_upgraded.ogg");
        this.pest = new Sound("sounds/vermin_alarm1.ogg");
        this.radiation = new Sound("sounds/radioactivity_mule_go_crazy.ogg");
        this.fire = new Sound("sounds/fire_upgraded.ogg");
        this.meteorTail = new Sound("sounds/meteor_tail.ogg");
        this.meteorImpact = new Sound("sounds/meteor_impact.ogg");
        this.earthquake = new Sound("sounds/earthquake.ogg");
        this.pirates = new Sound("sounds/pirates_ufo.ogg");
        this.solarWind = new Sound("sounds/solar_wind.ogg");
        this.moveLandGrant = new Sound("sounds/timer_ticking_alt_4.wav");
        this.newGame = new Sound("sounds/new_game.ogg");
        this.wampusAppears = this.showCritical;
        this.productionIndex = 0;
    }

    public void stopAllSounds() {
        SoundStore soundStore = SoundStore.get();
        int n = 0;
        while (true) {
            int n2 = -1;
            try {
                n2 = soundStore.getSource(n);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (n2 < 0) break;
            try {
                soundStore.stopSoundEffect(n2);
            }
            catch (Throwable throwable) {
                logger.log(Level.SEVERE, throwable.toString(), throwable);
            }
            ++n;
        }
    }

    public void setSoundsOn(boolean bl) {
        this.soundOn = bl;
        SoundStore.get().setSoundsOn(bl);
        SoundStore.get().setMusicOn(bl);
        if (this.theme != null) {
            try {
                if (bl) {
                    SoundStore.get().setMusicVolume(1.0f);
                    if (this.theme.isPlaying) {
                        this.theme.music.setVolume(1.0f);
                    }
                } else {
                    SoundStore.get().setMusicVolume(0.0f);
                }
            }
            catch (Throwable throwable) {
                logger.log(Level.SEVERE, throwable.toString(), throwable);
            }
        }
    }

    public void update() {
        int n;
        long l = System.currentTimeMillis();
        int n2 = (int)(l - this.lastUpdateTime);
        this.lastUpdateTime = l;
        n2 = MuleMath.clamp(n2, 1, Properties.mule.maxMusicPollMillis);
        org.newdawn.slick.Music.poll(20);
        if (this.timer != null) {
            if (this.timer.isStarted() && !this.timer.isFinished() && !this.timer.isPaused() && this.timer.getTime() < this.startTickTime) {
                float f = (this.startTickTime - this.timer.getTime()) / this.startTickTime;
                long l2 = (long)(250.0f - f * 175.0f);
                if (System.currentTimeMillis() - this.lastTickTime > l2) {
                    if (this.pitchTick) {
                        this.tick.play(0.95f, 0.75f);
                    } else {
                        this.tick.play(1.0f, 0.75f);
                    }
                    this.pitchTick = !this.pitchTick;
                    this.lastTickTime = System.currentTimeMillis();
                }
            } else {
                this.tick.stop();
            }
        }
        if (this.countdown != null && this.countdown.isStarted() && (n = this.countdown.getTimeAsInteger()) >= this.countdownStop && n <= this.countdownCount) {
            this.countdownTick.play();
            this.countdownCount = n - 1;
        }
    }

    public void playIntoTheme() {
        this.introTheme.loop(1.0f, 1.0f);
    }

    public void stopIntroTheme() {
        this.introTheme.stop();
    }

    public void playTheme() {
        this.theme.loop(1.0f, this.soundOn ? 1.0f : 0.0f);
        if (!this.soundOn) {
            try {
                SoundStore.get().setMusicVolume(0.0f);
            }
            catch (Throwable throwable) {
                logger.log(Level.SEVERE, throwable.toString(), throwable);
            }
        }
    }

    public void fadeTheme(int n) {
        if (!this.soundOn) {
            this.theme.stop();
        } else {
            this.theme.fade(n, 0.0f, true);
        }
    }

    public void stopTheme() {
        this.theme.stop();
    }

    public void playPlayerMessageGood() {
        this.playerMessageGood.play();
    }

    public void playPlayerMessageBad() {
        this.playerMessageBad.play();
    }

    public void playCollectUp() {
        this.collectUp.play(1.0f, 0.05f);
    }

    public void stopCollectUp() {
        this.collectUp.stop();
    }

    public void playCollectDown() {
        this.collectDown.play(1.0f, 0.05f);
    }

    public void stopCollectDown() {
        this.collectDown.stop();
    }

    public void stopTicking() {
        this.tick.stop();
        this.timer = null;
    }

    public void playAuctionEnded() {
        this.auctionEnded.play();
    }

    public void playButtonPressSpectator() {
        this.buttonPress[4].play(0.8f, 1.0f);
    }

    public void playButtonPress(int n) {
        float[] fArray = new float[]{0.9f, 1.1f, 1.3f, 1.5f};
        this.buttonPress[n].play(fArray[n], 1.0f);
    }

    public void playPowerUp() {
        this.powerUp.play();
    }

    public void playPowerDown() {
        this.powerDown.play();
    }

    public void playButtonPressFailed() {
        this.buttonPressFailed.play();
    }

    public void playOutfitMule() {
        this.outfitMule.play(1.0f, 5.0f);
    }

    public void stopOutfitMule() {
        this.outfitMule.stop();
    }

    public void playProduction() {
        this.production.get(this.productionIndex).play(1.0f, 0.65f);
        this.productionIndex = (this.productionIndex + 1) % this.production.size();
    }

    public void playBeginPhase() {
        this.beginPhase.play();
    }

    public void playPub() {
        this.pub.play();
    }

    public void playBuy() {
        this.buy.play();
    }

    public void playSell() {
        this.sell.play();
    }

    public void playTransaction(float f) {
        this.transactions[this.currentTransaction].play(f, 1.3f);
        this.currentTransaction = (this.currentTransaction + 1) % this.transactions.length;
    }

    public void playTransactionEnded() {
        this.transactionEnded.play();
    }

    public void loopStepsShop() {
        this.stepsShop.loop(1.0f, 0.75f);
    }

    public void loopStepsMap() {
        this.stepsMap.loop(1.0f, 0.75f);
    }

    public void stopStepsShop() {
        this.stepsShop.stop();
    }

    public void stopStepsMap() {
        this.stepsMap.stop();
    }

    public void loopStepsAuction() {
        this.stepsShop.loop(1.0f, 0.5f);
    }

    public void stopStepsAuction() {
        this.stepsShop.stop();
    }

    public void trackTimer(AbstractTimer abstractTimer, float f) {
        this.timer = abstractTimer;
        this.startTickTime = f;
        this.pitchTick = false;
    }

    public void trackCountdown(AbstractTimer abstractTimer) {
        if (!abstractTimer.isStarted()) {
            logger.severe("Can't track countdown which isn't started.");
        }
        this.trackCountdown(abstractTimer, abstractTimer.getTimeAsInteger());
    }

    public void trackCountdown(AbstractTimer abstractTimer, int n) {
        this.trackCountdown(abstractTimer, n, 0);
    }

    public void trackCountdown(AbstractTimer abstractTimer, int n, int n2) {
        this.countdown = abstractTimer;
        this.countdownCount = n;
        this.countdownStop = n2;
    }

    public boolean isSoundOn() {
        return SoundStore.get().soundsOn();
    }

    public void playStartAuction() {
        this.auctionStarted.play();
    }

    public void playSkipAuction() {
        this.auctionSkipped.play();
    }

    public void playCountdownGo() {
        this.countdownGo.play();
    }

    public void playBuyAssay() {
        this.buyAssay.play();
    }

    public void playCatchWampus() {
        this.catchWampus.play();
    }

    public void playClaimLand() {
        this.claimLand.play();
    }

    public void playBuild() {
        this.build.play();
    }

    public void playUnbuild() {
        this.unbuild.play();
    }

    public void playMuleWhinny() {
        if ((double)this.random.nextFloat() < 0.6) {
            this.muleWhinny.play(1.0f, 0.75f);
        } else {
            this.buyMule.play(1.0f, 0.75f);
        }
    }

    public void playBuyMule() {
        this.buyMule.play(1.0f, 1.5f);
    }

    public void playFreeMule() {
        this.muleWhinny.play(1.1f, 1.5f);
    }

    public void playShipLanding() {
        this.shipLanding.play();
    }

    public void playShipTakeoff() {
        this.shipTakeoff.play();
    }

    public void playPest() {
        this.pest.play();
    }

    public void playStorm() {
        this.storm.play();
    }

    public void playRadiation() {
        this.radiation.play(1.0f, 0.75f);
    }

    public void playFire() {
        this.fire.play();
    }

    public void playMeteorTail() {
        this.meteorTail.play();
    }

    public void playMeteorImpact() {
        this.meteorTail.stop();
        this.meteorImpact.play();
    }

    public void playPirates() {
        this.pirates.play(1.0f, 0.75f);
    }

    public void playEarthquake() {
        this.earthquake.play();
    }

    public void playSolarWind() {
        this.solarWind.play();
    }

    public void playAssay() {
        this.assay.play();
    }

    public void playAssayFinding() {
        this.assayFinding.play();
    }

    public void playAssayDigUp() {
        this.assayDigUp.play();
    }

    public void playSpoilage() {
        this.spoilage.play();
    }

    public void playSpoilageComplete() {
        this.spoilage.play(0.9f, 1.0f);
    }

    public void playJoinGame() {
        this.joinGame.play(1.0f, 0.8f);
    }

    public void playChooseDirection() {
        this.joinGame.play();
    }

    public void playLandBought() {
        this.countdownTick.play(1.5f, 1.0f);
    }

    public void playLandSale() {
        this.countdownGo.play(0.9f, 1.0f);
    }

    public void playShowCritical() {
        this.showCritical.play();
    }

    public void playMoveLandGrant() {
        this.moveLandGrant.play();
    }

    public void playWampusAppeared(float f) {
        float f2 = 1.3f - 0.3f * f / 320.0f;
        this.wampusAppears.play(f2, 0.8f);
    }

    public void playNewGame() {
        this.newGame.play();
    }

    private static class Music {
        private org.newdawn.slick.Music music;
        private boolean isPlaying = false;

        Music(String string) throws SlickException {
            this.music = new org.newdawn.slick.Music(string, true);
        }

        void stop() {
            if (this.isPlaying) {
                try {
                    this.music.setVolume(0.0f);
                    this.music.stop();
                }
                catch (Throwable throwable) {
                    logger.log(Level.SEVERE, throwable.toString(), throwable);
                }
                this.isPlaying = false;
            }
        }

        void play() {
            this.play(1.0f, 1.0f);
        }

        void play(float f, float f2) {
            this.stop();
            try {
                this.music.play(f, f2);
            }
            catch (Throwable throwable) {
                logger.log(Level.SEVERE, throwable.toString(), throwable);
            }
            this.isPlaying = true;
        }

        void loop(float f, float f2) {
            this.stop();
            try {
                this.music.loop(f, f2);
            }
            catch (Throwable throwable) {
                logger.log(Level.SEVERE, throwable.toString(), throwable);
            }
            this.isPlaying = true;
        }

        void fade(int n, float f, boolean bl) {
            if (this.isPlaying) {
                try {
                    this.music.fade(n, f, bl);
                }
                catch (Throwable throwable) {
                    logger.log(Level.SEVERE, throwable.toString(), throwable);
                }
            }
            this.isPlaying = false;
        }
    }

    private static class Sound {
        private org.newdawn.slick.Sound sound;
        private boolean isPlaying;

        public Sound(String string) throws SlickException {
            this.sound = new org.newdawn.slick.Sound(string);
        }

        public void play() {
            this.play(1.0f, 1.0f);
        }

        public void play(float f, float f2) {
            this.stop();
            try {
                this.sound.play(f, f2);
            }
            catch (Throwable throwable) {
                logger.log(Level.SEVERE, throwable.toString(), throwable);
            }
            this.isPlaying = true;
        }

        public void stop() {
            if (this.isPlaying) {
                try {
                    this.sound.stop();
                }
                catch (Throwable throwable) {
                    logger.log(Level.SEVERE, throwable.toString(), throwable);
                }
                this.isPlaying = false;
            }
        }

        public void loop() {
            this.loop(1.0f, 1.0f);
        }

        public void loop(float f, float f2) {
            if (!this.isPlaying) {
                try {
                    this.sound.loop(f, f2);
                }
                catch (Throwable throwable) {
                    logger.log(Level.SEVERE, throwable.toString(), throwable);
                }
                this.isPlaying = true;
            }
        }
    }
}

