/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.network;

import com.turborilla.mule.network.ClientId;
import com.turborilla.mule.network.Message;
import com.turborilla.mule.network.MessageReceiver;
import com.turborilla.mule.view.ActorSprite;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public abstract class UDPMessage
extends Message {
    public static final int MAX_SIZE = 256;

    public void write(ByteBuffer byteBuffer) {
        UDPHeader uDPHeader = new UDPHeader(this);
        uDPHeader.writeTo(byteBuffer);
        this.writeTo(byteBuffer);
    }

    protected abstract void writeTo(ByteBuffer var1) throws BufferOverflowException;

    protected abstract void readFrom(ByteBuffer var1) throws BufferUnderflowException;

    protected abstract UDPMessageType getType();

    public String toString() {
        return this.getType().toString();
    }

    public static class ServerLandGrantMessage
    extends UDPMessage {
        public byte landGrantId;
        public byte plot;
        public int claimer;
        public boolean done;

        public ServerLandGrantMessage(byte by, byte by2, int n, boolean bl) {
            this.landGrantId = by;
            this.plot = by2;
            this.claimer = n;
            this.done = bl;
        }

        private ServerLandGrantMessage() {
        }

        protected UDPMessageType getType() {
            return UDPMessageType.ServerLandGrant;
        }

        protected void readFrom(ByteBuffer byteBuffer) throws BufferUnderflowException {
            this.plot = byteBuffer.get();
            this.claimer = byteBuffer.getInt();
            byte by = byteBuffer.get();
            this.landGrantId = (byte)(by & 0x3F);
            this.done = (by & 0x40) != 0;
        }

        protected void writeTo(ByteBuffer byteBuffer) throws BufferOverflowException {
            byteBuffer.put(this.plot);
            byteBuffer.putInt(this.claimer);
            byte by = this.landGrantId;
            if (this.done) {
                by = (byte)(by | 0x40);
            }
            byteBuffer.put(by);
        }

        public void accept(MessageReceiver messageReceiver) {
            messageReceiver.apply(this);
        }
    }

    public static class PlayerLandGrantMessage
    extends UDPMessage {
        public byte landGrantId;
        public byte plot;
        public short frame;
        public boolean pressed;
        public boolean claimed;

        public PlayerLandGrantMessage(byte by, byte by2, short s, boolean bl, boolean bl2) {
            this.landGrantId = by;
            this.plot = by2;
            this.frame = s;
            this.pressed = bl;
            this.claimed = bl2;
        }

        private PlayerLandGrantMessage() {
        }

        protected UDPMessageType getType() {
            return UDPMessageType.PlayerLandGrant;
        }

        protected void readFrom(ByteBuffer byteBuffer) throws BufferUnderflowException {
            this.plot = byteBuffer.get();
            this.frame = byteBuffer.getShort();
            byte by = byteBuffer.get();
            this.landGrantId = (byte)(by & 0x3F);
            this.pressed = (by & 0x40) != 0;
            this.claimed = (by & 0x80) != 0;
        }

        protected void writeTo(ByteBuffer byteBuffer) throws BufferOverflowException {
            byteBuffer.put(this.plot);
            byteBuffer.putShort(this.frame);
            byte by = this.landGrantId;
            if (this.pressed) {
                by = (byte)(by | 0x40);
            }
            if (this.claimed) {
                by = (byte)(by | 0x80);
            }
            byteBuffer.put(by);
        }

        public void accept(MessageReceiver messageReceiver) {
            messageReceiver.apply(this);
        }
    }

    public static class SynchronizeTimerMessage
    extends UDPMessage {
        public int manager;
        public int id;
        public float time;
        public int roundTripTime;
        public int syncCount;
        public int startCount;

        public SynchronizeTimerMessage(int n, int n2, float f, int n3, int n4, int n5) {
            this.manager = n;
            this.id = n2;
            this.time = f;
            this.roundTripTime = n3;
            this.syncCount = n4;
            this.startCount = n5;
        }

        private SynchronizeTimerMessage() {
        }

        public void readFrom(ByteBuffer byteBuffer) throws BufferOverflowException {
            this.manager = byteBuffer.getInt();
            this.id = byteBuffer.getInt();
            this.time = byteBuffer.getFloat();
            this.roundTripTime = byteBuffer.getInt();
            this.syncCount = byteBuffer.getInt();
            this.startCount = byteBuffer.getInt();
        }

        public void writeTo(ByteBuffer byteBuffer) throws BufferOverflowException {
            byteBuffer.putInt(this.manager);
            byteBuffer.putInt(this.id);
            byteBuffer.putFloat(this.time);
            byteBuffer.putInt(this.roundTripTime);
            byteBuffer.putInt(this.syncCount);
            byteBuffer.putInt(this.startCount);
        }

        protected UDPMessageType getType() {
            return UDPMessageType.SynchronizeTimer;
        }

        public void accept(MessageReceiver messageReceiver) {
            messageReceiver.apply(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TotalAuctionStateMessage
    extends UDPMessage {
        public byte auctionId;
        public int sequenceNumber;
        public boolean allPlayersFinished;
        public ArrayList<PlayerAuctionState> playerStates;

        public TotalAuctionStateMessage(byte by, int n, ArrayList<PlayerAuctionState> arrayList, boolean bl) {
            this.auctionId = by;
            this.sequenceNumber = n;
            this.playerStates = arrayList;
            this.allPlayersFinished = bl;
        }

        private TotalAuctionStateMessage() {
        }

        @Override
        protected UDPMessageType getType() {
            return UDPMessageType.TotalAuctionState;
        }

        @Override
        protected void readFrom(ByteBuffer byteBuffer) throws BufferUnderflowException {
            this.auctionId = byteBuffer.get();
            this.sequenceNumber = byteBuffer.getInt();
            int n = byteBuffer.get();
            this.playerStates = new ArrayList(n);
            for (int i = 0; i < n; ++i) {
                PlayerAuctionState playerAuctionState = new PlayerAuctionState(byteBuffer);
                this.playerStates.add(playerAuctionState);
            }
            this.allPlayersFinished = TotalAuctionStateMessage.getBoolean(byteBuffer);
        }

        @Override
        protected void writeTo(ByteBuffer byteBuffer) throws BufferOverflowException {
            byteBuffer.put(this.auctionId);
            byteBuffer.putInt(this.sequenceNumber);
            byteBuffer.put((byte)this.playerStates.size());
            for (int i = 0; i < this.playerStates.size(); ++i) {
                this.playerStates.get(i).writeTo(byteBuffer);
            }
            TotalAuctionStateMessage.putBoolean(this.allPlayersFinished, byteBuffer);
        }

        @Override
        public void accept(MessageReceiver messageReceiver) {
            messageReceiver.apply(this);
        }

        public static class PlayerAuctionState {
            public int userNumber;
            public int tick;
            public boolean inAuction;
            public boolean isWalking;

            public PlayerAuctionState(int n, int n2, boolean bl, boolean bl2) {
                this.userNumber = n;
                this.tick = n2;
                this.inAuction = bl;
                this.isWalking = bl2;
            }

            public PlayerAuctionState(ByteBuffer byteBuffer) throws BufferUnderflowException {
                this.readFrom(byteBuffer);
            }

            protected void readFrom(ByteBuffer byteBuffer) throws BufferUnderflowException {
                this.userNumber = byteBuffer.getInt();
                this.tick = byteBuffer.getInt();
                byte by = byteBuffer.get();
                this.inAuction = (by & 1) != 0;
                this.isWalking = (by & 2) != 0;
            }

            protected void writeTo(ByteBuffer byteBuffer) throws BufferOverflowException {
                byteBuffer.putInt(this.userNumber);
                byteBuffer.putInt(this.tick);
                byte by = 0;
                if (this.inAuction) {
                    by = (byte)(by | 1);
                }
                if (this.isWalking) {
                    by = (byte)(by | 2);
                }
                byteBuffer.put(by);
            }
        }
    }

    public static class PlayerAuctionStateMessage
    extends UDPMessage {
        public byte auctionId;
        public int sequenceNumber;
        public short transactionCount;
        public byte teleportCount;
        public int tick;
        public boolean inAuction;
        public boolean isWalking;
        public boolean isFinished;

        public PlayerAuctionStateMessage(byte by, int n, short s, byte by2, int n2, boolean bl, boolean bl2, boolean bl3) {
            this.auctionId = by;
            this.sequenceNumber = n;
            this.transactionCount = s;
            this.teleportCount = by2;
            this.tick = n2;
            this.inAuction = bl;
            this.isWalking = bl2;
            this.isFinished = bl3;
        }

        private PlayerAuctionStateMessage() {
        }

        protected UDPMessageType getType() {
            return UDPMessageType.PlayerAuctionPrice;
        }

        protected void readFrom(ByteBuffer byteBuffer) throws BufferUnderflowException {
            this.auctionId = byteBuffer.get();
            this.sequenceNumber = byteBuffer.getInt();
            this.transactionCount = byteBuffer.getShort();
            this.teleportCount = byteBuffer.get();
            this.tick = byteBuffer.getInt();
            byte by = byteBuffer.get();
            this.inAuction = (by & 1) != 0;
            this.isWalking = (by & 2) != 0;
            this.isFinished = (by & 4) != 0;
        }

        protected void writeTo(ByteBuffer byteBuffer) throws BufferOverflowException {
            byteBuffer.put(this.auctionId);
            byteBuffer.putInt(this.sequenceNumber);
            byteBuffer.putShort(this.transactionCount);
            byteBuffer.put(this.teleportCount);
            byteBuffer.putInt(this.tick);
            byte by = 0;
            if (this.inAuction) {
                by = (byte)(by | 1);
            }
            if (this.isWalking) {
                by = (byte)(by | 2);
            }
            if (this.isFinished) {
                by = (byte)(by | 4);
            }
            byteBuffer.put(by);
        }

        public void accept(MessageReceiver messageReceiver) {
            messageReceiver.apply(this);
        }
    }

    public static class PositionMessage
    extends UDPMessage {
        public long frame;
        public float posX;
        public float posY;
        public ActorSprite.Direction dir;
        public boolean inShop;

        public PositionMessage(long l, float f, float f2, ActorSprite.Direction direction, boolean bl) {
            this.frame = l;
            this.posX = f;
            this.posY = f2;
            this.dir = direction;
            this.inShop = bl;
        }

        private PositionMessage() {
        }

        protected UDPMessageType getType() {
            return UDPMessageType.Position;
        }

        public void readFrom(ByteBuffer byteBuffer) throws BufferOverflowException {
            this.frame = byteBuffer.getLong();
            this.posX = byteBuffer.getFloat();
            this.posY = byteBuffer.getFloat();
            this.dir = ActorSprite.Direction.get(byteBuffer.get());
            this.inShop = PositionMessage.getBoolean(byteBuffer);
        }

        public void writeTo(ByteBuffer byteBuffer) throws BufferOverflowException {
            byteBuffer.putLong(this.frame);
            byteBuffer.putFloat(this.posX);
            byteBuffer.putFloat(this.posY);
            byteBuffer.put((byte)this.dir.value);
            PositionMessage.putBoolean(this.inShop, byteBuffer);
        }

        public void accept(MessageReceiver messageReceiver) {
            messageReceiver.apply(this);
        }
    }

    public static class UDPPingMessage
    extends UDPMessage {
        public long timestamp;
        public int roundTripTime;

        public UDPPingMessage(long l, int n) {
            this.timestamp = l;
            this.roundTripTime = n;
        }

        private UDPPingMessage() {
        }

        public void accept(MessageReceiver messageReceiver) {
            throw new RuntimeException("Ping message not handled by MessageReceiver");
        }

        protected UDPMessageType getType() {
            return UDPMessageType.Ping;
        }

        public void readFrom(ByteBuffer byteBuffer) throws BufferOverflowException {
            this.timestamp = byteBuffer.getLong();
            this.roundTripTime = byteBuffer.getInt();
        }

        public void writeTo(ByteBuffer byteBuffer) throws BufferOverflowException {
            byteBuffer.putLong(this.timestamp);
            byteBuffer.putInt(this.roundTripTime);
        }
    }

    public static class UDPInitMessage
    extends UDPMessage {
        public ClientId clientId;

        public UDPInitMessage(ClientId clientId) {
            this.clientId = clientId;
        }

        private UDPInitMessage() {
            this.clientId = ClientId.invalidClientId();
        }

        public void accept(MessageReceiver messageReceiver) {
            messageReceiver.apply(this);
        }

        protected UDPMessageType getType() {
            return UDPMessageType.Init;
        }

        public void readFrom(ByteBuffer byteBuffer) throws BufferOverflowException {
            this.clientId.readFrom(byteBuffer);
        }

        public void writeTo(ByteBuffer byteBuffer) throws BufferOverflowException {
            this.clientId.writeTo(byteBuffer);
        }
    }

    public static class UDPHeader {
        public UDPMessageType type;
        public int userNumber;
        public Message.BroadcastType broadcastType;

        public UDPHeader() {
            this.reset();
        }

        public UDPHeader(UDPMessage uDPMessage) {
            this.type = uDPMessage.getType();
            this.userNumber = uDPMessage.userNumber;
            this.broadcastType = uDPMessage.broadcastType;
        }

        public void reset() {
            this.type = UDPMessageType.Error;
            this.userNumber = 0;
            this.broadcastType = null;
        }

        public boolean isValid() {
            return this.type != UDPMessageType.Error && this.broadcastType != null;
        }

        public void readFrom(ByteBuffer byteBuffer) throws BufferUnderflowException {
            this.type = UDPMessageType.get(byteBuffer.getInt());
            this.userNumber = byteBuffer.getInt();
            this.broadcastType = Message.BroadcastType.get(byteBuffer.get());
        }

        public void writeTo(ByteBuffer byteBuffer) throws BufferOverflowException {
            byteBuffer.putInt(this.type.ordinal());
            byteBuffer.putInt(this.userNumber);
            byteBuffer.put((byte)this.broadcastType.ordinal());
        }

        public UDPMessage createMessage(ByteBuffer byteBuffer) {
            UDPMessage uDPMessage = null;
            switch (this.type) {
                case Position: {
                    uDPMessage = new PositionMessage();
                    break;
                }
                case Init: {
                    uDPMessage = new UDPInitMessage();
                    break;
                }
                case Ping: {
                    uDPMessage = new UDPPingMessage();
                    break;
                }
                case PlayerAuctionPrice: {
                    uDPMessage = new PlayerAuctionStateMessage();
                    break;
                }
                case TotalAuctionState: {
                    uDPMessage = new TotalAuctionStateMessage();
                    break;
                }
                case SynchronizeTimer: {
                    uDPMessage = new SynchronizeTimerMessage();
                    break;
                }
                case PlayerLandGrant: {
                    uDPMessage = new PlayerLandGrantMessage();
                    break;
                }
                case ServerLandGrant: {
                    uDPMessage = new ServerLandGrantMessage();
                    break;
                }
                default: {
                    Message.logger.severe("Unknown message type: " + this.type.toString());
                    return null;
                }
            }
            uDPMessage.userNumber = this.userNumber;
            uDPMessage.broadcastType = this.broadcastType;
            uDPMessage.readFrom(byteBuffer);
            return uDPMessage;
        }

        public String toString() {
            return (Object)((Object)this.type) + " (" + this.userNumber + ")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum UDPMessageType {
        Error,
        Position,
        PlayerAuctionPrice,
        TotalAuctionState,
        PlayerLandGrant,
        ServerLandGrant,
        Init,
        Ping,
        SynchronizeTimer;


        public static UDPMessageType get(int n) {
            UDPMessageType[] uDPMessageTypeArray = UDPMessageType.values();
            if (n < 0 || n >= uDPMessageTypeArray.length) {
                Message.logger.severe("Invalid UDP message type " + n);
                return Error;
            }
            return uDPMessageTypeArray[n];
        }
    }
}

