/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.network;

import com.turborilla.mule.model.Resource;
import com.turborilla.mule.network.ClientId;
import com.turborilla.mule.network.Message;
import com.turborilla.mule.network.MessageReceiver;
import com.turborilla.mule.view.ActorSprite;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public abstract class TCPMessage
extends Message {
    public int write(ByteBuffer byteBuffer) throws BufferOverflowException {
        int n = byteBuffer.position();
        TCPHeader tCPHeader = new TCPHeader(this);
        tCPHeader.writeTo(byteBuffer);
        int n2 = byteBuffer.position();
        this.writeTo(byteBuffer);
        int n3 = byteBuffer.position();
        int n4 = n3 - n2;
        byteBuffer.position(n);
        byteBuffer.putInt(n4);
        byteBuffer.position(n3);
        return n4;
    }

    public ByteBuffer toByteBuffer(int n) {
        if (n < 13) {
            n = 13;
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(n);
        return this.toByteBuffer(byteBuffer);
    }

    public ByteBuffer toByteBuffer(ByteBuffer byteBuffer) {
        while (true) {
            try {
                byteBuffer.clear();
                this.write(byteBuffer);
                byteBuffer.limit(byteBuffer.position());
                byteBuffer.rewind();
            }
            catch (BufferOverflowException bufferOverflowException) {
                int n = 2 * byteBuffer.capacity();
                logger.info("Increasing TCP byte buffer size to " + n);
                byteBuffer = ByteBuffer.allocate(n);
                continue;
            }
            break;
        }
        return byteBuffer;
    }

    protected abstract void writeTo(ByteBuffer var1) throws BufferOverflowException;

    protected abstract void readFrom(ByteBuffer var1) throws BufferUnderflowException;

    protected abstract TCPMessageType getType();

    public Message.BroadcastType getBroadcastType() {
        return this.broadcastType;
    }

    public boolean isLogged() {
        return true;
    }

    public String toString() {
        return this.getType().toString();
    }

    public static class StoreClosedMessage
    extends TCPMessage {
        public void accept(MessageReceiver messageReceiver) {
            messageReceiver.apply(this);
        }

        protected TCPMessageType getType() {
            return TCPMessageType.StoreClosed;
        }

        public void readFrom(ByteBuffer byteBuffer) throws BufferOverflowException {
        }

        public void writeTo(ByteBuffer byteBuffer) throws BufferOverflowException {
        }
    }

    public static class GameSettingsMessage
    extends TCPMessage {
        public boolean fastAIDevelopment;

        public GameSettingsMessage(boolean bl) {
            this.fastAIDevelopment = bl;
        }

        private GameSettingsMessage() {
        }

        protected TCPMessageType getType() {
            return TCPMessageType.GameSettings;
        }

        protected void readFrom(ByteBuffer byteBuffer) throws BufferUnderflowException {
            this.fastAIDevelopment = GameSettingsMessage.getBoolean(byteBuffer);
        }

        protected void writeTo(ByteBuffer byteBuffer) throws BufferOverflowException {
            GameSettingsMessage.putBoolean(this.fastAIDevelopment, byteBuffer);
        }

        public void accept(MessageReceiver messageReceiver) {
            messageReceiver.apply(this);
        }
    }

    public static class SynchronizedCheckMessage
    extends TCPMessage {
        public long checksum;

        public SynchronizedCheckMessage(long l) {
            this.checksum = l;
        }

        SynchronizedCheckMessage() {
        }

        protected TCPMessageType getType() {
            return TCPMessageType.SynchronizedCheck;
        }

        protected void readFrom(ByteBuffer byteBuffer) throws BufferUnderflowException {
            this.checksum = byteBuffer.getLong();
        }

        protected void writeTo(ByteBuffer byteBuffer) throws BufferOverflowException {
            byteBuffer.putLong(this.checksum);
        }

        public void accept(MessageReceiver messageReceiver) {
            messageReceiver.apply(this);
        }

        public boolean isLogged() {
            return false;
        }
    }

    public static class FastDevelopmentMessage
    extends TCPMessage {
        public Action action;
        public Resource resource;
        public int tileX;
        public int tileY;

        public FastDevelopmentMessage(Action action) {
            this(action, null, -1, -1);
        }

        public FastDevelopmentMessage(Action action, Resource resource, int n, int n2) {
            this.action = action;
            this.resource = resource;
            this.tileX = n;
            this.tileY = n2;
        }

        FastDevelopmentMessage() {
        }

        protected TCPMessageType getType() {
            return TCPMessageType.FastDevelopment;
        }

        protected void readFrom(ByteBuffer byteBuffer) throws BufferUnderflowException {
            int n = byteBuffer.getInt();
            int n2 = byteBuffer.getInt();
            this.tileX = byteBuffer.getInt();
            this.tileY = byteBuffer.getInt();
            this.action = Action.values()[n];
            this.resource = n2 == -1 ? null : Resource.values()[n2];
        }

        protected void writeTo(ByteBuffer byteBuffer) throws BufferOverflowException {
            int n = this.action.ordinal();
            int n2 = this.resource == null ? -1 : this.resource.ordinal();
            byteBuffer.putInt(n);
            byteBuffer.putInt(n2);
            byteBuffer.putInt(this.tileX);
            byteBuffer.putInt(this.tileY);
        }

        public void accept(MessageReceiver messageReceiver) {
            messageReceiver.apply(this);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Action {
            PICKUP,
            DEVELOP,
            CATCH_WAMPUS,
            ASSAY,
            GAMBLE;

        }
    }

    public static final class AvatarActionMessage
    extends TCPMessage {
        public boolean up;
        public boolean down;
        public boolean left;
        public boolean right;
        public boolean action;
        public long update;

        public AvatarActionMessage(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, long l) {
            this.up = bl;
            this.down = bl2;
            this.left = bl3;
            this.right = bl4;
            this.action = bl5;
            this.update = l;
        }

        private AvatarActionMessage() {
        }

        protected TCPMessageType getType() {
            return TCPMessageType.AvatarAction;
        }

        protected void readFrom(ByteBuffer byteBuffer) throws BufferUnderflowException {
            byte by = byteBuffer.get();
            this.up = (by & 1) != 0;
            this.down = (by & 2) != 0;
            this.left = (by & 4) != 0;
            this.right = (by & 8) != 0;
            this.action = (by & 0x10) != 0;
            this.update = byteBuffer.getLong();
        }

        protected void writeTo(ByteBuffer byteBuffer) throws BufferOverflowException {
            byte by = 0;
            if (this.up) {
                by = (byte)(by | 1);
            }
            if (this.down) {
                by = (byte)(by | 2);
            }
            if (this.left) {
                by = (byte)(by | 4);
            }
            if (this.right) {
                by = (byte)(by | 8);
            }
            if (this.action) {
                by = (byte)(by | 0x10);
            }
            byteBuffer.put(by);
            byteBuffer.putLong(this.update);
        }

        public void accept(MessageReceiver messageReceiver) {
            messageReceiver.apply(this);
        }

        public boolean isLogged() {
            return false;
        }
    }

    public static final class AvatarFinishMessage
    extends TCPMessage {
        public long update;

        public AvatarFinishMessage(long l) {
            this.update = l;
        }

        private AvatarFinishMessage() {
        }

        protected TCPMessageType getType() {
            return TCPMessageType.AvatarFinish;
        }

        protected void readFrom(ByteBuffer byteBuffer) throws BufferUnderflowException {
            this.update = byteBuffer.getLong();
        }

        protected void writeTo(ByteBuffer byteBuffer) throws BufferOverflowException {
            byteBuffer.putLong(this.update);
        }

        public void accept(MessageReceiver messageReceiver) {
            messageReceiver.apply(this);
        }

        public boolean isLogged() {
            return false;
        }
    }

    public static final class AvatarPassiveMessage
    extends TCPMessage {
        public long update;

        public AvatarPassiveMessage(long l) {
            this.update = l;
        }

        private AvatarPassiveMessage() {
        }

        protected TCPMessageType getType() {
            return TCPMessageType.AvatarPassive;
        }

        protected void readFrom(ByteBuffer byteBuffer) throws BufferUnderflowException {
            this.update = byteBuffer.getLong();
        }

        protected void writeTo(ByteBuffer byteBuffer) throws BufferOverflowException {
            byteBuffer.putLong(this.update);
        }

        public void accept(MessageReceiver messageReceiver) {
            messageReceiver.apply(this);
        }

        public boolean isLogged() {
            return false;
        }
    }

    public static class SynchronizedMessage
    extends TCPMessage {
        public int roundtrip;
        public int maxRoundtrip;
        public int headerBufferPosition;
        public TCPHeader header;
        public TCPMessage message;

        public SynchronizedMessage(TCPMessage tCPMessage) {
            this.message = tCPMessage;
        }

        private SynchronizedMessage() {
        }

        protected TCPMessageType getType() {
            return TCPMessageType.Synchronized;
        }

        protected void readFrom(ByteBuffer byteBuffer) throws BufferUnderflowException {
            this.roundtrip = byteBuffer.getInt();
            this.maxRoundtrip = byteBuffer.getInt();
            this.headerBufferPosition = byteBuffer.position();
            this.header = new TCPHeader();
            this.header.readFrom(byteBuffer);
            this.message = this.header.createMessage(byteBuffer);
        }

        protected void writeTo(ByteBuffer byteBuffer) throws BufferOverflowException {
            byteBuffer.putInt(this.roundtrip);
            byteBuffer.putInt(this.maxRoundtrip);
            this.message.write(byteBuffer);
        }

        public void accept(MessageReceiver messageReceiver) {
        }
    }

    public static class GambleMessage
    extends TCPMessage {
        public int playerNumber;
        public float totalTime;
        public float timeLeft;

        public GambleMessage(int n, float f, float f2) {
            this.playerNumber = n;
            this.totalTime = f;
            this.timeLeft = f2;
        }

        private GambleMessage() {
        }

        protected TCPMessageType getType() {
            return TCPMessageType.Gamble;
        }

        protected void readFrom(ByteBuffer byteBuffer) throws BufferUnderflowException {
            this.playerNumber = byteBuffer.getInt();
            this.totalTime = byteBuffer.getFloat();
            this.timeLeft = byteBuffer.getFloat();
        }

        protected void writeTo(ByteBuffer byteBuffer) throws BufferOverflowException {
            byteBuffer.putInt(this.playerNumber);
            byteBuffer.putFloat(this.totalTime);
            byteBuffer.putFloat(this.timeLeft);
        }

        public void accept(MessageReceiver messageReceiver) {
            messageReceiver.apply(this);
        }
    }

    public static class BuyLandMessage
    extends TCPMessage {
        public int buyerUserNumber;
        public int price;
        public long frame;

        public BuyLandMessage(int n, int n2, long l) {
            this.buyerUserNumber = n;
            this.price = n2;
            this.frame = l;
        }

        private BuyLandMessage() {
        }

        protected TCPMessageType getType() {
            return TCPMessageType.BuyLand;
        }

        protected void readFrom(ByteBuffer byteBuffer) throws BufferUnderflowException {
            this.buyerUserNumber = byteBuffer.getInt();
            this.price = byteBuffer.getInt();
            this.frame = byteBuffer.getLong();
        }

        protected void writeTo(ByteBuffer byteBuffer) throws BufferOverflowException {
            byteBuffer.putInt(this.buyerUserNumber);
            byteBuffer.putInt(this.price);
            byteBuffer.putLong(this.frame);
        }

        public void accept(MessageReceiver messageReceiver) {
            messageReceiver.apply(this);
        }
    }

    public static class ReconnectReadyMessage
    extends TCPMessage {
        public void accept(MessageReceiver messageReceiver) {
            messageReceiver.apply(this);
        }

        protected TCPMessageType getType() {
            return TCPMessageType.ReconnectReady;
        }

        public void readFrom(ByteBuffer byteBuffer) throws BufferOverflowException {
        }

        public void writeTo(ByteBuffer byteBuffer) throws BufferOverflowException {
        }
    }

    public static class AssayBuyMessage
    extends TCPMessage {
        public int selection;

        public AssayBuyMessage(int n) {
            this.selection = n;
        }

        private AssayBuyMessage() {
        }

        public void accept(MessageReceiver messageReceiver) {
            messageReceiver.apply(this);
        }

        protected TCPMessageType getType() {
            return TCPMessageType.AssayBuy;
        }

        public void readFrom(ByteBuffer byteBuffer) throws BufferOverflowException {
            this.selection = byteBuffer.getInt();
        }

        public void writeTo(ByteBuffer byteBuffer) throws BufferOverflowException {
            byteBuffer.putInt(this.selection);
        }
    }

    public static class PlantBuyMessage
    extends TCPMessage {
        public int selection;

        public PlantBuyMessage(int n) {
            this.selection = n;
        }

        private PlantBuyMessage() {
        }

        public void accept(MessageReceiver messageReceiver) {
            messageReceiver.apply(this);
        }

        protected TCPMessageType getType() {
            return TCPMessageType.PlantBuy;
        }

        public void readFrom(ByteBuffer byteBuffer) throws BufferOverflowException {
            this.selection = byteBuffer.getInt();
        }

        public void writeTo(ByteBuffer byteBuffer) throws BufferOverflowException {
            byteBuffer.putInt(this.selection);
        }
    }

    public static class WampusRewardMessage
    extends TCPMessage {
        public int selectedReward;

        public WampusRewardMessage(int n) {
            this.selectedReward = n;
        }

        private WampusRewardMessage() {
        }

        public void accept(MessageReceiver messageReceiver) {
            messageReceiver.apply(this);
        }

        protected TCPMessageType getType() {
            return TCPMessageType.WampusReward;
        }

        public void readFrom(ByteBuffer byteBuffer) throws BufferOverflowException {
            this.selectedReward = byteBuffer.getInt();
        }

        public void writeTo(ByteBuffer byteBuffer) throws BufferOverflowException {
            byteBuffer.putInt(this.selectedReward);
        }
    }

    public static class WampusCatchMessage
    extends TCPMessage {
        public int catcherUserNumber;

        public WampusCatchMessage(int n) {
            this.catcherUserNumber = n;
        }

        private WampusCatchMessage() {
        }

        public void accept(MessageReceiver messageReceiver) {
            messageReceiver.apply(this);
        }

        protected TCPMessageType getType() {
            return TCPMessageType.WampusCatch;
        }

        public void readFrom(ByteBuffer byteBuffer) throws BufferOverflowException {
            this.catcherUserNumber = byteBuffer.getInt();
        }

        public void writeTo(ByteBuffer byteBuffer) throws BufferOverflowException {
            byteBuffer.putInt(this.catcherUserNumber);
        }
    }

    public static class WampusHuntMessage
    extends TCPMessage {
        public float posX;
        public float posY;

        public WampusHuntMessage(float f, float f2) {
            this.posX = f;
            this.posY = f2;
        }

        private WampusHuntMessage() {
        }

        public void accept(MessageReceiver messageReceiver) {
            messageReceiver.apply(this);
        }

        protected TCPMessageType getType() {
            return TCPMessageType.WampusHunt;
        }

        public void readFrom(ByteBuffer byteBuffer) throws BufferOverflowException {
            this.posX = byteBuffer.getFloat();
            this.posY = byteBuffer.getFloat();
        }

        public void writeTo(ByteBuffer byteBuffer) throws BufferOverflowException {
            byteBuffer.putFloat(this.posX);
            byteBuffer.putFloat(this.posY);
        }
    }

    public static class AssayMessage
    extends TCPMessage {
        public int tileX;
        public int tileY;

        public AssayMessage(int n, int n2) {
            this.tileX = n;
            this.tileY = n2;
        }

        private AssayMessage() {
        }

        public void accept(MessageReceiver messageReceiver) {
            messageReceiver.apply(this);
        }

        protected TCPMessageType getType() {
            return TCPMessageType.Assay;
        }

        public void readFrom(ByteBuffer byteBuffer) throws BufferOverflowException {
            this.tileX = byteBuffer.getInt();
            this.tileY = byteBuffer.getInt();
        }

        public void writeTo(ByteBuffer byteBuffer) throws BufferOverflowException {
            byteBuffer.putInt(this.tileX);
            byteBuffer.putInt(this.tileY);
        }
    }

    public static class GameModelMessage
    extends TCPMessage {
        public byte[] serializedModel;

        public GameModelMessage(byte[] byArray) {
            this.serializedModel = byArray;
        }

        private GameModelMessage() {
        }

        public void accept(MessageReceiver messageReceiver) {
            messageReceiver.apply(this);
        }

        public int getMessageSize() {
            return 4 + this.serializedModel.length;
        }

        protected TCPMessageType getType() {
            return TCPMessageType.GameModel;
        }

        public void readFrom(ByteBuffer byteBuffer) throws BufferOverflowException {
            int n = byteBuffer.getInt();
            this.serializedModel = new byte[n];
            byteBuffer.get(this.serializedModel, 0, n);
        }

        public void writeTo(ByteBuffer byteBuffer) throws BufferOverflowException {
            byteBuffer.putInt(this.serializedModel.length);
            byteBuffer.put(this.serializedModel);
        }
    }

    public static class SystemChatMessage
    extends TCPMessage {
        public String text;

        public SystemChatMessage(String string) {
            this.text = string;
        }

        private SystemChatMessage() {
        }

        public void accept(MessageReceiver messageReceiver) {
            messageReceiver.apply(this);
        }

        protected TCPMessageType getType() {
            return TCPMessageType.SystemChat;
        }

        public void readFrom(ByteBuffer byteBuffer) throws BufferOverflowException {
            this.text = SystemChatMessage.getString(byteBuffer);
        }

        public void writeTo(ByteBuffer byteBuffer) throws BufferOverflowException {
            SystemChatMessage.putString(this.text, byteBuffer);
        }

        public boolean isLogged() {
            return false;
        }
    }

    public static class ChatMessage
    extends TCPMessage {
        public String text;

        public ChatMessage(String string) {
            this.text = string;
        }

        private ChatMessage() {
        }

        public void accept(MessageReceiver messageReceiver) {
            messageReceiver.apply(this);
        }

        protected TCPMessageType getType() {
            return TCPMessageType.Chat;
        }

        public void readFrom(ByteBuffer byteBuffer) throws BufferOverflowException {
            this.text = ChatMessage.getString(byteBuffer);
        }

        public void writeTo(ByteBuffer byteBuffer) throws BufferOverflowException {
            ChatMessage.putString(this.text, byteBuffer);
        }

        public boolean isLogged() {
            return false;
        }
    }

    public static class TimerFinishedMessage
    extends TimerMessage {
        public TimerFinishedMessage(int n, int n2, long l) {
            super(n, n2, l);
        }

        private TimerFinishedMessage() {
        }

        protected TCPMessageType getType() {
            return TCPMessageType.TimerFinished;
        }

        public void accept(MessageReceiver messageReceiver) {
            messageReceiver.apply(this);
        }
    }

    public static class TimerStartedMessage
    extends TimerMessage {
        public TimerStartedMessage(int n, int n2, long l) {
            super(n, n2, l);
        }

        private TimerStartedMessage() {
        }

        protected TCPMessageType getType() {
            return TCPMessageType.TimerStarted;
        }

        public void accept(MessageReceiver messageReceiver) {
            messageReceiver.apply(this);
        }
    }

    public static abstract class TimerMessage
    extends TCPMessage {
        public int manager;
        public int id;
        public long frame;

        public TimerMessage(int n, int n2, long l) {
            this.manager = n;
            this.id = n2;
            this.frame = l;
        }

        private TimerMessage() {
        }

        public void readFrom(ByteBuffer byteBuffer) throws BufferOverflowException {
            this.manager = byteBuffer.getInt();
            this.id = byteBuffer.getInt();
            this.frame = byteBuffer.getLong();
        }

        public void writeTo(ByteBuffer byteBuffer) throws BufferOverflowException {
            byteBuffer.putInt(this.manager);
            byteBuffer.putInt(this.id);
            byteBuffer.putLong(this.frame);
        }
    }

    public static class EndTransactionMessage
    extends TCPMessage {
        protected TCPMessageType getType() {
            return TCPMessageType.EndTransaction;
        }

        protected void readFrom(ByteBuffer byteBuffer) throws BufferUnderflowException {
        }

        protected void writeTo(ByteBuffer byteBuffer) throws BufferOverflowException {
        }

        public void accept(MessageReceiver messageReceiver) {
            messageReceiver.apply(this);
        }
    }

    public static class CancelTransactionMessage
    extends TCPMessage {
        protected TCPMessageType getType() {
            return TCPMessageType.CancelTransaction;
        }

        protected void readFrom(ByteBuffer byteBuffer) throws BufferUnderflowException {
        }

        protected void writeTo(ByteBuffer byteBuffer) throws BufferOverflowException {
        }

        public void accept(MessageReceiver messageReceiver) {
            messageReceiver.apply(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TransactionMessage
    extends TCPMessage {
        public int price;
        public ArrayList<Integer> buyers;
        public ArrayList<Integer> sellers;

        public TransactionMessage(int n, ArrayList<Integer> arrayList, ArrayList<Integer> arrayList2) {
            this.price = n;
            this.buyers = arrayList;
            this.sellers = arrayList2;
        }

        public TransactionMessage() {
        }

        @Override
        public void accept(MessageReceiver messageReceiver) {
            messageReceiver.apply(this);
        }

        @Override
        protected TCPMessageType getType() {
            return TCPMessageType.Transaction;
        }

        @Override
        public void readFrom(ByteBuffer byteBuffer) throws BufferOverflowException {
            int n;
            this.price = byteBuffer.getInt();
            int n2 = byteBuffer.get();
            this.buyers = new ArrayList(n2);
            for (n = 0; n < n2; ++n) {
                this.buyers.add(byteBuffer.getInt());
            }
            n = byteBuffer.get();
            this.sellers = new ArrayList(n);
            for (int i = 0; i < n; ++i) {
                this.sellers.add(byteBuffer.getInt());
            }
        }

        @Override
        public void writeTo(ByteBuffer byteBuffer) throws BufferOverflowException {
            int n;
            byteBuffer.putInt(this.price);
            byteBuffer.put((byte)this.buyers.size());
            for (n = 0; n < this.buyers.size(); ++n) {
                byteBuffer.putInt(this.buyers.get(n));
            }
            byteBuffer.put((byte)this.sellers.size());
            for (n = 0; n < this.sellers.size(); ++n) {
                byteBuffer.putInt(this.sellers.get(n));
            }
        }

        @Override
        public boolean isLogged() {
            return false;
        }
    }

    public static class BeginTransactionMessage
    extends TCPMessage {
        protected TCPMessageType getType() {
            return TCPMessageType.BeginTransaction;
        }

        protected void readFrom(ByteBuffer byteBuffer) throws BufferUnderflowException {
        }

        protected void writeTo(ByteBuffer byteBuffer) throws BufferOverflowException {
        }

        public void accept(MessageReceiver messageReceiver) {
            messageReceiver.apply(this);
        }
    }

    public static class ChooseDirectionMessage
    extends TCPMessage {
        public ActorSprite.Direction direction;

        public ChooseDirectionMessage(ActorSprite.Direction direction) {
            this.direction = direction;
        }

        private ChooseDirectionMessage() {
        }

        protected TCPMessageType getType() {
            return TCPMessageType.ChooseDirection;
        }

        protected void readFrom(ByteBuffer byteBuffer) throws BufferOverflowException {
            this.direction = ActorSprite.Direction.get(byteBuffer.getInt());
        }

        protected void writeTo(ByteBuffer byteBuffer) throws BufferOverflowException {
            byteBuffer.putInt(this.direction.value);
        }

        public void accept(MessageReceiver messageReceiver) {
            messageReceiver.apply(this);
        }
    }

    public static class EnterShopMessage
    extends TCPMessage {
        public long frame;
        public float posX;
        public float posY;

        public EnterShopMessage(long l, float f, float f2) {
            this.frame = l;
            this.posX = f;
            this.posY = f2;
        }

        public EnterShopMessage() {
        }

        public void accept(MessageReceiver messageReceiver) {
            messageReceiver.apply(this);
        }

        protected TCPMessageType getType() {
            return TCPMessageType.EnterShop;
        }

        protected void readFrom(ByteBuffer byteBuffer) throws BufferOverflowException {
            this.frame = byteBuffer.getLong();
            this.posX = byteBuffer.getFloat();
            this.posY = byteBuffer.getFloat();
        }

        protected void writeTo(ByteBuffer byteBuffer) throws BufferOverflowException {
            byteBuffer.putLong(this.frame);
            byteBuffer.putFloat(this.posX);
            byteBuffer.putFloat(this.posY);
        }
    }

    public static class LandGrantContinueMessage
    extends TCPMessage {
        public int tileIndex;

        public LandGrantContinueMessage(int n) {
            this.tileIndex = n;
        }

        private LandGrantContinueMessage() {
        }

        public boolean isLogged() {
            return false;
        }

        protected TCPMessageType getType() {
            return TCPMessageType.LandGrantContinue;
        }

        protected void readFrom(ByteBuffer byteBuffer) throws BufferUnderflowException {
            this.tileIndex = byteBuffer.getInt();
        }

        protected void writeTo(ByteBuffer byteBuffer) throws BufferOverflowException {
            byteBuffer.putInt(this.tileIndex);
        }

        public void accept(MessageReceiver messageReceiver) {
            messageReceiver.apply(this);
        }
    }

    public static class LandGrantStartMessage
    extends TCPMessage {
        public int roundtripFrames;

        public LandGrantStartMessage(int n) {
            this.roundtripFrames = n;
        }

        private LandGrantStartMessage() {
        }

        protected TCPMessageType getType() {
            return TCPMessageType.LandGrantStart;
        }

        protected void readFrom(ByteBuffer byteBuffer) throws BufferUnderflowException {
            this.roundtripFrames = byteBuffer.getInt();
        }

        protected void writeTo(ByteBuffer byteBuffer) throws BufferOverflowException {
            byteBuffer.putInt(this.roundtripFrames);
        }

        public void accept(MessageReceiver messageReceiver) {
            messageReceiver.apply(this);
        }
    }

    public static class LandAuctionStartMessage
    extends TCPMessage {
        protected TCPMessageType getType() {
            return TCPMessageType.LandAuctionStart;
        }

        protected void readFrom(ByteBuffer byteBuffer) throws BufferOverflowException {
        }

        protected void writeTo(ByteBuffer byteBuffer) throws BufferOverflowException {
        }

        public void accept(MessageReceiver messageReceiver) {
            messageReceiver.apply(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StartAuctionMessage
    extends TCPMessage {
        public ArrayList<Integer> buyers;
        public ArrayList<Integer> sellers;

        public StartAuctionMessage(ArrayList<Integer> arrayList, ArrayList<Integer> arrayList2) {
            this.buyers = arrayList;
            this.sellers = arrayList2;
        }

        private StartAuctionMessage() {
        }

        @Override
        public void accept(MessageReceiver messageReceiver) {
            messageReceiver.apply(this);
        }

        @Override
        protected TCPMessageType getType() {
            return TCPMessageType.StartAuction;
        }

        @Override
        public void readFrom(ByteBuffer byteBuffer) throws BufferOverflowException {
            int n;
            int n2 = byteBuffer.getInt();
            this.buyers = new ArrayList(n2);
            for (n = 0; n < n2; ++n) {
                this.buyers.add(byteBuffer.getInt());
            }
            n = byteBuffer.getInt();
            this.sellers = new ArrayList(n);
            for (int i = 0; i < n; ++i) {
                this.sellers.add(byteBuffer.getInt());
            }
        }

        @Override
        public void writeTo(ByteBuffer byteBuffer) throws BufferOverflowException {
            int n;
            byteBuffer.putInt(this.buyers.size());
            for (n = 0; n < this.buyers.size(); ++n) {
                byteBuffer.putInt(this.buyers.get(n));
            }
            byteBuffer.putInt(this.sellers.size());
            for (n = 0; n < this.sellers.size(); ++n) {
                byteBuffer.putInt(this.sellers.get(n));
            }
        }
    }

    public static class ContinueMessage
    extends TCPMessage {
        protected TCPMessageType getType() {
            return TCPMessageType.Continue;
        }

        protected void readFrom(ByteBuffer byteBuffer) throws BufferUnderflowException {
        }

        protected void writeTo(ByteBuffer byteBuffer) throws BufferOverflowException {
        }

        public void accept(MessageReceiver messageReceiver) {
            messageReceiver.apply(this);
        }
    }

    public static class ServerInfoMessage
    extends TCPMessage {
        public ClientId clientId;
        public int numPlayers;
        public int numSpectators;
        public boolean gameStarted;
        public String version;
        public boolean allowSpectators;

        private ServerInfoMessage() {
            this.clientId = ClientId.invalidClientId();
        }

        public ServerInfoMessage(ClientId clientId, int n, int n2, boolean bl, boolean bl2) {
            this.clientId = clientId;
            this.numPlayers = n;
            this.numSpectators = n2;
            this.gameStarted = bl;
            this.version = "1.3.4";
            this.allowSpectators = bl2;
        }

        protected TCPMessageType getType() {
            return TCPMessageType.ServerInfo;
        }

        protected void readFrom(ByteBuffer byteBuffer) throws BufferOverflowException {
            this.clientId.readFrom(byteBuffer);
            this.numPlayers = byteBuffer.getInt();
            this.numSpectators = byteBuffer.getInt();
            this.gameStarted = ServerInfoMessage.getBoolean(byteBuffer);
            this.version = ServerInfoMessage.getString(byteBuffer);
            this.allowSpectators = ServerInfoMessage.getBoolean(byteBuffer);
        }

        protected void writeTo(ByteBuffer byteBuffer) throws BufferOverflowException {
            this.clientId.writeTo(byteBuffer);
            byteBuffer.putInt(this.numPlayers);
            byteBuffer.putInt(this.numSpectators);
            ServerInfoMessage.putBoolean(this.gameStarted, byteBuffer);
            ServerInfoMessage.putString(this.version, byteBuffer);
            ServerInfoMessage.putBoolean(this.allowSpectators, byteBuffer);
        }

        public void accept(MessageReceiver messageReceiver) {
            messageReceiver.apply(this);
        }
    }

    public static class KickUserMessage
    extends TCPMessage {
        public int kickUserNumber;

        public KickUserMessage(int n) {
            this.kickUserNumber = n;
        }

        private KickUserMessage() {
        }

        protected TCPMessageType getType() {
            return TCPMessageType.KickUser;
        }

        protected void readFrom(ByteBuffer byteBuffer) throws BufferOverflowException {
            this.kickUserNumber = byteBuffer.getInt();
        }

        protected void writeTo(ByteBuffer byteBuffer) throws BufferOverflowException {
            byteBuffer.putInt(this.kickUserNumber);
        }

        public void accept(MessageReceiver messageReceiver) {
            messageReceiver.apply(this);
        }
    }

    public static class UserDisconnectedMessage
    extends TCPMessage {
        public int disconnectedUserNumber;

        public UserDisconnectedMessage(int n) {
            this.disconnectedUserNumber = n;
        }

        private UserDisconnectedMessage() {
        }

        protected TCPMessageType getType() {
            return TCPMessageType.UserDisconnected;
        }

        protected void readFrom(ByteBuffer byteBuffer) throws BufferOverflowException {
            this.disconnectedUserNumber = byteBuffer.getInt();
        }

        protected void writeTo(ByteBuffer byteBuffer) throws BufferOverflowException {
            byteBuffer.putInt(this.disconnectedUserNumber);
        }

        public void accept(MessageReceiver messageReceiver) {
            messageReceiver.apply(this);
        }
    }

    public static class UserLeftMessage
    extends TCPMessage {
        protected TCPMessageType getType() {
            return TCPMessageType.UserLeft;
        }

        protected void readFrom(ByteBuffer byteBuffer) throws BufferOverflowException {
        }

        protected void writeTo(ByteBuffer byteBuffer) throws BufferOverflowException {
        }

        public void accept(MessageReceiver messageReceiver) {
            messageReceiver.apply(this);
        }
    }

    public static class AliveMessage
    extends TCPMessage {
        public void accept(MessageReceiver messageReceiver) {
            messageReceiver.apply(this);
        }

        protected TCPMessageType getType() {
            return TCPMessageType.Alive;
        }

        protected void readFrom(ByteBuffer byteBuffer) throws BufferOverflowException {
        }

        protected void writeTo(ByteBuffer byteBuffer) throws BufferOverflowException {
        }

        public boolean isLogged() {
            return false;
        }
    }

    public static class ReadyMessage
    extends TCPMessage {
        public long frame;

        public ReadyMessage(long l) {
            this.frame = l;
        }

        private ReadyMessage() {
        }

        protected TCPMessageType getType() {
            return TCPMessageType.Ready;
        }

        protected void readFrom(ByteBuffer byteBuffer) throws BufferOverflowException {
            this.frame = byteBuffer.getLong();
        }

        protected void writeTo(ByteBuffer byteBuffer) throws BufferOverflowException {
            byteBuffer.putLong(this.frame);
        }

        public void accept(MessageReceiver messageReceiver) {
            messageReceiver.apply(this);
        }
    }

    public static class JoinSuccessfulMessage
    extends TCPMessage {
        public boolean myJoin = false;
        public boolean serverUser = false;

        private JoinSuccessfulMessage() {
        }

        protected TCPMessageType getType() {
            return TCPMessageType.JoinSuccessful;
        }

        protected void readFrom(ByteBuffer byteBuffer) throws BufferUnderflowException {
            this.myJoin = JoinSuccessfulMessage.getBoolean(byteBuffer);
            this.serverUser = JoinSuccessfulMessage.getBoolean(byteBuffer);
        }

        protected void writeTo(ByteBuffer byteBuffer) throws BufferOverflowException {
            JoinSuccessfulMessage.putBoolean(this.myJoin, byteBuffer);
            JoinSuccessfulMessage.putBoolean(this.serverUser, byteBuffer);
        }

        public void accept(MessageReceiver messageReceiver) {
            messageReceiver.apply(this);
        }
    }

    public static class AIJoinMessage
    extends TCPMessage {
        public String name;

        public AIJoinMessage(String string) {
            this.name = string;
        }

        private AIJoinMessage() {
        }

        public TCPMessageType getType() {
            return TCPMessageType.AIJoin;
        }

        protected void readFrom(ByteBuffer byteBuffer) throws BufferUnderflowException {
            this.name = AIJoinMessage.getString(byteBuffer);
        }

        protected void writeTo(ByteBuffer byteBuffer) throws BufferOverflowException {
            AIJoinMessage.putString(this.name, byteBuffer);
        }

        public void accept(MessageReceiver messageReceiver) {
            messageReceiver.apply(this);
        }

        void setUserNumber(int n) {
            this.userNumber = n;
        }
    }

    public static class PlayerJoinSuccessfulMessage
    extends TCPMessage {
        public int oldUserNumber;
        public int newUserNumber;

        public PlayerJoinSuccessfulMessage(int n, int n2) {
            this.oldUserNumber = n;
            this.newUserNumber = n2;
        }

        private PlayerJoinSuccessfulMessage() {
        }

        protected TCPMessageType getType() {
            return TCPMessageType.PlayerJoinSuccessful;
        }

        protected void readFrom(ByteBuffer byteBuffer) throws BufferOverflowException {
            this.oldUserNumber = byteBuffer.getInt();
            this.newUserNumber = byteBuffer.getInt();
        }

        protected void writeTo(ByteBuffer byteBuffer) throws BufferOverflowException {
            byteBuffer.putInt(this.oldUserNumber);
            byteBuffer.putInt(this.newUserNumber);
        }

        public void accept(MessageReceiver messageReceiver) {
            messageReceiver.apply(this);
        }
    }

    public static class PlayerUnjoinMessage
    extends TCPMessage {
        protected TCPMessageType getType() {
            return TCPMessageType.PlayerUnjoin;
        }

        protected void readFrom(ByteBuffer byteBuffer) throws BufferOverflowException {
        }

        protected void writeTo(ByteBuffer byteBuffer) throws BufferOverflowException {
        }

        public void accept(MessageReceiver messageReceiver) {
            messageReceiver.apply(this);
        }
    }

    public static class PlayerJoinMessage
    extends TCPMessage {
        protected TCPMessageType getType() {
            return TCPMessageType.PlayerJoin;
        }

        protected void readFrom(ByteBuffer byteBuffer) throws BufferOverflowException {
        }

        protected void writeTo(ByteBuffer byteBuffer) throws BufferOverflowException {
        }

        public void accept(MessageReceiver messageReceiver) {
            messageReceiver.apply(this);
        }
    }

    public static class ReconnectJoinMessage
    extends TCPMessage {
        public ClientId clientId;

        public ReconnectJoinMessage(ClientId clientId) {
            this.clientId = clientId;
        }

        private ReconnectJoinMessage() {
            this.clientId = ClientId.invalidClientId();
        }

        public void accept(MessageReceiver messageReceiver) {
            messageReceiver.apply(this);
        }

        protected TCPMessageType getType() {
            return TCPMessageType.ReconnectJoin;
        }

        public void readFrom(ByteBuffer byteBuffer) throws BufferOverflowException {
            this.clientId.readFrom(byteBuffer);
        }

        public void writeTo(ByteBuffer byteBuffer) throws BufferOverflowException {
            this.clientId.writeTo(byteBuffer);
        }

        public void setUserNumber(int n) {
            this.userNumber = n;
        }
    }

    public static class JoinMessage
    extends TCPMessage {
        public long userID;
        public String userName;
        public String race;
        public String version = "1.3.4";
        public boolean myJoin = false;
        public boolean serverUser = false;

        public JoinMessage(long l, String string, String string2) {
            this.userID = l;
            this.userName = string;
            this.race = string2;
        }

        private JoinMessage() {
        }

        protected TCPMessageType getType() {
            return TCPMessageType.Join;
        }

        protected void readFrom(ByteBuffer byteBuffer) throws BufferOverflowException {
            this.userID = byteBuffer.getLong();
            this.userName = JoinMessage.getString(byteBuffer);
            this.race = JoinMessage.getString(byteBuffer);
            this.version = JoinMessage.getString(byteBuffer);
            this.myJoin = JoinMessage.getBoolean(byteBuffer);
            this.serverUser = JoinMessage.getBoolean(byteBuffer);
        }

        protected void writeTo(ByteBuffer byteBuffer) throws BufferOverflowException {
            byteBuffer.putLong(this.userID);
            JoinMessage.putString(this.userName, byteBuffer);
            JoinMessage.putString(this.race, byteBuffer);
            JoinMessage.putString(this.version, byteBuffer);
            JoinMessage.putBoolean(this.myJoin, byteBuffer);
            JoinMessage.putBoolean(this.serverUser, byteBuffer);
        }

        public void accept(MessageReceiver messageReceiver) {
            messageReceiver.apply(this);
        }
    }

    public static final class TCPHeader {
        public static final int HEADER_SIZE = 13;
        public int messageSize;
        public TCPMessageType type;
        public int userNumber;
        public Message.BroadcastType broadcastType;

        public TCPHeader() {
            this.reset();
        }

        public TCPHeader(TCPMessage tCPMessage) {
            this.messageSize = -1;
            this.type = tCPMessage.getType();
            this.userNumber = tCPMessage.userNumber;
            this.broadcastType = tCPMessage.broadcastType;
        }

        public void reset() {
            this.messageSize = -1;
            this.type = TCPMessageType.Error;
            this.userNumber = 0;
            this.broadcastType = null;
        }

        public boolean isValid() {
            return this.type != TCPMessageType.Error && this.broadcastType != null && this.messageSize >= 0;
        }

        public void readFrom(ByteBuffer byteBuffer) throws BufferUnderflowException {
            this.messageSize = byteBuffer.getInt();
            this.type = TCPMessageType.get(byteBuffer.getInt());
            this.userNumber = byteBuffer.getInt();
            this.broadcastType = Message.BroadcastType.get(byteBuffer.get());
        }

        public void writeTo(ByteBuffer byteBuffer) throws BufferOverflowException {
            byteBuffer.putInt(this.messageSize);
            byteBuffer.putInt(this.type.ordinal());
            byteBuffer.putInt(this.userNumber);
            byteBuffer.put((byte)this.broadcastType.ordinal());
        }

        public TCPMessage createMessage(ByteBuffer byteBuffer) {
            TCPMessage tCPMessage = null;
            switch (this.type) {
                case Join: {
                    tCPMessage = new JoinMessage();
                    break;
                }
                case PlayerJoin: {
                    tCPMessage = new PlayerJoinMessage();
                    break;
                }
                case PlayerUnjoin: {
                    tCPMessage = new PlayerUnjoinMessage();
                    break;
                }
                case PlayerJoinSuccessful: {
                    tCPMessage = new PlayerJoinSuccessfulMessage();
                    break;
                }
                case AIJoin: {
                    tCPMessage = new AIJoinMessage();
                    break;
                }
                case JoinSuccessful: {
                    tCPMessage = new JoinSuccessfulMessage();
                    break;
                }
                case ServerInfo: {
                    tCPMessage = new ServerInfoMessage();
                    break;
                }
                case Ready: {
                    tCPMessage = new ReadyMessage();
                    break;
                }
                case Continue: {
                    tCPMessage = new ContinueMessage();
                    break;
                }
                case ChooseDirection: {
                    tCPMessage = new ChooseDirectionMessage();
                    break;
                }
                case EnterShop: {
                    tCPMessage = new EnterShopMessage();
                    break;
                }
                case TimerStarted: {
                    tCPMessage = new TimerStartedMessage();
                    break;
                }
                case TimerFinished: {
                    tCPMessage = new TimerFinishedMessage();
                    break;
                }
                case UserLeft: {
                    tCPMessage = new UserLeftMessage();
                    break;
                }
                case UserDisconnected: {
                    tCPMessage = new UserDisconnectedMessage();
                    break;
                }
                case KickUser: {
                    tCPMessage = new KickUserMessage();
                    break;
                }
                case Alive: {
                    tCPMessage = new AliveMessage();
                    break;
                }
                case Transaction: {
                    tCPMessage = new TransactionMessage();
                    break;
                }
                case CancelTransaction: {
                    tCPMessage = new CancelTransactionMessage();
                    break;
                }
                case BeginTransaction: {
                    tCPMessage = new BeginTransactionMessage();
                    break;
                }
                case EndTransaction: {
                    tCPMessage = new EndTransactionMessage();
                    break;
                }
                case GameModel: {
                    tCPMessage = new GameModelMessage();
                    break;
                }
                case Chat: {
                    tCPMessage = new ChatMessage();
                    break;
                }
                case SystemChat: {
                    tCPMessage = new SystemChatMessage();
                    break;
                }
                case PlantBuy: {
                    tCPMessage = new PlantBuyMessage();
                    break;
                }
                case AssayBuy: {
                    tCPMessage = new AssayBuyMessage();
                    break;
                }
                case Assay: {
                    tCPMessage = new AssayMessage();
                    break;
                }
                case WampusHunt: {
                    tCPMessage = new WampusHuntMessage();
                    break;
                }
                case WampusCatch: {
                    tCPMessage = new WampusCatchMessage();
                    break;
                }
                case WampusReward: {
                    tCPMessage = new WampusRewardMessage();
                    break;
                }
                case ReconnectJoin: {
                    tCPMessage = new ReconnectJoinMessage();
                    break;
                }
                case ReconnectReady: {
                    tCPMessage = new ReconnectReadyMessage();
                    break;
                }
                case LandAuctionStart: {
                    tCPMessage = new LandAuctionStartMessage();
                    break;
                }
                case BuyLand: {
                    tCPMessage = new BuyLandMessage();
                    break;
                }
                case Gamble: {
                    tCPMessage = new GambleMessage();
                    break;
                }
                case LandGrantStart: {
                    tCPMessage = new LandGrantStartMessage();
                    break;
                }
                case LandGrantContinue: {
                    tCPMessage = new LandGrantContinueMessage();
                    break;
                }
                case Synchronized: {
                    tCPMessage = new SynchronizedMessage();
                    break;
                }
                case AvatarPassive: {
                    tCPMessage = new AvatarPassiveMessage();
                    break;
                }
                case AvatarAction: {
                    tCPMessage = new AvatarActionMessage();
                    break;
                }
                case AvatarFinish: {
                    tCPMessage = new AvatarFinishMessage();
                    break;
                }
                case FastDevelopment: {
                    tCPMessage = new FastDevelopmentMessage();
                    break;
                }
                case SynchronizedCheck: {
                    tCPMessage = new SynchronizedCheckMessage();
                    break;
                }
                case GameSettings: {
                    tCPMessage = new GameSettingsMessage();
                    break;
                }
                case StoreClosed: {
                    tCPMessage = new StoreClosedMessage();
                    break;
                }
                case StartAuction: {
                    tCPMessage = new StartAuctionMessage();
                }
            }
            if (tCPMessage == null) {
                throw new RuntimeException("Unknown TCP message type: " + this);
            }
            tCPMessage.userNumber = this.userNumber;
            tCPMessage.broadcastType = this.broadcastType;
            tCPMessage.readFrom(byteBuffer);
            return tCPMessage;
        }

        public int totalSize() {
            return 13 + this.messageSize;
        }

        public String toString() {
            return (Object)((Object)this.type) + " (" + this.userNumber + ") " + this.messageSize + " bytes";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TCPMessageType {
        Error,
        Join,
        PlayerJoin,
        PlayerUnjoin,
        PlayerJoinSuccessful,
        AIJoin,
        JoinSuccessful,
        ServerInfo,
        Ready,
        GameInit,
        UserLeft,
        UserDisconnected,
        KickUser,
        ChooseDirection,
        EnterShop,
        TimerStarted,
        TimerFinished,
        Alive,
        BeginTransaction,
        Transaction,
        CancelTransaction,
        EndTransaction,
        Continue,
        Assay,
        GameModel,
        Chat,
        SystemChat,
        PlantBuy,
        AssayBuy,
        WampusHunt,
        WampusCatch,
        WampusReward,
        ReconnectJoin,
        ReconnectReady,
        LandAuctionStart,
        BuyLand,
        Gamble,
        LandGrantStart,
        LandGrantContinue,
        Synchronized,
        AvatarPassive,
        AvatarAction,
        AvatarFinish,
        FastDevelopment,
        SynchronizedCheck,
        GameSettings,
        StoreClosed,
        StartAuction;


        public static TCPMessageType get(int n) {
            TCPMessageType[] tCPMessageTypeArray = TCPMessageType.values();
            if (n < 0 || n >= tCPMessageTypeArray.length) {
                Message.logger.severe("Invalid TCP message type " + n);
                return Error;
            }
            return tCPMessageTypeArray[n];
        }
    }
}

