/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.network;

import com.turborilla.mule.Properties;
import com.turborilla.mule.controller.GameModelSerializer;
import com.turborilla.mule.model.GameModel;
import com.turborilla.mule.network.ClientId;
import com.turborilla.mule.network.ClientUser;
import com.turborilla.mule.network.ConnectedClient;
import com.turborilla.mule.network.Server;
import com.turborilla.mule.network.TCPMessage;
import com.turborilla.mule.network.UDPMessage;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ServerMessageHandler {
    private static final Logger logger = Logger.getLogger("mule");
    private GameModel model;
    private Stack<Integer> freeUserNumbers = new Stack();
    private HashMap<ClientId, Integer> reservedUserNumbers;

    public ServerMessageHandler() {
        for (int i = 0; i < Properties.mule.maxNumUsers; ++i) {
            this.freeUserNumbers.push(9 + Properties.mule.maxNumUsers - i);
        }
        this.reservedUserNumbers = new HashMap();
    }

    public void set(GameModel gameModel) {
        this.model = gameModel;
    }

    boolean processTCPMessage(TCPMessage.TCPHeader tCPHeader, ByteBuffer byteBuffer, ConnectedClient connectedClient, Server server) {
        int n = byteBuffer.position();
        byteBuffer.position(n + 13);
        switch (tCPHeader.type) {
            case Join: {
                if (!connectedClient.hasJoined()) {
                    this.sendServerInfo(connectedClient);
                    TCPMessage.JoinMessage joinMessage = (TCPMessage.JoinMessage)tCPHeader.createMessage(byteBuffer);
                    if (!this.processJoin(joinMessage, connectedClient, server)) {
                        server.removeClient(connectedClient);
                    }
                }
                return false;
            }
            case PlayerJoin: {
                TCPMessage.PlayerJoinMessage playerJoinMessage = (TCPMessage.PlayerJoinMessage)tCPHeader.createMessage(byteBuffer);
                return this.processPlayerJoin(playerJoinMessage, connectedClient, server);
            }
            case PlayerUnjoin: {
                TCPMessage.PlayerUnjoinMessage playerUnjoinMessage = (TCPMessage.PlayerUnjoinMessage)tCPHeader.createMessage(byteBuffer);
                return this.processPlayerUnjoin(playerUnjoinMessage, connectedClient, server);
            }
            case AIJoin: {
                if (connectedClient != server.getServerClient()) {
                    logger.severe("Server: Only host may send AI Join messages. Invalid sender: " + connectedClient.toString());
                    return false;
                }
                TCPMessage.AIJoinMessage aIJoinMessage = (TCPMessage.AIJoinMessage)tCPHeader.createMessage(byteBuffer);
                this.processAIJoin(aIJoinMessage, connectedClient, server);
                return false;
            }
            case ReconnectJoin: {
                this.sendServerInfo(connectedClient);
                TCPMessage.ReconnectJoinMessage reconnectJoinMessage = (TCPMessage.ReconnectJoinMessage)tCPHeader.createMessage(byteBuffer);
                if (!this.processReconnectJoin(reconnectJoinMessage, connectedClient, server)) {
                    server.removeClient(connectedClient);
                    return false;
                }
                return false;
            }
            case Synchronized: {
                TCPMessage.SynchronizedMessage synchronizedMessage = (TCPMessage.SynchronizedMessage)tCPHeader.createMessage(byteBuffer);
                byteBuffer.position(synchronizedMessage.headerBufferPosition);
                if (this.processTCPMessage(synchronizedMessage.header, byteBuffer, connectedClient, server)) {
                    synchronizedMessage.maxRoundtrip = server.getMaxRoundtrip();
                    for (ConnectedClient connectedClient2 : server.getClients()) {
                        synchronizedMessage.roundtrip = connectedClient2.getRoundtripTimeMonitor().getRoundtrip();
                        int n2 = tCPHeader.totalSize();
                        ByteBuffer byteBuffer2 = synchronizedMessage.toByteBuffer(n2);
                        connectedClient2.sendTCP(byteBuffer2);
                    }
                }
                return false;
            }
            case KickUser: 
            case UserDisconnected: 
            case BeginTransaction: 
            case Transaction: 
            case EndTransaction: 
            case GameModel: 
            case GameInit: 
            case WampusCatch: 
            case Gamble: 
            case PlayerJoinSuccessful: 
            case LandAuctionStart: 
            case BuyLand: 
            case LandGrantStart: 
            case LandGrantContinue: 
            case GameSettings: 
            case StartAuction: {
                if (connectedClient == server.getServerClient()) {
                    return true;
                }
                logger.warning("Server: Got spoofed server message " + (Object)((Object)tCPHeader.type));
                return false;
            }
            case Chat: {
                byteBuffer.position(n);
                server.sendTcpToPendingClients(byteBuffer);
                return true;
            }
            case SystemChat: {
                if (connectedClient == server.getServerClient()) {
                    server.sendTcpToPendingClients(byteBuffer);
                    return true;
                }
                logger.warning("Server: Got spoofed server message " + (Object)((Object)tCPHeader.type));
                return false;
            }
            case Alive: 
            case Ready: 
            case Continue: 
            case TimerStarted: 
            case TimerFinished: 
            case UserLeft: 
            case SynchronizedCheck: {
                return connectedClient.hasJoined();
            }
        }
        ClientUser clientUser = connectedClient.getUser(tCPHeader.userNumber);
        if (clientUser == null || !clientUser.isPlayer()) {
            logger.severe("Server: " + (Object)((Object)tCPHeader.type) + " not allowed from" + " Sender: " + connectedClient + " User: " + tCPHeader.userNumber);
            return false;
        }
        byteBuffer.position(n);
        return true;
    }

    private boolean processJoin(TCPMessage.JoinMessage joinMessage, ConnectedClient connectedClient, Server server) {
        if (this.model.isGameStarted() && !this.model.getGameInfo().isAllowSpectators()) {
            logger.info("Server: New spectators is not allowed to join.");
            return false;
        }
        if (this.freeUserNumbers.isEmpty()) {
            logger.info("Server: Server is full, no more users can join.");
            return false;
        }
        joinMessage.userNumber = this.freeUserNumbers.pop();
        connectedClient.addUser(new ClientUser(joinMessage.userNumber, false));
        logger.info("Server: Client " + connectedClient.toString() + " joins");
        joinMessage.serverUser = connectedClient == server.getServerClient();
        joinMessage.myJoin = false;
        server.sendTcpToOthers(joinMessage.toByteBuffer(128), connectedClient);
        joinMessage.myJoin = true;
        connectedClient.sendTCP(joinMessage.toByteBuffer(128));
        return true;
    }

    private boolean processPlayerJoin(TCPMessage.PlayerJoinMessage playerJoinMessage, ConnectedClient connectedClient, Server server) {
        if (this.model.isGameStarted()) {
            logger.info("Server: Game already started. " + connectedClient.toString() + " can't join as player.");
            return false;
        }
        int n = playerJoinMessage.getUserNumber();
        ClientUser clientUser = connectedClient.getUser(n);
        if (clientUser == null) {
            logger.info("Server: " + connectedClient.toString() + " has no user number " + n);
            return false;
        }
        if (clientUser.isPlayer()) {
            logger.info("Server: " + connectedClient.toString() + " is already a player and can't join again.");
            return false;
        }
        if (server.numPlayers() >= Properties.mule.maxNumPlayers) {
            logger.info("Server: No more players allowed. " + connectedClient.toString() + " can't join as a player.");
            return false;
        }
        logger.info(connectedClient.toString() + " joins game as a player");
        clientUser.setPlayer(true);
        return true;
    }

    private boolean processPlayerUnjoin(TCPMessage.PlayerUnjoinMessage playerUnjoinMessage, ConnectedClient connectedClient, Server server) {
        if (this.model.isGameStarted()) {
            logger.info("Server: Game already started. " + connectedClient.toString() + " can't become a spectator.");
            return false;
        }
        int n = playerUnjoinMessage.getUserNumber();
        ClientUser clientUser = connectedClient.getUser(n);
        if (clientUser == null) {
            logger.info("Server: " + connectedClient.toString() + " has no user number " + n);
            return false;
        }
        if (!clientUser.isPlayer()) {
            logger.info("Server: " + connectedClient.toString() + " is already a spectator and can't unjoin.");
            return false;
        }
        logger.info(connectedClient.toString() + " unjoins and becomes a spectator");
        clientUser.setPlayer(false);
        return true;
    }

    private boolean processAIJoin(TCPMessage.AIJoinMessage aIJoinMessage, ConnectedClient connectedClient, Server server) {
        if (this.freeUserNumbers.isEmpty()) {
            logger.info("Server: AI Join failed. Out of user numbers.");
            return false;
        }
        if (server.numPlayers() >= Properties.mule.maxNumPlayers) {
            logger.info("Server: AI Join failed. No more players allowed.");
            return false;
        }
        int n = this.freeUserNumbers.pop();
        logger.info("Server: AI gets user number " + n);
        aIJoinMessage.setUserNumber(n);
        connectedClient.addUser(new ClientUser(n, true));
        server.sendTcpToAll(aIJoinMessage.toByteBuffer(128));
        return true;
    }

    private boolean processReconnectJoin(TCPMessage.ReconnectJoinMessage reconnectJoinMessage, ConnectedClient connectedClient, Server server) {
        logger.info("Server: Previous client id " + reconnectJoinMessage.clientId + " reconnects with id " + connectedClient.getClientId());
        Integer n = this.reservedUserNumbers.get(reconnectJoinMessage.clientId);
        if (n == null) {
            logger.info("Server: Client id " + reconnectJoinMessage.clientId + " has no reserved user number");
            return false;
        }
        connectedClient.sendTCP(reconnectJoinMessage.toByteBuffer(128));
        return true;
    }

    void reserveUserNumber(ClientId clientId, int n) {
        this.reservedUserNumbers.put(clientId, n);
    }

    void acceptJoin(ConnectedClient connectedClient, Server server) {
        if (connectedClient != server.getServerClient()) {
            try {
                GameModelSerializer gameModelSerializer = new GameModelSerializer();
                byte[] byArray = gameModelSerializer.serializeModel(this.model);
                TCPMessage.GameModelMessage gameModelMessage = new TCPMessage.GameModelMessage(byArray);
                int n = 13 + gameModelMessage.getMessageSize();
                ByteBuffer byteBuffer = gameModelMessage.toByteBuffer(n);
                connectedClient.sendTCP(byteBuffer);
            }
            catch (IOException iOException) {
                logger.log(Level.SEVERE, "Server: Failed to send game model: " + iOException.toString());
            }
        }
    }

    boolean processUDPMessage(UDPMessage.UDPHeader uDPHeader, ByteBuffer byteBuffer, ConnectedClient connectedClient, InetSocketAddress inetSocketAddress, Server server) {
        ClientUser clientUser;
        switch (uDPHeader.type) {
            case Init: {
                UDPMessage.UDPInitMessage uDPInitMessage = (UDPMessage.UDPInitMessage)uDPHeader.createMessage(byteBuffer);
                ConnectedClient connectedClient2 = server.initUdp(uDPInitMessage.clientId, inetSocketAddress);
                if (connectedClient2 != null) {
                    server.sendUdp(byteBuffer, connectedClient2);
                }
                return false;
            }
            case Ping: {
                if (connectedClient != null) {
                    connectedClient.getRoundtripTimeMonitor().receivePing(byteBuffer);
                } else {
                    logger.warning("Server: Ping message from unknown UDP address " + inetSocketAddress);
                }
                return false;
            }
            case ServerLandGrant: 
            case SynchronizeTimer: 
            case TotalAuctionState: {
                if (connectedClient != server.getServerClient()) {
                    logger.severe("Server: " + (Object)((Object)uDPHeader.type) + " only allowed for server. User: " + uDPHeader.userNumber + " Sender: " + connectedClient + " Address: " + inetSocketAddress);
                    return false;
                }
                return true;
            }
        }
        if (connectedClient != null && (clientUser = connectedClient.getUser(uDPHeader.userNumber)) != null && clientUser.isPlayer()) {
            return true;
        }
        logger.severe("Server: " + (Object)((Object)uDPHeader.type) + " not allowed from" + " Sender: " + connectedClient + " User: " + uDPHeader.userNumber + " Address: " + inetSocketAddress);
        return false;
    }

    public void takeUserNumber(int n) {
        if (!this.freeUserNumbers.contains(n)) {
            logger.severe("User number " + n + " is not available");
        } else {
            this.freeUserNumbers.remove((Object)n);
        }
    }

    public void freeUserNumber(int n) {
        if (this.freeUserNumbers.contains(n)) {
            logger.severe("Duplicate free user number " + n);
        } else {
            this.freeUserNumbers.push(n);
        }
    }

    private void sendServerInfo(ConnectedClient connectedClient) {
        TCPMessage.ServerInfoMessage serverInfoMessage = new TCPMessage.ServerInfoMessage(connectedClient.getClientId(), this.model.getPlayers().size(), this.model.getSpectators().size(), this.model.isGameStarted(), this.model.getGameInfo().isAllowSpectators());
        connectedClient.sendTCP(serverInfoMessage.toByteBuffer(128));
    }
}

