/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.network;

import com.turborilla.mule.MuleException;
import com.turborilla.mule.Properties;
import com.turborilla.mule.network.ClientId;
import com.turborilla.mule.network.ClientUser;
import com.turborilla.mule.network.ConnectedClient;
import com.turborilla.mule.network.RoundtripTimeMonitor;
import com.turborilla.mule.network.ServerMessageHandler;
import com.turborilla.mule.network.ServerObserver;
import com.turborilla.mule.network.TCPMessage;
import com.turborilla.mule.network.UDPMessage;
import java.io.IOException;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Server {
    Logger logger = Logger.getLogger("mule");
    private Selector acceptSelector;
    private Selector clientSelector;
    private ServerSocketChannel serverChannel;
    private DatagramChannel udpChannel;
    private UDPMessage.UDPHeader udpHeader = new UDPMessage.UDPHeader();
    private ByteBuffer udpBuffer = ByteBuffer.allocateDirect(256);
    private ArrayList<ConnectedClient> pendingClients;
    private ArrayList<ConnectedClient> clients;
    private ArrayList<ConnectedClient> removedClients;
    private HashMap<Integer, ConnectedClient> userNumberToClientMap;
    private HashMap<ClientId, ConnectedClient> idToClientMap;
    private HashMap<InetSocketAddress, ConnectedClient> udpAddressToClientMap;
    private ConnectedClient serverClient;
    private ServerMessageHandler serverMessageHandler;
    private ArrayList<ServerObserver> observers;

    public Server(ServerMessageHandler serverMessageHandler) throws MuleException {
        this.logger.info("Server: Creating");
        this.pendingClients = new ArrayList();
        this.clients = new ArrayList();
        this.removedClients = new ArrayList();
        this.userNumberToClientMap = new HashMap();
        this.idToClientMap = new HashMap();
        this.udpAddressToClientMap = new HashMap();
        this.observers = new ArrayList();
        this.serverMessageHandler = serverMessageHandler;
        this.startAccepting();
        try {
            this.clientSelector = SelectorProvider.provider().openSelector();
            this.udpChannel = DatagramChannel.open();
            this.udpChannel.configureBlocking(false);
            this.udpChannel.socket().bind(new InetSocketAddress(Properties.mule.SERVER_UDP_PORT));
            this.udpChannel.register(this.clientSelector, 1);
            this.logger.info("Server: Started on TCP address " + this.serverChannel.socket().getLocalSocketAddress());
            this.logger.info("Server: Started on UDP address " + this.udpChannel.socket().getLocalSocketAddress());
        }
        catch (IOException iOException) {
            throw new MuleException(iOException);
        }
    }

    public void addObserver(ServerObserver serverObserver) {
        this.observers.add(serverObserver);
    }

    public void removeObserver(ServerObserver serverObserver) {
        this.observers.remove(serverObserver);
    }

    private void startAccepting() throws MuleException {
        if (this.acceptSelector == null || !this.acceptSelector.isOpen()) {
            try {
                this.acceptSelector = SelectorProvider.provider().openSelector();
                this.serverChannel = ServerSocketChannel.open();
                this.serverChannel.configureBlocking(false);
                this.serverChannel.socket().bind(new InetSocketAddress(Properties.mule.SERVER_TCP_PORT));
                this.serverChannel.register(this.acceptSelector, 16);
            }
            catch (BindException bindException) {
                throw new MuleException("Failed to start server on port " + Properties.mule.SERVER_TCP_PORT + ".\n" + "Please make sure that you have started\n" + "only one instance of the game.");
            }
            catch (IOException iOException) {
                try {
                    if (this.serverChannel != null) {
                        this.serverChannel.close();
                    }
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
                throw new MuleException(iOException);
            }
        }
    }

    public void acceptClients() {
        block7: {
            try {
                if (this.acceptSelector.selectNow() <= 0) break block7;
                Iterator<SelectionKey> iterator = this.acceptSelector.selectedKeys().iterator();
                while (iterator.hasNext()) {
                    int n;
                    SelectionKey selectionKey = iterator.next();
                    iterator.remove();
                    if (!selectionKey.isAcceptable()) continue;
                    int n2 = this.clients.size() + this.pendingClients.size();
                    if (n2 >= (n = Properties.mule.maxNumUsers)) {
                        this.logger.warning("Server: Client rejected. Server is full.");
                        for (ConnectedClient connectedClient : this.pendingClients) {
                            if (!connectedClient.hasJoinTimedOut()) continue;
                            this.removeClient(connectedClient);
                        }
                        continue;
                    }
                    ServerSocketChannel serverSocketChannel = (ServerSocketChannel)selectionKey.channel();
                    SocketChannel socketChannel = serverSocketChannel.accept();
                    socketChannel.configureBlocking(false);
                    socketChannel.socket().setTcpNoDelay(true);
                    SelectionKey selectionKey2 = socketChannel.register(this.clientSelector, 1);
                    ConnectedClient connectedClient = new ConnectedClient(this, socketChannel);
                    this.idToClientMap.put(connectedClient.getClientId(), connectedClient);
                    this.logger.info("Server: Accepted client " + connectedClient.getInetAddress() + " id " + connectedClient.getClientId());
                    selectionKey2.attach(connectedClient);
                    this.pendingClients.add(connectedClient);
                }
            }
            catch (ClosedChannelException closedChannelException) {
                this.logger.log(Level.SEVERE, closedChannelException.toString(), closedChannelException);
            }
            catch (SocketException socketException) {
                this.logger.log(Level.SEVERE, socketException.toString(), socketException);
            }
            catch (IOException iOException) {
                this.logger.log(Level.SEVERE, iOException.toString(), iOException);
            }
        }
    }

    public void receiveMessages() throws IOException {
        if (this.clientSelector.selectNow() > 0) {
            Iterator<SelectionKey> iterator = this.clientSelector.selectedKeys().iterator();
            while (iterator.hasNext()) {
                SelectionKey selectionKey = iterator.next();
                iterator.remove();
                if (selectionKey.isReadable()) {
                    ConnectedClient connectedClient = (ConnectedClient)selectionKey.attachment();
                    if (selectionKey.channel() instanceof SocketChannel) {
                        try {
                            connectedClient.receiveTCPMessages();
                        }
                        catch (IOException iOException) {
                            this.logger.warning("Server: TCP receive failed from " + connectedClient.toString() + ". " + iOException.toString());
                            this.clientDisconnected(connectedClient);
                        }
                        continue;
                    }
                    this.receiveUdpMessages();
                    continue;
                }
                this.logger.severe("Server: Got unreadable selector key. Ready operations: " + selectionKey.readyOps());
            }
        }
    }

    public void sendMessages() {
        ConnectedClient connectedClient;
        int n = 0;
        while (n < this.clients.size()) {
            connectedClient = this.clients.get(n);
            try {
                connectedClient.sendTCPMessages();
                connectedClient.getRoundtripTimeMonitor().sendPing(this.udpChannel, connectedClient);
                ++n;
            }
            catch (IOException iOException) {
                this.logger.severe("Server: Failed to send TCP messages to client " + connectedClient.toString() + ": " + iOException.toString());
                this.clientDisconnected(connectedClient);
            }
        }
        n = 0;
        while (n < this.pendingClients.size()) {
            connectedClient = this.pendingClients.get(n);
            try {
                connectedClient.sendTCPMessages();
                connectedClient.getRoundtripTimeMonitor().sendPing(this.udpChannel, connectedClient);
                ++n;
            }
            catch (IOException iOException) {
                this.logger.severe("Server: Failed to send TCP messages to pending client " + connectedClient.toString() + ": " + iOException.toString());
                this.clientDisconnected(connectedClient);
            }
        }
        n = 0;
        while (n < this.removedClients.size()) {
            connectedClient = this.removedClients.get(n);
            try {
                connectedClient.sendTCPMessages();
                ++n;
            }
            catch (IOException iOException) {
                this.logger.warning("Server: Failed to send TCP messages to removed client " + connectedClient.toString() + " " + iOException.toString());
                connectedClient.clearOutputQueue();
            }
            if (connectedClient.getOutputQueueSize() != 0) continue;
            this.logger.info("Server: Closing connection to removed client " + connectedClient.toString());
            connectedClient.close();
            this.removedClients.remove(connectedClient);
        }
    }

    private void receiveUdpMessages() {
        while (true) {
            this.udpBuffer.clear();
            InetSocketAddress inetSocketAddress = null;
            try {
                inetSocketAddress = (InetSocketAddress)this.udpChannel.receive(this.udpBuffer);
                if (inetSocketAddress == null) {
                    return;
                }
                ConnectedClient connectedClient = this.udpAddressToClientMap.get(inetSocketAddress);
                this.udpBuffer.limit(this.udpBuffer.position());
                this.udpBuffer.rewind();
                this.udpHeader.readFrom(this.udpBuffer);
                if (!this.udpHeader.isValid()) {
                    String string = connectedClient == null ? inetSocketAddress.toString() : connectedClient.toString();
                    this.logger.severe("Invalid UDP message from " + string);
                }
                if (!this.serverMessageHandler.processUDPMessage(this.udpHeader, this.udpBuffer, connectedClient, inetSocketAddress, this)) continue;
                switch (this.udpHeader.broadcastType) {
                    case TO_ALL: {
                        this.sendUdpToAll(this.udpBuffer);
                        break;
                    }
                    case TO_OTHERS: {
                        this.sendUdpToOthers(this.udpBuffer, connectedClient);
                        break;
                    }
                    case TO_SERVER: {
                        this.sendUdpToServer(this.udpBuffer);
                    }
                }
                continue;
            }
            catch (Exception exception) {
                this.logger.log(Level.SEVERE, exception.toString(), exception);
                continue;
            }
            break;
        }
    }

    private void sendUdpToAll(ByteBuffer byteBuffer) {
        for (ConnectedClient connectedClient : this.clients) {
            byteBuffer.rewind();
            connectedClient.sendUDP(this.udpChannel, byteBuffer);
        }
    }

    private void sendUdpToOthers(ByteBuffer byteBuffer, ConnectedClient connectedClient) {
        for (ConnectedClient connectedClient2 : this.clients) {
            if (connectedClient2 == connectedClient) continue;
            byteBuffer.rewind();
            connectedClient2.sendUDP(this.udpChannel, byteBuffer);
        }
    }

    private void sendUdpToServer(ByteBuffer byteBuffer) {
        byteBuffer.rewind();
        this.serverClient.sendUDP(this.udpChannel, byteBuffer);
    }

    public void sendUdp(ByteBuffer byteBuffer, ConnectedClient connectedClient) {
        byteBuffer.rewind();
        connectedClient.sendUDP(this.udpChannel, byteBuffer);
    }

    public ConnectedClient initUdp(ClientId clientId, InetSocketAddress inetSocketAddress) {
        ConnectedClient connectedClient = this.idToClientMap.get(clientId);
        if (connectedClient == null) {
            this.logger.warning("Server: Got UDP init from non-existing client id " + clientId);
        } else {
            if (this.udpAddressToClientMap.remove(connectedClient.getUDPAddress()) != null) {
                this.logger.info("Server: Removing old UDP address " + connectedClient.getUDPAddress() + " for client " + connectedClient.toString());
            }
            connectedClient.setUDPAddress(new InetSocketAddress(inetSocketAddress.getAddress(), inetSocketAddress.getPort()));
            this.logger.info("Server: Client " + connectedClient.toString() + " requests UDP address " + connectedClient.getUDPAddress());
            this.udpAddressToClientMap.put(connectedClient.getUDPAddress(), connectedClient);
        }
        return connectedClient;
    }

    public String getHostAddress(int n) {
        ConnectedClient connectedClient = this.userNumberToClientMap.get(n);
        if (connectedClient != null) {
            return connectedClient.getInetAddress().getHostAddress();
        }
        this.logger.warning("Trying to get host address to player " + n + " who isn't connected.");
        return null;
    }

    public void logRoundtrip() {
        StringBuilder stringBuilder = new StringBuilder(60);
        stringBuilder.append("Roundtrips: ");
        for (ConnectedClient connectedClient : this.clients) {
            RoundtripTimeMonitor roundtripTimeMonitor = connectedClient.getRoundtripTimeMonitor();
            stringBuilder.append(connectedClient.toStringUsers());
            stringBuilder.append(" ");
            stringBuilder.append(roundtripTimeMonitor.getRoundtrip());
            stringBuilder.append("ms (");
            stringBuilder.append(roundtripTimeMonitor.getSafeRoundtrip());
            stringBuilder.append("ms) ");
        }
        this.logger.info(stringBuilder.toString());
    }

    public boolean removeUser(int n) {
        ConnectedClient connectedClient = this.userNumberToClientMap.get(n);
        if (connectedClient == null) {
            this.logger.warning("Server: No client with user number " + n + " exists");
        } else {
            connectedClient.removeUser(n);
            if (connectedClient.getUsers().isEmpty()) {
                return this.removeClient(connectedClient);
            }
        }
        return false;
    }

    boolean removeClient(ConnectedClient connectedClient) {
        this.logger.info("Server: Removing client " + connectedClient.toString() + " with id " + connectedClient.getClientId());
        SelectionKey selectionKey = connectedClient.getTcpChannel().keyFor(this.clientSelector);
        if (selectionKey != null) {
            selectionKey.cancel();
        }
        if (!this.clients.remove(connectedClient) && !this.pendingClients.remove(connectedClient)) {
            return false;
        }
        while (!connectedClient.getUsers().isEmpty()) {
            ClientUser clientUser = connectedClient.getUsers().get(0);
            connectedClient.removeUser(clientUser.getUserNumber());
        }
        this.idToClientMap.remove(connectedClient.getClientId());
        this.udpAddressToClientMap.remove(connectedClient.getUDPAddress());
        this.removedClients.add(connectedClient);
        return true;
    }

    void clientDisconnected(ConnectedClient connectedClient) {
        connectedClient.clearOutputQueue();
        for (ServerObserver serverObserver : this.observers) {
            for (ClientUser clientUser : connectedClient.getUsers()) {
                serverObserver.userDisconnected(clientUser.getUserNumber());
            }
        }
        this.removeClient(connectedClient);
    }

    public void addUserToClient(int n, boolean bl, ClientId clientId) {
        ConnectedClient connectedClient;
        ConnectedClient connectedClient2 = this.userNumberToClientMap.get(n);
        if (connectedClient2 != (connectedClient = this.idToClientMap.get(clientId))) {
            if (connectedClient2 != null) {
                this.logger.info("Server: " + connectedClient2.toString() + " lost user number " + n);
                connectedClient2.removeUser(n);
            }
            if (connectedClient != null) {
                this.logger.info("Server: " + connectedClient.toString() + " gets user number " + n);
                this.serverMessageHandler.takeUserNumber(n);
                connectedClient.addUser(new ClientUser(n, bl));
            }
        }
    }

    public void reserveUserNumbers() {
        for (ConnectedClient connectedClient : this.clients) {
            for (ClientUser clientUser : connectedClient.getUsers()) {
                if (!clientUser.isPlayer()) continue;
                this.serverMessageHandler.reserveUserNumber(connectedClient.getClientId(), clientUser.getUserNumber());
            }
        }
    }

    public void removeAllClients() {
        while (!this.clients.isEmpty()) {
            this.removeClient(this.clients.get(0));
        }
    }

    public void close() {
        this.logger.info("Server: Closing");
        this.removeAllClients();
        this.removedClients.clear();
        if (this.acceptSelector != null) {
            try {
                this.acceptSelector.close();
            }
            catch (IOException iOException) {
                this.logger.severe(iOException.getMessage());
                iOException.printStackTrace();
            }
        }
        if (this.clientSelector != null) {
            try {
                this.clientSelector.close();
            }
            catch (IOException iOException) {
                this.logger.severe(iOException.getMessage());
                iOException.printStackTrace();
            }
        }
        if (this.serverChannel != null) {
            try {
                this.serverChannel.close();
            }
            catch (IOException iOException) {
                this.logger.severe(iOException.getMessage());
                iOException.printStackTrace();
            }
        }
        if (this.udpChannel != null) {
            try {
                this.udpChannel.close();
            }
            catch (IOException iOException) {
                this.logger.severe(iOException.getMessage());
                iOException.printStackTrace();
            }
        }
    }

    public int getMaxRoundtrip() {
        int n = 0;
        for (ConnectedClient connectedClient : this.clients) {
            int n2 = connectedClient.getRoundtripTimeMonitor().getRoundtrip();
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    public int getMaxSafeRoundtrip() {
        int n = 0;
        for (ConnectedClient connectedClient : this.clients) {
            int n2 = connectedClient.getRoundtripTimeMonitor().getSafeRoundtrip();
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    public boolean hasUDPAddress(int n) {
        ConnectedClient connectedClient = this.userNumberToClientMap.get(n);
        if (connectedClient != null) {
            return connectedClient.getUDPAddress() != null;
        }
        return false;
    }

    boolean processTcpMessage(TCPMessage.TCPHeader tCPHeader, ByteBuffer byteBuffer, ConnectedClient connectedClient) {
        if (this.serverMessageHandler.processTCPMessage(tCPHeader, byteBuffer, connectedClient, this)) {
            switch (tCPHeader.broadcastType) {
                case TO_ALL: {
                    this.sendTcpToAll(byteBuffer);
                    break;
                }
                case TO_OTHERS: {
                    this.sendTcpToOthers(byteBuffer, connectedClient);
                    break;
                }
                case TO_SERVER: {
                    this.sendTcpToServer(byteBuffer);
                }
            }
            return true;
        }
        return false;
    }

    void sendTcpToAll(ByteBuffer byteBuffer) {
        for (ConnectedClient connectedClient : this.clients) {
            connectedClient.sendTCP(byteBuffer);
        }
    }

    void sendTcpToOthers(ByteBuffer byteBuffer, ConnectedClient connectedClient) {
        for (ConnectedClient connectedClient2 : this.clients) {
            if (connectedClient2 == connectedClient) continue;
            connectedClient2.sendTCP(byteBuffer);
        }
    }

    void sendTcpToServer(ByteBuffer byteBuffer) {
        this.serverClient.sendTCP(byteBuffer);
    }

    void sendTcpToPendingClients(ByteBuffer byteBuffer) {
        for (ConnectedClient connectedClient : this.pendingClients) {
            connectedClient.sendTCP(byteBuffer);
        }
    }

    public void setServerClient(ClientId clientId) {
        this.serverClient = this.idToClientMap.get(clientId);
        if (this.serverClient == null) {
            this.logger.severe("Server: No connected client with id " + clientId + " exists.");
        }
    }

    public ConnectedClient getServerClient() {
        return this.serverClient;
    }

    public ServerMessageHandler getMessageHandler() {
        return this.serverMessageHandler;
    }

    public ClientId getClientId(int n) {
        ConnectedClient connectedClient = this.userNumberToClientMap.get(n);
        if (connectedClient != null) {
            return connectedClient.getClientId();
        }
        return ClientId.invalidClientId();
    }

    public void acceptClientJoin(int n) {
        this.acceptClientJoin(n, true);
    }

    private void acceptClientJoin(int n, boolean bl) {
        if (n == 0) {
            this.logger.warning("Server: Can't accept client join with no user number.");
            return;
        }
        Iterator<ConnectedClient> iterator = this.pendingClients.iterator();
        while (iterator.hasNext()) {
            ConnectedClient connectedClient = iterator.next();
            if (connectedClient.getUser(n) == null) continue;
            this.logger.info("Server: Join accepted for " + connectedClient.toString());
            iterator.remove();
            this.clients.add(connectedClient);
            if (!bl) continue;
            this.serverMessageHandler.acceptJoin(connectedClient, this);
        }
    }

    public int numPlayers() {
        int n = 0;
        for (ConnectedClient connectedClient : this.clients) {
            for (ClientUser clientUser : connectedClient.getUsers()) {
                if (!clientUser.isPlayer()) continue;
                ++n;
            }
        }
        return n;
    }

    public int numRemovedClients() {
        return this.removedClients.size();
    }

    Map<Integer, ConnectedClient> getUserNumberToClientMap() {
        return this.userNumberToClientMap;
    }

    ConnectedClient getClientByUdpAddress(InetSocketAddress inetSocketAddress) {
        return this.udpAddressToClientMap.get(inetSocketAddress);
    }

    ArrayList<ConnectedClient> getClients() {
        return this.clients;
    }
}

