/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.network;

import com.turborilla.mule.Properties;
import com.turborilla.mule.network.ConnectedClient;
import com.turborilla.mule.network.UDPMessage;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.util.Arrays;

public final class RoundtripTimeMonitor {
    private static final int MAX_NUM_TIMES = 20;
    private static final int MAX_ROUNDTRIP = 2000;
    private int[] udpRoundtripTimes = new int[20];
    private int[] udpRoundtripTimesSorted = new int[20];
    private int roundtripIndex = 0;
    private int numTimes;
    private int udpSafeRoundtrip;
    private int udpRoundtrip;
    private long udpSendTime;
    private UDPMessage.UDPPingMessage udpPingMessage;
    private ByteBuffer udpPingBuffer;

    public RoundtripTimeMonitor() {
        Arrays.fill(this.udpRoundtripTimes, 0);
        Arrays.fill(this.udpRoundtripTimesSorted, 0);
        this.udpSafeRoundtrip = 0;
        this.udpRoundtrip = 0;
        this.udpSendTime = System.currentTimeMillis() + 4000L;
        this.udpPingBuffer = ByteBuffer.allocate(40);
        this.udpPingMessage = new UDPMessage.UDPPingMessage(0L, 0);
    }

    public void sendPing(DatagramChannel datagramChannel, ConnectedClient connectedClient) {
        if (connectedClient.getUDPAddress() == null) {
            return;
        }
        if (System.currentTimeMillis() >= this.udpSendTime) {
            this.udpPingBuffer.clear();
            this.udpPingMessage.roundTripTime = this.udpRoundtrip;
            this.udpPingMessage.timestamp = System.currentTimeMillis();
            this.udpPingMessage.write(this.udpPingBuffer);
            this.udpPingBuffer.rewind();
            connectedClient.sendUDP(datagramChannel, this.udpPingBuffer);
            this.udpSendTime = System.currentTimeMillis() + Properties.mule.udpPingInterval;
        }
    }

    public void receivePing(ByteBuffer byteBuffer) {
        this.udpPingMessage.readFrom(byteBuffer);
        this.udpRoundtripTimes[this.roundtripIndex] = (int)(System.currentTimeMillis() - this.udpPingMessage.timestamp);
        this.roundtripIndex = (this.roundtripIndex + 1) % this.udpRoundtripTimes.length;
        if (this.numTimes < this.udpRoundtripTimes.length) {
            ++this.numTimes;
        }
        for (int i = 0; i < this.numTimes; ++i) {
            this.udpRoundtripTimesSorted[i] = this.udpRoundtripTimes[i];
        }
        Arrays.sort(this.udpRoundtripTimesSorted, 0, this.numTimes);
        this.udpSafeRoundtrip = this.udpRoundtripTimesSorted[3 * this.numTimes / 4];
        this.udpRoundtrip = this.udpRoundtripTimesSorted[this.numTimes / 2];
        if (this.udpSafeRoundtrip > 2000) {
            this.udpSafeRoundtrip = 2000;
            if (this.udpRoundtrip > 2000) {
                this.udpRoundtrip = 2000;
            }
        }
    }

    public int getSafeRoundtrip() {
        return this.udpSafeRoundtrip;
    }

    public int getRoundtrip() {
        return this.udpRoundtrip;
    }
}

