/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.network;

import com.turborilla.mule.Properties;
import com.turborilla.mule.model.Player;
import com.turborilla.mule.network.MasterClientListener;
import com.turborilla.mule.network.MasterRequest;
import com.turborilla.mule.network.MasterResponse;
import com.turborilla.mule.network.MasterResponseException;
import com.turborilla.mule.view.ViewProperties;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MasterClient
extends MasterClientListener {
    private Logger logger = Logger.getLogger("mule");
    private String serverHttpURL;
    private Thread thread;
    private ArrayList<RequestQueue> outputQueues = new ArrayList();
    private LinkedBlockingQueue<MasterResponse> inputQueue;
    private ArrayList<WeakReference<MasterClientListener>> listeners;
    private boolean closed = false;
    private String sessionId;
    private long lastSendAliveTime = 0L;

    public MasterClient() {
        for (RequestPolicy requestPolicy : RequestPolicy.values()) {
            this.outputQueues.add(new RequestQueue(requestPolicy));
        }
        this.inputQueue = new LinkedBlockingQueue();
        this.listeners = new ArrayList();
        this.thread = new Thread(new MasterCommunicator());
        this.thread.setPriority(1);
        this.thread.start();
    }

    public void setServerAddress(String string) {
        if (string == null || string.equals("")) {
            this.logger.warning("MasterClient: Ignoring empty URL address.");
        } else {
            String string2 = string.startsWith("http://") ? new String(string) : "http://" + string;
            if (string2.endsWith("/")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            string2 = string2 + Properties.mule.masterServerPath;
            this.logger.info("MasterClient: Address " + string2);
            this.serverHttpURL = string2;
        }
    }

    public void close() {
        this.logger.info("MasterServer: Closing...");
        long l = System.currentTimeMillis();
        this.closed = true;
        try {
            while (this.thread.isAlive()) {
                this.thread.join(4000L);
                if (!this.thread.isAlive()) continue;
                this.logger.info("Interrupting master server");
                this.thread.interrupt();
                break;
            }
        }
        catch (InterruptedException interruptedException) {
            this.logger.log(Level.WARNING, interruptedException.toString(), interruptedException);
        }
        for (RequestQueue requestQueue : this.outputQueues) {
            requestQueue.clear();
        }
        this.inputQueue.clear();
        l = System.currentTimeMillis() - l;
        this.logger.info("MasterServer: Closed (" + l + "ms)");
    }

    public boolean isClosed() {
        return this.closed;
    }

    public int numRequests() {
        int n = 0;
        for (int i = 0; i < this.outputQueues.size(); ++i) {
            n += this.outputQueues.get(i).size();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addObserver(MasterClientListener masterClientListener) {
        if (masterClientListener == null) {
            throw new IllegalArgumentException("Can't add null value master client listener");
        }
        ArrayList<WeakReference<MasterClientListener>> arrayList = this.listeners;
        synchronized (arrayList) {
            Iterator<WeakReference<MasterClientListener>> iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                MasterClientListener masterClientListener2 = (MasterClientListener)iterator.next().get();
                if (masterClientListener != masterClientListener2) continue;
                this.logger.warning("MasterClient already has listener " + masterClientListener2);
                return;
            }
            this.listeners.add(new WeakReference<MasterClientListener>(masterClientListener));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeObserver(MasterClientListener masterClientListener) {
        if (masterClientListener == null) {
            throw new IllegalArgumentException("Can't remove null value master client listener");
        }
        ArrayList<WeakReference<MasterClientListener>> arrayList = this.listeners;
        synchronized (arrayList) {
            Iterator<WeakReference<MasterClientListener>> iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                MasterClientListener masterClientListener2 = (MasterClientListener)iterator.next().get();
                if (masterClientListener != masterClientListener2) continue;
                iterator.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveResponses() {
        MasterResponse masterResponse = null;
        while ((masterResponse = this.inputQueue.poll()) != null) {
            ArrayList<WeakReference<MasterClientListener>> arrayList = this.listeners;
            synchronized (arrayList) {
                Iterator<WeakReference<MasterClientListener>> iterator = this.listeners.iterator();
                while (iterator.hasNext()) {
                    MasterClientListener masterClientListener = (MasterClientListener)iterator.next().get();
                    if (masterClientListener == null) {
                        iterator.remove();
                        continue;
                    }
                    masterResponse.accept(masterClientListener);
                }
            }
        }
    }

    public void sendLogin(String string, String string2, boolean bl) {
        this.logSend("Login");
        MasterRequest.FormData formData = new MasterRequest.FormData();
        formData.addField("username", string);
        formData.addField("password", string2);
        formData.addField("version", "1.3.4");
        if (bl) {
            formData.addField("ignore_maintenance", bl);
        }
        this.unreliableRequest(new MasterRequest("login.php", formData, new MasterResponse.Login()));
    }

    public void sendRegisterUser(String string, String string2) {
        MasterRequest.FormData formData = new MasterRequest.FormData();
        formData.addField("username", string);
        formData.addField("password", string2);
        this.unreliableRequest(new MasterRequest("register_user.php", formData, new MasterResponse.RegisterUser()));
    }

    public void sendRefreshLobby(String string, long l) {
        MasterRequest.FormData formData = new MasterRequest.FormData();
        formData.addField("last_update", string);
        formData.addField("last_message_id", l);
        this.unreliableRequest(new MasterRequest("refresh_lobby.php", formData, new MasterResponse.RefreshLobby()));
    }

    public void sendTestConnection() {
        MasterRequest.FormData formData = new MasterRequest.FormData();
        this.unreliableRequest(new MasterRequest("test_connection.php", formData, new MasterResponse.TestConnection()));
    }

    public void sendNewGame(String string, String string2, boolean bl, boolean bl2, int n, boolean bl3) {
        this.logSend("New Game");
        MasterRequest.FormData formData = new MasterRequest.FormData();
        formData.addField("game_name", string);
        formData.addField("mode", string2);
        formData.addField("version", "1.3.4");
        if (bl) {
            formData.addField("development", "single");
        } else {
            formData.addField("development", "multi");
        }
        if (bl2) {
            formData.addField("water", "river");
        } else {
            formData.addField("water", "lakes");
        }
        formData.addField("rounds", n);
        formData.addField("spectators", bl3);
        this.reliableRequest(new MasterRequest("new_game.php", formData, new MasterResponse.NewGame()));
    }

    public void sendStartGame(Collection<Player> collection) {
        this.logSend("Start Game");
        MasterRequest.FormData formData = new MasterRequest.FormData();
        int n = 0;
        for (Player player : collection) {
            String string = ViewProperties.get().getAvatarWebColor(player.getColorIndex());
            formData.addField("player_number" + n, player.getUserNumber());
            formData.addField("player_index" + n, player.getPlayerIndex());
            formData.addField("color" + n, string);
            ++n;
        }
        this.reliableRequest(new MasterRequest("start_game.php", formData, new MasterResponse.StartGame()));
    }

    public void sendFinishGame(boolean bl) {
        this.logSend("Finish Game");
        MasterRequest.FormData formData = new MasterRequest.FormData();
        formData.addField("failed", bl ? "true" : "false");
        this.reliableRequest(new MasterRequest("finish_game.php", formData, new MasterResponse.FinishGame()));
    }

    public void sendUserJoin(long l, int n, String string) {
        this.logSend("User Join");
        MasterRequest.FormData formData = new MasterRequest.FormData();
        formData.addField("user_id", l);
        formData.addField("user_number", n);
        formData.addField("name", string);
        this.reliableRequest(new MasterRequest("user_join.php", formData, new MasterResponse.UserJoin()));
    }

    public void sendUserLeft(long l, int n) {
        this.logSend("User Left ID " + l + " user number " + n);
        MasterRequest.FormData formData = new MasterRequest.FormData();
        formData.addField("user_id", l);
        formData.addField("user_number", n);
        this.reliableRequest(new MasterRequest("user_left.php", formData, new MasterResponse.UserLeft()));
    }

    public void sendRoundResults(int n, int n2, int n3, int n4, int n5) {
        this.logSend("Round Results");
        MasterRequest.FormData formData = new MasterRequest.FormData();
        formData.addField("user_number", n);
        formData.addField("round", n2);
        formData.addField("money", n3);
        formData.addField("goods", n4);
        formData.addField("plots", n5);
        this.reliableRequest(new MasterRequest("round_result.php", formData, new MasterResponse.RoundResults()));
    }

    public void sendFinishRound() {
        this.logSend("Finish Round");
        MasterRequest.FormData formData = new MasterRequest.FormData();
        this.reliableRequest(new MasterRequest("finish_round.php", formData, new MasterResponse.FinishRound()));
    }

    public void sendLog(long l, String string, String string2) {
        this.logSend("Game Log");
        try {
            FileInputStream fileInputStream = new FileInputStream(string2);
            int n = fileInputStream.available();
            byte[] byArray = new byte[n];
            fileInputStream.read(byArray, 0, n);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n);
            ZipOutputStream zipOutputStream = new ZipOutputStream(byteArrayOutputStream);
            zipOutputStream.setMethod(8);
            zipOutputStream.setLevel(9);
            zipOutputStream.putNextEntry(new ZipEntry("log.txt"));
            zipOutputStream.write(byArray);
            zipOutputStream.closeEntry();
            zipOutputStream.close();
            MasterRequest.FormData formData = new MasterRequest.FormData();
            formData.addField("game_id", l);
            formData.addField("type", string);
            formData.addFile("log", "log.txt", "text/plain", byteArrayOutputStream.toByteArray());
            this.unreliableRequest(new MasterRequest("save_log.php", formData, new MasterResponse.SaveLog()));
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.logger.severe("Log file \"" + string2 + "\" not found. " + fileNotFoundException.getMessage());
        }
        catch (IOException iOException) {
            this.logger.severe("Failed to read log file \"" + string2 + "\". " + iOException.getMessage());
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.logger.severe("Couldn't send log. Out of memory.");
        }
    }

    public void sendEnterLobby() {
        this.logSend("Enter Lobby");
        MasterRequest.FormData formData = new MasterRequest.FormData();
        this.unreliableRequest(new MasterRequest("enter_lobby.php", formData, new MasterResponse.EnterLobby()));
    }

    public void sendChatMessage(String string) {
        MasterRequest.FormData formData = new MasterRequest.FormData();
        formData.addField("text", string);
        this.unreliableRequest(new MasterRequest("add_lobby_chat.php", formData, new MasterResponse.AddChatMessage()));
    }

    public void sendChatLog(long l, String string) {
        this.logSend("Game Chat Log");
        try {
            byte[] byArray = string.getBytes("ISO-8859-1");
            MasterRequest.FormData formData = new MasterRequest.FormData();
            formData.addField("game_id", l);
            formData.addFile("chat", "chat.html", "text/plain", byArray);
            this.unreliableRequest(new MasterRequest("save_chat.php", formData, new MasterResponse.SaveChat()));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.logger.log(Level.SEVERE, unsupportedEncodingException.toString(), unsupportedEncodingException);
        }
    }

    public void sendResumeGame(long l) {
        MasterRequest.FormData formData = new MasterRequest.FormData();
        formData.addField("game_id", l);
        this.unreliableRequest(new MasterRequest("resume_game.php", formData, new MasterResponse.ResumeGame()));
    }

    public void sendLogout() {
        MasterRequest.FormData formData = new MasterRequest.FormData();
        this.unreliableRequest(new MasterRequest("logout.php", formData, new MasterResponse.Logout()));
    }

    public void getUserInfo(long l, String string) {
        MasterRequest.FormData formData = new MasterRequest.FormData();
        formData.addField("user_id", l);
        formData.addField("mode", string);
        this.unreliableRequest(new MasterRequest("get_user_info.php", formData, new MasterResponse.UserInfo(l)));
    }

    public void getAvatarImage(long l) {
        MasterRequest.FormData formData = new MasterRequest.FormData();
        formData.addField("user_id", l);
        this.unreliableRequest(new MasterRequest("get_avatar_image.php", formData, new MasterResponse.AvatarImage(l)));
    }

    private void logSend(String string) {
        this.logger.info("MasterClient: Sending " + string);
    }

    private void unreliableRequest(MasterRequest masterRequest) {
        if (!this.closed) {
            int n = RequestPolicy.UNRELIABLE_UNORDERED.ordinal();
            this.outputQueues.get(n).add(masterRequest);
        }
    }

    private void reliableRequest(MasterRequest masterRequest) {
        if (!this.closed) {
            int n = RequestPolicy.RELIABLE_ORDERED.ordinal();
            this.outputQueues.get(n).add(masterRequest);
        }
    }

    private boolean send(MasterRequest masterRequest) {
        boolean bl;
        block17: {
            MasterResponse masterResponse = masterRequest.getResponse();
            bl = true;
            try {
                URL uRL = new URL(this.serverHttpURL + "/" + masterRequest.getPath());
                HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
                httpURLConnection.setUseCaches(false);
                if (this.sessionId != null) {
                    httpURLConnection.setRequestProperty("Cookie", "PHPSESSID=" + this.sessionId);
                }
                httpURLConnection.setRequestMethod("POST");
                httpURLConnection.setRequestProperty("Content-Type", "multipart/form-data, boundary=Mule-Boundary");
                httpURLConnection.setAllowUserInteraction(true);
                httpURLConnection.setDoInput(true);
                httpURLConnection.setDoOutput(true);
                OutputStream outputStream = httpURLConnection.getOutputStream();
                outputStream.write(masterRequest.getData().getBytes());
                outputStream.write("--Mule-Boundary--".getBytes("ISO-8859-1"));
                outputStream.flush();
                outputStream.close();
                String string = null;
                switch (httpURLConnection.getResponseCode()) {
                    case 500: {
                        string = "Internal server error. Please try again later.";
                        break;
                    }
                    case 404: {
                        string = "Service not found at server.";
                        break;
                    }
                    case 403: {
                        string = "Forbidden to access server.";
                        break;
                    }
                    case 400: {
                        string = "Bad server request. Please try again later.";
                    }
                }
                if (string != null) {
                    String string2 = masterResponse.getClass().getSimpleName();
                    this.logger.severe(string2 + " " + string);
                    masterResponse.error(string);
                    bl = false;
                } else {
                    try {
                        masterResponse.read(httpURLConnection);
                    }
                    catch (MasterResponseException masterResponseException) {
                        String string3 = masterResponse.getClass().getSimpleName();
                        this.logger.log(Level.SEVERE, string3 + " " + masterResponseException.toString(), masterResponseException);
                        masterResponse.error(masterResponseException.getUserMessage());
                        bl = false;
                    }
                }
                if (bl && masterResponse instanceof MasterResponse.AvatarImage) break block17;
                try {
                    httpURLConnection.getInputStream().close();
                    httpURLConnection.disconnect();
                }
                catch (IOException iOException) {
                    if (bl) {
                        throw iOException;
                    }
                }
            }
            catch (ConnectException connectException) {
                String string = masterResponse.getClass().getSimpleName();
                this.logger.severe(string + " " + connectException.toString());
                masterResponse.error(connectException.getMessage());
                bl = false;
            }
            catch (IOException iOException) {
                String string = masterResponse.getClass().getSimpleName();
                this.logger.log(Level.SEVERE, string + " " + iOException.toString(), iOException);
                masterResponse.error(iOException.getMessage());
                bl = false;
            }
        }
        return bl;
    }

    private void printHeaderFields(URLConnection uRLConnection) {
        for (Map.Entry<String, List<String>> entry : uRLConnection.getHeaderFields().entrySet()) {
            System.out.println(entry.getKey() + ": " + entry.getValue());
        }
    }

    @Override
    public void apply(MasterResponse.Login login) {
        this.sessionId = login.getString("session_id");
        this.logger.info("MasterClient: Session ID: " + this.sessionId);
    }

    private static final class RequestQueue {
        private static Logger logger = Logger.getLogger("mule");
        private final LinkedBlockingQueue<MasterRequest> queue;
        private long time = 0L;
        private long retryDelay = MIN_RETRY;
        private final RequestPolicy policy;
        private static long MIN_RETRY = 2000L;
        private static long MAX_RETRY = 180000L;

        public RequestQueue(RequestPolicy requestPolicy) {
            this.queue = new LinkedBlockingQueue();
            this.policy = requestPolicy;
        }

        public void clear() {
            this.time = 0L;
            this.retryDelay = MIN_RETRY;
            this.queue.clear();
        }

        public int size() {
            return this.queue.size();
        }

        public boolean add(MasterRequest masterRequest) {
            return this.queue.add(masterRequest);
        }

        public MasterRequest peek() {
            return this.queue.peek();
        }

        public void remove() {
            this.time = 0L;
            this.retryDelay = MIN_RETRY;
            this.queue.poll();
        }

        public boolean isReliable() {
            return this.policy == RequestPolicy.RELIABLE_ORDERED;
        }

        public void retry() {
            logger.info("Master Client: Retry send in " + this.retryDelay + " ms");
            this.time = System.currentTimeMillis() + this.retryDelay;
            this.retryDelay = Math.min(this.retryDelay * 7L / 4L, MAX_RETRY);
        }

        public long getTime() {
            return this.time;
        }
    }

    private class MasterCommunicator
    implements Runnable {
        private MasterCommunicator() {
        }

        public void run() {
            while (true) {
                boolean bl = false;
                if (System.currentTimeMillis() > MasterClient.this.lastSendAliveTime + Properties.mule.masterSendAliveTime && MasterClient.this.sessionId != null) {
                    MasterClient.this.lastSendAliveTime = System.currentTimeMillis();
                    MasterRequest.FormData formData = new MasterRequest.FormData();
                    MasterClient.this.unreliableRequest(new MasterRequest("alive.php", formData, new MasterResponse.Alive()));
                }
                for (int i = 0; i < MasterClient.this.outputQueues.size(); ++i) {
                    MasterRequest masterRequest;
                    RequestQueue requestQueue = (RequestQueue)MasterClient.this.outputQueues.get(i);
                    if (requestQueue.getTime() > System.currentTimeMillis() || (masterRequest = requestQueue.peek()) == null) continue;
                    bl = true;
                    try {
                        boolean bl2 = MasterClient.this.send(masterRequest);
                        if (bl2 || !requestQueue.isReliable()) {
                            requestQueue.remove();
                            masterRequest.getResponse().accept(MasterClient.this);
                            MasterClient.this.inputQueue.add(masterRequest.getResponse());
                            continue;
                        }
                        requestQueue.retry();
                        continue;
                    }
                    catch (Throwable throwable) {
                        MasterClient.this.logger.log(Level.SEVERE, throwable.toString(), throwable);
                    }
                }
                if (bl) continue;
                try {
                    if (MasterClient.this.closed) break;
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                    MasterClient.this.logger.info("MasterClient: Sending thread was interrupted with " + MasterClient.this.numRequests() + " requests on queue.");
                    break;
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RequestPolicy {
        UNRELIABLE_UNORDERED,
        RELIABLE_ORDERED;

    }
}

