/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.network;

import com.turborilla.mule.Properties;
import com.turborilla.mule.network.Message;
import com.turborilla.mule.network.TCPMessage;
import java.util.Iterator;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Logger;

public class DelayedMessageQueue {
    private Logger logger = Logger.getLogger("mule");
    private LinkedBlockingQueue<DelayedMessage> queue = new LinkedBlockingQueue();

    DelayedMessageQueue() {
    }

    public void tickFrame() {
        for (DelayedMessage delayedMessage : this.queue) {
            if (delayedMessage.delayFrames <= 0) continue;
            delayedMessage.delayFrames--;
        }
    }

    public Message nextMessage() {
        if (this.queue.isEmpty()) {
            return null;
        }
        Iterator<DelayedMessage> iterator = this.queue.iterator();
        while (iterator.hasNext()) {
            DelayedMessage delayedMessage = iterator.next();
            if (delayedMessage.delayFrames != 0) continue;
            iterator.remove();
            return delayedMessage.message;
        }
        return null;
    }

    void add(TCPMessage.SynchronizedMessage synchronizedMessage) {
        int n = synchronizedMessage.maxRoundtrip - synchronizedMessage.roundtrip;
        int n2 = n * Properties.mule.framesPerSecond / 2000;
        TCPMessage tCPMessage = synchronizedMessage.message;
        this.logger.info((Object)((Object)tCPMessage.getType()) + " is delivered in " + n2 + " frames, rountrip " + synchronizedMessage.roundtrip + "ms, max " + synchronizedMessage.maxRoundtrip + "ms");
        DelayedMessage delayedMessage = new DelayedMessage(n2, tCPMessage);
        this.queue.add(delayedMessage);
    }

    private static class DelayedMessage {
        private int delayFrames;
        private Message message;

        private DelayedMessage(int n, Message message) {
            this.delayFrames = n;
            this.message = message;
        }
    }
}

