/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.network;

import com.turborilla.mule.Properties;
import com.turborilla.mule.network.ClientId;
import com.turborilla.mule.network.ClientUser;
import com.turborilla.mule.network.RoundtripTimeMonitor;
import com.turborilla.mule.network.Server;
import com.turborilla.mule.network.TCPMessage;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConnectedClient {
    Logger logger = Logger.getLogger("mule");
    private final Server server;
    private SocketChannel tcpChannel;
    private InetSocketAddress udpAddress;
    private final ClientId clientId;
    private final ArrayList<ClientUser> users;
    private long connectionTime;
    private InetAddress inetAddress;
    private TCPMessage.TCPHeader tcpRecvHeader = new TCPMessage.TCPHeader();
    private ByteBuffer tcpRecvHeaderBuffer = ByteBuffer.allocateDirect(13);
    private ByteBuffer tcpRecvMessageBuffer = ByteBuffer.allocate(4096);
    private LinkedBlockingQueue<ByteBuffer> outputQueue;
    private ByteBuffer sendBuffer;
    private int sendPosition;
    private RoundtripTimeMonitor roundtripMonitor;

    public ConnectedClient(Server server, SocketChannel socketChannel) throws SocketException {
        this.server = server;
        this.tcpChannel = socketChannel;
        this.clientId = ClientId.randomCliendId();
        this.users = new ArrayList();
        this.outputQueue = new LinkedBlockingQueue();
        this.connectionTime = System.currentTimeMillis();
        this.inetAddress = socketChannel.socket().getInetAddress();
        this.roundtripMonitor = new RoundtripTimeMonitor();
    }

    public ClientId getClientId() {
        return this.clientId;
    }

    public InetAddress getInetAddress() {
        return this.inetAddress;
    }

    public ArrayList<ClientUser> getUsers() {
        return this.users;
    }

    public ClientUser getUser(int n) {
        for (int i = 0; i < this.users.size(); ++i) {
            ClientUser clientUser = this.users.get(i);
            if (clientUser.getUserNumber() != n) continue;
            return clientUser;
        }
        return null;
    }

    public void addUser(ClientUser clientUser) {
        this.users.add(clientUser);
        this.server.getUserNumberToClientMap().put(clientUser.getUserNumber(), this);
    }

    public boolean removeUser(int n) {
        this.logger.info("Server: Removing user " + n + " from " + this.toString());
        ClientUser clientUser = this.getUser(n);
        boolean bl = this.users.remove(clientUser);
        if (bl) {
            this.server.getUserNumberToClientMap().remove(n);
            this.server.getMessageHandler().freeUserNumber(n);
        }
        return bl;
    }

    public void sendTCP(ByteBuffer byteBuffer) {
        this.outputQueue.add(byteBuffer);
    }

    public void receiveTCPMessages() throws IOException {
        while (true) {
            if (this.tcpRecvHeaderBuffer.hasRemaining()) {
                this.tcpChannel.read(this.tcpRecvHeaderBuffer);
                if (this.tcpRecvHeaderBuffer.position() != this.tcpRecvHeaderBuffer.limit()) break;
                this.tcpRecvHeaderBuffer.rewind();
                this.tcpRecvHeader.readFrom(this.tcpRecvHeaderBuffer);
                if (!this.tcpRecvHeader.isValid()) {
                    this.logger.severe("Server: Client " + this.toString() + " sent invalid TCP message.");
                    this.server.clientDisconnected(this);
                    return;
                }
                int n = 13 + this.tcpRecvHeader.messageSize;
                if (n > this.tcpRecvMessageBuffer.capacity()) {
                    this.logger.info("Server: Increasing TCP recieve buffer to " + this.tcpRecvHeader.messageSize + " bytes");
                    this.tcpRecvMessageBuffer = ByteBuffer.allocate(n);
                }
                if (this.getUser(this.tcpRecvHeader.userNumber) == null && this.tcpRecvHeader.userNumber != 0) {
                    this.logger.severe("Message " + (Object)((Object)this.tcpRecvHeader.type) + " from " + this.toString() + " has spoofed user number " + this.tcpRecvHeader.userNumber);
                    this.server.clientDisconnected(this);
                    return;
                }
                this.tcpRecvMessageBuffer.clear();
                this.tcpRecvMessageBuffer.limit(n);
                this.tcpRecvHeader.writeTo(this.tcpRecvMessageBuffer);
                continue;
            }
            this.tcpChannel.read(this.tcpRecvMessageBuffer);
            if (this.tcpRecvMessageBuffer.position() != this.tcpRecvMessageBuffer.limit()) break;
            this.tcpRecvMessageBuffer.rewind();
            if (this.server.processTcpMessage(this.tcpRecvHeader, this.tcpRecvMessageBuffer, this)) {
                this.tcpRecvMessageBuffer = ByteBuffer.allocate(this.tcpRecvMessageBuffer.capacity());
            }
            this.tcpRecvHeader.reset();
            this.tcpRecvHeaderBuffer.clear();
        }
    }

    public void sendTCPMessages() throws IOException {
        while (true) {
            if (this.sendBuffer == null) {
                this.sendBuffer = this.outputQueue.poll();
                if (this.sendBuffer == null) {
                    return;
                }
                this.sendPosition = 0;
                continue;
            }
            this.sendBuffer.rewind();
            this.sendBuffer.position(this.sendPosition);
            this.tcpChannel.write(this.sendBuffer);
            this.sendPosition = this.sendBuffer.position();
            if (this.sendBuffer.position() != this.sendBuffer.limit()) {
                return;
            }
            this.sendBuffer = null;
        }
    }

    public void sendUDP(DatagramChannel datagramChannel, ByteBuffer byteBuffer) {
        try {
            if (this.udpAddress == null) {
                this.logger.warning("Server: Connected client has no UDP address");
            } else {
                int n = datagramChannel.send(byteBuffer, this.udpAddress);
                if (n == 0) {
                    this.logger.severe("Server: Couldn't send UDP message.");
                }
            }
        }
        catch (IOException iOException) {
            this.logger.severe("Server: UDP send failed to client " + this.toString() + ". " + iOException.getMessage());
        }
    }

    public InetSocketAddress getUDPAddress() {
        return this.udpAddress;
    }

    public void setUDPAddress(InetSocketAddress inetSocketAddress) {
        this.udpAddress = inetSocketAddress;
    }

    public String toString() {
        return this.inetAddress + " " + this.toStringUsers();
    }

    public String toStringUsers() {
        StringBuilder stringBuilder = new StringBuilder(20);
        stringBuilder.append("<");
        for (int i = 0; i < this.users.size(); ++i) {
            if (i > 0) {
                stringBuilder.append(" ");
            }
            stringBuilder.append(this.users.get(i).toShortString());
        }
        stringBuilder.append(">");
        return stringBuilder.toString();
    }

    public RoundtripTimeMonitor getRoundtripTimeMonitor() {
        return this.roundtripMonitor;
    }

    public int getOutputQueueSize() {
        return this.outputQueue.size();
    }

    public SocketChannel getTcpChannel() {
        return this.tcpChannel;
    }

    public void clearOutputQueue() {
        this.outputQueue.clear();
    }

    public boolean hasJoined() {
        return !this.users.isEmpty();
    }

    public boolean hasJoinTimedOut() {
        if (this.hasJoined()) {
            return false;
        }
        long l = System.currentTimeMillis() - this.connectionTime;
        return l > Properties.mule.joinTimeout;
    }

    public void close() {
        try {
            this.tcpChannel.close();
        }
        catch (IOException iOException) {
            this.logger.warning("Server: Exception on closing TCP channel for " + this.toString() + ": " + iOException.getMessage());
        }
    }
}

