/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.network;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.UUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientId
implements Comparable<ClientId> {
    private UUID uuid;

    private ClientId(UUID uUID) {
        this.uuid = uUID;
    }

    public boolean isValid() {
        return this.uuid.getMostSignificantBits() != 0L && this.uuid.getLeastSignificantBits() != 0L;
    }

    public static ClientId invalidClientId() {
        ClientId clientId = new ClientId(new UUID(0L, 0L));
        return clientId;
    }

    public static ClientId randomCliendId() {
        UUID uUID = UUID.randomUUID();
        ClientId clientId = new ClientId(uUID);
        return clientId;
    }

    public String toString() {
        return this.uuid.toString();
    }

    public boolean equals(Object object) {
        if (object instanceof ClientId) {
            ClientId clientId = (ClientId)object;
            return clientId.uuid.equals(clientId.uuid);
        }
        return false;
    }

    public int hashCode() {
        return this.uuid.hashCode();
    }

    @Override
    public int compareTo(ClientId clientId) {
        return this.uuid.compareTo(this.uuid);
    }

    protected void readFrom(ByteBuffer byteBuffer) throws BufferOverflowException {
        long l = byteBuffer.getLong();
        long l2 = byteBuffer.getLong();
        this.uuid = new UUID(l, l2);
    }

    protected void writeTo(ByteBuffer byteBuffer) throws BufferOverflowException {
        byteBuffer.putLong(this.uuid.getMostSignificantBits());
        byteBuffer.putLong(this.uuid.getLeastSignificantBits());
    }
}

