/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.network;

import com.turborilla.mule.MuleException;
import com.turborilla.mule.Properties;
import com.turborilla.mule.network.ClientId;
import com.turborilla.mule.network.DelayedMessageQueue;
import com.turborilla.mule.network.Message;
import com.turborilla.mule.network.TCPMessage;
import com.turborilla.mule.network.UDPMessage;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.nio.channels.UnresolvedAddressException;
import java.nio.channels.spi.SelectorProvider;
import java.util.Iterator;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Client {
    Logger logger = Logger.getLogger("mule");
    Selector selector;
    SocketChannel tcpChannel;
    DatagramChannel udpChannel;
    private InetSocketAddress serverTCPAddress;
    private InetSocketAddress serverUDPAddress;
    private LinkedBlockingQueue<Message> inputQueue;
    private LinkedBlockingQueue<TCPMessage> outputQueue;
    private DelayedMessageQueue delayedInputQueue;
    private TCPMessage.TCPHeader tcpRecvHeader = new TCPMessage.TCPHeader();
    private ByteBuffer tcpRecvHeaderBuffer = ByteBuffer.allocateDirect(13);
    private ByteBuffer tcpRecvMessageBuffer = ByteBuffer.allocate(4096);
    private ByteBuffer tcpSendBuffer = ByteBuffer.allocate(4096);
    private UDPMessage.UDPHeader udpRecvHeader = new UDPMessage.UDPHeader();
    private ByteBuffer udpRecvBuffer = ByteBuffer.allocateDirect(256);
    private ByteBuffer udpSendBuffer = ByteBuffer.allocateDirect(256);
    private boolean waitingForTcpResponse = false;
    private long tcpResponseTime = 0L;
    private long lastReceivedUDPMessageTime = 0L;
    private long lastSentUDPInitTime = 0L;
    private long udpInitInterval;
    private ClientId clientId;
    private int serverRoundtripTime;

    public Client() {
        this.inputQueue = new LinkedBlockingQueue();
        this.outputQueue = new LinkedBlockingQueue();
        this.delayedInputQueue = new DelayedMessageQueue();
        this.udpInitInterval = Properties.mule.udpInitInterval;
        this.clientId = ClientId.invalidClientId();
    }

    public void connect(String string) throws MuleException {
        this.logger.info("Client connects...");
        try {
            this.close();
            this.tcpRecvHeaderBuffer.clear();
            this.tcpRecvMessageBuffer.clear();
            this.tcpSendBuffer.clear();
            this.tcpSendBuffer.limit(0);
            this.serverTCPAddress = new InetSocketAddress(string, Properties.mule.SERVER_TCP_PORT);
            this.serverUDPAddress = new InetSocketAddress(string, Properties.mule.SERVER_UDP_PORT);
            int[] nArray = Properties.mule.clientUDPPorts;
            for (int i = 0; i < nArray.length; ++i) {
                int n = nArray[i];
                InetSocketAddress inetSocketAddress = new InetSocketAddress(n);
                try {
                    this.udpChannel = DatagramChannel.open();
                    this.udpChannel.configureBlocking(false);
                    this.udpChannel.socket().bind(inetSocketAddress);
                    this.logger.info("Client UDP local address: " + inetSocketAddress.toString());
                    break;
                }
                catch (IOException iOException) {
                    this.logger.warning("Client couldn't connect with UDP port " + n + " (" + iOException.getMessage() + ")");
                    continue;
                }
            }
            if (!this.udpChannel.socket().isBound()) {
                throw new IOException("No UDP socket available");
            }
            this.selector = SelectorProvider.provider().openSelector();
            this.tcpChannel = SocketChannel.open();
            this.tcpChannel.configureBlocking(false);
            this.tcpChannel.socket().setTcpNoDelay(true);
            this.logger.info("Client: Connects TCP: " + this.serverTCPAddress.toString() + " UDP: " + this.serverUDPAddress.toString());
            this.logger.info("Client: TCP receive buffer: " + this.tcpChannel.socket().getReceiveBufferSize() + " send buffer: " + this.tcpChannel.socket().getSendBufferSize());
            this.tcpChannel.connect(this.serverTCPAddress);
            this.tcpChannel.register(this.selector, 8);
        }
        catch (UnresolvedAddressException unresolvedAddressException) {
            throw new MuleException("UNRESOLVED ADDRESS: " + string);
        }
        catch (ClosedChannelException closedChannelException) {
            throw new MuleException("CLOSED CHANNEL: " + closedChannelException.getMessage());
        }
        catch (SocketException socketException) {
            throw new MuleException("SOCKET EXCEPTION: " + socketException.getMessage());
        }
        catch (IOException iOException) {
            throw new MuleException("I/O EXCEPTION: " + iOException.getMessage());
        }
    }

    public int getLocalUDPPort() {
        return this.udpChannel.socket().getLocalPort();
    }

    public boolean hasNextMessage() {
        return !this.inputQueue.isEmpty();
    }

    public Message nextMessage() {
        return this.inputQueue.poll();
    }

    public void tickDelayedMessages() {
        this.delayedInputQueue.tickFrame();
        Message message = null;
        while ((message = this.delayedInputQueue.nextMessage()) != null) {
            this.inputQueue.add(message);
        }
    }

    public void logInputQueue() {
        for (Message message : this.inputQueue) {
            this.logger.info(message.toString());
        }
    }

    public ClientId getClientId() {
        return this.clientId;
    }

    public void setClientId(ClientId clientId) {
        this.clientId = clientId;
    }

    private boolean initUDP() {
        if (!this.clientId.isValid()) {
            return false;
        }
        long l = System.currentTimeMillis() - this.lastReceivedUDPMessageTime;
        if (l > Properties.mule.udpTimeout) {
            l = System.currentTimeMillis() - this.lastSentUDPInitTime;
            if (l > this.udpInitInterval) {
                if (this.lastSentUDPInitTime == 0L) {
                    this.logger.info("Sending UDP initialization message id " + this.clientId);
                } else {
                    this.logger.warning("UDP messages timed out. Sending new UDP initialization message id " + this.clientId);
                }
                this.udpInitInterval = this.udpInitInterval * 5L / 4L;
                this.lastSentUDPInitTime = System.currentTimeMillis();
                this.sendUDP(new UDPMessage.UDPInitMessage(this.clientId));
            }
            return false;
        }
        return true;
    }

    public boolean isUDPInitialized() {
        return this.lastReceivedUDPMessageTime != 0L;
    }

    public void sendTCP(TCPMessage tCPMessage) {
        this.sendTCP(0, tCPMessage);
    }

    public void sendTCP(int n, TCPMessage tCPMessage) {
        tCPMessage.userNumber = n;
        this.outputQueue.add(tCPMessage);
    }

    public void sendTcpToServer(int n, TCPMessage tCPMessage) {
        tCPMessage.broadcastType = Message.BroadcastType.TO_SERVER;
        tCPMessage.userNumber = n;
        this.outputQueue.add(tCPMessage);
    }

    public void sendTcpUnordered(int n, TCPMessage tCPMessage) {
        tCPMessage.broadcastType = Message.BroadcastType.TO_OTHERS;
        tCPMessage.userNumber = n;
        this.inputQueue.add(tCPMessage);
        this.outputQueue.add(tCPMessage);
    }

    public void sendTcpToOthers(TCPMessage tCPMessage) {
        this.sendTcpToOthers(tCPMessage.userNumber, tCPMessage);
    }

    public void sendTcpToOthers(int n, TCPMessage tCPMessage) {
        tCPMessage.userNumber = n;
        tCPMessage.broadcastType = Message.BroadcastType.TO_OTHERS;
        this.outputQueue.add(tCPMessage);
    }

    public void sendUDP(UDPMessage uDPMessage) {
        this.sendUDP(uDPMessage.userNumber, uDPMessage);
    }

    public void sendUDP(int n, UDPMessage uDPMessage) {
        this.udpSendBuffer.clear();
        uDPMessage.userNumber = n;
        uDPMessage.write(this.udpSendBuffer);
        this.udpSendBuffer.limit(this.udpSendBuffer.position());
        this.udpSendBuffer.rewind();
        try {
            int n2 = this.udpChannel.send(this.udpSendBuffer, this.serverUDPAddress);
            if (n2 == 0) {
                this.logger.warning("Client couldn't send UDP message");
            }
        }
        catch (IOException iOException) {
            this.logger.severe("Client: Couldn't send UDP message.");
        }
    }

    public void sendUDPToOthers(UDPMessage uDPMessage) {
        this.sendUDPToOthers(uDPMessage.userNumber, uDPMessage);
    }

    public void sendUDPToOthers(int n, UDPMessage uDPMessage) {
        uDPMessage.broadcastType = Message.BroadcastType.TO_OTHERS;
        uDPMessage.userNumber = n;
        this.sendUDP(uDPMessage);
    }

    public void sendUDPToServer(UDPMessage uDPMessage) {
        this.sendUDPToServer(uDPMessage.userNumber, uDPMessage);
    }

    public void sendUDPToServer(int n, UDPMessage uDPMessage) {
        uDPMessage.broadcastType = Message.BroadcastType.TO_SERVER;
        uDPMessage.userNumber = n;
        this.sendUDP(uDPMessage);
    }

    public void sendAliveMessages() {
        long l;
        if (!this.waitingForTcpResponse && (l = System.currentTimeMillis() - this.tcpResponseTime) > Properties.mule.aliveMessageInterval && this.isConnected()) {
            this.sendTCP(new TCPMessage.AliveMessage());
            this.waitingForTcpResponse = true;
            this.tcpResponseTime = System.currentTimeMillis();
        }
    }

    public boolean checkTCPTimeOut() {
        if (this.waitingForTcpResponse) {
            long l = System.currentTimeMillis() - this.tcpResponseTime;
            Properties.mule.getClass();
            if (l > 20000L) {
                return true;
            }
        }
        return false;
    }

    public void clearTCPTimeOut() {
        this.tcpResponseTime = System.currentTimeMillis();
    }

    public void sendMessages() throws IOException {
        if (this.isConnected()) {
            this.initUDP();
            while (true) {
                if (!this.tcpSendBuffer.hasRemaining()) {
                    TCPMessage tCPMessage = this.outputQueue.poll();
                    if (tCPMessage == null) {
                        return;
                    }
                    this.tcpSendBuffer = tCPMessage.toByteBuffer(this.tcpSendBuffer);
                    continue;
                }
                this.tcpChannel.write(this.tcpSendBuffer);
                if (this.tcpSendBuffer.position() != this.tcpSendBuffer.limit()) break;
            }
            return;
        }
    }

    public void receiveMessages() throws IOException {
        if (this.selector != null && this.selector.selectNow() > 0) {
            Iterator<SelectionKey> iterator = this.selector.selectedKeys().iterator();
            while (iterator.hasNext()) {
                SelectionKey selectionKey = iterator.next();
                iterator.remove();
                if (!selectionKey.isReadable()) continue;
                if (selectionKey.channel() == this.tcpChannel) {
                    this.receiveTCPMessages();
                    continue;
                }
                this.receiveUDPMessages();
            }
        }
    }

    private void receiveTCPMessages() throws IOException {
        while (true) {
            if (this.tcpRecvHeaderBuffer.hasRemaining()) {
                this.tcpChannel.read(this.tcpRecvHeaderBuffer);
                if (this.tcpRecvHeaderBuffer.position() != this.tcpRecvHeaderBuffer.limit()) break;
                this.tcpRecvHeaderBuffer.rewind();
                this.tcpRecvHeader.readFrom(this.tcpRecvHeaderBuffer);
                if (this.tcpRecvHeader.messageSize > this.tcpRecvMessageBuffer.capacity()) {
                    this.logger.info("Client: Increasing TCP recieve buffer for " + this.tcpRecvHeader);
                    this.tcpRecvMessageBuffer = ByteBuffer.allocate(this.tcpRecvHeader.messageSize);
                }
                this.tcpRecvMessageBuffer.clear();
                this.tcpRecvMessageBuffer.limit(this.tcpRecvHeader.messageSize);
                continue;
            }
            this.tcpChannel.read(this.tcpRecvMessageBuffer);
            if (this.tcpRecvMessageBuffer.position() != this.tcpRecvMessageBuffer.limit()) break;
            this.tcpRecvMessageBuffer.rewind();
            TCPMessage tCPMessage = this.tcpRecvHeader.createMessage(this.tcpRecvMessageBuffer);
            if (tCPMessage.isLogged()) {
                this.logger.info("Client: " + this.tcpRecvHeader);
            }
            if (this.tcpRecvHeader.type == TCPMessage.TCPMessageType.Synchronized) {
                this.delayedInputQueue.add((TCPMessage.SynchronizedMessage)tCPMessage);
            } else {
                this.inputQueue.add(tCPMessage);
                this.waitingForTcpResponse = false;
                this.tcpResponseTime = System.currentTimeMillis();
            }
            this.tcpRecvHeader.reset();
            this.tcpRecvHeaderBuffer.clear();
        }
    }

    private void receiveUDPMessages() throws IOException {
        while (true) {
            try {
                this.udpRecvBuffer.clear();
                SocketAddress socketAddress = this.udpChannel.receive(this.udpRecvBuffer);
                if (socketAddress == null) break;
                this.udpRecvBuffer.rewind();
                this.udpRecvHeader.readFrom(this.udpRecvBuffer);
                UDPMessage uDPMessage = this.udpRecvHeader.createMessage(this.udpRecvBuffer);
                if (this.udpRecvHeader.type == UDPMessage.UDPMessageType.Ping) {
                    this.handlePingMessage((UDPMessage.UDPPingMessage)uDPMessage);
                } else {
                    if (this.udpRecvHeader.type == UDPMessage.UDPMessageType.Init) {
                        this.udpInitInterval = Properties.mule.udpInitInterval;
                    }
                    this.inputQueue.add(uDPMessage);
                }
            }
            catch (Exception exception) {
                this.logger.severe(exception.getMessage());
            }
            this.lastReceivedUDPMessageTime = System.currentTimeMillis();
        }
    }

    private void handlePingMessage(UDPMessage.UDPPingMessage uDPPingMessage) {
        this.sendUDP(uDPPingMessage);
        this.serverRoundtripTime = uDPPingMessage.roundTripTime;
    }

    public int getRoundtripTime() {
        return this.serverRoundtripTime;
    }

    public void logRoundtripTime() {
        this.logger.info("Client: Roundtrip time is " + this.serverRoundtripTime + " ms");
    }

    public boolean finishConnect() throws ClosedChannelException, IOException {
        if (this.tcpChannel == null || this.tcpChannel.isConnected()) {
            return false;
        }
        boolean bl = false;
        if (this.selector != null && this.selector.selectNow() > 0) {
            Iterator<SelectionKey> iterator = this.selector.selectedKeys().iterator();
            while (iterator.hasNext()) {
                SelectionKey selectionKey = iterator.next();
                iterator.remove();
                if (!selectionKey.isConnectable()) continue;
                SocketChannel socketChannel = (SocketChannel)selectionKey.channel();
                try {
                    socketChannel.finishConnect();
                }
                catch (ConnectException connectException) {
                    selectionKey.cancel();
                    this.tcpChannel = SocketChannel.open();
                    this.tcpChannel.configureBlocking(false);
                    this.tcpChannel.connect(this.serverTCPAddress);
                    this.tcpChannel.register(this.selector, 8);
                    return false;
                }
                this.logger.info("Client finishes connection");
                selectionKey.interestOps(1);
                this.udpChannel.connect(this.serverUDPAddress);
                this.udpChannel.register(this.selector, 1);
                bl = true;
            }
        }
        return bl;
    }

    public boolean isConnected() {
        return this.tcpChannel != null && this.udpChannel != null && this.tcpChannel.isConnected() && this.udpChannel.isConnected();
    }

    public void close() {
        if (this.tcpChannel != null) {
            try {
                this.tcpChannel.socket().close();
            }
            catch (IOException iOException) {
                this.logger.severe("Client failed to close TCP Channel. " + iOException.getMessage());
                iOException.printStackTrace();
            }
        }
        if (this.udpChannel != null) {
            this.udpChannel.socket().close();
        }
        if (this.selector != null) {
            try {
                this.selector.close();
            }
            catch (IOException iOException) {
                this.logger.severe("Client failed to close selector. " + iOException.getMessage());
                iOException.printStackTrace();
            }
        }
        this.selector = null;
        this.waitingForTcpResponse = false;
        this.outputQueue.clear();
    }

    public int getOutputQueueSize() {
        return this.outputQueue.size();
    }

    public String getServerAddress() {
        if (!this.isConnected()) {
            return null;
        }
        return this.tcpChannel.socket().getInetAddress().getHostAddress();
    }

    public void debugChangeUDPAddress() {
        this.logger.info("Client: Debug changing UDP address");
        try {
            this.udpChannel.close();
        }
        catch (IOException iOException) {
            this.logger.log(Level.WARNING, iOException.toString(), iOException);
        }
        for (int i = 0; i < 10; ++i) {
            int n = 4600 + i;
            InetSocketAddress inetSocketAddress = new InetSocketAddress(n);
            try {
                this.udpChannel = DatagramChannel.open();
                this.udpChannel.configureBlocking(false);
                this.udpChannel.socket().bind(inetSocketAddress);
                this.udpChannel.connect(this.serverUDPAddress);
                this.udpChannel.register(this.selector, 1);
                this.logger.info("Client UDP local address: " + inetSocketAddress.toString());
                break;
            }
            catch (IOException iOException) {
                this.logger.warning("Client couldn't connect with UDP port " + n + " (" + iOException.getMessage() + ")");
                continue;
            }
        }
    }
}

