/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.network;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

public class ByteArray {
    public static final int BIG_ENDIAN = 0;
    public static final int LITTLE_ENDIAN = 1;
    private byte[] data;
    private int position;
    private int byteOrder;

    public ByteArray() {
        this(new byte[0]);
    }

    public ByteArray(int n) {
        this(new byte[n]);
    }

    public ByteArray(byte[] byArray) {
        this.data = byArray;
        this.reset();
    }

    public void reset() {
        this.position = 0;
        this.byteOrder = 0;
    }

    public byte[] getData() {
        return this.data;
    }

    public int getByteOrder() {
        return this.byteOrder;
    }

    public void setByteOrder(int n) {
        this.byteOrder = n;
    }

    public int length() {
        return this.data.length;
    }

    public void setLength(int n) {
        if (n != this.data.length) {
            byte[] byArray = this.data;
            this.data = new byte[n];
            System.arraycopy(byArray, 0, this.data, 0, Math.min(byArray.length, n));
            if (this.position > n) {
                this.position = n;
            }
        }
    }

    public int position() {
        return this.position;
    }

    public void setPosition(int n) throws IndexOutOfBoundsException {
        if (n < 0 || n > this.data.length) {
            throw new IndexOutOfBoundsException();
        }
        this.position = n;
    }

    public void truncate() {
        this.setLength(this.position);
    }

    public int available() {
        return this.length() - this.position();
    }

    public void compress() {
        this.compress(new Deflater());
    }

    public void compress(Deflater deflater) {
        ByteArray byteArray = ByteArray.compress(deflater, this.data, 0, this.data.length);
        this.data = byteArray.data;
        this.position = byteArray.position;
    }

    private static ByteArray compress(Deflater deflater, byte[] byArray, int n, int n2) {
        ByteArray byteArray = new ByteArray();
        byte[] byArray2 = new byte[4096];
        deflater.reset();
        deflater.setInput(byArray, n, n2);
        deflater.finish();
        while (!deflater.finished()) {
            int n3 = deflater.deflate(byArray2);
            byteArray.write(byArray2, 0, n3);
        }
        deflater.end();
        return byteArray;
    }

    public void decompress() throws IOException {
        this.decompress(new Inflater());
    }

    public void decompress(Inflater inflater) throws IOException {
        ByteArray byteArray = ByteArray.decompress(inflater, this.data, 0, this.data.length);
        if (byteArray == null) {
            throw new IOException();
        }
        this.data = byteArray.data;
        this.position = 0;
    }

    private static ByteArray decompress(Inflater inflater, byte[] byArray, int n, int n2) {
        ByteArray byteArray = new ByteArray();
        byte[] byArray2 = new byte[4096];
        inflater.reset();
        inflater.setInput(byArray, n, n2);
        try {
            while (!inflater.needsInput()) {
                int n3 = inflater.inflate(byArray2);
                byteArray.write(byArray2, 0, n3);
            }
            inflater.end();
        }
        catch (DataFormatException dataFormatException) {
            return null;
        }
        return byteArray;
    }

    private void checkAvailable(int n) throws IndexOutOfBoundsException {
        if (this.available() < n) {
            throw new IndexOutOfBoundsException();
        }
    }

    public byte readByte() throws IndexOutOfBoundsException {
        this.checkAvailable(1);
        return this.data[this.position++];
    }

    public int read(byte[] byArray) throws IndexOutOfBoundsException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IndexOutOfBoundsException {
        if (n2 == 0) {
            return 0;
        }
        this.checkAvailable(n2);
        System.arraycopy(this.data, this.position, byArray, n, n2);
        this.position += n2;
        return n2;
    }

    public void read(OutputStream outputStream) throws IOException {
        outputStream.write(this.data, this.position, this.data.length - this.position);
        this.position = this.data.length;
    }

    public boolean readBoolean() throws IndexOutOfBoundsException {
        return this.readByte() != 0;
    }

    public short readShort() throws IndexOutOfBoundsException {
        this.checkAvailable(2);
        if (this.byteOrder == 1) {
            return (short)(this.data[this.position++] & 0xFF | (this.data[this.position++] & 0xFF) << 8);
        }
        return (short)((this.data[this.position++] & 0xFF) << 8 | this.data[this.position++] & 0xFF);
    }

    public int readInt() throws IndexOutOfBoundsException {
        this.checkAvailable(4);
        if (this.byteOrder == 1) {
            return this.data[this.position++] & 0xFF | (this.data[this.position++] & 0xFF) << 8 | (this.data[this.position++] & 0xFF) << 16 | (this.data[this.position++] & 0xFF) << 24;
        }
        return (this.data[this.position++] & 0xFF) << 24 | (this.data[this.position++] & 0xFF) << 16 | (this.data[this.position++] & 0xFF) << 8 | this.data[this.position++] & 0xFF;
    }

    public long readLong() throws IndexOutOfBoundsException {
        this.checkAvailable(8);
        if (this.byteOrder == 1) {
            return (long)this.readInt() & 0xFFFFFFFFL | ((long)this.readInt() & 0xFFFFFFFFL) << 32;
        }
        return ((long)this.readInt() & 0xFFFFFFFFL) << 32 | (long)this.readInt() & 0xFFFFFFFFL;
    }

    public float readFloat() throws IndexOutOfBoundsException {
        return Float.intBitsToFloat(this.readInt());
    }

    public double readDouble() throws IndexOutOfBoundsException {
        return Double.longBitsToDouble(this.readLong());
    }

    public String readUTF() throws IndexOutOfBoundsException, UTFDataFormatException {
        this.checkAvailable(2);
        int n = this.readShort() & 0xFFFF;
        this.checkAvailable(n);
        int n2 = this.position() + n;
        StringBuffer stringBuffer = new StringBuffer(n);
        while (this.position() < n2) {
            int n3;
            int n4 = this.readByte() & 0xFF;
            if ((n4 & 0x80) == 0) {
                stringBuffer.append((char)n4);
                continue;
            }
            int n5 = this.readByte() & 0xFF;
            if ((n5 & 0xC0) != 128) {
                throw new UTFDataFormatException();
            }
            if ((n4 & 0xE0) == 192) {
                n3 = (char)((n4 & 0x1F) << 6 | n5 & 0x3F);
                stringBuffer.append((char)n3);
                continue;
            }
            if ((n4 & 0xF0) == 224) {
                n3 = this.readByte() & 0xFF;
                if ((n3 & 0xC0) != 128) {
                    throw new UTFDataFormatException();
                }
                char c = (char)((n4 & 0xF) << 12 | (n5 & 0x3F) << 6 | n3 & 0x3F);
                stringBuffer.append(c);
                continue;
            }
            throw new UTFDataFormatException();
        }
        return stringBuffer.toString();
    }

    private void ensureCapacity(int n) {
        if (this.position + n > this.data.length) {
            this.setLength(this.position + n);
        }
    }

    public void writeByte(int n) {
        this.ensureCapacity(1);
        this.data[this.position++] = (byte)n;
    }

    public void write(byte[] byArray) {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) {
        if (n2 == 0) {
            return;
        }
        this.ensureCapacity(n2);
        System.arraycopy(byArray, n, this.data, this.position, n2);
        this.position += n2;
    }

    public void write(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[4096];
        int n;
        while ((n = inputStream.read(byArray)) != -1) {
            this.write(byArray, 0, n);
        }
        return;
    }

    public void writeBoolean(boolean bl) {
        this.writeByte(bl ? -1 : 0);
    }

    public void writeShort(int n) {
        this.ensureCapacity(2);
        if (this.byteOrder == 1) {
            this.data[this.position++] = (byte)(n & 0xFF);
            this.data[this.position++] = (byte)(n >> 8 & 0xFF);
        } else {
            this.data[this.position++] = (byte)(n >> 8 & 0xFF);
            this.data[this.position++] = (byte)(n & 0xFF);
        }
    }

    public void writeInt(int n) {
        this.ensureCapacity(4);
        if (this.byteOrder == 1) {
            this.data[this.position++] = (byte)(n & 0xFF);
            this.data[this.position++] = (byte)(n >> 8 & 0xFF);
            this.data[this.position++] = (byte)(n >> 16 & 0xFF);
            this.data[this.position++] = (byte)(n >>> 24);
        } else {
            this.data[this.position++] = (byte)(n >>> 24);
            this.data[this.position++] = (byte)(n >> 16 & 0xFF);
            this.data[this.position++] = (byte)(n >> 8 & 0xFF);
            this.data[this.position++] = (byte)(n & 0xFF);
        }
    }

    public void writeLong(long l) {
        this.ensureCapacity(8);
        if (this.byteOrder == 1) {
            this.writeInt((int)(l & 0xFFFFFFFFL));
            this.writeInt((int)(l >>> 32));
        } else {
            this.writeInt((int)(l >>> 32));
            this.writeInt((int)(l & 0xFFFFFFFFL));
        }
    }

    public void writeFloat(float f) {
        this.writeInt(Float.floatToIntBits(f));
    }

    public void writeDouble(double d) {
        this.writeLong(Double.doubleToLongBits(d));
    }

    public void writeUTF(String string) throws UTFDataFormatException {
        char c;
        int n;
        int n2 = 0;
        for (n = 0; n < string.length(); ++n) {
            c = string.charAt(n);
            if (c > '\u0000' && c < '\u0080') {
                ++n2;
                continue;
            }
            if (c == '\u0000' || c >= '\u0080' && c < '\u0800') {
                n2 += 2;
                continue;
            }
            n2 += 3;
        }
        if (n2 > 65535) {
            throw new UTFDataFormatException();
        }
        this.ensureCapacity(2 + n2);
        this.writeShort(n2);
        for (n = 0; n < string.length(); ++n) {
            c = string.charAt(n);
            if (c > '\u0000' && c < '\u0080') {
                this.writeByte(c);
                continue;
            }
            if (c == '\u0000' || c >= '\u0080' && c < '\u0800') {
                this.writeByte(0xC0 | 0x1F & c >> 6);
                this.writeByte(0x80 | 0x3F & c);
                continue;
            }
            this.writeByte(0xE0 | 0xF & c >> 12);
            this.writeByte(0x80 | 0x3F & c >> 6);
            this.writeByte(0x80 | 0x3F & c);
        }
    }
}

