/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.model.util;

import java.io.Serializable;

public strictfp class Vec2
implements Serializable {
    private static final long serialVersionUID = 9115262848727709142L;
    public float x;
    public float y;

    public Vec2() {
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public Vec2(Vec2 vec2) {
        this(vec2.getX(), vec2.getY());
    }

    public Vec2(float f, float f2) {
        this.x = f;
        this.y = f2;
    }

    public void set(Vec2 vec2) {
        this.set(vec2.getX(), vec2.getY());
    }

    public float dot(Vec2 vec2) {
        return this.x * vec2.getX() + this.y * vec2.getY();
    }

    public Vec2 set(float f, float f2) {
        this.x = f;
        this.y = f2;
        return this;
    }

    public Vec2 negate() {
        return new Vec2(-this.x, -this.y);
    }

    public Vec2 negateLocal() {
        this.x = -this.x;
        this.y = -this.y;
        return this;
    }

    public Vec2 add(Vec2 vec2) {
        this.x += vec2.getX();
        this.y += vec2.getY();
        return this;
    }

    public Vec2 add(float f, float f2) {
        this.x += f;
        this.y += f2;
        return this;
    }

    public Vec2 sub(Vec2 vec2) {
        this.x -= vec2.getX();
        this.y -= vec2.getY();
        return this;
    }

    public Vec2 scale(float f) {
        this.x *= f;
        this.y *= f;
        return this;
    }

    public Vec2 normalise() {
        float f = this.length();
        this.x /= f;
        this.y /= f;
        return this;
    }

    public Vec2 getNormal() {
        Vec2 vec2 = this.copy();
        vec2.normalise();
        return vec2;
    }

    public float lengthSquared() {
        return this.x * this.x + this.y * this.y;
    }

    public float length() {
        return (float)StrictMath.sqrt(this.lengthSquared());
    }

    public void projectOntoUnit(Vec2 vec2, Vec2 vec22) {
        float f = vec2.dot(this);
        vec22.x = f * vec2.getX();
        vec22.y = f * vec2.getY();
    }

    public Vec2 copy() {
        return new Vec2(this.x, this.y);
    }

    public String toString() {
        return "[Vec2 " + this.x + "," + this.y + " (" + this.length() + ")]";
    }

    public float distance(Vec2 vec2) {
        float f = vec2.getX() - this.getX();
        float f2 = vec2.getY() - this.getY();
        return (float)StrictMath.sqrt(f * f + f2 * f2);
    }

    public float distance(float f, float f2) {
        float f3 = f - this.getX();
        float f4 = f2 - this.getY();
        return (float)StrictMath.sqrt(f3 * f3 + f4 * f4);
    }

    public float distanceSquared(Vec2 vec2) {
        float f = vec2.getX() - this.getX();
        float f2 = vec2.getY() - this.getY();
        return f * f + f2 * f2;
    }

    public int hashCode() {
        return (int)(this.x * this.y * 1000.0f);
    }

    public boolean equals(Object object) {
        if (object instanceof Vec2) {
            Vec2 vec2 = (Vec2)object;
            return vec2.x == this.x && vec2.y == this.y;
        }
        return false;
    }
}

