/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.model.util;

import com.turborilla.mule.Properties;
import com.turborilla.mule.model.util.NetworkTimer;
import com.turborilla.mule.network.Client;
import com.turborilla.mule.network.TCPMessage;
import com.turborilla.mule.network.UDPMessage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.logging.Logger;

public final class NetworkTimerManager
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger("mule");
    int id;
    private TreeMap<Integer, NetworkTimer> timers;
    private ArrayList<NetworkTimer> activeTimers;
    private int nextTimerId;
    transient long frame;
    transient ArrayList<Integer> localUserNumbers;
    transient int roundTripTime;
    private static final float SYNC_SPEED = 0.01f;

    public NetworkTimerManager(int n) {
        this.id = n;
        this.timers = new TreeMap();
        this.activeTimers = new ArrayList();
        this.localUserNumbers = new ArrayList();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.frame = 0L;
        this.localUserNumbers = new ArrayList();
        this.roundTripTime = 0;
    }

    public void addLocalUserNumber(int n) {
        this.localUserNumbers.add(n);
    }

    public void removeLocalUserNumber(int n) {
        this.localUserNumbers.remove((Object)n);
    }

    public NetworkTimer createTimer(String string, int n, boolean bl) {
        int n2 = this.nextTimerId++;
        NetworkTimer networkTimer = new NetworkTimer(this, string, n2, n, bl);
        this.timers.put(n2, networkTimer);
        return networkTimer;
    }

    public void destroyTimer(NetworkTimer networkTimer) {
        NetworkTimer networkTimer2 = this.timers.remove(networkTimer.id);
        if (networkTimer2 != null) {
            this.activeTimers.remove(networkTimer2);
        }
    }

    public void setFrame(long l) {
        this.frame = l;
    }

    public void update(Client client) {
        this.roundTripTime = client.getRoundtripTime();
        Iterator<NetworkTimer> iterator = this.activeTimers.iterator();
        while (iterator.hasNext()) {
            NetworkTimer networkTimer = iterator.next();
            float f = 0.01f * networkTimer.syncTime;
            networkTimer.syncTime -= f;
            networkTimer.time += f;
            if (!networkTimer.paused) {
                networkTimer.time -= networkTimer.speed * Properties.mule.delta;
                if (networkTimer.time <= 0.0f && this.localUserNumbers.contains(networkTimer.ownerUserNumber)) {
                    networkTimer.stop();
                    if (this.localUserNumbers.contains(networkTimer.ownerUserNumber)) {
                        TCPMessage.TimerFinishedMessage timerFinishedMessage = new TCPMessage.TimerFinishedMessage(this.id, networkTimer.id, this.frame);
                        client.sendTCP(networkTimer.ownerUserNumber, timerFinishedMessage);
                    }
                    iterator.remove();
                }
            }
            if (System.currentTimeMillis() - networkTimer.lastSyncTime <= Properties.mule.syncTimersInterval) continue;
            networkTimer.synchronize(client);
        }
    }

    public NetworkTimer apply(TCPMessage.TimerStartedMessage timerStartedMessage) {
        if (timerStartedMessage.manager != this.id) {
            return null;
        }
        NetworkTimer networkTimer = this.timers.get(timerStartedMessage.id);
        if (networkTimer == null) {
            logger.severe("Unknown timer " + timerStartedMessage.id + " started");
        } else if (networkTimer.ownerUserNumber != timerStartedMessage.getUserNumber()) {
            logger.severe("Timer " + timerStartedMessage.id + " started by user " + timerStartedMessage.getUserNumber() + " but owned by user " + networkTimer.ownerUserNumber);
        } else {
            networkTimer.startFrame = timerStartedMessage.frame;
            this.activeTimers.add(networkTimer);
        }
        return networkTimer;
    }

    public NetworkTimer apply(TCPMessage.TimerFinishedMessage timerFinishedMessage) {
        if (timerFinishedMessage.manager != this.id) {
            return null;
        }
        NetworkTimer networkTimer = this.timers.get(timerFinishedMessage.id);
        if (networkTimer == null) {
            logger.severe("Unknown timer " + timerFinishedMessage.id + " finished");
        } else if (networkTimer.ownerUserNumber != timerFinishedMessage.getUserNumber()) {
            logger.severe("Timer " + timerFinishedMessage.id + " finished by user " + timerFinishedMessage.getUserNumber() + " but owned by user " + networkTimer.ownerUserNumber);
        } else {
            networkTimer.finishFrame = timerFinishedMessage.frame;
            logger.info("Finished " + networkTimer + " at " + networkTimer.time + " (owner " + networkTimer.ownerUserNumber + ")");
            networkTimer.time = 0.0f;
            this.activeTimers.remove(networkTimer);
        }
        return networkTimer;
    }

    public void apply(UDPMessage.SynchronizeTimerMessage synchronizeTimerMessage) {
        if (synchronizeTimerMessage.manager != this.id) {
            return;
        }
        NetworkTimer networkTimer = this.timers.get(synchronizeTimerMessage.id);
        if (networkTimer != null) {
            if (networkTimer.ownerUserNumber != synchronizeTimerMessage.getUserNumber()) {
                logger.severe("Timer " + synchronizeTimerMessage.id + " synchronized by user " + synchronizeTimerMessage.getUserNumber() + " but owned by user " + networkTimer.ownerUserNumber);
            } else if (networkTimer.syncCount < synchronizeTimerMessage.syncCount) {
                if (networkTimer.startCount > synchronizeTimerMessage.startCount) {
                    logger.warning("Old synchronize message (started " + synchronizeTimerMessage.startCount + ") for timer " + synchronizeTimerMessage.id + " (started " + networkTimer.startCount + ")");
                } else {
                    float f = (float)(synchronizeTimerMessage.roundTripTime + this.roundTripTime) / 2000.0f;
                    float f2 = networkTimer.speed * f * Properties.mule.gameSecond;
                    networkTimer.syncTime = synchronizeTimerMessage.time - f2 - networkTimer.time;
                    networkTimer.syncCount = synchronizeTimerMessage.syncCount;
                }
            }
        }
    }
}

