/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.model.util;

import com.turborilla.mule.model.util.AbstractTimer;
import com.turborilla.mule.model.util.NetworkTimerManager;
import com.turborilla.mule.network.Client;
import com.turborilla.mule.network.TCPMessage;
import com.turborilla.mule.network.UDPMessage;
import java.io.Serializable;
import java.util.logging.Logger;

public strictfp final class NetworkTimer
extends AbstractTimer
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger("mule");
    final int id;
    final NetworkTimerManager manager;
    final String name;
    int ownerUserNumber;
    float time;
    private float totalTime;
    boolean started;
    boolean paused;
    float speed;
    long startFrame;
    long finishFrame;
    public static long NO_FRAME = -1L;
    boolean synced;
    float syncTime;
    long lastSyncTime;
    int syncCount;
    int startCount;

    NetworkTimer(NetworkTimerManager networkTimerManager, String string, int n, int n2, boolean bl) {
        this.name = string;
        this.id = n;
        this.manager = networkTimerManager;
        this.ownerUserNumber = n2;
        this.synced = bl;
        this.syncTime = 0.0f;
        this.lastSyncTime = 0L;
        this.syncCount = 0;
        this.startCount = 0;
        this.reset();
    }

    public void reset() {
        this.started = false;
        this.paused = false;
        this.speed = 1.0f;
        this.time = 0.0f;
        this.totalTime = 0.0f;
        this.startFrame = NO_FRAME;
        this.finishFrame = NO_FRAME;
    }

    public void start(float f, Client client) {
        logger.info("Started \"" + this.name + "\" at " + f + " (owner " + this.ownerUserNumber + ")");
        this.time = f;
        this.totalTime = f;
        this.started = true;
        ++this.startCount;
        this.lastSyncTime = 0L;
        this.syncTime = 0.0f;
        if (this.manager.localUserNumbers.contains(this.ownerUserNumber)) {
            client.sendTCP(this.ownerUserNumber, new TCPMessage.TimerStartedMessage(this.manager.id, this.id, this.manager.frame));
        }
    }

    public void stop() {
        this.time = 0.0f;
    }

    public float getTime() {
        if (this.time < 0.0f) {
            return 0.0f;
        }
        return this.time;
    }

    public float getTotalTime() {
        return this.totalTime;
    }

    public boolean isStarted() {
        return this.started;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public boolean isFinished() {
        return this.finishFrame != NO_FRAME;
    }

    public void pause(boolean bl) {
        this.paused = bl;
    }

    public String getName() {
        return this.name;
    }

    public void setSpeed(float f) {
        this.speed = f;
    }

    public float getSpeed() {
        return this.speed;
    }

    public long getStartFrame() {
        return this.startFrame;
    }

    public long getFinishFrame() {
        return this.finishFrame;
    }

    public void synchronize(Client client) {
        this.lastSyncTime = System.currentTimeMillis();
        if (this.synced && this.manager.localUserNumbers.contains(this.ownerUserNumber)) {
            ++this.syncCount;
            client.sendUDPToOthers(this.ownerUserNumber, new UDPMessage.SynchronizeTimerMessage(this.manager.id, this.id, this.time, client.getRoundtripTime(), this.syncCount, this.startCount));
        }
    }

    public String toString() {
        return "Timer " + this.id + " \"" + this.name + "\"";
    }

    public void setOwner(int n) {
        this.ownerUserNumber = n;
    }

    public int getId() {
        return this.id;
    }
}

