/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.model.map;

import com.turborilla.mule.Properties;
import com.turborilla.mule.model.Collidable;
import com.turborilla.mule.model.CollisionDetector;
import com.turborilla.mule.model.Geometry;
import com.turborilla.mule.model.HirelingManager;
import com.turborilla.mule.model.Player;
import com.turborilla.mule.model.Resource;
import com.turborilla.mule.model.map.Building;
import com.turborilla.mule.model.map.Factory;
import com.turborilla.mule.model.map.PlanetMap;
import com.turborilla.mule.model.map.Tile;
import com.turborilla.mule.model.util.Vec2;
import com.turborilla.mule.view.MapSkin;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlanetTile
extends Tile
implements Comparable<PlanetTile> {
    private static final long serialVersionUID = 3846895770715074788L;
    public static final int tileWidth = 64;
    public static final int tileHeight = 64;
    private PlanetTileType type;
    private int crystite = 0;
    private final int posX;
    private final int posY;
    private final Vec2 center;
    private Player owner;
    private boolean forSale;
    private ArrayList<Building> buildings;
    private ArrayList<Player> assays = new ArrayList(4);
    private CollisionDetector.CollisionSet collisionSet;
    private static TreeMap<String, TileBitCollision> tileBitCollisions = new TreeMap();

    public PlanetTile(PlanetTileType planetTileType, int n, int n2, int n3, int n4, int n5) {
        super(planetTileType.name, planetTileType.identifier + n, n4, n5);
        this.type = planetTileType;
        this.owner = null;
        this.forSale = false;
        this.buildings = new ArrayList(4);
        this.assays = new ArrayList(4);
        this.posX = n2;
        this.posY = n3;
        this.center = new Vec2(n2 * 64 + 32, n3 * 64 + 32);
    }

    public PlanetTile(PlanetTileType planetTileType, int n, int n2, int n3) {
        this(planetTileType, n, n2, n3, 0, 0);
    }

    public static Resource getResourceFromTile(PlanetTile planetTile) {
        return planetTile.isEmpty() ? null : planetTile.getFactory().getResource();
    }

    public PlanetTileType getType() {
        return this.type;
    }

    public void setType(PlanetTileType planetTileType) {
        this.type = planetTileType;
    }

    public void setIdentifier(String string, int n) {
        this.identifier = string + n;
    }

    public int getYieldPotential(Resource resource) {
        switch (resource) {
            case Food: {
                return this.type.food;
            }
            case Energy: {
                return this.type.energy;
            }
            case Smithore: {
                return this.type.smithore;
            }
            case Crystite: {
                return this.type.allow(Resource.Crystite) ? this.getCrystite() : 0;
            }
        }
        return 0;
    }

    public int getCrystite() {
        return this.crystite;
    }

    public void setCrystite(int n) {
        this.crystite = n;
    }

    public Player getOwner() {
        return this.owner;
    }

    public void setOwner(PlanetMap planetMap, Player player) {
        if (this.owner == player) {
            return;
        }
        if (this.owner != null) {
            this.owner.removeOwnedTile(this);
        }
        if (player != null) {
            player.addOwnedTile(this);
        }
        this.owner = player;
    }

    public int getPosX() {
        return this.posX;
    }

    public int getPosY() {
        return this.posY;
    }

    public boolean isEmpty() {
        return this.buildings.isEmpty();
    }

    public Factory getFactory() {
        for (Building building : this.buildings) {
            if (!(building instanceof Factory)) continue;
            return (Factory)building;
        }
        return null;
    }

    public Factory getFactoryWithResource(Resource ... resourceArray) {
        Factory factory = this.getFactory();
        if (factory != null) {
            for (Resource resource : resourceArray) {
                if (factory.getResource() != resource) continue;
                return factory;
            }
        }
        return null;
    }

    public boolean assay(Player player) {
        if (this.isAssayedBy(player)) {
            return false;
        }
        this.assays.add(player);
        return true;
    }

    public boolean isAssayedBy(Player player) {
        return this.assays.contains(player);
    }

    @Override
    public int compareTo(PlanetTile planetTile) {
        if (planetTile == null) {
            return -1;
        }
        if (this.posY < planetTile.posY) {
            return -1;
        }
        if (this.posY > planetTile.posY) {
            return 1;
        }
        if (this.posX < planetTile.posX) {
            return -1;
        }
        if (this.posX > planetTile.posX) {
            return 1;
        }
        return 0;
    }

    public void addBuilding(PlanetMap planetMap, HirelingManager hirelingManager, Building building) {
        if (building.getTile() != this) {
            throw new RuntimeException("Building for tile " + building.getTile() + " was added to " + this);
        }
        this.buildings.add(building);
        this.buildingsChanged(planetMap, hirelingManager);
    }

    public Building removeBuilding(PlanetMap planetMap, HirelingManager hirelingManager, int n) {
        Building building = this.buildings.remove(n);
        building.destroy(planetMap);
        this.buildingsChanged(planetMap, hirelingManager);
        return building;
    }

    public void removeBuildings(PlanetMap planetMap, HirelingManager hirelingManager) {
        for (Building building : this.buildings) {
            building.destroy(planetMap);
        }
        this.buildings.clear();
        this.buildingsChanged(planetMap, hirelingManager);
    }

    private void buildingsChanged(PlanetMap planetMap, HirelingManager hirelingManager) {
        if (this.owner != null) {
            this.owner.calcEnergyRequirement();
            Building.calcBonuses(this.owner, planetMap, hirelingManager);
        }
    }

    public ArrayList<Building> getBuildings() {
        return this.buildings;
    }

    public void constructCollidables(MapSkin mapSkin) {
        Serializable serializable;
        int n = this.numTileBits();
        this.collisionSet = new CollisionDetector.CollisionSet(n);
        int n2 = this.getPosX() * 64;
        int n3 = this.getPosY() * 64;
        Object object = mapSkin.getCollisionBox(this.identifier);
        if (object != null) {
            serializable = Geometry.Rectangle.createCollidable(n2 + ((MapSkin.CollisionBox)object).x, n3 + ((MapSkin.CollisionBox)object).y, ((MapSkin.CollisionBox)object).width, ((MapSkin.CollisionBox)object).height);
            this.collisionSet.add((Collidable)serializable);
        }
        object = this.getTileBitIterator();
        while (object.hasNext()) {
            serializable = (Tile)object.next();
            int n4 = n2 + ((Tile)serializable).getXOffset();
            int n5 = n3 + ((Tile)serializable).getYOffset();
            String string = ((Tile)serializable).getIdentifier();
            MapSkin.CollisionBox collisionBox = mapSkin.getCollisionBox(string);
            if (collisionBox == null) continue;
            Collidable collidable = Geometry.Rectangle.createCollidable(n4 + collisionBox.x, n5 + collisionBox.y, collisionBox.width, collisionBox.height);
            this.collisionSet.add(collidable);
        }
    }

    public CollisionDetector.CollisionSet getCollisionSet() {
        return this.collisionSet;
    }

    public boolean isInCollision(float f, float f2) {
        return this.collisionSet.contains(f, f2);
    }

    public String toString() {
        return (Object)((Object)this.getType()) + " (" + this.posX + "," + this.posY + ")";
    }

    public void setForSale(boolean bl) {
        this.forSale = bl;
    }

    public boolean isForSale() {
        return this.forSale;
    }

    public Vec2 getCenter() {
        return this.center;
    }

    static {
        tileBitCollisions.put("tile-bits0", new TileBitCollision(6, 5, 16, 13));
        tileBitCollisions.put("tile-bits1", new TileBitCollision(5, 5, 30, 15));
        tileBitCollisions.put("tile-bits2", new TileBitCollision(6, 4, 18, 14));
        tileBitCollisions.put("tile-bits3", new TileBitCollision(6, 4, 21, 15));
        tileBitCollisions.put("tile-bits4", new TileBitCollision(0, 4, 30, 16));
        tileBitCollisions.put("water0", new TileBitCollision(2, 1, 49, 21));
        tileBitCollisions.put("water1", new TileBitCollision(2, 1, 46, 24));
        tileBitCollisions.put("water2", new TileBitCollision(5, 3, 33, 42));
        tileBitCollisions.put("water3", new TileBitCollision(5, 5, 46, 36));
        tileBitCollisions.put("mountain0", new TileBitCollision(1, 8, 24, 21));
        tileBitCollisions.put("mountain1", new TileBitCollision(1, 5, 27, 22));
        tileBitCollisions.put("mountain2", new TileBitCollision(0, 8, 26, 19));
        tileBitCollisions.put("double-mountain", new TileBitCollision(1, 8, 28, 26));
        tileBitCollisions.put("triple-mountain", new TileBitCollision(1, 9, 34, 31));
    }

    private static class TileBitCollision {
        int x;
        int y;
        int w;
        int h;

        public TileBitCollision(int n, int n2, int n3, int n4) {
            this.x = n;
            this.y = n2;
            this.w = n3;
            this.h = n4;
        }

        public Collidable create(int n, int n2) {
            return Geometry.Rectangle.createCollidable(n + this.x, n2 + this.y, this.w, this.h);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PlanetTileType {
        Shop("shop", "tiles-shop", 0, 0, 0),
        Plain("plain", "tiles-plain", Properties.mule.plainFood, Properties.mule.plainEnergy, Properties.mule.plainSmithore),
        SmallWater("small water", "tiles-plain", Properties.mule.smallWaterFood, Properties.mule.smallWaterEnergy, Properties.mule.smallWaterSmithore),
        Water("water", "tiles-plain", Properties.mule.waterFood, Properties.mule.waterEnergy, Properties.mule.waterSmithore),
        Desert("desert", "tiles-desert", Properties.mule.desertFood, Properties.mule.desertEnergy, Properties.mule.desertSmithore),
        Mountain1("1mountain", "tiles-plain", Properties.mule.mountain1Food, Properties.mule.mountain1Energy, Properties.mule.mountain1Smithore),
        Mountain2("2mountain", "tiles-plain", Properties.mule.mountain2Food, Properties.mule.mountain2Energy, Properties.mule.mountain2Smithore),
        Mountain3("3mountain", "tiles-plain", Properties.mule.mountain3Food, Properties.mule.mountain3Energy, Properties.mule.mountain3Smithore),
        River("river", "tiles-river", Properties.mule.waterFood, Properties.mule.waterEnergy, Properties.mule.waterSmithore),
        Crater("crater", "tiles-crater", Properties.mule.plainFood, Properties.mule.plainEnergy, Properties.mule.plainSmithore);

        public final String name;
        public final String identifier;
        public final int food;
        public final int energy;
        public final int smithore;

        private PlanetTileType(String string2, String string3, int n2, int n3, int n4) {
            this.name = string2;
            this.identifier = string3;
            this.food = n2;
            this.energy = n3;
            this.smithore = n4;
        }

        public boolean allow(Resource resource) {
            switch (this) {
                case River: {
                    return resource != Resource.Crystite && resource != Resource.Smithore;
                }
            }
            return true;
        }
    }
}

