/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.model.map;

import com.turborilla.mule.Properties;
import com.turborilla.mule.model.map.PlanetMap;
import com.turborilla.mule.model.map.PlanetTile;
import com.turborilla.mule.view.MapSkin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Random;

public class PlanetMapGenerator {
    public PlanetMap generate(PlanetMap planetMap, Random random, boolean bl, boolean bl2) {
        PlanetTile.PlanetTileType planetTileType;
        Object object;
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = this.random(random, Properties.mule.minNumSmallWater, Properties.mule.maxNumSmallWater);
        int n6 = this.random(random, Properties.mule.minNumWater, Properties.mule.maxNumWater);
        int n7 = this.random(random, Properties.mule.minNumDesert, Properties.mule.maxNumDesert);
        if (!bl2) {
            n7 = 0;
        }
        MapSkin mapSkin = planetMap.getSkin();
        int n8 = 4;
        int n9 = 2;
        planetMap.addTile(PlanetTile.PlanetTileType.Shop, 0, n8, n9);
        int n10 = 1;
        planetMap.setRiver(bl);
        if (bl) {
            n6 = 0;
            int[] nArray = new int[]{1, 2, 3, 4};
            Collections.shuffle(Arrays.asList(bl), random);
            if (nArray[0] == 1) {
                nArray[0] = nArray[3];
            }
            planetMap.addTile(PlanetTile.PlanetTileType.River, 0, n8, n9 + 1);
            planetMap.addTile(PlanetTile.PlanetTileType.River, nArray[0], n8, n9 + 2);
            planetMap.addTile(PlanetTile.PlanetTileType.River, nArray[1], n8, n9 - 2);
            planetMap.addTile(PlanetTile.PlanetTileType.River, nArray[2], n8, n9 - 1);
            n10 += 4;
        }
        for (n4 = 0; n4 < planetMap.getYSize(); ++n4) {
            int n11 = 0 + random.nextInt(4);
            n3 = 5 + random.nextInt(4);
            n2 = 1 + random.nextInt(3);
            n = 4 - n2;
            object = this.getMountainType(n2);
            planetTileType = this.getMountainType(n);
            planetMap.addTile((PlanetTile.PlanetTileType)((Object)object), random.nextInt(mapSkin.getNumTiles((PlanetTile.PlanetTileType)((Object)object))), n11, n4);
            planetMap.addTile(planetTileType, random.nextInt(mapSkin.getNumTiles(planetTileType)), n3, n4);
            n10 += 2;
        }
        n4 = planetMap.getXSize() * planetMap.getYSize() - n10;
        ArrayList<PlanetTile.PlanetTileType> arrayList = new ArrayList<PlanetTile.PlanetTileType>(n4);
        for (n3 = 0; n3 < n5; ++n3) {
            arrayList.add(PlanetTile.PlanetTileType.SmallWater);
        }
        for (n3 = 0; n3 < n6; ++n3) {
            arrayList.add(PlanetTile.PlanetTileType.Water);
        }
        for (n3 = 0; n3 < n7; ++n3) {
            arrayList.add(PlanetTile.PlanetTileType.Desert);
        }
        while (arrayList.size() < n4) {
            arrayList.add(PlanetTile.PlanetTileType.Plain);
        }
        Collections.shuffle(arrayList, random);
        n3 = 0;
        for (n2 = 0; n2 < planetMap.getXSize(); ++n2) {
            for (n = 0; n < planetMap.getYSize(); ++n) {
                object = (PlanetTile)planetMap.getTile(n2, n);
                if (object == null) {
                    planetTileType = (PlanetTile.PlanetTileType)((Object)arrayList.get(n3++));
                    int n12 = mapSkin.getNumTiles(planetTileType);
                    int n13 = random.nextInt(n12);
                    object = planetMap.addTile(planetTileType, n13, n2, n);
                }
                this.constructTileBits((PlanetTile)object, random, mapSkin);
                ((PlanetTile)object).constructCollidables(mapSkin);
            }
        }
        for (n2 = 0; n2 < 4; ++n2) {
            this.generateCrystite(planetMap, random, n8, n9, 3);
        }
        return planetMap;
    }

    private PlanetTile.PlanetTileType getMountainType(int n) {
        if (n == 0) {
            return PlanetTile.PlanetTileType.Plain;
        }
        if (n == 1) {
            return PlanetTile.PlanetTileType.Mountain1;
        }
        if (n == 2) {
            return PlanetTile.PlanetTileType.Mountain2;
        }
        if (n == 3) {
            return PlanetTile.PlanetTileType.Mountain3;
        }
        throw new RuntimeException("No tile type for " + n + " mountains");
    }

    private void constructTileBits(PlanetTile planetTile, Random random, MapSkin mapSkin) {
        int n;
        int n2;
        int n3;
        int n4;
        if (planetTile.getIdentifier().startsWith("tiles-plain")) {
            int n5 = random.nextInt(3);
            MapSkin.Decals decals = mapSkin.getDirt();
            n4 = 64 - decals.getWidth();
            n3 = 64 - decals.getHeight();
            for (n2 = 0; n2 < n5; ++n2) {
                n = random.nextInt(decals.getNum());
                int n6 = (int)(random.nextDouble() * (double)n4);
                int n7 = (int)(random.nextDouble() * (double)n3);
                planetTile.addTileBit("dirt", "decals-dirt" + n, n6, n7);
            }
        }
        if (planetTile.getName().equals("1mountain")) {
            this.createAlienMountains(planetTile, random, 1, mapSkin);
        } else if (planetTile.getName().equals("2mountain")) {
            this.createAlienMountains(planetTile, random, 2, mapSkin);
        } else if (planetTile.getName().equals("3mountain")) {
            this.createAlienMountains(planetTile, random, 3, mapSkin);
        } else if (planetTile.getName().equals("water")) {
            MapSkin.Decals decals = mapSkin.getWater();
            int n8 = 5;
            n4 = 5;
            n3 = random.nextInt(decals.getNum());
            n2 = (int)(random.nextDouble() * (double)n8);
            n = (int)(random.nextDouble() * (double)n4);
            planetTile.addTileBit("water", "decals-water" + n3, n2, n);
        } else if (planetTile.getName().equals("small water")) {
            MapSkin.Decals decals = mapSkin.getSmallWater();
            int n9 = 15;
            n4 = 15;
            n3 = random.nextInt(decals.getNum());
            n2 = (int)(random.nextDouble() * (double)n9);
            n = (int)(random.nextDouble() * (double)n4);
            planetTile.addTileBit("small water", "decals-small-water" + n3, n2, n);
        }
    }

    private void createAlienMountains(PlanetTile planetTile, Random random, int n, MapSkin mapSkin) {
        int n2 = mapSkin.getMountains().getWidth();
        int n3 = mapSkin.getMountains().getHeight();
        int n4 = mapSkin.getMountains().getNum();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < n4; ++i) {
            arrayList.add(i);
        }
        Collections.shuffle(arrayList, random);
        int[] nArray = new int[]{20, 0, 10};
        int[] nArray2 = new int[]{30, 10, 20};
        int[] nArray3 = new int[]{0, 10, 20};
        int[] nArray4 = new int[]{5, 15, 25};
        for (int i = 0; i < n; ++i) {
            int n5 = nArray[i] + (int)(random.nextDouble() * (double)(nArray2[i] - nArray[i]));
            int n6 = nArray3[i] + (int)(random.nextDouble() * (double)(nArray4[i] - nArray3[i]));
            planetTile.addTileBit("1mountain", "decals-mountain" + arrayList.get(i), n5, n6);
        }
    }

    private void generateCrystite(PlanetMap planetMap, Random random, int n, int n2, int n3) {
        int n4;
        int n5;
        PlanetTile planetTile;
        while ((planetTile = (PlanetTile)planetMap.getTile(n5 = this.random(random, 0, planetMap.getXSize() - 1), n4 = this.random(random, 0, planetMap.getYSize() - 1))).getCrystite() >= 3) {
        }
        for (int i = 0; i < planetMap.getXSize(); ++i) {
            for (int j = 0; j < planetMap.getYSize(); ++j) {
                planetTile = (PlanetTile)planetMap.getTile(i, j);
                int n6 = Math.abs(i - n5) + Math.abs(j - n4);
                int n7 = Math.max(3 - n6, 0);
                if (n7 == 3) {
                    n7 = n3;
                }
                if (n7 <= planetTile.getCrystite()) continue;
                planetTile.setCrystite(n7);
            }
        }
    }

    private int random(Random random, int n, int n2) {
        return n + random.nextInt(1 + n2 - n);
    }

    private static class Coordinate {
        public int x;
        public int y;

        public Coordinate(int n, int n2) {
            this.x = n;
            this.y = n2;
        }
    }
}

