/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.model.map;

import com.turborilla.mule.MuleMath;
import com.turborilla.mule.Properties;
import com.turborilla.mule.model.LabItem;
import com.turborilla.mule.model.Resource;
import com.turborilla.mule.model.map.Building;
import com.turborilla.mule.model.map.PlanetMap;
import com.turborilla.mule.model.map.PlanetTile;
import java.util.Random;

public class Factory
extends Building {
    private static final long serialVersionUID = 1L;
    public final Resource resource;
    public LabItem labItem;
    private final int yieldPotential;
    private int bonus = 0;
    private int temporaryBonus = 0;
    private int capacity = 0;
    private int expectedProduction = 0;
    private int production = 0;
    private int energyNeeded;
    private int energyReduction = 0;
    private String identifier;
    private String highlightIdentifier;
    private String lowEnergyIdentifier;
    private boolean yieldVisible;

    public Factory(Resource resource, PlanetTile planetTile) {
        this(resource, planetTile, LabItem.NONE);
    }

    public Factory(Resource resource, PlanetTile planetTile, LabItem labItem) {
        super(planetTile);
        this.resource = resource;
        this.yieldPotential = planetTile.getYieldPotential(resource);
        int n = planetTile.getOwner() == null ? 0 : planetTile.getOwner().getColorIndex();
        this.setYieldVisible(resource != Resource.Crystite);
        this.highlightIdentifier = "factory-highlight-" + resource.getName() + "-color" + n;
        this.lowEnergyIdentifier = "factory-low-energy-" + resource.getName() + "-color" + n + "-power";
        this.energyNeeded = resource.energyCost;
        this.setLabItem(labItem);
    }

    public void destroy(PlanetMap planetMap) {
    }

    public int getProduction() {
        return this.production;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setProduction(int n) {
        this.production = n < 0 ? 0 : (n > Properties.mule.maxProduction ? Properties.mule.maxProduction : n);
    }

    public Resource getResource() {
        return this.resource;
    }

    public void setLabItem(LabItem labItem) {
        if (this.labItem == labItem) {
            return;
        }
        this.labItem = labItem;
        this.tile.removeTileBits("lab");
        if (this.labItem == LabItem.WATER_TANK) {
            this.tile.addTileBit("lab", "factory-water-store-sand", 47, 8);
        } else if (this.labItem == LabItem.MINING_TOWER) {
            this.tile.addTileBit("lab", "factory-mining-tower-sand", 46, 9);
        } else if (this.labItem == LabItem.POWER_PLANT) {
            this.tile.addTileBit("lab", "power-plant", 3, 3);
        }
    }

    public LabItem getLabItem() {
        return this.labItem;
    }

    public int getEnergyNeeded() {
        return this.energyNeeded - this.energyReduction;
    }

    public int getYieldPotential() {
        return this.yieldPotential;
    }

    public void setBonus(int n) {
        this.bonus = n;
    }

    public int getBonus() {
        return this.bonus;
    }

    public void setTemporaryBonus(int n) {
        this.temporaryBonus = n;
    }

    public int getTemporaryBonus() {
        return this.temporaryBonus;
    }

    public int getEnergyReduction() {
        return this.energyReduction;
    }

    public void setEnergyReduction(int n) {
        this.energyReduction = n;
    }

    public void calcCapacity(Random random) {
        int n = Math.round(MuleMath.normalDistributed(random));
        this.capacity = this.yieldPotential + this.bonus + this.temporaryBonus + n;
        this.expectedProduction = this.capacity - n;
        this.capacity = this.calcCapacity(this.capacity);
        this.expectedProduction = this.calcCapacity(this.expectedProduction);
        this.temporaryBonus = 0;
    }

    private int calcCapacity(int n) {
        if (this.power < this.energyNeeded) {
            n = this.power == 0 ? 0 : (this.capacity > 1 ? (n /= 2) : 1);
        }
        n = MuleMath.clamp(n, 0, Properties.mule.maxProduction);
        return n;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public int getExpectedProduction() {
        return this.expectedProduction;
    }

    public String getHighlightIdentifier() {
        return this.highlightIdentifier;
    }

    public String getLowEnergyIdentifier() {
        return this.lowEnergyIdentifier;
    }

    public int getPower() {
        return this.power;
    }

    public String toString() {
        return this.resource.getName() + " factory";
    }

    public void setYieldVisible(boolean bl) {
        this.yieldVisible = bl;
        int n = this.tile.getOwner() == null ? 0 : this.tile.getOwner().getColorIndex();
        this.identifier = bl ? "factory-" + this.resource.getName() + this.yieldPotential + "-color" + n : "factory-" + this.resource.getName() + "5-color" + n;
    }

    public boolean isYieldVisible() {
        return this.yieldVisible;
    }
}

