/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.model.map;

import com.turborilla.mule.Properties;
import com.turborilla.mule.model.HirelingManager;
import com.turborilla.mule.model.Player;
import com.turborilla.mule.model.map.Depot;
import com.turborilla.mule.model.map.Factory;
import com.turborilla.mule.model.map.PlanetMap;
import com.turborilla.mule.model.map.PlanetTile;
import java.io.Serializable;

public abstract class Building
implements Serializable {
    private static final long serialVersionUID = 1L;
    public final PlanetTile tile;
    protected int power;
    public static final int[][] adjacentDirs = new int[][]{{1, 0}, {-1, 0}, {0, 1}, {0, -1}};
    public static final int[][] diagonalDirs = new int[][]{{-1, -1}, {-1, 1}, {1, -1}, {1, 1}};

    public Building(PlanetTile planetTile) {
        this.tile = planetTile;
    }

    public abstract void destroy(PlanetMap var1);

    public abstract int getEnergyNeeded();

    public PlanetTile getTile() {
        return this.tile;
    }

    public void setPower(int n) {
        this.power = n;
    }

    public static void calcBonuses(Player player, PlanetMap planetMap, HirelingManager hirelingManager) {
        player.setDepot(false);
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        for (PlanetTile planetTile : player.getOwnedTiles()) {
            for (Building building : planetTile.getBuildings()) {
                if (building instanceof Factory) {
                    Factory factory = (Factory)building;
                    factory.setBonus(0);
                    switch (factory.getResource()) {
                        case Food: {
                            ++n;
                            break;
                        }
                        case Energy: {
                            ++n2;
                            break;
                        }
                        case Smithore: {
                            ++n3;
                            break;
                        }
                        case Crystite: {
                            ++n4;
                        }
                    }
                    int n5 = 0;
                    for (int i = 0; i < adjacentDirs.length; ++i) {
                        Factory factory2;
                        PlanetTile planetTile2 = (PlanetTile)planetMap.getTile(planetTile.getPosX() + adjacentDirs[i][0], planetTile.getPosY() + adjacentDirs[i][1]);
                        if (planetTile2 == null || (factory2 = planetTile2.getFactory()) == null || planetTile2.getOwner() != player || factory2.getResource() != factory.getResource()) continue;
                        ++n5;
                    }
                    if (n5 <= 0) continue;
                    factory.setBonus(factory.getBonus() + 1);
                    continue;
                }
                if (!(building instanceof Depot)) continue;
                player.setDepot(true);
            }
        }
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        if (Properties.mule.enableHiring) {
            // empty if block
        }
        for (PlanetTile planetTile : player.getOwnedTiles()) {
            Factory factory = planetTile.getFactory();
            if (factory == null) continue;
            switch (factory.getResource()) {
                case Food: {
                    factory.setBonus(factory.getBonus() + n / 3 + n6);
                    break;
                }
                case Energy: {
                    factory.setBonus(factory.getBonus() + n2 / 3 + n7);
                    break;
                }
                case Smithore: {
                    factory.setBonus(factory.getBonus() + n3 / 3 + n8);
                    break;
                }
                case Crystite: {
                    factory.setBonus(factory.getBonus() + n4 / 3 + n9);
                    break;
                }
            }
        }
    }

    private static int labBonus(Factory factory, Factory factory2, int n) {
        if (factory2.getYieldPotential() == 0) {
            return 0;
        }
        switch (factory2.getLabItem()) {
            case WATER_TANK: {
                switch (factory.getResource()) {
                    case Food: {
                        return Properties.mule.waterTankFoodBonus[n];
                    }
                    case Smithore: {
                        return Properties.mule.waterTankSmithoreBonus[n];
                    }
                }
                break;
            }
            case MINING_TOWER: {
                switch (factory.getResource()) {
                    case Smithore: {
                        return Properties.mule.miningTowerSmithoreBonus[n];
                    }
                    case Energy: {
                        return Properties.mule.miningTowerEnergyBonus[n];
                    }
                }
                break;
            }
            case POWER_PLANT: {
                switch (factory.getResource()) {
                    case Energy: {
                        return Properties.mule.powerPlantEnergyBonus[n];
                    }
                    case Food: {
                        return Properties.mule.powerPlantFoodBonus[n];
                    }
                }
            }
        }
        return 0;
    }
}

