/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.model;

import com.turborilla.mule.model.GameMode;
import java.io.Serializable;
import java.util.EnumMap;

public class UserStatistics
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int rank;
    private EnumMap<GameMode, GameModeStatistics> gameModeStatistics;

    public UserStatistics(int n) {
        this.rank = n;
        this.gameModeStatistics = new EnumMap(GameMode.class);
    }

    public void putGameModeStatistics(GameMode gameMode, GameModeStatistics gameModeStatistics) {
        this.gameModeStatistics.put(gameMode, gameModeStatistics);
    }

    public GameModeStatistics getGameModeStatistics(GameMode gameMode) {
        return this.gameModeStatistics.get((Object)gameMode);
    }

    public int getRank() {
        return this.rank;
    }

    public static class GameModeStatistics
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private int gamesFinished = 0;
        private int gamesWon = 0;
        private int gamesStarted = 0;
        private int gamesAbandoned = 0;
        private int personalScore = 0;
        private int colonyScore = 0;
        private int totalScore = 0;
        private int winPercentage = 0;
        private int abandonedPercentage = 0;

        public GameModeStatistics(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
            this.gamesFinished = n;
            this.gamesWon = n2;
            this.gamesStarted = n3;
            this.gamesAbandoned = n4;
            this.personalScore = n5;
            this.colonyScore = n6;
            this.totalScore = n7;
            if (n3 > 0) {
                this.winPercentage = (int)Math.round((double)(100.0f * (float)n2) / (double)n);
                this.abandonedPercentage = (int)Math.round((double)(100.0f * (float)n4) / (double)n3);
            }
        }

        public int getGamesFinished() {
            return this.gamesFinished;
        }

        public int getGamesWon() {
            return this.gamesWon;
        }

        public int getGamesStarted() {
            return this.gamesStarted;
        }

        public int getWinPercentage() {
            return this.winPercentage;
        }

        public int getAbandonedPercentage() {
            return this.abandonedPercentage;
        }

        public int getPersonalScore() {
            return this.personalScore;
        }

        public int getColonyScore() {
            return this.colonyScore;
        }

        public int getTotalScore() {
            return this.totalScore;
        }

        public int getGamesAbandoned() {
            return this.gamesAbandoned;
        }
    }
}

