/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.model;

import com.turborilla.mule.MuleMath;
import com.turborilla.mule.Properties;
import com.turborilla.mule.model.GameModel;
import com.turborilla.mule.model.Player;
import com.turborilla.mule.model.map.PlanetMap;
import com.turborilla.mule.model.map.PlanetTile;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Random;
import java.util.logging.Logger;

public class PlotSeller
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger("mule");
    private Queue<PlanetTile> playerLandAuctions = new LinkedList<PlanetTile>();
    private Queue<PlanetTile> colonyLandAuctions = new LinkedList<PlanetTile>();
    private int landPrice;
    private int landPriceAccumulator;
    private int auctionSetSize;
    private int landSellPrice;
    private boolean startingAuctionSet;
    private PlanetTile lastBoughtLand;
    private int lastRoundGenerated;
    private Random random;

    public PlotSeller(Random random) {
        this.landPrice = Properties.mule.landAuctionPrice;
        this.landPriceAccumulator = 0;
        this.auctionSetSize = 0;
        this.landSellPrice = 0;
        this.startingAuctionSet = true;
        this.lastRoundGenerated = -1;
        this.random = random;
    }

    public int numPlayerAuctions() {
        return this.playerLandAuctions.size();
    }

    public int numColonyAuctions() {
        return this.colonyLandAuctions.size();
    }

    public int numAuctions() {
        return this.numPlayerAuctions() + this.numColonyAuctions();
    }

    public PlanetTile getAuctionTile() {
        if (!this.playerLandAuctions.isEmpty()) {
            return this.playerLandAuctions.peek();
        }
        return this.colonyLandAuctions.peek();
    }

    public int getAuctionPrice() {
        return this.landPrice;
    }

    public boolean hasGeneratedColonyAuctions(int n) {
        return n <= this.lastRoundGenerated;
    }

    public int generateColonyAuctions(PlanetMap planetMap, int n) {
        int n2;
        this.lastRoundGenerated = n;
        this.colonyLandAuctions.clear();
        if (Properties.mule.testLandAuction) {
            n2 = 2;
        } else {
            Properties.mule.getClass();
            n2 = 1 + StrictMath.round(1.0f * MuleMath.normalDistributed(this.random));
            n2 = MuleMath.clamp(n2, 0, 3);
        }
        if (n2 > 0) {
            int n3;
            int n4;
            ArrayList<PlanetTile> arrayList = new ArrayList<PlanetTile>(planetMap.getXSize() * planetMap.getYSize());
            PlanetTile planetTile = planetMap.getShopTile();
            for (n4 = Properties.mule.debugTutorial; n4 < planetMap.getXSize(); ++n4) {
                for (n3 = 0; n3 < planetMap.getYSize(); ++n3) {
                    PlanetTile planetTile2 = (PlanetTile)planetMap.getTile(n4, n3);
                    if (planetTile2.getOwner() != null || planetTile2 == planetTile) continue;
                    arrayList.add(planetTile2);
                }
            }
            n2 = Math.min(n2, arrayList.size());
            for (n4 = 0; n4 < n2; ++n4) {
                n3 = this.random.nextInt(arrayList.size() - n4);
                this.colonyLandAuctions.add((PlanetTile)arrayList.get(n3));
                Collections.swap(arrayList, n3, arrayList.size() - 1 - n4);
            }
        }
        logger.info("Generated " + this.colonyLandAuctions.size() + " colony land auctions");
        return n2;
    }

    public boolean beginAuction(GameModel gameModel) {
        if (this.numAuctions() == 0) {
            return false;
        }
        if (this.startingAuctionSet) {
            if (this.auctionSetSize > 0) {
                this.landPrice = this.landPriceAccumulator / this.auctionSetSize - 60;
                this.landPriceAccumulator = 0;
                this.auctionSetSize = 0;
            }
        } else {
            this.landPrice = this.landSellPrice - 60;
        }
        this.landPrice = Math.max(this.landPrice, 80);
        this.landPrice = MuleMath.closest(this.landPrice, 4);
        logger.info("Land auction price: $" + this.landPrice);
        return true;
    }

    public boolean finishAuction(Player player, int n, PlanetMap planetMap) {
        boolean bl;
        Queue<PlanetTile> queue = this.playerLandAuctions.isEmpty() ? this.colonyLandAuctions : this.playerLandAuctions;
        PlanetTile planetTile = queue.poll();
        if (player != null && player.getMoney() >= n) {
            player.setMoney(player.getMoney() - n);
            Player player2 = planetTile.getOwner();
            if (player2 != null) {
                player2.setMoney(player2.getMoney() + n);
            }
            planetTile.setOwner(planetMap, player);
            this.landSellPrice = n;
            this.lastBoughtLand = planetTile;
            bl = true;
        } else {
            this.landSellPrice = this.landPrice / 2 + 52;
            bl = false;
        }
        ++this.auctionSetSize;
        this.landPriceAccumulator += this.landSellPrice;
        this.startingAuctionSet = queue.isEmpty();
        planetTile.setForSale(false);
        return bl;
    }

    public boolean sellLand(Player player, PlanetTile planetTile) {
        if (planetTile == null) {
            return false;
        }
        if (planetTile.isForSale()) {
            return false;
        }
        if (planetTile.getOwner() != player) {
            return false;
        }
        planetTile.setForSale(true);
        this.playerLandAuctions.add(planetTile);
        planetTile.getOwner().setSellLand(false);
        return true;
    }

    public PlanetTile getLastBoughtLand() {
        return this.lastBoughtLand;
    }

    public void clearAuctions() {
        this.playerLandAuctions.clear();
        this.colonyLandAuctions.clear();
    }
}

