/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.model;

import com.turborilla.mule.Properties;
import com.turborilla.mule.model.GameModel;
import com.turborilla.mule.model.Player;
import com.turborilla.mule.model.PlayerEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import java.util.logging.Logger;

public strictfp final class PlayerEventGenerator
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger("mule");
    private ArrayList<PlayerEvent> events = new ArrayList();
    private int nextEvent;
    private PlayerEvent debugEvent = null;
    private Random random;

    public PlayerEventGenerator(GameModel gameModel) {
        this.events.add(new PlayerEvent.HomeWorldPackage());
        this.events.add(new PlayerEvent.WanderingSpaceTraveler());
        this.events.add(new PlayerEvent.BestBuiltMule());
        this.events.add(new PlayerEvent.TapDancingMule());
        this.events.add(new PlayerEvent.AgricultureAward());
        this.events.add(new PlayerEvent.WormInfestation());
        this.events.add(new PlayerEvent.MuseumBoughtComputer());
        this.events.add(new PlayerEvent.SwampEelEating());
        this.events.add(new PlayerEvent.Charity());
        this.events.add(new PlayerEvent.ArtificialDumbness());
        this.events.add(new PlayerEvent.RelativeDied());
        this.events.add(new PlayerEvent.DeadMooseRat());
        this.events.add(new PlayerEvent.ExtraPlot());
        this.events.add(new PlayerEvent.MischievousElves());
        this.events.add(new PlayerEvent.MuleLostBolt());
        this.events.add(new PlayerEvent.MulesDeteriorated());
        this.events.add(new PlayerEvent.DirtySolarCollectors());
        this.events.add(new PlayerEvent.GypsyInlaws());
        this.events.add(new PlayerEvent.FlyingCatBugs());
        this.events.add(new PlayerEvent.KazingaRaces());
        this.events.add(new PlayerEvent.BatLizard());
        this.events.add(new PlayerEvent.LostPlot());
        this.random = new Random(gameModel.getRandom().nextLong());
        Collections.shuffle(this.events, this.random);
        this.nextEvent = 0;
    }

    public void debugForceEvent(PlayerEvent playerEvent) {
        this.debugEvent = playerEvent;
    }

    public PlayerEvent nextEvent(Player player, GameModel gameModel) {
        Properties.mule.getClass();
        if (this.debugEvent != null) {
            return this.debugEvent;
        }
        if (gameModel.getRound() == 1) {
            logger.info("No event frist round");
            return null;
        }
        float f = this.random.nextFloat();
        logger.info("Event random chance: " + f);
        if (f > Properties.mule.playerEventChance) {
            return null;
        }
        int n = player.getRank();
        if (gameModel.getPlayersInRankOrder().size() == 1) {
            n = 2;
        }
        if (n > 1 && player.getFood() == 0) {
            logger.info("Player event pitys player without food.");
            for (int i = this.nextEvent; i < this.events.size(); ++i) {
                if (!(this.events.get(i) instanceof PlayerEvent.HomeWorldPackage)) continue;
                Collections.swap(this.events, i, this.nextEvent);
                break;
            }
        }
        PlayerEvent playerEvent = null;
        for (int i = this.nextEvent; i < this.events.size(); ++i) {
            PlayerEvent playerEvent2 = this.events.get(i);
            if (gameModel.getRound() > gameModel.getGameInfo().getLastRound() - 2 && !playerEvent2.isGood() || n == 1 && playerEvent2.isGood() || n >= 3 && !playerEvent2.isGood() || !playerEvent2.condition(player, gameModel)) continue;
            Collections.swap(this.events, i, this.nextEvent);
            ++this.nextEvent;
            playerEvent = playerEvent2;
            break;
        }
        if (playerEvent == null) {
            logger.info("No suitable event was found");
        }
        return playerEvent;
    }

    public String apply(PlayerEvent playerEvent, Player player, GameModel gameModel) {
        int n = 25 * (gameModel.getRound() / 4 + 1);
        return playerEvent.action(player, gameModel, n);
    }
}

