/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.model;

import com.turborilla.mule.model.GameModel;
import com.turborilla.mule.model.Player;
import com.turborilla.mule.model.Resource;
import com.turborilla.mule.model.map.Factory;
import com.turborilla.mule.model.map.PlanetMap;
import com.turborilla.mule.model.map.PlanetTile;
import java.io.Serializable;
import java.util.ArrayList;

public abstract class PlayerEvent
implements Serializable {
    private static final long serialVersionUID = 7680441361222391310L;

    public abstract boolean isGood();

    boolean condition(Player player, GameModel gameModel) {
        return true;
    }

    abstract String action(Player var1, GameModel var2, int var3);

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static class LostPlot
    extends PlayerEvent {
        private static final long serialVersionUID = -7940228927780771712L;

        public boolean isGood() {
            return false;
        }

        public boolean condition(Player player, GameModel gameModel) {
            for (PlanetTile planetTile : player.getOwnedTiles()) {
                if (!planetTile.getBuildings().isEmpty()) continue;
                return true;
            }
            return false;
        }

        public String action(Player player, GameModel gameModel, int n) {
            PlanetTile planetTile = null;
            for (PlanetTile planetTile2 : player.getOwnedTiles()) {
                if (!planetTile2.getBuildings().isEmpty()) continue;
                planetTile = planetTile2;
            }
            planetTile.setOwner(gameModel.getMap(), null);
            return "You lost a plot of land because the claim was not recorded";
        }
    }

    public static class BatLizard
    extends PlayerEvent {
        private static final long serialVersionUID = -7940228927780771712L;

        public boolean isGood() {
            return false;
        }

        public String action(Player player, GameModel gameModel, int n) {
            int n2 = 4 * n;
            player.setMoney(player.getMoney() - n2);
            return "Your child was bitten by a Bat-Lizard and the hospital bill cost you $" + n2;
        }
    }

    public static class KazingaRaces
    extends PlayerEvent {
        private static final long serialVersionUID = -7940228927780771712L;

        public boolean isGood() {
            return false;
        }

        public String action(Player player, GameModel gameModel, int n) {
            int n2 = 4 * n;
            player.setMoney(player.getMoney() - n2);
            return "You lost $" + n2 + " betting on the two-legged Kazinga races";
        }
    }

    public static class FlyingCatBugs
    extends PlayerEvent {
        private static final long serialVersionUID = -7940228927780771712L;

        public boolean isGood() {
            return false;
        }

        public String action(Player player, GameModel gameModel, int n) {
            int n2 = 4 * n;
            player.setMoney(player.getMoney() - n2);
            return "Flying Cat-Bugs ate the roof off your house. Repairs cost $" + n2;
        }
    }

    public static class GypsyInlaws
    extends PlayerEvent {
        private static final long serialVersionUID = -7940228927780771712L;

        public boolean isGood() {
            return false;
        }

        public String action(Player player, GameModel gameModel, int n) {
            int n2 = 6 * n;
            player.setMoney(player.getMoney() - n2);
            return "Your Space Gypsy inlaws made a mess of the town. It cost you $" + n2 + " to clean it up";
        }
    }

    public static class DirtySolarCollectors
    extends PlayerEvent {
        private static final long serialVersionUID = -7940228927780771712L;

        public boolean isGood() {
            return false;
        }

        public boolean condition(Player player, GameModel gameModel) {
            for (PlanetTile planetTile : player.getOwnedTiles()) {
                if (planetTile.getFactoryWithResource(Resource.Energy) == null) continue;
                return true;
            }
            return false;
        }

        public String action(Player player, GameModel gameModel, int n) {
            int n2 = 2 * n;
            int n3 = 0;
            for (PlanetTile planetTile : player.getOwnedTiles()) {
                if (planetTile.getFactoryWithResource(Resource.Energy) == null) continue;
                n3 += n2;
            }
            player.setMoney(player.getMoney() - n3);
            return "The Solar Collectors on your energy M.U.L.E.s are dirty. Cleaning cost you $" + n2 + " each for a total of $" + n3;
        }
    }

    public static class MulesDeteriorated
    extends PlayerEvent {
        private static final long serialVersionUID = -7940228927780771712L;

        public boolean isGood() {
            return false;
        }

        public boolean condition(Player player, GameModel gameModel) {
            for (PlanetTile planetTile : player.getOwnedTiles()) {
                if (planetTile.getFactoryWithResource(Resource.Crystite, Resource.Smithore) == null) continue;
                return true;
            }
            return false;
        }

        public String action(Player player, GameModel gameModel, int n) {
            int n2 = 2 * n;
            int n3 = 0;
            for (PlanetTile planetTile : player.getOwnedTiles()) {
                if (planetTile.getFactoryWithResource(Resource.Crystite, Resource.Smithore) == null) continue;
                n3 += n2;
            }
            player.setMoney(player.getMoney() - n3);
            return "Your mining M.U.L.E.s have deteriorated from heavy use and cost $" + n2 + " each to repair. The total cost is $" + n3;
        }
    }

    public static class MuleLostBolt
    extends PlayerEvent {
        private static final long serialVersionUID = -7940228927780771712L;

        public boolean isGood() {
            return false;
        }

        public boolean condition(Player player, GameModel gameModel) {
            for (PlanetTile planetTile : player.getOwnedTiles()) {
                if (planetTile.getBuildings().isEmpty()) continue;
                return true;
            }
            return false;
        }

        public String action(Player player, GameModel gameModel, int n) {
            int n2 = 3 * n;
            player.setMoney(player.getMoney() - n2);
            return "One of your M.U.L.E.s lost a bolt. Repairs cost you $" + n2;
        }
    }

    public static class MischievousElves
    extends PlayerEvent {
        private static final long serialVersionUID = -7940228927780771712L;

        public boolean isGood() {
            return false;
        }

        public String action(Player player, GameModel gameModel, int n) {
            player.setFood(player.getFood() / 2);
            return "Mischievous Glac-Elves broke into your storage shed and stole half your food";
        }
    }

    public static class ExtraPlot
    extends PlayerEvent {
        private static final long serialVersionUID = -7940228927780771712L;

        public boolean isGood() {
            return true;
        }

        public boolean condition(Player player, GameModel gameModel) {
            PlanetMap planetMap = gameModel.getMap();
            for (int i = 0; i < planetMap.getYSize(); ++i) {
                for (int j = 0; j < planetMap.getXSize(); ++j) {
                    PlanetTile planetTile = (PlanetTile)planetMap.getTile(j, i);
                    if (planetTile.getOwner() != null || planetTile.getType() == PlanetTile.PlanetTileType.Shop) continue;
                    return true;
                }
            }
            return false;
        }

        public String action(Player player, GameModel gameModel, int n) {
            int n2;
            ArrayList<PlanetTile> arrayList = new ArrayList<PlanetTile>();
            PlanetMap planetMap = gameModel.getMap();
            for (n2 = 0; n2 < planetMap.getYSize(); ++n2) {
                for (int i = 0; i < planetMap.getXSize(); ++i) {
                    PlanetTile planetTile = (PlanetTile)planetMap.getTile(i, n2);
                    if (planetTile.getOwner() != null || planetTile.getType() == PlanetTile.PlanetTileType.Shop) continue;
                    arrayList.add(planetTile);
                }
            }
            n2 = gameModel.getRandom().nextInt(arrayList.size());
            PlanetTile planetTile = (PlanetTile)arrayList.get(n2);
            planetTile.setOwner(planetMap, player);
            return "You received an extra plot of land to encourage colony development";
        }
    }

    public static class DeadMooseRat
    extends PlayerEvent {
        private static final long serialVersionUID = -7940228927780771712L;

        public boolean isGood() {
            return true;
        }

        public String action(Player player, GameModel gameModel, int n) {
            int n2 = 2 * n;
            player.setMoney(player.getMoney() + n2);
            return "You found a dead Moose Rat and sold the hide for $" + n2;
        }
    }

    public static class RelativeDied
    extends PlayerEvent {
        private static final long serialVersionUID = -7940228927780771712L;

        public boolean isGood() {
            return true;
        }

        public String action(Player player, GameModel gameModel, int n) {
            int n2 = 4 * n;
            player.setMoney(player.getMoney() + n2);
            return "A distant relative died and left you a vast fortune. But after taxes you only got $" + n2;
        }
    }

    public static class ArtificialDumbness
    extends PlayerEvent {
        private static final long serialVersionUID = -7940228927780771712L;

        public boolean isGood() {
            return true;
        }

        public String action(Player player, GameModel gameModel, int n) {
            int n2 = 6 * n;
            player.setMoney(player.getMoney() + n2);
            return "Your offworld investments in Artificial Dumbness paid $" + n2 + " in dividends";
        }
    }

    public static class Charity
    extends PlayerEvent {
        private static final long serialVersionUID = -7940228927780771712L;

        public boolean isGood() {
            return true;
        }

        public String action(Player player, GameModel gameModel, int n) {
            int n2 = 3 * n;
            player.setMoney(player.getMoney() + n2);
            return "A charity from your home-world took pity on you and sent $" + n2;
        }
    }

    public static class SwampEelEating
    extends PlayerEvent {
        private static final long serialVersionUID = -7940228927780771712L;

        public boolean isGood() {
            return true;
        }

        public String action(Player player, GameModel gameModel, int n) {
            int n2 = 2 * n;
            player.setMoney(player.getMoney() + n2);
            return "You won the colony Swamp Eel eating contest and collected $" + n2 + " (Yuck!)";
        }
    }

    public static class MuseumBoughtComputer
    extends PlayerEvent {
        private static final long serialVersionUID = -7940228927780771712L;

        public boolean isGood() {
            return true;
        }

        public String action(Player player, GameModel gameModel, int n) {
            int n2 = 8 * n;
            player.setMoney(player.getMoney() + n2);
            return "The museum bought your antique personal computer for $" + n2;
        }
    }

    public static class WormInfestation
    extends PlayerEvent {
        private static final long serialVersionUID = -7940228927780771712L;

        public boolean isGood() {
            return true;
        }

        public String action(Player player, GameModel gameModel, int n) {
            int n2 = 4 * n;
            player.setMoney(player.getMoney() + n2);
            return "The colony awarded you $" + n2 + " for stopping the Wart Worm infestation";
        }
    }

    public static class AgricultureAward
    extends PlayerEvent {
        private static final long serialVersionUID = -7940228927780771712L;

        public boolean isGood() {
            return true;
        }

        public boolean condition(Player player, GameModel gameModel) {
            for (PlanetTile planetTile : player.getOwnedTiles()) {
                if (planetTile.getFactoryWithResource(Resource.Food) == null) continue;
                return true;
            }
            return false;
        }

        public String action(Player player, GameModel gameModel, int n) {
            int n2 = 0;
            int n3 = 2 * n;
            for (PlanetTile planetTile : player.getOwnedTiles()) {
                Factory factory = planetTile.getFactoryWithResource(Resource.Food);
                if (factory == null) continue;
                n2 += n3;
            }
            player.setMoney(player.getMoney() + n2);
            return "The colony council for agriculture awarded you $" + n3 + " for each food plot you have developed. The total grant is $" + n2;
        }
    }

    public static class TapDancingMule
    extends PlayerEvent {
        private static final long serialVersionUID = -7940228927780771712L;

        public boolean isGood() {
            return true;
        }

        public boolean condition(Player player, GameModel gameModel) {
            for (PlanetTile planetTile : player.getOwnedTiles()) {
                if (planetTile.getBuildings().isEmpty()) continue;
                return true;
            }
            return false;
        }

        public String action(Player player, GameModel gameModel, int n) {
            int n2 = 4 * n;
            player.setMoney(player.getMoney() + n2);
            return "Your M.U.L.E. won the colony tap-dancing contest. You collected $" + n2;
        }
    }

    public static class BestBuiltMule
    extends PlayerEvent {
        private static final long serialVersionUID = -7940228927780771712L;

        public boolean isGood() {
            return true;
        }

        public boolean condition(Player player, GameModel gameModel) {
            for (PlanetTile planetTile : player.getOwnedTiles()) {
                if (planetTile.getBuildings().isEmpty()) continue;
                return true;
            }
            return false;
        }

        public String action(Player player, GameModel gameModel, int n) {
            int n2 = 2 * n;
            player.setMoney(player.getMoney() + n2);
            return "Your M.U.L.E. was judged \"Best Built\" at the colony fair. You won $" + n2;
        }
    }

    public static class WanderingSpaceTraveler
    extends PlayerEvent {
        private static final long serialVersionUID = -7940228927780771712L;

        public boolean isGood() {
            return true;
        }

        public String action(Player player, GameModel gameModel, int n) {
            player.setSmithore(player.getSmithore() + 2);
            return "A wandering space traveler repaid your hospitality by leaving two bars of smithore";
        }
    }

    public static class HomeWorldPackage
    extends PlayerEvent {
        private static final long serialVersionUID = -7940228927780771712L;

        public boolean isGood() {
            return true;
        }

        public String action(Player player, GameModel gameModel, int n) {
            player.setFood(player.getFood() + 3);
            player.setEnergy(player.getEnergy() + 2);
            return "You just received a package from your home-world relatives containing 3 food and 2 energy units";
        }
    }
}

