/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.model;

import com.turborilla.mule.Properties;
import com.turborilla.mule.controller.PlayerController;
import com.turborilla.mule.model.AssayBot;
import com.turborilla.mule.model.AuctionState;
import com.turborilla.mule.model.Avatar;
import com.turborilla.mule.model.GameModel;
import com.turborilla.mule.model.LabItem;
import com.turborilla.mule.model.Mule;
import com.turborilla.mule.model.Race;
import com.turborilla.mule.model.Resource;
import com.turborilla.mule.model.Shop;
import com.turborilla.mule.model.User;
import com.turborilla.mule.model.map.Building;
import com.turborilla.mule.model.map.Factory;
import com.turborilla.mule.model.map.PlanetTile;
import com.turborilla.mule.view.ActorSprite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Random;
import java.util.TreeSet;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Player
extends User
implements Comparable<Player> {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger("mule");
    private final int playerIndex;
    public static int NO_PLAYER_INDEX = -1;
    private transient PlayerController playerController;
    private int money;
    private int food;
    private int energy;
    private int smithore;
    private int crystite;
    private int foodUsage;
    private int energyUsage;
    private int foodSpoilage;
    private int energySpoilage;
    private TreeSet<PlanetTile> ownedTiles;
    private int energyRequirement;
    private Avatar avatar;
    private PlanetTile homeBase;
    public boolean hasClaimedLand;
    private boolean sellLand;
    private boolean moveHomeBase;
    private LabItem labItem;
    private AuctionState auctionState;
    private AuctionState targetAuctionState;
    private boolean auctionBuyer;
    private int points;
    private int landPoints;
    private int goodsPoints;
    private int rank;
    private boolean depot;
    private float developmentTime;
    private boolean gambled;
    private boolean enteredShop;
    private short auctionTransactionCount;
    private byte auctionTeleportCount;
    private boolean aiPlayer;
    private boolean finishedAuction;
    private int auctionSpeed;

    static Player createDummyPlayer() {
        User user = new User("Spectator", 0L, 0, null);
        Player player = new Player(user, NO_PLAYER_INDEX, 0);
        player.setContinue(true);
        return player;
    }

    Player(User user, int n, int n2) {
        super(user);
        this.money = Properties.mule.playerStartMoney;
        this.food = Properties.mule.playerStartFood;
        this.energy = Properties.mule.playerStartEnergy;
        this.smithore = Properties.mule.playerStartSmithore;
        this.crystite = Properties.mule.playerStartCrystite;
        this.foodUsage = 0;
        this.energyUsage = 0;
        this.foodSpoilage = 0;
        this.energySpoilage = 0;
        this.ownedTiles = new TreeSet();
        this.energyRequirement = 0;
        this.auctionSpeed = Properties.mule.auctionSpeed;
        logger.info("Creating " + this.toString());
        Race race = Race.getRace(user.getDefaultRace());
        if (race == null) {
            race = Race.defaultRace;
        }
        this.playerIndex = n;
        this.avatar = new Avatar(race, n2);
        this.hasClaimedLand = true;
        this.sellLand = false;
        this.moveHomeBase = false;
        this.depot = false;
        this.gambled = false;
        this.enteredShop = false;
        this.labItem = LabItem.NONE;
        this.developmentTime = Properties.mule.maxDevelopmentTime;
        this.rank = -1;
        this.auctionState = new AuctionState();
        this.targetAuctionState = new AuctionState();
        this.auctionTeleportCount = 0;
    }

    public int getPlayerIndex() {
        return this.playerIndex;
    }

    public void setController(PlayerController playerController) {
        if (this.playerController != null) {
            this.playerController.uninstall();
        }
        this.playerController = playerController;
    }

    public PlayerController getController() {
        return this.playerController;
    }

    public void setRace(Race race) {
        this.avatar.setRace(race);
    }

    public int getMoney() {
        return this.money;
    }

    public void setMoney(int n) {
        if (n < 0) {
            logger.info(this.toString() + " gets money $" + n + ", reassigning to $0 instead");
            this.money = 0;
        } else {
            this.money = n;
        }
    }

    public Avatar getAvatar() {
        return this.avatar;
    }

    @Override
    public int compareTo(Player player) {
        if (this.playerIndex > player.playerIndex) {
            return 1;
        }
        if (this.playerIndex < player.playerIndex) {
            return -1;
        }
        return 0;
    }

    public String toString() {
        return "(P" + this.getUserNumber() + ")" + this.getName();
    }

    public void useFood(int n) {
        int n2 = Properties.mule.foodRequirements[n];
        if (Properties.mule.enableHiring && this.avatar.getRace().equals("mechtron")) {
            n2 = 0;
        }
        logger.info(this.toString() + " has " + this.food + " food and needs " + n2 + " food");
        if (n2 > this.food) {
            this.foodUsage = this.food;
            float f = (float)this.foodUsage / (float)n2;
            float f2 = Properties.mule.maxDevelopmentTime;
            float f3 = Properties.mule.minDevelopmentTime;
            this.developmentTime = f * f2 + (1.0f - f) * f3;
        } else {
            this.foodUsage = n2;
            this.developmentTime = Properties.mule.maxDevelopmentTime;
        }
        this.food -= this.foodUsage;
    }

    public void useEnergy(Random random) {
        this.energyUsage = 0;
        ArrayList<PlanetTile> arrayList = new ArrayList<PlanetTile>(this.ownedTiles.size());
        arrayList.addAll(this.ownedTiles);
        Collections.shuffle(arrayList, random);
        for (PlanetTile planetTile : arrayList) {
            for (Building building : planetTile.getBuildings()) {
                int n = Math.min(this.energy, building.getEnergyNeeded());
                building.setPower(n);
                this.energy -= n;
                this.energyUsage += n;
                if (!(building instanceof Factory)) continue;
                Factory factory = (Factory)building;
                factory.calcCapacity(random);
            }
        }
    }

    public float getDevelopmentTime() {
        return this.developmentTime;
    }

    public int getFood() {
        return this.food;
    }

    public void setFood(int n) {
        this.food = n;
    }

    public int getEnergy() {
        return this.energy;
    }

    public void setEnergy(int n) {
        this.energy = n;
    }

    public int getSmithore() {
        return this.smithore;
    }

    public void setSmithore(int n) {
        this.smithore = n;
    }

    public int getCrystite() {
        return this.crystite;
    }

    public void setCrystite(int n) {
        this.crystite = n;
    }

    public PlanetTile getHomeBase() {
        return this.homeBase;
    }

    public Collection<PlanetTile> getOwnedTiles() {
        return this.ownedTiles;
    }

    public boolean addOwnedTile(PlanetTile planetTile) {
        if (this.homeBase == null) {
            this.homeBase = planetTile;
        }
        return this.ownedTiles.add(planetTile);
    }

    public boolean removeOwnedTile(PlanetTile planetTile) {
        if (this.homeBase == planetTile) {
            this.homeBase = null;
        }
        return this.ownedTiles.remove(planetTile);
    }

    public int getEnergyRequirement() {
        return this.energyRequirement;
    }

    public void calcEnergyRequirement() {
        this.energyRequirement = 0;
        for (PlanetTile planetTile : this.ownedTiles) {
            for (Building building : planetTile.getBuildings()) {
                this.energyRequirement += building.getEnergyNeeded();
            }
        }
    }

    public LabItem getLabItem() {
        return this.labItem;
    }

    public void setLabItem(LabItem labItem) {
        this.labItem = labItem;
    }

    public void setBuyer(boolean bl, int n) {
        this.auctionBuyer = bl;
        int n2 = bl ? -n : n;
        this.auctionState.setState(false, n2);
        this.targetAuctionState.setState(false, n2);
        this.auctionState.setWalking(false);
        this.targetAuctionState.setWalking(false);
        this.avatar.setDirection(bl ? ActorSprite.Direction.North : ActorSprite.Direction.South);
    }

    public boolean isBuyer() {
        return this.auctionBuyer;
    }

    public AuctionState getAuctionState() {
        return this.auctionState;
    }

    public AuctionState getTargetAuctionState() {
        return this.targetAuctionState;
    }

    public int getResource(Resource resource) {
        switch (resource) {
            case Food: {
                return this.food;
            }
            case Energy: {
                return this.energy;
            }
            case Crystite: {
                return this.crystite;
            }
            case Smithore: {
                return this.smithore;
            }
        }
        throw new RuntimeException("Resource " + (Object)((Object)resource) + " doesn't exist.");
    }

    public int getUsage(Resource resource) {
        switch (resource) {
            case Food: {
                return this.foodUsage;
            }
            case Energy: {
                return this.energyUsage;
            }
            case Crystite: {
                return 0;
            }
            case Smithore: {
                return 0;
            }
        }
        throw new RuntimeException("Resource " + (Object)((Object)resource) + " doesn't exist.");
    }

    public int getProduction(Resource resource) {
        int n = 0;
        for (PlanetTile planetTile : this.ownedTiles) {
            Factory factory = planetTile.getFactory();
            if (factory == null || factory.getResource() != resource) continue;
            n += factory.getProduction();
        }
        return n;
    }

    public void setResource(Resource resource, int n) {
        switch (resource) {
            case Food: {
                this.setFood(n);
                return;
            }
            case Energy: {
                this.setEnergy(n);
                return;
            }
            case Crystite: {
                this.setCrystite(n);
                return;
            }
            case Smithore: {
                this.setSmithore(n);
                return;
            }
        }
        throw new RuntimeException("Resource " + (Object)((Object)resource) + " doesn't exist.");
    }

    public int calcSpoilage(Resource resource) {
        if (this.hasDepot()) {
            return 0;
        }
        switch (resource) {
            case Food: {
                return this.food / 2;
            }
            case Energy: {
                return this.energy / 4;
            }
            case Crystite: {
                return this.crystite > 50 ? this.crystite - 50 : 0;
            }
            case Smithore: {
                return this.smithore > 50 ? this.smithore - 50 : 0;
            }
        }
        throw new RuntimeException("Resource " + (Object)((Object)resource) + " doesn't exist.");
    }

    public boolean isOutfittingMule() {
        Mule mule = this.avatar.getMule();
        if (mule == null) {
            return false;
        }
        return mule.isOutfitting();
    }

    public boolean isAssaying() {
        AssayBot assayBot = this.avatar.getAssayBot();
        return assayBot != null && assayBot.isAssaying();
    }

    @Override
    public int getColorIndex() {
        return this.avatar.getColorIndex();
    }

    public void calcPoints(Shop shop) {
        this.landPoints = 0;
        this.goodsPoints = 0;
        for (PlanetTile planetTile : this.ownedTiles) {
            this.landPoints += Properties.mule.pointsPerLand;
            Factory factory = planetTile.getFactory();
            if (factory == null) continue;
            this.goodsPoints += Properties.mule.pointsPerMule;
            this.goodsPoints += factory.getResource().equipmentCost;
        }
        this.goodsPoints += this.food * shop.getPrice(Resource.Food);
        this.goodsPoints += this.energy * shop.getPrice(Resource.Energy);
        this.goodsPoints += this.smithore * shop.getPrice(Resource.Smithore);
        this.goodsPoints += this.crystite * shop.getPrice(Resource.Crystite);
        this.points = this.money + this.landPoints + this.goodsPoints;
    }

    public int getLandPoints() {
        return this.landPoints;
    }

    public int getGoodsPoints() {
        return this.goodsPoints;
    }

    public int getPoints() {
        return this.points;
    }

    public int getRank() {
        return this.rank;
    }

    public void setRank(int n) {
        this.rank = n;
    }

    public void setDepot(boolean bl) {
        this.depot = bl;
    }

    public boolean hasDepot() {
        return this.depot;
    }

    public int getResourceCritical(Resource resource, int n, int n2) {
        if (n == n2) {
            return 0;
        }
        if (resource == Resource.Energy) {
            return this.getEnergyRequirement() + 1;
        }
        if (resource == Resource.Food) {
            return Properties.mule.foodRequirements[n + 1];
        }
        return 0;
    }

    public int getResourceCritical(Resource resource, GameModel gameModel) {
        return this.getResourceCritical(resource, gameModel.getRound(), gameModel.getGameInfo().getLastRound());
    }

    public boolean isSellingLand() {
        return this.sellLand;
    }

    public void setSellLand(boolean bl) {
        this.sellLand = bl;
    }

    public boolean isMoveHomeBase() {
        return this.moveHomeBase;
    }

    public void setMoveHomeBase(boolean bl) {
        this.moveHomeBase = bl;
    }

    public boolean moveHomeBaseTo(PlanetTile planetTile) {
        if (planetTile == null) {
            return false;
        }
        if (planetTile.getOwner() != this) {
            return false;
        }
        this.homeBase = planetTile;
        this.moveHomeBase = false;
        return true;
    }

    public boolean hasGambled() {
        return this.gambled;
    }

    public boolean hasEnteredShop() {
        return this.enteredShop;
    }

    public void setGambled(boolean bl) {
        this.gambled = bl;
    }

    public void setEnteredShop(boolean bl) {
        this.enteredShop = bl;
    }

    public ActorSprite getAuctionSprite() {
        return this.avatar.getBigSprite();
    }

    public int calcProduction(Resource resource) {
        int n = 0;
        for (PlanetTile planetTile : this.getOwnedTiles()) {
            Factory factory = planetTile.getFactory();
            if (factory == null || factory.getResource() != resource) continue;
            n += factory.getProduction();
        }
        return n;
    }

    @Override
    public boolean isSpectator() {
        return false;
    }

    public short getAuctionTransactionCount() {
        return this.auctionTransactionCount;
    }

    public void setAuctionTransactionCount(short s) {
        this.auctionTransactionCount = s;
    }

    public byte getAuctionTeleportCount() {
        return this.auctionTeleportCount;
    }

    public void increaseAuctionTeleportCount() {
        this.auctionTeleportCount = (byte)(this.auctionTeleportCount + 1);
        logger.info(this.toString() + " auction teleport count: " + this.auctionTeleportCount);
    }

    public void resetAuctionTeleportCount() {
        this.auctionTeleportCount = 0;
    }

    public int hashCode() {
        return this.getUserNumber();
    }

    @Override
    public boolean isAiPlayer() {
        return this.aiPlayer;
    }

    public boolean equals(Object object) {
        if (object instanceof Player) {
            Player player = (Player)object;
            return this.getUserNumber() == player.getUserNumber();
        }
        return false;
    }

    void setAiPlayer(boolean bl) {
        this.aiPlayer = true;
    }

    public void setFinishedAuction(boolean bl) {
        this.finishedAuction = bl;
    }

    public boolean isFinishedAuction() {
        return this.finishedAuction;
    }

    public int getAuctionSpeed() {
        return this.auctionSpeed;
    }

    public void setAuctionSpeed(int n) {
        this.auctionSpeed = n;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class OrderByPoints
    implements Comparator<Player> {
        @Override
        public int compare(Player player, Player player2) {
            if (player.points > player2.points) {
                return -1;
            }
            if (player.points < player2.points) {
                return 1;
            }
            if (player.playerIndex < player2.playerIndex) {
                return -1;
            }
            if (player.playerIndex > player2.playerIndex) {
                return 1;
            }
            return 0;
        }
    }
}

