/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.model;

import com.turborilla.mule.model.Actor;
import com.turborilla.mule.model.LabItem;
import com.turborilla.mule.model.Mule;
import com.turborilla.mule.model.Resource;
import com.turborilla.mule.view.ActorSprite;

public class MuleEquipment
extends Actor {
    private static final long serialVersionUID = 1738432623700556908L;
    private final Resource resource;
    private final Mule mule;
    private LabItem labItem;

    public MuleEquipment(Mule mule, int n, Resource resource) {
        this(mule, n, resource, LabItem.NONE);
    }

    public MuleEquipment(Mule mule, int n, Resource resource, LabItem labItem) {
        this.resource = resource;
        this.labItem = labItem;
        this.mule = mule;
        String string = "smithore";
        if (resource != null) {
            switch (resource) {
                case Food: {
                    string = "food";
                    break;
                }
                case Smithore: {
                    string = "smithore";
                    break;
                }
                case Energy: {
                    string = "energy";
                    break;
                }
                case Crystite: {
                    string = "crystite";
                }
            }
        }
        this.setBigSprite(ActorSprite.createMuleEquipment(string, n, true));
        this.setSmallSprite(ActorSprite.createMuleEquipment(string, n, false));
        this.getBigSprite().setAutoUpdate(false);
        this.getSmallSprite().setAutoUpdate(false);
    }

    public void update() {
        this.position.set(this.mule.getPosition());
        this.setDirection(this.mule.getDirection());
        if (this.mule.isIdle()) {
            this.getSprite().setIdle(true);
        } else {
            this.getSprite().setIdle(false);
        }
        this.getSprite().setFrame(this.mule.getSprite().getFrame());
    }

    public boolean isInShop() {
        return this.mule.isInShop();
    }

    public Resource getResource() {
        return this.resource;
    }

    public LabItem getLabItem() {
        return this.labItem;
    }

    public void setLabItem(LabItem labItem) {
        this.labItem = labItem;
    }

    public int getPrice() {
        return this.resource.equipmentCost;
    }
}

