/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.model;

import com.turborilla.mule.model.Player;
import com.turborilla.mule.model.map.PlanetMap;
import com.turborilla.mule.model.map.PlanetTile;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LandGrant
implements Serializable {
    private static final long serialVersionUID = 1L;
    private ArrayList<PlanetTile> freeTiles = new ArrayList(45);
    private int currentTile;
    private boolean finished;

    public void begin(PlanetMap planetMap) {
        this.freeTiles.clear();
        this.currentTile = -1;
        this.finished = false;
        for (int i = 0; i < planetMap.getYSize(); ++i) {
            for (int j = 0; j < planetMap.getXSize(); ++j) {
                PlanetTile planetTile = (PlanetTile)planetMap.getTile(j, i);
                if (planetTile.getType() == PlanetTile.PlanetTileType.Shop || planetTile.getOwner() != null) continue;
                this.freeTiles.add(planetTile);
            }
        }
    }

    public boolean checkFinished(Collection<Player> collection) {
        boolean bl = true;
        for (Player player : collection) {
            if (player.hasClaimedLand) continue;
            bl = false;
        }
        if (bl) {
            this.finished = true;
        }
        return bl;
    }

    public PlanetTile getTile() {
        return this.getTile(this.currentTile);
    }

    public PlanetTile getNextTile() {
        return this.getTile(this.currentTile + 1);
    }

    public PlanetTile getTile(int n) {
        if (n < 0 || n >= this.freeTiles.size()) {
            return null;
        }
        return this.freeTiles.get(n);
    }

    public boolean hasNextTile() {
        if (this.finished) {
            return false;
        }
        return this.currentTile < this.freeTiles.size() - 1;
    }

    public void nextTile() {
        ++this.currentTile;
    }

    public boolean isStarted() {
        return this.currentTile >= 0;
    }

    public int getTileIndex() {
        return this.currentTile;
    }

    public int numFreeTiles() {
        return this.freeTiles.size();
    }

    public PlanetTile getFreeTile(int n) {
        return this.freeTiles.get(n);
    }
}

