/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.model;

import com.turborilla.mule.Properties;
import com.turborilla.mule.ai.AISystem;
import com.turborilla.mule.ai.AbstractAI;
import com.turborilla.mule.controller.WampusMenu;
import com.turborilla.mule.model.AssayBot;
import com.turborilla.mule.model.Auction;
import com.turborilla.mule.model.Avatar;
import com.turborilla.mule.model.ColonyEventGenerator;
import com.turborilla.mule.model.Development;
import com.turborilla.mule.model.GameInfo;
import com.turborilla.mule.model.GameModelObserver;
import com.turborilla.mule.model.HirelingManager;
import com.turborilla.mule.model.LabItem;
import com.turborilla.mule.model.LandGrant;
import com.turborilla.mule.model.LandRush;
import com.turborilla.mule.model.Mule;
import com.turborilla.mule.model.MuleEquipment;
import com.turborilla.mule.model.Phase;
import com.turborilla.mule.model.Player;
import com.turborilla.mule.model.PlayerEventGenerator;
import com.turborilla.mule.model.PlotSeller;
import com.turborilla.mule.model.Resource;
import com.turborilla.mule.model.Shop;
import com.turborilla.mule.model.Spectator;
import com.turborilla.mule.model.User;
import com.turborilla.mule.model.Wampus;
import com.turborilla.mule.model.map.Building;
import com.turborilla.mule.model.map.Depot;
import com.turborilla.mule.model.map.Factory;
import com.turborilla.mule.model.map.PlanetMap;
import com.turborilla.mule.model.map.PlanetMapGenerator;
import com.turborilla.mule.model.map.PlanetTile;
import com.turborilla.mule.model.util.NetworkTimer;
import com.turborilla.mule.model.util.NetworkTimerManager;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Random;
import java.util.Stack;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GameModel
implements Serializable {
    private static final long serialVersionUID = 4L;
    private static Logger logger = Logger.getLogger("mule");
    private transient User myUser;
    private transient Player myPlayer;
    private transient ArrayList<User> localUsers;
    private transient ArrayList<Player> localPlayers;
    private transient ArrayList<Player> remotePlayers;
    private transient AISystem aiSystem;
    private transient ArrayList<GameModelObserver> observers;
    private GameInfo gameInfo;
    private long gameStartTime;
    private boolean gameStarted;
    private boolean gameOver;
    private Random random;
    private PlanetMap map;
    private Stack<Integer> colorList;
    private Stack<Integer> playerIndexList;
    private ArrayList<User> users;
    private ArrayList<Player> players;
    private ArrayList<Player> playersInRankOrder;
    private ArrayList<Spectator> spectators;
    private ArrayList<Mule> mules;
    private Phase phase;
    private Phase nextPhase;
    private Shop shop;
    private int round;
    private ColonyEventGenerator colonyEventGenerator;
    private PlayerEventGenerator playerEventGenerator;
    private User serverUser;
    private Wampus wampus;
    private LandRush landRush;
    private LandGrant landGrant;
    private Development development;
    private Auction auction;
    private PlotSeller plotSeller;
    private HirelingManager hirelingManager;
    private NetworkTimerManager timerManager;
    private NetworkTimer countdown;
    private NetworkTimer phaseTimer;

    public GameModel(Phase phase, GameInfo gameInfo) {
        this.initialize();
        this.gameOver = false;
        this.gameStarted = false;
        this.gameStartTime = -1L;
        this.gameInfo = gameInfo;
        this.random = Properties.mule.debugRandomSeed ? new Random(Properties.mule.debugRandomSeedValue) : new Random(System.currentTimeMillis());
        this.map = new PlanetMap(9, 5);
        this.users = new ArrayList();
        this.players = new ArrayList();
        this.playersInRankOrder = new ArrayList();
        this.spectators = new ArrayList();
        this.mules = new ArrayList();
        this.phase = phase;
        this.nextPhase = null;
        this.serverUser = null;
        this.round = Properties.mule.firstRound;
        this.landRush = new LandRush(this.random);
        this.landGrant = new LandGrant();
        this.development = new Development(this);
        this.auction = new Auction();
        this.plotSeller = new PlotSeller(this.random);
        this.hirelingManager = new HirelingManager(this.random);
        this.timerManager = new NetworkTimerManager(1);
        this.countdown = this.timerManager.createTimer("countdown", 0, false);
        this.phaseTimer = this.timerManager.createTimer("phase timer", 0, true);
        this.colorList = new Stack();
        this.colorList.push(4);
        this.colorList.push(2);
        this.colorList.push(3);
        this.colorList.push(5);
        this.playerIndexList = new Stack();
        for (int i = 0; i < Properties.mule.maxNumPlayers; ++i) {
            this.playerIndexList.push(Properties.mule.maxNumPlayers - 1 - i);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.initialize();
        objectInputStream.defaultReadObject();
    }

    private void initialize() {
        this.myUser = null;
        this.myPlayer = null;
        this.localUsers = new ArrayList();
        this.localPlayers = new ArrayList();
        this.remotePlayers = new ArrayList();
        this.aiSystem = new AISystem();
    }

    public void initializeGame() {
        this.shop = new Shop();
        PlanetMapGenerator planetMapGenerator = new PlanetMapGenerator();
        planetMapGenerator.generate(this.map, this.random, this.gameInfo.isRiver(), this.gameInfo.isDeserts());
        this.colonyEventGenerator = new ColonyEventGenerator();
        this.colonyEventGenerator.generate(this);
        this.playerEventGenerator = new PlayerEventGenerator(this);
        this.aiSystem.buildPathFindingGraph(this.map, this.shop);
    }

    public boolean claimLand(Player player, float f, float f2) {
        PlanetTile planetTile = this.map.getTileAtPosition(f, f2);
        return this.claimLand(player, planetTile);
    }

    public boolean claimLand(Player player, PlanetTile planetTile) {
        if (player.hasClaimedLand) {
            return false;
        }
        if (planetTile != null && planetTile.getIdentifier() == "tile-shop") {
            return false;
        }
        if (planetTile.getOwner() == null) {
            planetTile.setOwner(this.map, player);
            player.hasClaimedLand = true;
            this.notifyObservers(GameModelObserver.Event.LAND_CLAIMED, planetTile);
            if (this.wampus != null) {
                this.wampus.landClaimed(planetTile);
            }
            for (AbstractAI abstractAI : this.aiSystem.getAIs()) {
                abstractAI.landClaimed(planetTile, this);
            }
            return true;
        }
        return false;
    }

    public boolean buyMule(Player player, boolean bl) {
        if (player.getAvatar().getMule() != null) {
            return false;
        }
        if (this.shop.numMules() == 0) {
            if (bl) {
                this.notifyObservers(GameModelObserver.Event.OUT_OF_STOCK, player);
            }
            return false;
        }
        if (player.getMoney() < this.shop.getMuleCost()) {
            if (bl) {
                this.notifyObservers(GameModelObserver.Event.TOO_EXPENSIVE, player);
            }
            return false;
        }
        player.setMoney(player.getMoney() - this.shop.getMuleCost());
        Mule mule = new Mule(player);
        this.mules.add(mule);
        player.getAvatar().setMule(mule);
        if (bl) {
            this.notifyObservers(GameModelObserver.Event.BUYING, player, -this.shop.getMuleCost());
        }
        this.shop.decreaseMules();
        for (AbstractAI abstractAI : this.aiSystem.getAIs()) {
            abstractAI.mulesChanged(player, this);
        }
        return true;
    }

    public boolean sellMule(Player player, boolean bl) {
        Mule mule = player.getAvatar().getMule();
        if (mule == null) {
            return false;
        }
        MuleEquipment muleEquipment = mule.getEquipment();
        int n = this.shop.getMuleCost();
        int n2 = muleEquipment == null ? 0 : muleEquipment.getPrice();
        int n3 = n + n2;
        player.setMoney(player.getMoney() + n3);
        this.removeMule(mule);
        logger.info(player.toString() + " sold a mule for $" + n3);
        if (bl) {
            this.notifyObservers(GameModelObserver.Event.BUYING, player, n3);
        }
        this.shop.increaseMules();
        for (AbstractAI abstractAI : this.aiSystem.getAIs()) {
            abstractAI.mulesChanged(player, this);
        }
        return true;
    }

    public boolean equipMule(Player player, Resource resource, boolean bl) {
        Mule mule = player.getAvatar().getMule();
        if (mule == null) {
            return false;
        }
        if (mule.isOutfitting()) {
            return false;
        }
        MuleEquipment muleEquipment = mule.getEquipment();
        int n = resource.equipmentCost;
        if (muleEquipment != null) {
            if (muleEquipment.getResource() == resource) {
                return false;
            }
            n -= muleEquipment.getPrice();
        }
        if (player.getMoney() < n) {
            if (bl) {
                this.notifyObservers(GameModelObserver.Event.TOO_EXPENSIVE, player);
            }
            return false;
        }
        player.setMoney(player.getMoney() - n);
        mule.outfit(new MuleEquipment(mule, player.getColorIndex(), resource));
        if (bl) {
            this.notifyObservers(GameModelObserver.Event.BUYING, player, -n);
        }
        return true;
    }

    public boolean allowDevelop(Player player, PlanetTile planetTile) {
        Mule mule = player.getAvatar().getMule();
        if (mule == null) {
            return true;
        }
        MuleEquipment muleEquipment = mule.getEquipment();
        if (muleEquipment == null) {
            return true;
        }
        return planetTile.getType().allow(muleEquipment.getResource());
    }

    public boolean developLand(Player player, PlanetTile planetTile) {
        if (planetTile == null || planetTile.getOwner() != player) {
            return false;
        }
        if (this.developLand(planetTile, player)) {
            if (planetTile.getFactory() != null) {
                logger.info(player + " develops tile " + planetTile + " with " + planetTile.getFactory());
            } else {
                logger.info(player + " undevelops tile " + planetTile);
            }
            return true;
        }
        return false;
    }

    private boolean developLand(PlanetTile planetTile, Player player) {
        Mule mule = player.getAvatar().getMule();
        LabItem labItem = player.getLabItem();
        if (planetTile.getBuildings().size() == 0) {
            if (mule == null) {
                return false;
            }
            if (mule.getEquipment() == null) {
                return false;
            }
            this.createBuilding(planetTile, mule, labItem);
        } else {
            Building building = planetTile.getBuildings().get(0);
            if (labItem == LabItem.MINING_TOWER) {
                Factory factory = planetTile.getFactoryWithResource(Resource.Smithore);
                if (factory == null) {
                    return false;
                }
                if (factory.getLabItem() == labItem) {
                    return false;
                }
                factory.setLabItem(labItem);
                player.setLabItem(LabItem.NONE);
            } else if (labItem == LabItem.WATER_TANK) {
                Factory factory = planetTile.getFactoryWithResource(Resource.Food);
                if (factory == null) {
                    return false;
                }
                if (factory.getLabItem() == labItem) {
                    return false;
                }
                factory.setLabItem(labItem);
                player.setLabItem(LabItem.NONE);
            } else if (labItem == LabItem.POWER_PLANT) {
                Factory factory = planetTile.getFactoryWithResource(Resource.Energy);
                if (factory == null) {
                    return false;
                }
                if (factory.getLabItem() == labItem) {
                    return false;
                }
                factory.setLabItem(labItem);
                player.setLabItem(LabItem.NONE);
            } else {
                if (mule != null && mule.getEquipment() == null) {
                    return false;
                }
                planetTile.removeBuilding(this.map, this.hirelingManager, 0);
                this.createBuilding(planetTile, mule, labItem);
                if (building instanceof Factory) {
                    Mule mule2 = new Mule(player, (Factory)building);
                    player.getAvatar().setMule(mule2);
                    this.mules.add(mule2);
                } else if (building instanceof Depot) {
                    player.setLabItem(LabItem.DEPOT);
                }
            }
        }
        return true;
    }

    private void createBuilding(PlanetTile planetTile, Mule mule, LabItem labItem) {
        Player player = planetTile.getOwner();
        if (mule != null) {
            Building building = mule.createBuilding(planetTile);
            planetTile.addBuilding(this.map, this.hirelingManager, building);
            this.removeMule(mule);
            this.showYieldPotential(planetTile);
        } else if (labItem == LabItem.DEPOT) {
            Depot depot = new Depot(planetTile);
            planetTile.addBuilding(this.map, this.hirelingManager, depot);
            player.setLabItem(LabItem.NONE);
        }
    }

    public boolean buyAssay(Player player, boolean bl) {
        Avatar avatar = player.getAvatar();
        if (avatar.getAssayBot() != null) {
            return false;
        }
        AssayBot assayBot = new AssayBot(avatar);
        avatar.setAssayBot(assayBot);
        logger.info(player.toString() + " got an assay bot");
        return true;
    }

    public boolean sellAssay(Player player, boolean bl) {
        Avatar avatar = player.getAvatar();
        AssayBot assayBot = avatar.getAssayBot();
        if (assayBot == null) {
            return false;
        }
        logger.info(player.toString() + " returned assay bot");
        avatar.setAssayBot(null);
        return true;
    }

    public boolean isAssayedBy(Player player, PlanetTile planetTile) {
        if (planetTile == null) {
            return false;
        }
        return planetTile.isAssayedBy(player);
    }

    public int assay(Player player, PlanetTile planetTile, boolean bl) {
        player.getAvatar().setAssayBot(null);
        planetTile.assay(player);
        this.showYieldPotential(planetTile);
        for (AbstractAI abstractAI : this.aiSystem.getAIs()) {
            abstractAI.assay(player, planetTile, this);
        }
        if (bl) {
            this.notifyObservers(GameModelObserver.Event.ASSAY, planetTile.getCrystite(), player);
        }
        return planetTile.getCrystite();
    }

    private void showYieldPotential(PlanetTile planetTile) {
        Factory factory = planetTile.getFactory();
        if (factory != null && planetTile.isAssayedBy(this.myPlayer)) {
            factory.setYieldVisible(true);
        }
    }

    public Resource dig(Player player, PlanetTile planetTile) {
        Resource resource = null;
        if (planetTile.getCrystite() == 0) {
            // empty if block
        }
        return resource;
    }

    public strictfp int gamble(Player player, float f, boolean bl) {
        if (f < 0.0f) {
            f = 0.0f;
        }
        float f2 = Properties.mule.maxDevelopmentTime;
        float f3 = Math.min(f / f2, 1.0f);
        int n = Properties.mule.pubRoundBonus[this.round];
        n += (int)(this.random.nextFloat() * f3 * (float)Properties.mule.pubMaxRandomAmount);
        if (Properties.mule.enableHiring && player.getAvatar().getRace().equals("flapper")) {
            logger.info(player.toString() + " gets flapper gambling bonus");
            n *= 2;
        }
        n = Math.min(n, 250);
        logger.info(player.toString() + " gambles $" + n + ", max: " + f2 + ", left: " + f + ", fraction " + f3);
        player.setMoney(player.getMoney() + n);
        player.setGambled(true);
        if (bl) {
            this.notifyObservers(GameModelObserver.Event.BUYING, player, n);
        }
        return n;
    }

    public boolean buyLabItem(Player player, LabItem labItem, boolean bl) {
        if (labItem == LabItem.NONE) {
            return false;
        }
        if (!labItem.isAvailableFor(player, this.round, this.players.size())) {
            return false;
        }
        player.setLabItem(labItem);
        player.setMoney(player.getMoney() - labItem.price);
        if (bl) {
            this.notifyObservers(GameModelObserver.Event.BUYING, player, -labItem.price);
        }
        return true;
    }

    public boolean sellLabItem(Player player, boolean bl) {
        LabItem labItem = player.getLabItem();
        if (labItem == LabItem.NONE) {
            return false;
        }
        player.setMoney(player.getMoney() + labItem.price);
        player.setLabItem(LabItem.NONE);
        if (bl) {
            this.notifyObservers(GameModelObserver.Event.BUYING, player, labItem.price);
        }
        return true;
    }

    public ColonyEventGenerator getColonyEventGenerator() {
        return this.colonyEventGenerator;
    }

    public Phase getPhase() {
        return this.phase;
    }

    public boolean allUsersReady() {
        for (User user : this.users) {
            if (!user.isAccepted() || user.isReady()) continue;
            return false;
        }
        return true;
    }

    public void forceUsersReady() {
        for (User user : this.users) {
            if (!user.isAccepted()) continue;
            user.setReady(true);
        }
    }

    private void clearUsersReady() {
        for (User user : this.users) {
            user.setReady(false);
        }
    }

    public Phase getNextPhase() {
        return this.nextPhase;
    }

    public void setCurrentPhase(Phase phase) {
        this.phase = phase;
    }

    public void setNextPhase(Phase phase) {
        this.nextPhase = phase;
    }

    public PlanetMap getMap() {
        return this.map;
    }

    public Shop getShop() {
        return this.shop;
    }

    public ArrayList<User> getUsers() {
        return this.users;
    }

    public Player getPlayer(int n) {
        for (int i = 0; i < this.players.size(); ++i) {
            Player player = this.players.get(i);
            if (player.getUserNumber() != n) continue;
            return player;
        }
        return null;
    }

    public ArrayList<Player> getPlayers() {
        return this.players;
    }

    public ArrayList<Player> getPlayersInRankOrder() {
        return this.playersInRankOrder;
    }

    /*
     * Unable to fully structure code
     */
    public void updatePlayerRankOrder() {
        block5: {
            this.playersInRankOrder.clear();
            this.playersInRankOrder.addAll(this.players);
            for (Player var2_3 : this.players) {
                var2_3.calcPoints(this.shop);
            }
            if (!this.gameStarted) break block5;
            if (this.round != Properties.mule.firstRound) ** GOTO lbl-1000
            Properties.mule.getClass();
            if (Properties.mule.debugRandomStartRank) {
                Collections.shuffle(this.playersInRankOrder, this.random);
                var1_1 = "Random rank order: ";
                for (var2_4 = 0; var2_4 < this.playersInRankOrder.size(); ++var2_4) {
                    var3_5 = this.playersInRankOrder.get(var2_4);
                    var1_1 = (String)var1_1 + var3_5 + " ";
                }
                GameModel.logger.info((String)var1_1);
            } else lbl-1000:
            // 2 sources

            {
                Collections.sort(this.playersInRankOrder, new Player.OrderByPoints());
            }
        }
        for (var1_2 = 0; var1_2 < this.playersInRankOrder.size(); ++var1_2) {
            this.playersInRankOrder.get(var1_2).setRank(var1_2 + 1);
        }
        this.notifyObservers(GameModelObserver.Event.PLAYERS_RANK_ORDER_UPDATED, new Object[]{this.playersInRankOrder});
    }

    public Player getMyPlayer() {
        return this.myPlayer;
    }

    public ArrayList<User> getLocalUsers() {
        return this.localUsers;
    }

    public ArrayList<Player> getLocalPlayers() {
        return this.localPlayers;
    }

    public ArrayList<Player> getRemotePlayers() {
        return this.remotePlayers;
    }

    public ArrayList<Mule> getMules() {
        return this.mules;
    }

    public void removeMule(Mule mule) {
        Player player;
        this.mules.remove(mule);
        if (!mule.isRunningAway() && (player = mule.getOwner()) != null) {
            player.getAvatar().setMule(null);
        }
    }

    public void removeAllMules() {
        this.mules.clear();
        for (Player player : this.players) {
            player.getAvatar().setMule(null);
        }
    }

    private void notifyObservers(GameModelObserver.Event event, Object ... objectArray) {
        if (this.observers == null) {
            return;
        }
        for (int i = 0; i < this.observers.size(); ++i) {
            GameModelObserver gameModelObserver = this.observers.get(i);
            gameModelObserver.notifyEvent(event, objectArray);
        }
    }

    public void addObserver(GameModelObserver gameModelObserver) {
        if (this.observers == null) {
            this.observers = new ArrayList();
        }
        if (this.observers.contains(gameModelObserver)) {
            logger.severe("Duplicate game model observer: " + gameModelObserver.toString());
        }
        this.observers.add(gameModelObserver);
    }

    public void removeObserver(GameModelObserver gameModelObserver) {
        if (this.observers != null) {
            this.observers.remove(gameModelObserver);
        }
    }

    public boolean canGoToNextPhase() {
        return this.nextPhase != null && this.allUsersReady();
    }

    public void goToNextPhase() {
        this.phase = this.nextPhase;
        this.nextPhase = null;
        this.clearUsersReady();
    }

    public void aiBeginPhase() {
        for (AbstractAI abstractAI : this.aiSystem.getAIs()) {
            abstractAI.beginPhase(this.phase, this);
        }
    }

    public void aiEndPhase() {
        for (AbstractAI abstractAI : this.aiSystem.getAIs()) {
            abstractAI.endPhase(this.phase, this);
        }
    }

    public Random getRandom() {
        return this.random;
    }

    public int getRound() {
        return this.round;
    }

    public void beginNextRound() {
        ++this.round;
        this.notifyObservers(GameModelObserver.Event.NEXT_ROUND, this.round);
    }

    public void setGameInfo(GameInfo gameInfo) {
        this.gameInfo = gameInfo;
        this.notifyObservers(GameModelObserver.Event.SET_GAME_INFO, gameInfo);
    }

    public GameInfo getGameInfo() {
        return this.gameInfo;
    }

    public boolean isResourceAvailable(Resource resource) {
        boolean bl = false;
        if (this.shop.getResource(resource) > 0) {
            bl = true;
        } else {
            for (Player player : this.getPlayers()) {
                if (player.getResource(resource) <= 0) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public int calcColonyTotal() {
        int n = 0;
        for (Player player : this.players) {
            n += player.getPoints();
        }
        return n;
    }

    public ArrayList<Spectator> getSpectators() {
        return this.spectators;
    }

    public Spectator getSpectator(int n) {
        for (Spectator spectator : this.spectators) {
            if (spectator.getUserNumber() != n) continue;
            return spectator;
        }
        return null;
    }

    public User getUser(int n) {
        for (User user : this.users) {
            if (user.getUserNumber() != n) continue;
            return user;
        }
        return null;
    }

    public User getUserById(long l) {
        for (User user : this.users) {
            if (user.getUserId() != l) continue;
            return user;
        }
        return null;
    }

    public void removeUser(int n) {
        Spectator spectator;
        Player player = this.getPlayer(n);
        if (player != null) {
            player.setController(null);
            this.users.remove(player);
            this.players.remove(player);
            this.playersInRankOrder.remove(player);
            this.localUsers.remove(player);
            this.localPlayers.remove(player);
            this.remotePlayers.remove(player);
            this.timerManager.removeLocalUserNumber(n);
            this.colorList.push(player.getColorIndex());
            this.playerIndexList.push(player.getPlayerIndex());
            Collections.sort(this.playerIndexList, new PlayerIndexComparator());
            this.notifyObservers(GameModelObserver.Event.USER_REMOVED, player);
        }
        if ((spectator = this.getSpectator(n)) != null) {
            this.users.remove(spectator);
            this.localUsers.remove(spectator);
            this.spectators.remove(spectator);
            this.notifyObservers(GameModelObserver.Event.USER_REMOVED, spectator);
        }
    }

    public User getMyUser() {
        return this.myUser;
    }

    public int getMyUserNumber() {
        if (this.myUser == null) {
            return 0;
        }
        return this.myUser.getUserNumber();
    }

    public void setServerUser(User user) {
        logger.info(user.toString() + " is hosting the server");
        this.serverUser = user;
        this.countdown.setOwner(user.getUserNumber());
        this.phaseTimer.setOwner(user.getUserNumber());
        this.notifyObservers(GameModelObserver.Event.SERVER_USER, user);
    }

    public void createWampus() {
        this.wampus = new Wampus(this.map, this.random, this.round);
    }

    public Wampus getWampus() {
        return this.wampus;
    }

    public void wampusCaught(Player player, WampusMenu wampusMenu) {
        if (player != null && this.wampus.setCaughtBy(player)) {
            for (AbstractAI abstractAI : this.aiSystem.getAIs()) {
                abstractAI.wampusCaught(player, this, wampusMenu);
            }
        }
    }

    public int wampusReward(Player player, int n) {
        if (this.wampus == null) {
            return 0;
        }
        if (!this.wampus.isCaughtBy(player)) {
            return 0;
        }
        if (n == 0) {
            player.setMoney(player.getMoney() + this.wampus.getMoneyReward());
            return this.wampus.getMoneyReward();
        }
        player.setSmithore(player.getSmithore() + this.wampus.getSmithoreReward());
        return this.wampus.getSmithoreReward();
    }

    public ArrayList<GameModelObserver> getObservers() {
        return this.observers;
    }

    public boolean allPlayersContinue() {
        for (Player player : this.players) {
            if (player.isContinue()) continue;
            return false;
        }
        return true;
    }

    public boolean allSpectatorsContinue() {
        for (Spectator spectator : this.spectators) {
            if (spectator.isContinue()) continue;
            return false;
        }
        return true;
    }

    public User getServerUser() {
        return this.serverUser;
    }

    public void startGame() {
        if (this.gameStartTime < 0L) {
            this.gameStartTime = System.currentTimeMillis();
        }
        this.gameStarted = true;
        this.updatePlayerRankOrder();
        this.notifyObservers(GameModelObserver.Event.GAME_STARTED, this.gameStartTime);
    }

    public void stopGame() {
        this.gameStarted = false;
    }

    public boolean isGameStarted() {
        return this.gameStarted;
    }

    public long getGameStartTime() {
        return this.gameStartTime;
    }

    public NetworkTimerManager getTimerManager() {
        return this.timerManager;
    }

    public NetworkTimer getCountdown() {
        return this.countdown;
    }

    public NetworkTimer getPhaseTimer() {
        return this.phaseTimer;
    }

    public HirelingManager getHirelingManager() {
        return this.hirelingManager;
    }

    public PlotSeller getPlotSeller() {
        return this.plotSeller;
    }

    public int peekNextPlayerIndex() {
        if (this.playerIndexList.isEmpty()) {
            return Player.NO_PLAYER_INDEX;
        }
        return this.playerIndexList.peek();
    }

    public Player createPlayer(User user) {
        if (this.getUser(user.getUserNumber()) != null) {
            logger.severe("Failed to create player. User " + this.getUser(user.getUserNumber()) + " already exists.");
            return null;
        }
        int n = this.colorList.pop();
        int n2 = this.playerIndexList.pop();
        Player player = new Player(user, n2, n);
        this.users.add(player);
        this.players.add(player);
        Collections.sort(this.players);
        this.notifyObservers(GameModelObserver.Event.USER_ADDED, player);
        return player;
    }

    public Spectator createSpectator(User user) {
        if (this.getUser(user.getUserNumber()) != null) {
            logger.severe("Failed to create spectator. User " + this.getUser(user.getUserNumber()) + " already exists.");
            return null;
        }
        Spectator spectator = new Spectator(user);
        this.users.add(spectator);
        this.spectators.add(spectator);
        this.notifyObservers(GameModelObserver.Event.USER_ADDED, spectator);
        return spectator;
    }

    public void setMyUser(User user) {
        logger.info(user.toString() + " is my user");
        this.myUser = user;
        this.myPlayer = user instanceof Player ? (Player)user : ((Spectator)user).getDummyPlayer();
        this.notifyObservers(GameModelObserver.Event.MY_USER, this.myUser);
        this.setLocalUser(user);
    }

    public void setAiPlayer(Player player, boolean bl) {
        player.setAiPlayer(true);
        if (bl) {
            this.setLocalUser(player);
        }
        this.notifyObservers(GameModelObserver.Event.SET_AI_PLAYER, player);
    }

    private void setLocalUser(User user) {
        logger.info(user.toString() + " is a local " + user.getClass().getSimpleName());
        if (user instanceof Player) {
            Player player = (Player)user;
            this.auction.removeRemotePlayer(player);
            this.remotePlayers.remove(player);
            this.localPlayers.add(player);
        }
        this.localUsers.add(user);
        this.timerManager.addLocalUserNumber(user.getUserNumber());
    }

    public void setRemoteUser(User user) {
        logger.info(user.toString() + " is a remote " + user.getClass().getSimpleName());
        if (user instanceof Spectator) {
            this.localUsers.remove(user);
        }
        if (user instanceof Player) {
            this.localPlayers.remove(user);
            this.remotePlayers.add((Player)user);
        }
        this.timerManager.removeLocalUserNumber(user.getUserNumber());
    }

    public strictfp Player nextPlayerForEvent() {
        if (this.round > this.gameInfo.getLastRound() - 2) {
            return this.playersInRankOrder.get(this.playersInRankOrder.size() - 1);
        }
        if (this.random.nextFloat() < 0.5f) {
            return this.playersInRankOrder.get(0);
        }
        return this.playersInRankOrder.get(this.playersInRankOrder.size() - 1);
    }

    public void setSellLand(Player player, boolean bl) {
        player.setSellLand(!player.isSellingLand());
        if (bl) {
            this.notifyObservers(GameModelObserver.Event.SELL, player, player.isSellingLand());
        }
    }

    public Auction getAuction() {
        return this.auction;
    }

    public AISystem getAiSystem() {
        return this.aiSystem;
    }

    public LandRush getLandRush() {
        return this.landRush;
    }

    public Development getDevelopment() {
        return this.development;
    }

    public boolean isGameOver() {
        return this.gameOver;
    }

    public void setGameOver() {
        this.gameOver = true;
    }

    public LandGrant getLandGrant() {
        return this.landGrant;
    }

    public void notifyUserReady(User user) {
        this.notifyObservers(GameModelObserver.Event.USER_READY, user, user.isContinue());
    }

    public void showFactoryYield() {
        for (int i = 0; i < this.map.getXSize(); ++i) {
            for (int j = 0; j < this.map.getYSize(); ++j) {
                PlanetTile planetTile = (PlanetTile)this.map.getTile(i, j);
                Factory factory = planetTile.getFactory();
                if (factory == null) continue;
                factory.setYieldVisible(true);
            }
        }
    }

    public boolean isLastRound() {
        return this.getRound() == this.getGameInfo().getLastRound();
    }

    public void userStatistics(User user) {
        this.notifyObservers(GameModelObserver.Event.USER_STATISTICS, user);
    }

    public PlayerEventGenerator getPlayerEventGenerator() {
        return this.playerEventGenerator;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PlayerIndexComparator
    implements Comparator<Integer> {
        private PlayerIndexComparator() {
        }

        @Override
        public int compare(Integer n, Integer n2) {
            if (n < n2) {
                return 1;
            }
            if (n > n2) {
                return -1;
            }
            return 0;
        }
    }
}

