/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.model;

import com.turborilla.mule.Settings;
import com.turborilla.mule.model.GameMode;
import java.io.Serializable;

public class GameInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int NO_GAME_ID = 0;
    public static final int COORDINATE_X_SIZE = 100;
    public static final int COORDINATE_Y_SIZE = 100;
    private String serverAddress;
    private String codeName;
    private String gameName;
    private long gameID;
    private int coordinate;
    private GameMode mode;
    private boolean singleDevelopment;
    private boolean useRiver;
    private boolean useDeserts;
    private int numRounds;
    private boolean allowSpectators;
    private boolean fastAiDevelopment;
    private String mapSkinName;

    public GameInfo(String string, String string2) {
        this.serverAddress = string;
        this.gameName = string2;
        this.coordinate = 0;
        this.gameID = 0L;
    }

    public GameInfo(String string, String string2, String string3, GameMode gameMode, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4, String string4) {
        this.serverAddress = string;
        this.fastAiDevelopment = Settings.get().fastAiDevelopment;
        this.codeName = string2;
        this.gameName = string3;
        this.coordinate = 0;
        this.gameID = 0L;
        this.mode = gameMode;
        this.singleDevelopment = bl;
        this.useRiver = bl2;
        this.useDeserts = bl3;
        this.numRounds = n;
        this.allowSpectators = bl4;
        this.mapSkinName = string4;
    }

    public GameInfo() {
        this.serverAddress = null;
        this.gameName = null;
        this.gameID = 0L;
    }

    public String getServerAddress() {
        return this.serverAddress;
    }

    public String getGameName() {
        return this.gameName;
    }

    public boolean isFastAiDevelopment() {
        return this.fastAiDevelopment;
    }

    public void setGameName(String string) {
        this.gameName = string;
    }

    public void setServerAddress(String string) {
        this.serverAddress = string;
    }

    public long getGameID() {
        return this.gameID;
    }

    public void setGameID(long l) {
        this.gameID = l;
    }

    public GameMode getMode() {
        return this.mode;
    }

    public int getCoordX() {
        return this.coordinate % 100;
    }

    public int getCoordY() {
        return this.coordinate / 100;
    }

    public String getCoordinateString() {
        return GameInfo.coordinateToString(this.coordinate);
    }

    public boolean validCoordinate() {
        return GameInfo.validCoordinate(this.coordinate);
    }

    public static boolean validCoordinate(int n) {
        return n > 0;
    }

    public static String coordinateToString(int n) {
        if (GameInfo.validCoordinate(n)) {
            int n2 = n % 100;
            int n3 = n / 100;
            return "(" + (n2 < 10 ? "0" + n2 : Integer.valueOf(n2)) + "." + (n3 < 10 ? "0" + n3 : Integer.valueOf(n3)) + ")";
        }
        return "(?)";
    }

    public void setCoordinate(int n) {
        this.coordinate = n;
    }

    public boolean isAllowSpectators() {
        return this.allowSpectators;
    }

    public String getMapSkin() {
        return this.mapSkinName;
    }

    public boolean isSingleDevelopment() {
        return this.singleDevelopment;
    }

    public boolean isDeserts() {
        return this.useDeserts;
    }

    public boolean isRiver() {
        return this.useRiver;
    }

    public int getLastRound() {
        return this.numRounds;
    }

    public String getCodeName() {
        return this.codeName;
    }

    public void setFastAiDevelopment(boolean bl) {
        this.fastAiDevelopment = bl;
    }
}

