/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.model;

import com.turborilla.mule.model.Avatar;
import com.turborilla.mule.model.Collidable;
import com.turborilla.mule.model.CollisionDetector;

public abstract class CollisionResolver {

    public static class AvatarWallCollision
    implements CollisionDetector.CollisionCallback {
        public void collision(Collidable collidable, Collidable collidable2, CollisionDetector.CollisionResult collisionResult) {
            collisionResult.overlap.scale(2.0f);
            collidable.position.add(collisionResult.overlap);
        }
    }

    public static class RemoteAvatarCollision
    implements CollisionDetector.CollisionCallback {
        public void collision(Collidable collidable, Collidable collidable2, CollisionDetector.CollisionResult collisionResult) {
            Avatar avatar = (Avatar)collidable;
            if (!avatar.isIdle()) {
                collisionResult.overlap.scale(1.5f);
                collidable.position.add(collisionResult.overlap);
            }
        }
    }

    public static class LocalAvatarCollision
    implements CollisionDetector.CollisionCallback {
        public void collision(Collidable collidable, Collidable collidable2, CollisionDetector.CollisionResult collisionResult) {
            Avatar avatar = (Avatar)collidable;
            Avatar avatar2 = (Avatar)collidable2;
            if (!avatar.isIdle() && avatar2.isIdle()) {
                collisionResult.overlap.scale(1.5f);
                collidable.position.add(collisionResult.overlap);
            } else if (avatar.isIdle() && !avatar2.isIdle()) {
                collisionResult.overlap.scale(1.5f);
                collidable2.position.sub(collisionResult.overlap);
            } else {
                collisionResult.overlap.scale(0.75f);
                collidable.position.add(collisionResult.overlap);
                collidable2.position.sub(collisionResult.overlap);
            }
        }
    }
}

