/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.model;

import com.turborilla.mule.model.Collidable;
import com.turborilla.mule.model.Geometry;
import com.turborilla.mule.model.util.Vec2;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.logging.Logger;

public strictfp class CollisionDetector {
    private Logger logger = Logger.getLogger("mule");
    private CollisionSet setA;
    private CollisionSet setB;
    private CollisionCallback callback;

    public CollisionDetector(CollisionSet collisionSet, CollisionSet collisionSet2, CollisionCallback collisionCallback) {
        this.setA = collisionSet;
        this.setB = collisionSet2;
        this.callback = collisionCallback;
    }

    public void setCollisionSetA(CollisionSet collisionSet) {
        this.setA = collisionSet;
    }

    public void setCollisionSetB(CollisionSet collisionSet) {
        this.setB = collisionSet;
    }

    public void checkCollisions() {
        for (Collidable collidable : this.setA.collidables) {
            for (Collidable collidable2 : this.setB.collidables) {
                Object object;
                if (collidable == collidable2) continue;
                Geometry geometry = collidable.getGeometry();
                Geometry geometry2 = collidable2.getGeometry();
                if (geometry == null || geometry2 == null) continue;
                Vec2 vec2 = collidable.getPosition();
                Vec2 vec22 = collidable2.getPosition();
                boolean bl = false;
                if (geometry.getType().compareTo(geometry2.getType()) > 0) {
                    object = vec2;
                    vec2 = vec22;
                    vec22 = object;
                    Geometry geometry3 = geometry;
                    geometry = geometry2;
                    geometry2 = geometry3;
                    bl = true;
                }
                object = null;
                block0 : switch (geometry.getType()) {
                    case Circle: {
                        switch (geometry2.getType()) {
                            case Circle: {
                                object = this.checkCollision(vec2, (Geometry.Circle)geometry, vec22, (Geometry.Circle)geometry2);
                                break block0;
                            }
                            case Rectangle: {
                                object = this.checkCollision(vec2, (Geometry.Circle)geometry, vec22, (Geometry.Rectangle)geometry2);
                                break block0;
                            }
                        }
                        this.collisionNotSupported(geometry, geometry2);
                        break;
                    }
                    case Rectangle: {
                        switch (geometry2.getType()) {
                            default: 
                        }
                        this.collisionNotSupported(geometry, geometry2);
                        break;
                    }
                    default: {
                        this.collisionNotSupported(geometry, geometry2);
                    }
                }
                if (object == null) continue;
                if (!bl) {
                    this.callback.collision(collidable, collidable2, (CollisionResult)object);
                    continue;
                }
                ((CollisionResult)object).overlap.scale(-1.0f);
                this.callback.collision(collidable2, collidable, (CollisionResult)object);
            }
        }
    }

    private CollisionResult checkCollision(Vec2 vec2, Geometry.Circle circle, Vec2 vec22, Geometry.Circle circle2) {
        float f = vec2.x - vec22.x;
        float f2 = vec2.y - vec22.y;
        float f3 = f * f + f2 * f2;
        float f4 = circle.getRadius() + circle2.getRadius();
        float f5 = f4 * f4;
        if (f3 < f5) {
            CollisionResult collisionResult = new CollisionResult();
            collisionResult.collisionPoint.set(0.5f * (vec2.x + vec22.x), 0.5f * (vec2.y + vec22.y));
            collisionResult.overlap.set(f, f2);
            collisionResult.overlap.normalise();
            collisionResult.overlap.scale(0.5f * (f4 - (float)Math.sqrt(f3)));
            return collisionResult;
        }
        return null;
    }

    private CollisionResult checkCollision(Vec2 vec2, Geometry.Circle circle, Vec2 vec22, Geometry.Rectangle rectangle) {
        float f;
        float f2 = vec2.x - vec22.x;
        float f3 = vec2.y - vec22.y;
        if (rectangle.isHollow()) {
            float f4 = rectangle.getHalfWidth() - circle.getRadius();
            float f5 = rectangle.getHalfHeight() - circle.getRadius();
            if (Math.abs(f2) < f4 && Math.abs(f3) < f5) {
                return null;
            }
            float f6 = Math.max(Math.abs(f2) - f4, 0.0f);
            float f7 = Math.max(Math.abs(f3) - f5, 0.0f);
            CollisionResult collisionResult = new CollisionResult();
            collisionResult.overlap.x = Math.signum(f2) * -0.5f * f6;
            collisionResult.overlap.y = Math.signum(f3) * -0.5f * f7;
            return collisionResult;
        }
        float f8 = circle.getRadius() + rectangle.getHalfWidth();
        float f9 = circle.getRadius() + rectangle.getHalfHeight();
        if (Math.abs(f2) > f8 || Math.abs(f3) > f9) {
            return null;
        }
        CollisionResult collisionResult = new CollisionResult();
        float f10 = f8 - Math.abs(f2);
        if (f10 < (f = f9 - Math.abs(f3))) {
            collisionResult.overlap.x = Math.signum(f2) * 0.5f * f10;
            collisionResult.overlap.y = 0.0f;
        } else {
            collisionResult.overlap.x = 0.0f;
            collisionResult.overlap.y = Math.signum(f3) * 0.5f * f;
        }
        return collisionResult;
    }

    private void collisionNotSupported(Geometry geometry, Geometry geometry2) {
        this.logger.severe("Collision not supported yet for " + (Object)((Object)geometry.getType()) + "-vs-" + (Object)((Object)geometry2.getType()));
    }

    public static interface CollisionCallback {
        public void collision(Collidable var1, Collidable var2, CollisionResult var3);
    }

    public strictfp static class CollisionResult {
        public Vec2 collisionPoint = new Vec2(0.0f, 0.0f);
        public Vec2 overlap = new Vec2(0.0f, 0.0f);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public strictfp static class CollisionSet
    implements Serializable {
        private static final long serialVersionUID = 4376044233135245323L;
        private ArrayList<Collidable> collidables = new ArrayList();

        public CollisionSet() {
            this.collidables = new ArrayList();
        }

        public CollisionSet(int n) {
            this.collidables = new ArrayList(n);
        }

        public void add(Collidable collidable) {
            this.collidables.add(collidable);
        }

        public void addAll(CollisionSet collisionSet) {
            for (Collidable collidable : collisionSet.collidables) {
                this.collidables.add(collidable);
            }
        }

        public void remove(Collidable collidable) {
            this.collidables.remove(collidable);
        }

        public void clear() {
            this.collidables.clear();
        }

        public ArrayList<Collidable> getCollidables() {
            return this.collidables;
        }

        public boolean contains(float f, float f2) {
            for (Collidable collidable : this.collidables) {
                if (!collidable.contains(f, f2)) continue;
                return true;
            }
            return false;
        }

        public boolean intersects(float f, float f2, Geometry geometry) {
            for (Collidable collidable : this.collidables) {
                if (!collidable.intersects(f, f2, geometry)) continue;
                return true;
            }
            return false;
        }

        public Collidable getFirstContainer(float f, float f2) {
            for (Collidable collidable : this.collidables) {
                if (!collidable.contains(f, f2)) continue;
                return collidable;
            }
            return null;
        }
    }
}

