/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.model;

import com.turborilla.mule.MuleException;
import com.turborilla.mule.Properties;
import com.turborilla.mule.model.Actor;
import com.turborilla.mule.model.AssayBot;
import com.turborilla.mule.model.CollisionDetector;
import com.turborilla.mule.model.Geometry;
import com.turborilla.mule.model.Mule;
import com.turborilla.mule.model.Race;
import com.turborilla.mule.model.util.Vec2;
import com.turborilla.mule.view.ActorSprite;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.logging.Logger;

public class Avatar
extends Actor {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger("mule");
    public static Geometry.Circle outOfShopGeometry = new Geometry.Circle(5.0f);
    public static Geometry.Circle inShopGeometry = new Geometry.Circle(8.0f);
    private Vec2 directionVector;
    private int colorIndex;
    private Race race;
    private boolean inShop;
    private Mule mule;
    private AssayBot assayBot;
    private final int MAX_NUM_POSITIONS = 20;
    private ArrayBlockingQueue<Position> positions;
    private Position currentPos;
    private Position nextPos;
    private float interpolationAccumulator = 0.0f;
    private float interpolationTime = 0.0f;
    private float interpolationMark = 0.0f;
    private long lastReceivedFrame = -1L;
    private boolean bufferingPositions = true;
    private int numPositionsToBuffer = 2;
    private WalkState walkState;
    private float distance;
    private int speed;
    private float landSpeed;
    private float landDiagonalSpeed;
    private float shopSpeed;
    private float shopDiagonalSpeed;
    private long sendPositionFrame;

    public Avatar(Race race, int n) {
        this(race, n, race.getSpeed());
    }

    public Avatar(Race race, int n, int n2) {
        this.position = new Vec2(50.0f, 50.0f);
        this.directionVector = new Vec2(0.0f, 0.0f);
        this.colorIndex = n;
        this.inShop = false;
        this.race = race;
        this.setGeometry(outOfShopGeometry);
        this.sendPositionFrame = 0L;
        this.positions = new ArrayBlockingQueue(20);
        this.setSpeed(n2);
        this.createSprites();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.createSprites();
    }

    private void createSprites() {
        ActorSprite actorSprite;
        ActorSprite actorSprite2;
        float f = Race.getSpeedFactor(this.speed);
        try {
            actorSprite2 = ActorSprite.createAvatar(this.race.getIdentifier(), this.colorIndex, f, false);
            actorSprite = ActorSprite.createAvatar(this.race.getIdentifier(), this.colorIndex, f, true);
        }
        catch (MuleException muleException) {
            logger.severe(muleException.getMessage());
            try {
                actorSprite2 = ActorSprite.createAvatar(Race.defaultRace.getIdentifier(), this.colorIndex, f, false);
                actorSprite = ActorSprite.createAvatar(Race.defaultRace.getIdentifier(), this.colorIndex, f, true);
            }
            catch (MuleException muleException2) {
                throw new RuntimeException(muleException2.getMessage());
            }
        }
        this.setSmallSprite(actorSprite2);
        this.setBigSprite(actorSprite);
    }

    public void setRace(Race race) {
        this.race = race;
        float f = Race.getSpeedFactor(race.getSpeed());
        this.getSmallSprite().setAvatarSpriteSheet(race.getIdentifier(), this.colorIndex, false, f);
        this.getBigSprite().setAvatarSpriteSheet(race.getIdentifier(), this.colorIndex, true, f);
        this.setSpeed(race.getSpeed());
    }

    private void setSpeed(int n) {
        this.speed = n;
        float f = Race.getSpeedFactor(n);
        this.landSpeed = f * Properties.mule.landMovingSpeed;
        this.landDiagonalSpeed = f * Properties.mule.landDiagonalMovingSpeed;
        this.shopSpeed = f * Properties.mule.shopMovingSpeed;
        this.shopDiagonalSpeed = f * Properties.mule.shopDiagonalMovingSpeed;
    }

    public strictfp void updateLocal(boolean bl, boolean bl2, boolean bl3, boolean bl4, CollisionDetector.CollisionSet collisionSet) {
        float f = this.getMovingSpeed();
        float f2 = 1.0f;
        if ((bl4 || bl3) && (bl || bl2)) {
            f2 = (float)(1.0 / Math.sqrt(2.0));
            f = this.getDiagonalMovingSpeed();
        }
        if (collisionSet != null && collisionSet.contains(this.position.x, this.position.y)) {
            f *= Properties.mule.obstacleMovingSpeedFactor;
        }
        this.directionVector.x = 0.0f;
        this.directionVector.y = 0.0f;
        if (bl && !bl2) {
            this.position.y -= f * Properties.mule.delta;
            this.directionVector.y -= f2;
            this.setDirection(ActorSprite.Direction.North);
        }
        if (bl2 && !bl) {
            this.position.y += f * Properties.mule.delta;
            this.directionVector.y += f2;
            this.setDirection(ActorSprite.Direction.South);
        }
        if (bl4 && !bl3) {
            this.position.x -= f * Properties.mule.delta;
            this.directionVector.x -= f2;
            this.setDirection(ActorSprite.Direction.West);
        }
        if (bl3 && !bl4) {
            this.position.x += f * Properties.mule.delta;
            this.directionVector.x += f2;
            this.setDirection(ActorSprite.Direction.East);
        }
        if (this.directionVector.x != 0.0f || this.directionVector.y != 0.0f) {
            this.startWalking();
        } else {
            this.stopWalking();
        }
        this.updateActor();
    }

    public void updateRemote(CollisionDetector.CollisionSet collisionSet) {
        this.updateInterpolate(collisionSet);
        this.updateActor();
    }

    public void updateActor() {
        this.getBlink().update();
        if (this.mule != null) {
            this.mule.update();
        }
        if (this.assayBot != null) {
            this.assayBot.update();
        }
    }

    private void updateInterpolate(CollisionDetector.CollisionSet collisionSet) {
        float f;
        if (this.bufferingPositions) {
            if (this.positions.size() < this.numPositionsToBuffer) {
                return;
            }
            if (this.position.distance(this.positions.peek()) < 0.01f) {
                this.positions.poll();
                return;
            }
            this.nextPos = new Position(0L, this.position.x, this.position.y, this.getDirection(), this.isInShop());
            this.interpolationTime = 0.0f;
            this.interpolationAccumulator = 0.0f;
            this.walkState = WalkState.Idle;
            this.bufferingPositions = false;
        }
        while (this.interpolationAccumulator >= this.interpolationTime) {
            this.currentPos = this.nextPos;
            this.nextPos = this.positions.poll();
            if (this.nextPos == null) {
                this.setPosition(this.currentPos.x, this.currentPos.y);
                this.clearPositions();
                return;
            }
            if (this.nextPos.inShop != this.inShop) {
                this.setPosition(this.nextPos.x, this.nextPos.y);
                this.setInShop(this.nextPos.inShop);
                continue;
            }
            this.interpolationAccumulator -= this.interpolationTime;
            this.distance = this.currentPos.distance(this.nextPos);
            f = this.getMovingSpeed();
            if (collisionSet != null && collisionSet.contains(this.currentPos.x, this.currentPos.y)) {
                f *= Properties.mule.obstacleMovingSpeedFactor;
            }
            this.interpolationTime = this.distance / f;
            if (this.interpolationTime < 1.0E-4f) {
                this.walkState = WalkState.Idle;
                this.interpolationTime = 0.0f;
            } else if (this.interpolationTime < 0.985f * Properties.mule.timeBetweenPositions) {
                switch (this.walkState) {
                    case Starting: {
                        this.walkState = WalkState.Ending;
                        break;
                    }
                    case Walking: {
                        this.walkState = WalkState.Ending;
                        break;
                    }
                    case Ending: {
                        this.walkState = WalkState.Starting;
                        break;
                    }
                    case Idle: {
                        this.walkState = WalkState.Starting;
                    }
                }
            } else {
                this.walkState = WalkState.Walking;
            }
            if (this.walkState == WalkState.Idle) {
                this.setDirection(this.nextPos.dir);
                continue;
            }
            if (this.walkState == WalkState.Starting) {
                this.interpolationMark = this.interpolationTime;
                this.interpolationTime = Properties.mule.timeBetweenPositions;
                continue;
            }
            this.setDirection(ActorSprite.Direction.get(this.nextPos.x - this.currentPos.x, this.nextPos.y - this.currentPos.y));
            this.startWalking();
        }
        f = 1.0f;
        switch (this.walkState) {
            case Walking: 
            case Ending: {
                f = this.interpolationAccumulator / this.interpolationTime;
                this.startWalking();
                break;
            }
            case Starting: {
                f = 1.0f + (this.interpolationAccumulator - this.interpolationTime) / this.interpolationMark;
                if (f < 0.0f) {
                    f = 0.0f;
                    break;
                }
                this.setDirection(ActorSprite.Direction.get(this.nextPos.x - this.currentPos.x, this.nextPos.y - this.currentPos.y));
                this.startWalking();
            }
        }
        if (f > 1.0f) {
            logger.severe("Remote avatar interpolation is more than 1.0");
            f = 1.0f;
            this.stopWalking();
        }
        this.setPosition((1.0f - f) * this.currentPos.x + f * this.nextPos.x, (1.0f - f) * this.currentPos.y + f * this.nextPos.y);
        this.interpolationAccumulator += Properties.mule.delta;
    }

    public boolean addPosition(Position position) {
        if (this.lastReceivedFrame > position.frame) {
            return false;
        }
        this.positions.add(position);
        this.lastReceivedFrame = position.frame;
        if (this.positions.size() == 20) {
            logger.warning("Filled avatar position buffer");
            this.positions.poll();
        }
        return true;
    }

    public int getNumPositions() {
        return this.positions.size();
    }

    public float getMovingSpeed() {
        if (this.inShop) {
            return this.shopSpeed;
        }
        return this.landSpeed;
    }

    public float getDiagonalMovingSpeed() {
        if (this.inShop) {
            return this.shopDiagonalSpeed;
        }
        return this.landDiagonalSpeed;
    }

    public Vec2 getDirectionVector() {
        return this.directionVector;
    }

    public void clearPositions() {
        this.stopWalking();
        this.currentPos = null;
        this.nextPos = null;
        this.positions.clear();
        this.bufferingPositions = true;
    }

    public void startWalking() {
        this.getSprite().setIdle(false);
    }

    public void stopWalking() {
        this.getSprite().setIdle(true);
        this.directionVector.set(0.0f, 0.0f);
    }

    public boolean isWalking() {
        return !this.getSprite().isIdle();
    }

    public boolean isInShop() {
        return this.inShop;
    }

    public void setInShop(boolean bl) {
        this.inShop = bl;
        if (bl) {
            this.setGeometry(inShopGeometry);
        } else {
            this.setGeometry(outOfShopGeometry);
        }
    }

    public Mule getMule() {
        return this.mule;
    }

    void setMule(Mule mule) {
        this.mule = mule;
    }

    public AssayBot getAssayBot() {
        return this.assayBot;
    }

    public void setAssayBot(AssayBot assayBot) {
        this.assayBot = assayBot;
    }

    public int getColorIndex() {
        return this.colorIndex;
    }

    public Race getRace() {
        return this.race;
    }

    public long getSendPositionFrame() {
        return this.sendPositionFrame;
    }

    public void setSendPositionFrame(long l) {
        this.sendPositionFrame = l;
    }

    public static class Position
    extends Vec2 {
        private static final long serialVersionUID = 6126051477486236930L;
        public long frame;
        public ActorSprite.Direction dir;
        public boolean inShop;

        public Position(long l, float f, float f2, ActorSprite.Direction direction, boolean bl) {
            super(f, f2);
            this.frame = l;
            this.dir = direction;
            this.inShop = bl;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum WalkState {
        Starting,
        Walking,
        Ending,
        Idle;

    }
}

