/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.model;

import com.turborilla.mule.model.AuctionState;
import com.turborilla.mule.model.Player;
import com.turborilla.mule.model.Resource;
import com.turborilla.mule.model.Shop;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AuctionLimits
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger("mule");
    public int auctionBuyTick;
    public int auctionSellTick;
    public int minTick;
    public int maxTick;
    private final int startPrice;
    private final int startMinTick;
    private final int startMaxTick;
    private TickSetup tickSetup;

    public AuctionLimits(int n, int n2, TickSetup tickSetup) {
        this.tickSetup = tickSetup;
        this.auctionBuyTick = Integer.MIN_VALUE;
        this.auctionSellTick = Integer.MAX_VALUE;
        this.startPrice = n;
        this.minTick = this.priceToMinTick(n);
        this.maxTick = this.priceToMaxTick(n2);
        this.startMinTick = this.minTick;
        this.startMaxTick = this.maxTick;
    }

    public int tickToPrice(int n) {
        return this.startPrice + n / this.tickSetup.scale * this.tickSetup.priceStep;
    }

    public int priceToMinTick(int n) {
        return (n - this.startPrice) / this.tickSetup.priceStep * this.tickSetup.scale;
    }

    public int priceToMaxTick(int n) {
        return (this.tickSetup.priceStep + n - this.startPrice) / this.tickSetup.priceStep * this.tickSetup.scale - 1;
    }

    public int getMaxPrice() {
        return this.tickToPrice(this.maxTick);
    }

    public int getMinPrice() {
        return this.tickToPrice(this.minTick);
    }

    public int getMaxTick() {
        return this.maxTick;
    }

    public int getStartMinTick() {
        return this.startMinTick;
    }

    public int getStartMaxTick() {
        return this.startMaxTick;
    }

    public void calcBuyAndSellTicks(Resource resource, Shop shop, ArrayList<Player> arrayList, ArrayList<Player> arrayList2, boolean bl, boolean bl2) {
        this.auctionBuyTick = Integer.MIN_VALUE;
        this.auctionSellTick = Integer.MAX_VALUE;
        for (Player object : arrayList) {
            AuctionState n5 = bl ? object.getTargetAuctionState() : object.getAuctionState();
            if (!n5.isInAuction() || n5.getTick() <= this.auctionBuyTick) continue;
            this.auctionBuyTick = n5.getTick();
        }
        int n = this.auctionBuyTick;
        for (Player player : arrayList2) {
            AuctionState auctionState = bl ? player.getTargetAuctionState() : player.getAuctionState();
            if (!auctionState.isInAuction()) continue;
            n = Math.max(n, auctionState.getTick());
            if (auctionState.getTick() >= this.auctionSellTick) continue;
            this.auctionSellTick = auctionState.getTick();
        }
        if (n > this.maxTick) {
            int n3 = n - this.maxTick;
            this.maxTick += n3;
            this.minTick += n3;
        }
        if (resource == null && bl2 && this.auctionBuyTick < this.minTick) {
            if (this.auctionBuyTick == Integer.MIN_VALUE) {
                this.maxTick = this.startMaxTick;
                this.minTick = this.startMinTick;
            } else {
                int n4 = this.minTick - this.auctionBuyTick;
                this.maxTick -= n4;
                this.minTick -= n4;
            }
        }
        if (resource != null) {
            int n2 = this.priceToMinTick(shop.getBuyPrice(resource));
            int n3 = this.priceToMaxTick(shop.getSellPrice(resource));
            if (n2 > this.auctionBuyTick && n2 >= this.minTick) {
                this.auctionBuyTick = n2;
            }
            if (n3 < this.auctionSellTick && shop.getResource(resource) > 0) {
                this.auctionSellTick = n3;
            }
        }
    }

    public void increaseMaxTick(int n) {
        if (n > this.maxTick) {
            int n2 = n - this.maxTick;
            this.maxTick += n2;
            this.minTick += n2;
        }
    }

    public int getMinTickInAuction(Resource resource) {
        return resource == null ? this.startMinTick : this.minTick;
    }

    public int getPixelRatio() {
        return this.tickSetup.pixelRatio;
    }

    public int getMaxOutOfAuctionTicks() {
        return this.tickSetup.maxOutOfAuction;
    }

    public int getPriceStep() {
        return this.tickSetup.priceStep;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PlayersByPriceBigFirst
    implements Comparator<Player> {
        @Override
        public int compare(Player player, Player player2) {
            AuctionState auctionState = player.getAuctionState();
            AuctionState auctionState2 = player2.getAuctionState();
            if (auctionState.isInAuction() && !auctionState2.isInAuction()) {
                return -1;
            }
            if (!auctionState.isInAuction() && auctionState2.isInAuction()) {
                return 1;
            }
            if (auctionState.getTick() > auctionState2.getTick()) {
                return -1;
            }
            if (auctionState.getTick() < auctionState2.getTick()) {
                return 1;
            }
            if (player.getRank() > player2.getRank()) {
                return -1;
            }
            if (player.getRank() < player2.getRank()) {
                return 1;
            }
            logger.severe("Players " + player.toString() + " " + player2.toString() + " have the same rank");
            if (player.getPlayerIndex() > player2.getPlayerIndex()) {
                return -1;
            }
            if (player.getPlayerIndex() < player2.getPlayerIndex()) {
                return 1;
            }
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PlayersByPriceSmallFirst
    implements Comparator<Player> {
        @Override
        public int compare(Player player, Player player2) {
            AuctionState auctionState = player.getAuctionState();
            AuctionState auctionState2 = player2.getAuctionState();
            if (auctionState.isInAuction() && !auctionState2.isInAuction()) {
                return -1;
            }
            if (!auctionState.isInAuction() && auctionState2.isInAuction()) {
                return 1;
            }
            if (auctionState.getTick() < auctionState2.getTick()) {
                return -1;
            }
            if (auctionState.getTick() > auctionState2.getTick()) {
                return 1;
            }
            if (player.getRank() > player2.getRank()) {
                return -1;
            }
            if (player.getRank() < player2.getRank()) {
                return 1;
            }
            logger.severe("Players " + player.toString() + " " + player2.toString() + " have the same rank");
            if (player.getPlayerIndex() > player2.getPlayerIndex()) {
                return -1;
            }
            if (player.getPlayerIndex() < player2.getPlayerIndex()) {
                return 1;
            }
            return 0;
        }
    }

    public static class TickSetup
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final int pixelRatio;
        public final int scale;
        public final int maxOutOfAuction;
        public final int priceStep;

        public TickSetup(int n, int n2, int n3, int n4) {
            this.pixelRatio = n;
            this.scale = n2;
            this.maxOutOfAuction = n3;
            this.priceStep = n4;
        }
    }
}

