/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.model;

import com.turborilla.mule.Properties;
import com.turborilla.mule.model.Avatar;
import com.turborilla.mule.model.FollowActor;
import com.turborilla.mule.model.map.PlanetTile;
import com.turborilla.mule.model.util.Timer;
import com.turborilla.mule.model.util.Vec2;
import com.turborilla.mule.view.ActorSprite;
import java.io.Serializable;

public strictfp class AssayBot
extends FollowActor {
    private static final long serialVersionUID = 1L;
    private Vec2 startPos;
    private Vec2 assayPos;
    private float travelTime;
    private float speed = 120.0f;
    private float spinTimer;
    private Timer assayTimer = new AssayTimer();
    private transient AssayListener assayListener;

    public AssayBot(Avatar avatar) {
        super(avatar, 22);
        this.createSprites();
        this.clearPositions();
        this.startPos = new Vec2();
        this.assayPos = new Vec2();
    }

    public void createSprites() {
        this.setSmallSprite(ActorSprite.createAssayBot(false));
        this.setBigSprite(ActorSprite.createAssayBot(true));
        this.setDirection(ActorSprite.Direction.South);
    }

    public void assay(PlanetTile planetTile, AssayListener assayListener) {
        this.startPos.set(this.position);
        this.assayPos.set(planetTile.getCenter());
        this.assayPos.x += 20.0f;
        this.assayPos.y -= 9.0f;
        ActorSprite.Direction direction = ActorSprite.Direction.get(this.assayPos.x - this.startPos.x, this.assayPos.x - this.startPos.x);
        this.travelTime = this.assayPos.distance(this.startPos) / this.speed;
        this.setDirection(direction);
        this.spinTimer = 0.0f;
        this.assayListener = assayListener;
        this.assayTimer.start(Properties.mule.assayTime);
    }

    public boolean isAssaying() {
        return this.assayTimer.isStarted() && !this.assayTimer.isFinished();
    }

    public void stopAssay() {
        this.assayTimer.reset();
        this.getColor().a = 1.0f;
    }

    public void update() {
        if (this.isAssaying()) {
            this.assayTimer.tick(Properties.mule.delta);
            float f = 1.0f;
            float f2 = this.assayTimer.getTime();
            float f3 = this.assayTimer.getTotal();
            if (f2 > f3 - this.travelTime) {
                f = (f3 - f2) / this.travelTime;
            } else {
                this.spinTimer -= Properties.mule.delta;
                if (this.spinTimer <= 0.0f) {
                    switch (this.getDirection()) {
                        case North: {
                            this.setDirection(ActorSprite.Direction.East);
                            break;
                        }
                        case South: {
                            this.setDirection(ActorSprite.Direction.West);
                            break;
                        }
                        case East: {
                            this.setDirection(ActorSprite.Direction.South);
                            break;
                        }
                        case West: {
                            this.setDirection(ActorSprite.Direction.North);
                        }
                    }
                    this.spinTimer += 0.05f;
                }
                if (f2 < 0.5f) {
                    this.getColor().a = f2 / 0.5f;
                }
            }
            this.position.x = this.assayPos.x * f + this.startPos.x * (1.0f - f);
            this.position.y = this.assayPos.y * f + this.startPos.y * (1.0f - f);
        } else {
            this.updateFollow();
        }
    }

    private strictfp class AssayTimer
    extends Timer
    implements Serializable {
        private static final long serialVersionUID = 1L;

        private AssayTimer() {
        }

        public void finished() {
            ActorSprite.Direction direction = ActorSprite.Direction.get(((AssayBot)AssayBot.this).startPos.x - ((AssayBot)AssayBot.this).assayPos.x, ((AssayBot)AssayBot.this).startPos.x - ((AssayBot)AssayBot.this).assayPos.x);
            AssayBot.this.setDirection(direction);
            if (AssayBot.this.assayListener != null) {
                AssayBot.this.assayListener.finished();
                AssayBot.this.assayListener = null;
            }
        }
    }

    public static interface AssayListener {
        public void finished();
    }
}

