/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.model;

import com.turborilla.mule.Properties;
import com.turborilla.mule.model.Collidable;
import com.turborilla.mule.view.ActorSprite;
import java.io.Serializable;
import org.newdawn.slick.Color;

public abstract class Actor
extends Collidable {
    private static final long serialVersionUID = 1971969353123470826L;
    public static final float SINGLE_BLINK_SPEED = 3.0f;
    public static final float REPEAT_BLINK_SPEED = 1.25f;
    public static final int COLOR_BLINK = 1;
    public static final int ALPHA_BLINK = 2;
    private transient ActorSprite smallSprite;
    private transient ActorSprite bigSprite;
    private Color color = new Color(Color.white);
    private Blink blink = new Blink(3.0f);
    private int blinkType = 1;

    public void setSmallSprite(ActorSprite actorSprite) {
        this.smallSprite = actorSprite;
    }

    public void setBigSprite(ActorSprite actorSprite) {
        this.bigSprite = actorSprite;
    }

    public abstract boolean isInShop();

    public ActorSprite.Direction getDirection() {
        return this.getSprite().getDirection();
    }

    public void setDirection(ActorSprite.Direction direction) {
        this.smallSprite.setDirection(direction);
        this.bigSprite.setDirection(direction);
    }

    public boolean isIdle() {
        return this.getSprite().isIdle();
    }

    public ActorSprite getSprite() {
        if (this.isInShop()) {
            return this.bigSprite;
        }
        return this.smallSprite;
    }

    public ActorSprite getBigSprite() {
        return this.bigSprite;
    }

    public ActorSprite getSmallSprite() {
        return this.smallSprite;
    }

    public Color getColor() {
        return this.color;
    }

    public Blink getBlink() {
        return this.blink;
    }

    public void setBlinkType(int n) {
        this.blinkType = n;
    }

    public int getBlinkType() {
        return this.blinkType;
    }

    public static class Blink
    implements Serializable {
        private static final long serialVersionUID = -511717346352119516L;
        private float speed;
        private float alpha;
        private int num;

        public Blink(float f) {
            this.speed = f;
            this.alpha = 0.0f;
        }

        public void blink() {
            this.alpha = 1.0f;
            this.num = 1;
        }

        public void blinkRepeat() {
            this.num = Integer.MAX_VALUE;
        }

        public void setSpeed(float f) {
            this.speed = f;
        }

        public void setAlpha(float f) {
            this.alpha = f;
        }

        public void update() {
            if (this.num > 0) {
                this.alpha -= this.speed * Properties.mule.delta;
                if (this.alpha <= 0.0f) {
                    if (this.num != Integer.MAX_VALUE) {
                        --this.num;
                    }
                    this.alpha = this.num == 0 ? 0.0f : (this.alpha += 1.0f);
                }
            }
        }

        public boolean isBlinking() {
            return this.num > 0;
        }

        public float getAlpha() {
            return this.alpha;
        }

        public void end() {
            if (this.num > 1) {
                this.num = 1;
            }
        }
    }
}

