/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.frame;

import com.turborilla.mule.model.GameInfo;
import com.turborilla.mule.model.GameModel;
import com.turborilla.mule.model.GameModelObserver;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class StatusBar
extends JPanel
implements GameModelObserver {
    private static final long serialVersionUID = 4771063275781224750L;
    private JLabel fps = new JLabel();
    private JLabel ping = new JLabel();
    private JLabel serverAddress = new JLabel();
    private JLabel game = new JLabel();
    private JLabel round = new JLabel();
    private JLabel time = new JLabel();
    private long startTime;
    private Timer timer;
    private int lastFps;
    private long lastFpsUpdate;
    private int lastPing;
    private long lastPingUpdate;
    private Dimension fpsDimension;
    private Dimension pingDimension;

    public StatusBar() {
        int n = this.fps.getFontMetrics(this.fps.getFont()).stringWidth("FPS: 99 ");
        this.fpsDimension = new Dimension(n, this.fps.getFont().getSize() + 1);
        int n2 = this.ping.getFontMetrics(this.ping.getFont()).stringWidth("Ping: 9999ms ");
        this.pingDimension = new Dimension(n2, this.ping.getFont().getSize() + 1);
        this.add(this.fps);
        this.add(new JSeparator(1));
        this.add(this.ping);
        this.add(new JSeparator(1));
        this.add(this.serverAddress);
        this.add(new JSeparator(1));
        this.add(this.game);
        this.add(new JSeparator(1));
        this.add(this.round);
        this.add(new JSeparator(1));
        this.add(this.time);
        this.setPreferredSize(new Dimension(0, this.getFont().getSize() + 10));
    }

    public void observe(GameModel gameModel) {
        this.notifyEvent(GameModelObserver.Event.SET_GAME_INFO, gameModel.getGameInfo());
        this.notifyEvent(GameModelObserver.Event.NEXT_ROUND, gameModel.getRound());
        if (gameModel.isGameStarted()) {
            this.notifyEvent(GameModelObserver.Event.GAME_STARTED, gameModel.getGameStartTime());
        }
        gameModel.addObserver(this);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                StatusBar.this.setVisible(true);
            }
        });
    }

    public void notifyEvent(GameModelObserver.Event event, Object ... objectArray) {
        if (event == GameModelObserver.Event.SET_GAME_INFO) {
            GameInfo gameInfo = (GameInfo)objectArray[0];
            final String string = gameInfo.getServerAddress();
            String string2 = gameInfo.getGameName();
            if (gameInfo.validCoordinate()) {
                string2 = string2 + " " + gameInfo.getCoordinateString();
            }
            final String string3 = string2;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    StatusBar.this.setFpsText("FPS:");
                    StatusBar.this.setPingText("Ping:");
                    StatusBar.this.serverAddress.setText("Server: " + string);
                    StatusBar.this.game.setText("Game: " + string3);
                    StatusBar.this.time.setText("Time: 00:00:00");
                    StatusBar.this.lastFps = 0;
                    StatusBar.this.lastFpsUpdate = 0L;
                    StatusBar.this.lastPing = -1;
                    StatusBar.this.lastPingUpdate = 0L;
                    StatusBar.this.fps.setVisible(true);
                    StatusBar.this.ping.setVisible(true);
                    StatusBar.this.serverAddress.setVisible(true);
                    StatusBar.this.game.setVisible(true);
                    StatusBar.this.round.setVisible(true);
                    StatusBar.this.time.setVisible(true);
                }
            });
        } else if (event == GameModelObserver.Event.NEXT_ROUND) {
            final int n = (Integer)objectArray[0];
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    StatusBar.this.round.setText("Round: " + n);
                }
            });
        } else if (event == GameModelObserver.Event.GAME_STARTED) {
            final long l = (Long)objectArray[0];
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    StatusBar.this.startTime = l;
                    StatusBar.this.timer = new Timer(1000, new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            int n = (int)(System.currentTimeMillis() - StatusBar.this.startTime);
                            int n2 = n / 3600000;
                            int n3 = n / 60000 % 60;
                            int n4 = n / 1000 % 60;
                            String string = "Time: ";
                            if (n2 < 10) {
                                string = string + "0";
                            }
                            string = string + n2 + ":";
                            if (n3 < 10) {
                                string = string + "0";
                            }
                            string = string + n3 + ":";
                            if (n4 < 10) {
                                string = string + "0";
                            }
                            string = string + n4;
                            StatusBar.this.time.setText(string);
                        }
                    });
                    StatusBar.this.timer.setInitialDelay(0);
                    StatusBar.this.timer.start();
                }
            });
        }
    }

    public void clear() {
        this.fps.setVisible(false);
        this.ping.setVisible(false);
        this.serverAddress.setVisible(false);
        this.game.setVisible(false);
        this.round.setVisible(false);
        this.time.setVisible(false);
        if (this.timer != null) {
            this.timer.stop();
        }
    }

    public void setFpsCounter(final int n) {
        if (this.lastFps == n) {
            return;
        }
        if (System.currentTimeMillis() - this.lastFpsUpdate < 200L) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                StatusBar.this.lastFps = n;
                StatusBar.this.lastFpsUpdate = System.currentTimeMillis();
                StatusBar.this.setFpsText("FPS: " + n);
            }
        });
    }

    public void setPing(final int n) {
        if (this.lastPing == n) {
            return;
        }
        if (System.currentTimeMillis() - this.lastPingUpdate < 200L) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                StatusBar.this.lastPing = n;
                StatusBar.this.lastPingUpdate = System.currentTimeMillis();
                StatusBar.this.setPingText("Ping: " + n + "ms");
            }
        });
    }

    private void setFpsText(String string) {
        this.fps.setText(string);
        this.fps.setPreferredSize(this.fpsDimension);
    }

    private void setPingText(String string) {
        this.ping.setText(string);
        this.ping.setPreferredSize(this.pingDimension);
    }
}

