/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.frame;

import com.turborilla.mule.view.ViewProperties;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.newdawn.slick.util.ResourceLoader;

public class Sprite {
    public BufferedImage image;
    public int x = 0;
    public int y = 0;
    public final int width;
    public final int height;
    public final int numFrames;
    public int duration = 100;
    public int frame = 0;
    private int frameTime = 0;
    private int[] frames;

    public Sprite(String string, int n, int n2) throws IOException {
        this.width = n;
        this.height = n2;
        this.image = ImageIO.read(ResourceLoader.getResource(string));
        this.numFrames = this.image.getWidth(null) / n;
    }

    public void update(int n) {
        this.frameTime += n;
        int n2 = this.frameTime / this.duration;
        this.frameTime %= this.duration;
        this.frame = (this.frame + n2) % this.frames.length;
    }

    public void swapColors(int n) {
        int[] nArray = ViewProperties.get().avatarSrcARGB;
        int[] nArray2 = ViewProperties.get().avatarDestARGB[n];
        for (int i = 0; i < this.image.getHeight(); ++i) {
            block1: for (int j = 0; j < this.image.getWidth(); ++j) {
                int n2 = this.image.getRGB(j, i);
                for (int k = 0; k < nArray.length; ++k) {
                    if (n2 != nArray[k]) continue;
                    this.image.setRGB(j, i, nArray2[k]);
                    continue block1;
                }
            }
        }
    }

    public void draw(Graphics graphics) {
        int n = this.frames[this.frame];
        graphics.drawImage(this.image, this.x, this.y, this.x + this.width, this.y + this.height, n * this.width, 0, (n + 1) * this.width, this.height, null);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setPos(int n, int n2) {
        this.x = n;
        this.y = n2;
    }

    public void setFrames(int[] nArray) {
        this.frames = nArray;
        this.frame = 0;
        this.frameTime = 0;
    }
}

