/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.frame;

import com.turborilla.mule.frame.GameTableModel;
import com.turborilla.mule.frame.GameTableRenderer;
import com.turborilla.mule.frame.UserTableModel;
import com.turborilla.mule.frame.UserTableRenderer;
import com.turborilla.mule.network.MasterResponse;
import com.turborilla.mule.sound.SoundPlayer;
import com.turborilla.mule.view.ViewProperties;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class MasterServerPane
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger("mule");
    private JSplitPane splitPane;
    private GameTableModel gameTableModel = new GameTableModel();
    private JTable gameTable = new JTable(this.gameTableModel);
    private JScrollPane gameTableScroll;
    private UserTableModel userTableModel;
    private JTable userTable;
    private JScrollPane userTableScroll;
    private ArrayList<Listener> listeners;

    public MasterServerPane() {
        int n;
        int n2;
        this.gameTable.setSelectionMode(0);
        this.gameTable.getTableHeader().setReorderingAllowed(false);
        this.gameTable.setDefaultRenderer(Object.class, new GameTableRenderer(this.gameTable));
        this.gameTableScroll = new JScrollPane(this.gameTable, 22, 31);
        for (n2 = 0; n2 < GameTableModel.columnWidths.length; ++n2) {
            n = GameTableModel.columnWidths[n2];
            this.gameTable.getColumnModel().getColumn(n2).setPreferredWidth(n);
        }
        this.userTableModel = new UserTableModel();
        this.userTable = new JTable(this.userTableModel);
        this.userTable.getTableHeader().setReorderingAllowed(false);
        this.userTable.getColumnModel().setColumnSelectionAllowed(false);
        this.userTable.setSelectionMode(0);
        this.userTable.setDefaultRenderer(Object.class, new UserTableRenderer());
        this.userTableScroll = new JScrollPane(this.userTable, 22, 31);
        for (n2 = 0; n2 < UserTableModel.columnWidths.length; ++n2) {
            n = UserTableModel.columnWidths[n2];
            this.userTable.getColumnModel().getColumn(n2).setPreferredWidth(n);
        }
        this.splitPane = new JSplitPane(1, this.gameTableScroll, this.userTableScroll);
        this.splitPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.splitPane.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                MasterServerPane.this.setDividerLocation();
            }
        });
        this.setLayout(new BorderLayout());
        this.add((Component)this.splitPane, "Center");
        this.setPreferredSize(new Dimension(ViewProperties.get().screenWidth, ViewProperties.get().screenHeight));
        this.gameTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                MasterServerPane.this.selectedGame();
            }
        });
        this.gameTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    for (Listener listener : MasterServerPane.this.listeners) {
                        listener.doubleClickedGame();
                    }
                }
            }
        });
        this.listeners = new ArrayList();
    }

    public MasterResponse.RefreshLobby.Game getSelectedGame() {
        int n = this.gameTable.getSelectedRow();
        return this.gameTableModel.getGame(n);
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    private void selectedGame() {
        MasterResponse.RefreshLobby.Game game = this.getSelectedGame();
        for (Listener listener : this.listeners) {
            listener.selectedGame(game);
        }
    }

    public void setUsers(MasterResponse.RefreshLobby.User[] userArray) {
        if (userArray == null) {
            logger.severe("Can't set users to null");
        } else {
            this.userTableModel.setUsers(userArray);
        }
    }

    public void setGames(MasterResponse.RefreshLobby.Game[] gameArray, long l) {
        int n = this.gameTable.getSelectedRow();
        MasterResponse.RefreshLobby.Game game = this.gameTableModel.getGame(n);
        for (MasterResponse.RefreshLobby.Game game2 : gameArray) {
            boolean bl = true;
            if (l == game2.getHostUserId()) continue;
            for (MasterResponse.RefreshLobby.Game game3 : this.gameTableModel.getGames()) {
                if (game2.getId() != game3.getId()) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            SoundPlayer.get().playNewGame();
            break;
        }
        this.gameTableModel.setGames(gameArray);
        this.userTableModel.setGames(gameArray);
        if (game != null) {
            n = this.gameTableModel.findGameRow(game.getId());
            this.gameTable.getSelectionModel().setSelectionInterval(n, n);
        }
    }

    public void setDividerLocation() {
        this.splitPane.setDividerLocation(this.splitPane.getSize().width - 140);
    }

    public static interface Listener {
        public void selectedGame(MasterResponse.RefreshLobby.Game var1);

        public void doubleClickedGame();
    }
}

