/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.frame;

import com.turborilla.mule.MuleException;
import com.turborilla.mule.Properties;
import com.turborilla.mule.Settings;
import com.turborilla.mule.frame.LoginAnimation;
import com.turborilla.mule.frame.SpringUtilities;
import com.turborilla.mule.model.UserInfo;
import com.turborilla.mule.network.MasterClient;
import com.turborilla.mule.network.MasterClientListener;
import com.turborilla.mule.network.MasterResponse;
import com.turborilla.mule.sound.SoundPlayer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import org.lwjgl.Sys;
import org.newdawn.slick.util.ResourceLoader;

public class Login {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger("mule");
    private static int MAX_NAME_LENGTH = 25;
    private JFrame frame;
    private JPanel loginPanel;
    private String realName;
    private JTextField username;
    private JPasswordField password;
    private JButton login;
    private JButton register;
    private JButton skipLogin;
    private JPanel settingsPanel;
    private JTextField masterServer;
    private boolean closed;
    private boolean active;
    private boolean skippedLogin;
    private long userId = 0L;
    private String race = "";
    private LoginAnimation animation;
    private MasterClient masterClient;
    private MasterListener masterClientListener;

    public void run() throws MuleException {
        this.animation.start();
        while (this.active) {
            this.masterClient.receiveResponses();
            SoundPlayer.get().update();
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException interruptedException) {
                throw new MuleException(interruptedException);
            }
        }
        this.masterClient.removeObserver(this.masterClientListener);
        if (this.skippedLogin) {
            this.masterClient.close();
        }
    }

    public UserInfo getUserInfo() {
        String string = this.username.getText();
        String string2 = this.realName == null ? string : this.realName;
        return new UserInfo(string2, string, new String(this.password.getPassword()), this.userId, this.race, false, false);
    }

    public Login(final MasterClient masterClient) throws MuleException {
        this.masterClient = masterClient;
        this.frame = new JFrame("Planet M.U.L.E. v.1.3.4");
        this.frame.setDefaultCloseOperation(1);
        ImageIcon imageIcon = new ImageIcon(ResourceLoader.getResource("frame/mule-icon.gif"));
        this.frame.setIconImage(imageIcon.getImage());
        this.masterClientListener = new MasterListener();
        masterClient.addObserver(this.masterClientListener);
        this.closed = false;
        this.active = true;
        this.skippedLogin = false;
        this.username = new JTextField(Settings.get().username, 18);
        this.password = new JPasswordField(18);
        this.login = new JButton("Login");
        this.register = new JButton("Register");
        this.skipLogin = new JButton("Play Local");
        this.login.setEnabled(false);
        this.animation = new LoginAnimation();
        Dimension dimension = new Dimension(100, 20);
        this.loginPanel = new JPanel();
        this.loginPanel.setBorder(BorderFactory.createTitledBorder("Login"));
        JPanel jPanel = new JPanel(new SpringLayout());
        JLabel jLabel = new JLabel("Username", 11);
        JLabel jLabel2 = new JLabel("Password", 11);
        this.username.setPreferredSize(dimension);
        this.password.setPreferredSize(dimension);
        jPanel.add(jLabel);
        jPanel.add(this.username);
        jPanel.add(jLabel2);
        jPanel.add(this.password);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(this.login);
        jPanel2.add(Box.createHorizontalStrut(10));
        jPanel2.add(this.register);
        jPanel2.add(Box.createHorizontalStrut(10));
        jPanel2.add(this.skipLogin);
        jPanel.add(Box.createHorizontalStrut(0));
        jPanel.add(jPanel2);
        SpringUtilities.makeCompactGrid(jPanel, 3, 2, 0, 0, 6, 6);
        this.loginPanel.add(jPanel);
        this.settingsPanel = new JPanel();
        this.settingsPanel.setBorder(BorderFactory.createTitledBorder("Settings"));
        JPanel jPanel3 = new JPanel(new SpringLayout());
        String string = Settings.get().masterServer;
        if (!string.startsWith("http")) {
            string = Properties.mule.masterServerUrl;
        }
        this.masterServer = new JTextField(string, 30);
        this.masterServer.setPreferredSize(dimension);
        JButton jButton = new JButton("Default");
        jPanel3.add(new JLabel("Master Server"));
        jPanel3.add(this.masterServer);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 0));
        jPanel4.add(jButton);
        jPanel4.add(Box.createHorizontalStrut(50));
        jPanel3.add(Box.createHorizontalStrut(0));
        jPanel3.add(jPanel4);
        SpringUtilities.makeCompactGrid(jPanel3, 2, 2, 0, 0, 6, 6);
        this.settingsPanel.add(jPanel3);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout());
        jPanel5.add((Component)this.loginPanel, "North");
        jPanel5.add((Component)this.settingsPanel, "Center");
        JPanel jPanel6 = new JPanel();
        jPanel6.add(this.animation);
        this.frame.setLayout(new BorderLayout());
        this.frame.add((Component)jPanel6, "North");
        this.frame.add((Component)jPanel5, "Center");
        this.frame.setResizable(false);
        this.login.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                masterClient.setServerAddress(Login.this.masterServer.getText());
                String string = new String(Login.this.password.getPassword());
                masterClient.sendLogin(Login.this.username.getText(), string, false);
                Login.this.setEnableLogin(false);
            }
        });
        this.register.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string;
                String string2 = "Do you want to open your web browser\nand create a new account?\n";
                int n = JOptionPane.showConfirmDialog(Login.this.frame, string2, "Register", 0);
                if (n == 0 && !Sys.openURL((string = Login.this.masterServer.getText() + "/forum") + "?action=register")) {
                    String string3 = "Failed to open web browser.\nPlease browse to " + string;
                    JOptionPane.showMessageDialog(Login.this.frame, string3, "Browser Failed", 2);
                }
            }
        });
        this.skipLogin.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = "If you don't login your game results will not be saved.\nDo you want to skip login?";
                int n = JOptionPane.showConfirmDialog(Login.this.frame, string, "Play Local", 0);
                if (n == 0) {
                    if (Login.this.username.getText().length() == 0) {
                        Login.this.username.setText("Unnamed");
                    }
                    Login.this.skippedLogin = true;
                    Login.this.finishLogin();
                }
            }
        });
        this.username.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent keyEvent) {
                if (Login.this.username.getText().length() >= MAX_NAME_LENGTH) {
                    keyEvent.consume();
                }
            }

            public void keyReleased(KeyEvent keyEvent) {
                Login.this.checkCanLogin();
                if (keyEvent.getKeyCode() == 10) {
                    Login.this.password.requestFocus();
                }
            }
        });
        this.password.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent keyEvent) {
                super.keyTyped(keyEvent);
                Login.this.checkCanLogin();
            }

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    Login.this.login.doClick();
                }
            }
        });
        this.masterServer.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                Login.this.checkCanLogin();
            }
        });
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Login.this.masterServer.setText(Properties.mule.masterServerUrl);
            }
        });
        this.frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                logger.info("Login window closing");
                Login.this.animation.stop();
                Login.this.closed = true;
                Login.this.active = false;
            }

            public void windowClosed(WindowEvent windowEvent) {
                logger.info("Login window closed");
            }
        });
        this.frame.pack();
        if (this.username.getText().length() > 0) {
            this.password.requestFocusInWindow();
        } else {
            this.username.requestFocusInWindow();
        }
        this.frame.setLocationRelativeTo(null);
        this.frame.setVisible(true);
    }

    private boolean checkCanLogin() {
        if (this.username.getText().length() > 0 && this.password.getPassword().length > 0 && this.masterServer.getText().length() > 0) {
            this.login.setEnabled(true);
            return true;
        }
        this.login.setEnabled(false);
        return false;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public String getPassword() {
        return new String(this.password.getPassword());
    }

    public void setUsername(String string) {
        this.username.setText(string);
    }

    public String getMasterServerAddress() {
        return this.masterServer.getText();
    }

    public long getUserId() {
        return this.userId;
    }

    private void setEnableLogin(boolean bl) {
        this.username.setEnabled(bl);
        this.password.setEnabled(bl);
        this.masterServer.setEnabled(bl);
        this.login.setEnabled(bl);
    }

    private void finishLogin() {
        WindowListener[] windowListenerArray;
        Settings.get().username = this.username.getText();
        Settings.get().masterServer = this.masterServer.getText();
        this.frame.getContentPane().removeAll();
        for (WindowListener windowListener : windowListenerArray = (WindowListener[])this.frame.getListeners(WindowListener.class)) {
            this.frame.removeWindowListener(windowListener);
        }
        this.active = false;
    }

    public void dispose() {
        logger.info("Disposing login");
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    Login.this.frame.setVisible(false);
                    Login.this.frame.dispose();
                }
            });
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, exception.toString(), exception);
        }
    }

    private class MasterListener
    extends MasterClientListener {
        private MasterListener() {
        }

        public void apply(final MasterResponse.Login login) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (login.isError()) {
                        String string = "Error while contacting the Master Server.\nPlease try again later.\n\n" + login.getError();
                        JOptionPane.showMessageDialog(Login.this.frame, string, "Login Failed", 0);
                        Login.this.setEnableLogin(true);
                    } else if (login.isMaintenance()) {
                        String string = login.getMaintenance();
                        logger.info(string);
                        JOptionPane.showMessageDialog(Login.this.frame, string, "Server Maintenance", 2);
                        Login.this.setEnableLogin(true);
                    } else if (login.isWrongVersion()) {
                        logger.info("New game version available. Current: 1.3.4. New: " + login.getVersion() + ".");
                        String string = "A new game version is available.\nYour current version is 1.3.4.\nThe new version is " + login.getVersion() + ".\n" + "You must restart the game to download the update.";
                        String string2 = "New Game Version";
                        JOptionPane.showConfirmDialog(Login.this.frame, string, string2, -1);
                        Login.this.setEnableLogin(true);
                    } else if (login.isRaceUnknown()) {
                        String string;
                        logger.info("You must select your species to login");
                        String string3 = "You must select your species to login.\nDo you want to open your web browser\nand select your species now?";
                        String string4 = "Unknown Species";
                        int n = JOptionPane.showConfirmDialog(Login.this.frame, string3, string4, 0);
                        if (n == 0 && !Sys.openURL(string = Login.this.masterServer.getText() + "/profile")) {
                            String string5 = "Failed to open web browser.\nPlease browse to " + string;
                            JOptionPane.showMessageDialog(Login.this.frame, string5, "Browser Failed", 2);
                        }
                        Login.this.setEnableLogin(true);
                    } else if (login.isWrongPassword()) {
                        Login.this.setEnableLogin(true);
                        logger.info("Wrong password");
                        String string = "Wrong password.\nPlease type a new password or username.";
                        JOptionPane.showMessageDialog(Login.this.frame, string, "Login Failed", 2);
                        Login.this.password.requestFocus();
                        Login.this.password.getCaret().moveDot(0);
                    } else if (login.isNoUsername()) {
                        String string;
                        logger.info("Unknown username");
                        String string6 = "That username doesn't exist.\nDo you want to open your web browser\nand create a new account?";
                        String string7 = "Unknown User";
                        int n = JOptionPane.showConfirmDialog(Login.this.frame, string6, string7, 0);
                        if (n == 0 && !Sys.openURL((string = Login.this.masterServer.getText() + "/wordpress/forum") + "?action=register")) {
                            String string8 = "Failed to open web browser.\nPlease browse to " + string;
                            JOptionPane.showMessageDialog(Login.this.frame, string8, "Browser Failed", 2);
                        }
                        Login.this.setEnableLogin(true);
                        Login.this.username.requestFocus();
                    } else {
                        Login.this.realName = login.getName();
                        Login.this.userId = login.getUserId();
                        Login.this.race = login.getRace();
                        logger.info("Logged in as \"" + Login.this.username.getText() + "\" (id " + Login.this.userId + ")");
                        Login.this.finishLogin();
                    }
                }
            });
        }
    }
}

