/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.frame;

import com.turborilla.mule.HTMLEncode;
import com.turborilla.mule.frame.Chat;
import com.turborilla.mule.frame.FrameUtil;
import com.turborilla.mule.frame.MetaFrame;
import com.turborilla.mule.model.UserInfo;
import com.turborilla.mule.network.MasterClient;
import com.turborilla.mule.network.MasterResponse;
import java.awt.Color;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.swing.JComponent;

public class LobbyChat
extends Chat {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger("mule");
    private MasterClient masterClient;
    private UserInfo userInfo;
    private long lastLobbyChatId;
    private HashMap<Long, String> lobbyUserNames = new HashMap();
    private final String myTextColor;

    public LobbyChat(MetaFrame metaFrame, MasterClient masterClient, UserInfo userInfo) {
        super(metaFrame);
        this.masterClient = masterClient;
        this.userInfo = userInfo;
        this.myTextColor = FrameUtil.toHexRGB(new Color(0, 0, 255));
        this.lastLobbyChatId = 0L;
        if (masterClient.isClosed()) {
            this.addSystemMessage("Connection to Master Server is closed");
            this.addSystemMessage("Chat is disabled");
            this.chatInput.setEnabled(false);
        } else {
            this.chatInput.setEnabled(true);
        }
    }

    public JComponent getSwingComponent() {
        return this.chatPanel;
    }

    public void addLobbyMessages(MasterResponse.RefreshLobby.Message[] messageArray) {
        if (messageArray != null) {
            long l = this.lastLobbyChatId;
            for (int i = 0; i < messageArray.length; ++i) {
                MasterResponse.RefreshLobby.Message message = messageArray[i];
                long l2 = message.getId();
                if (l2 <= this.lastLobbyChatId) continue;
                if (l2 > l) {
                    l = l2;
                }
                String string = message.getName();
                String string2 = message.getText();
                this.addMessage("<p><b>" + HTMLEncode.encode(string) + "</b>: " + HTMLEncode.encode(string2) + "</p>");
                logger.info("Lobby Chat (" + l2 + ") " + string + ": " + string2);
            }
            this.lastLobbyChatId = l;
        }
    }

    protected void chatInputKeyPressed(KeyEvent keyEvent) {
        String string;
        if (keyEvent.getKeyCode() == 10 && this.isValidChatText(string = this.chatInput.getText())) {
            logger.info("Lobby Chat Send: " + string);
            String string2 = HTMLEncode.encode(this.userInfo.getName());
            this.addMessage("<p><font color=\"#" + this.myTextColor + "\"><b>" + string2 + "</b>: " + HTMLEncode.encode(string) + "</font></p>");
            this.masterClient.sendChatMessage(string);
            this.chatInput.setText("");
        }
    }

    protected void chatCleared() {
        this.chatInput.setText("");
    }

    public void setLastLobbyMessageId(long l) {
        this.lastLobbyChatId = l;
    }

    public long getLastLobbyMessageId() {
        return this.lastLobbyChatId;
    }

    public void setUsers(MasterResponse.RefreshLobby.User[] userArray) {
        if (userArray != null) {
            for (MasterResponse.RefreshLobby.User user : userArray) {
                this.lobbyUserNames.put(user.getId(), user.getName());
            }
        }
    }

    protected void focusLost() {
    }

    protected void mouseClicked() {
    }
}

