/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.frame;

import com.turborilla.mule.network.MasterResponse;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;

public class GameTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = -2772411510750952383L;
    private static final String[] columnNames = new String[]{"Game", "Mode", "Status", "Host", "Reliability", "Round", "Players"};
    public static final int[] columnWidths = new int[]{140, 80, 55, 60, 80, 55, 110};
    private MasterResponse.RefreshLobby.Game[] games = new MasterResponse.RefreshLobby.Game[0];
    private int rowCount = 0;
    private static Comparator<MasterResponse.RefreshLobby.Game> gameComparator = new Comparator<MasterResponse.RefreshLobby.Game>(){

        @Override
        public int compare(MasterResponse.RefreshLobby.Game game, MasterResponse.RefreshLobby.Game game2) {
            long l;
            int n = game.getStatus().compareTo(game2.getStatus());
            if (n > 0) {
                return -1;
            }
            if (n < 0) {
                return 1;
            }
            long l2 = game.getId();
            if (l2 > (l = game2.getId())) {
                return -1;
            }
            if (l < l2) {
                return 1;
            }
            return 0;
        }
    };

    public String getColumnName(int n) {
        return columnNames[n];
    }

    public int getColumnCount() {
        return columnNames.length;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public Object getValueAt(int n, int n2) {
        if (this.games.length == 0) {
            return n2 == 0 ? "No games found" : "";
        }
        MasterResponse.RefreshLobby.Game game = this.games[n];
        switch (n2) {
            case 0: {
                return game.getNameAndCoordinate();
            }
            case 1: {
                return game.getMode();
            }
            case 2: {
                if (game.getStatus().equals("waiting")) {
                    return "Open";
                }
                return "Playing";
            }
            case 3: {
                return game.getHostName();
            }
            case 4: {
                return game.getReliability();
            }
            case 5: {
                return game.getRound() + " of " + game.getNumRounds();
            }
            case 6: {
                return game.getUsers();
            }
        }
        return "error";
    }

    public void setGames(MasterResponse.RefreshLobby.Game[] gameArray) {
        this.games = gameArray;
        if (gameArray == null || gameArray.length == 0) {
            this.rowCount = 1;
        } else {
            this.rowCount = gameArray.length;
            Arrays.sort(gameArray, gameComparator);
        }
        for (TableModelListener tableModelListener : this.getTableModelListeners()) {
            tableModelListener.tableChanged(new TableModelEvent(this));
        }
    }

    public MasterResponse.RefreshLobby.Game getGame(int n) {
        if (this.games == null) {
            return null;
        }
        if (n < 0 || n >= this.games.length) {
            return null;
        }
        return this.games[n];
    }

    public int findGameRow(long l) {
        if (this.games != null) {
            for (int i = 0; i < this.games.length; ++i) {
                if (this.games[i].getId() != l) continue;
                return i;
            }
        }
        return -1;
    }

    public boolean hasGames() {
        return this.games != null && this.games.length > 0;
    }

    public MasterResponse.RefreshLobby.Game[] getGames() {
        return this.games;
    }
}

