/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.frame;

import com.turborilla.mule.HTMLEncode;
import com.turborilla.mule.frame.Chat;
import com.turborilla.mule.frame.MetaFrame;
import com.turborilla.mule.frame.UserListModel;
import com.turborilla.mule.frame.UserListRenderer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.Timer;

public class GameChat
extends Chat {
    private static final long serialVersionUID = 1L;
    private final MetaFrame frame;
    private JSplitPane chatSplitPane;
    private UserListModel userListModel;
    private JList userList;
    private JPanel userListPanel;
    private JButton kick;
    private Timer blinkTimer;
    private Color blinkColor = Color.cyan;
    private boolean clearChatInputOnFocus;
    private static final String START_CHAT_STRING = "Press [Enter] or click here to chat";

    public GameChat(final MetaFrame metaFrame) {
        super(metaFrame);
        this.frame = metaFrame;
        this.userListModel = new UserListModel();
        this.userList = new JList(this.userListModel);
        this.userList.setCellRenderer(new UserListRenderer());
        this.userList.setFont(this.userList.getFont().deriveFont(1));
        this.userList.setFocusable(false);
        this.kick = new JButton("Kick");
        this.kick.setEnabled(false);
        this.kick.setFocusable(false);
        JScrollPane jScrollPane = new JScrollPane(this.userList, 20, 31);
        this.userListPanel = new JPanel();
        this.userListPanel.setLayout(new BorderLayout());
        this.userListPanel.add((Component)jScrollPane, "Center");
        this.userListPanel.add((Component)this.kick, "South");
        this.chatSplitPane = new JSplitPane(1, this.userListPanel, this.chatPanel);
        this.chatSplitPane.setDividerLocation(155);
        this.chatSplitPane.setPreferredSize(new Dimension(0, 150));
        this.blinkTimer = new Timer(100, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (GameChat.this.chatInput.isEnabled()) {
                    GameChat.this.chatInput.setBackground(Color.white);
                }
                GameChat.this.blinkTimer.stop();
            }
        });
        this.userList.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                metaFrame.focusDefaultComponent();
            }
        });
    }

    public JComponent getSwingComponent() {
        return this.chatSplitPane;
    }

    public JList getUserList() {
        return this.userList;
    }

    public UserListModel getUserListModel() {
        return this.userListModel;
    }

    public JButton getKickButton() {
        return this.kick;
    }

    protected void chatInputKeyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 10) {
            String string = this.chatInput.getText();
            if (this.isValidChatText(string)) {
                this.frame.sendChatMessage(string);
            }
            this.chatInput.setText("");
        } else if (n == 27) {
            this.frame.focusDefaultComponent();
        }
    }

    protected void addUserMessage(String string, int n) {
        UserListModel.UserItem userItem = this.userListModel.getUser(n);
        String string2 = "Unknown";
        int n2 = 0;
        if (userItem != null) {
            string2 = userItem.name;
            n2 = userItem.colorIndex;
        }
        this.addMessage("<p><font color=\"" + this.getColor(n2) + "\"><b>" + HTMLEncode.encode(string2) + ":</b></font> " + HTMLEncode.encode(string) + "</p>");
    }

    protected void focusLost() {
        String string = this.chatInput.getText();
        if (!this.isValidChatText(string)) {
            this.chatCleared();
        }
        this.chatInput.setEnabled(false);
        this.chatInput.setBackground(null);
    }

    private void blink() {
        this.chatInput.setBackground(this.blinkColor);
        this.blinkTimer.start();
    }

    protected void mouseClicked() {
        if (!this.chatInput.isEnabled()) {
            this.startChat();
        }
    }

    public void startChat() {
        if (this.clearChatInputOnFocus) {
            this.chatInput.setText("");
            this.clearChatInputOnFocus = false;
        }
        this.chatInput.setEnabled(true);
        this.chatInput.requestFocusInWindow();
        this.chatInput.grabFocus();
    }

    protected void chatCleared() {
        this.chatInput.setEnabled(false);
        this.chatInput.setText(START_CHAT_STRING);
        this.clearChatInputOnFocus = true;
    }
}

