/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.frame;

import com.turborilla.mule.frame.Sprite;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Random;

public abstract class Animation {
    public abstract void begin();

    public abstract void draw(Graphics var1);

    public abstract boolean isCompleted();

    public abstract void update(int var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChaseMule
    extends Animation {
        private int[] avatarWalkRight = new int[]{25, 26, 27, 28, 29, 30, 31, 32};
        private int[] muleWalkRight = new int[]{9, 10, 9, 11};
        private int[] muleIdleRight = new int[]{9, 13};
        private Random random = new Random(System.currentTimeMillis());
        private int blinkTime;
        private ArrayList<Sprite> avatars;
        private Sprite mule;

        public ChaseMule(ArrayList<Sprite> arrayList, Sprite sprite) {
            this.avatars = arrayList;
            this.mule = sprite;
        }

        @Override
        public void begin() {
            for (int i = 0; i < this.avatars.size(); ++i) {
                Sprite sprite = this.avatars.get(i);
                sprite.setFrames(this.avatarWalkRight);
                sprite.setPos(-33 - 30 * i, 130 + this.random.nextInt(20));
                sprite.duration = 40;
            }
            this.mule.setFrames(this.muleWalkRight);
            this.mule.setPos(-70, 110);
            this.mule.duration = 180;
            this.blinkTime = 1600;
        }

        @Override
        public void draw(Graphics graphics) {
            for (Sprite sprite : this.avatars) {
                sprite.draw(graphics);
            }
            this.mule.draw(graphics);
        }

        @Override
        public boolean isCompleted() {
            return this.avatars.get((int)(this.avatars.size() - 1)).x > 665;
        }

        @Override
        public void update(int n) {
            if (this.mule.x < 280) {
                ++this.mule.x;
                if (this.mule.x >= 280) {
                    this.mule.setFrames(this.muleIdleRight);
                    this.mule.duration = 400;
                }
            } else if (this.blinkTime > 0) {
                this.blinkTime -= n;
                if (this.blinkTime <= 0) {
                    this.mule.setFrames(this.muleWalkRight);
                    this.mule.duration = 90;
                }
            } else {
                this.mule.x += 2;
            }
            if (this.blinkTime < 150) {
                for (Sprite sprite : this.avatars) {
                    sprite.x += 3;
                    sprite.update(n);
                }
            }
            this.mule.update(n);
        }
    }

    public static class WalkingMule
    extends Animation {
        private int[] muleWalkRight = new int[]{9, 10, 9, 11};
        private Sprite mule;

        public WalkingMule(Sprite sprite) {
            this.mule = sprite;
        }

        public void begin() {
            this.mule.setFrames(this.muleWalkRight);
            this.mule.setPos(-70, 110);
            this.mule.duration = 180;
        }

        public void draw(Graphics graphics) {
            this.mule.draw(graphics);
        }

        public boolean isCompleted() {
            return this.mule.x > 680;
        }

        public void update(int n) {
            ++this.mule.x;
            this.mule.update(n);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Parade
    extends Animation {
        private int[] walkLeftFrames = new int[]{17, 18, 19, 20, 21, 22, 23, 24};
        private ArrayList<Sprite> avatars;

        public Parade(ArrayList<Sprite> arrayList) {
            this.avatars = arrayList;
        }

        @Override
        public void begin() {
            for (int i = 0; i < this.avatars.size(); ++i) {
                Sprite sprite = this.avatars.get(i);
                sprite.duration = 80;
                sprite.setFrames(this.walkLeftFrames);
                sprite.setPos(600 + 100 * i, 140);
            }
        }

        @Override
        public void draw(Graphics graphics) {
            for (Sprite sprite : this.avatars) {
                sprite.draw(graphics);
            }
        }

        @Override
        public boolean isCompleted() {
            return this.avatars.get((int)(this.avatars.size() - 1)).x < -70;
        }

        @Override
        public void update(int n) {
            for (Sprite sprite : this.avatars) {
                --sprite.x;
                sprite.update(n);
            }
        }
    }
}

