/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.controller.phase;

import com.turborilla.mule.Properties;
import com.turborilla.mule.Settings;
import com.turborilla.mule.controller.phase.PhaseController;
import com.turborilla.mule.model.Avatar;
import com.turborilla.mule.model.Phase;
import com.turborilla.mule.model.Player;
import com.turborilla.mule.model.PlayerEvent;
import com.turborilla.mule.model.User;
import com.turborilla.mule.model.util.NetworkTimer;
import com.turborilla.mule.model.util.Timer;
import com.turborilla.mule.model.util.Vec2;
import com.turborilla.mule.network.TCPMessage;
import com.turborilla.mule.sound.SoundPlayer;
import com.turborilla.mule.view.ActorSprite;
import com.turborilla.mule.view.BlinkerListener;
import com.turborilla.mule.view.GameInput;
import com.turborilla.mule.view.MessagePainter;
import com.turborilla.mule.view.Transition;
import java.util.logging.Logger;

public class PlayerEventPhase
extends PhaseController {
    private static Logger logger = Logger.getLogger("mule");
    private Player eventPlayer;
    private PlayerEvent event;
    private boolean finished = false;
    private Timer introTimer = new Timer(){

        public void finished() {
            if (PlayerEventPhase.this.event == null) {
                PlayerEventPhase.this.finished = true;
            } else {
                String string = PlayerEventPhase.this.model.getPlayerEventGenerator().apply(PlayerEventPhase.this.event, PlayerEventPhase.this.eventPlayer, PlayerEventPhase.this.model);
                logger.info("Event Message: " + string);
                String string2 = "* * * * " + PlayerEventPhase.this.eventPlayer.getName() + " - " + string + " * * * *";
                PlayerEventPhase.this.view.setScrollingTerminalMessage(string2, PlayerEventPhase.this.eventPlayer, new MessagePainter.ScrollingTerminalMessageListener(){

                    public void finished() {
                        PlayerEventPhase.this.finished = true;
                    }
                });
                PlayerEventPhase.this.blink();
                PlayerEventPhase.this.view.setTitle("Player Event #" + PlayerEventPhase.this.model.getRound());
                if (PlayerEventPhase.this.event.isGood()) {
                    SoundPlayer.get().playPlayerMessageGood();
                } else {
                    SoundPlayer.get().playPlayerMessageBad();
                }
            }
        }
    };
    BlinkerListener blinkerListener = new BlinkerListener(){

        public void blink(boolean bl) {
            if (PlayerEventPhase.this.finished && !bl) {
                PlayerEventPhase.this.view.getGlobalBlinker().removeListener(this);
                PlayerEventPhase.this.goToNextPhase();
            }
        }
    };

    public void begin() {
        this.controller.checkClientSynchronization();
        if (this.controller.isServer() && this.model.getGameInfo().isFastAiDevelopment() != Settings.get().fastAiDevelopment) {
            logger.info("Switching fast AI development");
            this.controller.getClient().sendTCP(new TCPMessage.GameSettingsMessage(Settings.get().fastAiDevelopment));
        }
        this.view.fadeTerminalMessage();
        this.introTimer.reset();
        this.finished = false;
        if (!this.model.getDevelopment().hasCurrentPlayer()) {
            this.model.getDevelopment().setPlayerOrder();
        }
        this.eventPlayer = this.model.getDevelopment().nextPlayer();
        this.event = this.model.getPlayerEventGenerator().nextEvent(this.eventPlayer, this.model);
        Avatar avatar = this.eventPlayer.getAvatar();
        avatar.getSmallSprite().setDirection(ActorSprite.Direction.South);
        if (this.event == null) {
            logger.info("No player event for " + this.eventPlayer + " (rank " + this.eventPlayer.getRank() + ")");
            this.blink();
            this.view.setTitle("Development #" + this.model.getRound());
            this.view.fadeTerminalMessage();
            SoundPlayer.get().playBeginPhase();
            this.introTimer.start(5.0f);
            this.eventPlayer.useFood(this.model.getRound());
        } else {
            logger.info("Event player: " + this.eventPlayer + " (rank " + this.eventPlayer.getRank() + ")");
            logger.info("Event: " + this.event.toString());
            this.introTimer.start(0.0f);
        }
    }

    private void blink() {
        this.view.getGlobalBlinker().addListener(this.blinkerListener);
        this.eventPlayer.setContinue(false);
        this.view.getGlobalBlinker().setVisible(true);
        this.view.getMapPainter().setBlinkingPlayer(this.eventPlayer);
    }

    public void draw() {
        this.view.getMapPainter().draw(this.model.getMap(), this.model.getPlayers(), this.model.getMyPlayer());
        if (!this.eventPlayer.isAiPlayer() || !this.model.getGameInfo().isFastAiDevelopment()) {
            Vec2 vec2 = this.model.getMap().getShopCenter();
            Avatar avatar = this.eventPlayer.getAvatar();
            this.view.getActorPainter().drawMini(avatar, vec2);
        }
        if (this.event == null) {
            this.view.drawTimer(this.eventPlayer.getDevelopmentTime());
        }
    }

    public Transition end() {
        if (this.event != null) {
            this.eventPlayer.useFood(this.model.getRound());
        }
        this.eventPlayer = null;
        this.event = null;
        return null;
    }

    public void timerFinished(NetworkTimer networkTimer) {
    }

    public void update(GameInput gameInput) {
        this.introTimer.tick(Properties.mule.delta);
    }

    private void goToNextPhase() {
        if (this.eventPlayer.isAiPlayer() && this.model.getGameInfo().isFastAiDevelopment()) {
            this.model.setNextPhase(Phase.FAST_DEVELOPMENT);
        } else {
            this.model.setNextPhase(Phase.DEVELOPMENT);
        }
        for (User user : this.model.getLocalUsers()) {
            user.send(this.controller.getClient(), new TCPMessage.ReadyMessage(this.controller.getFrame()));
        }
    }

    public void apply(TCPMessage.GameSettingsMessage gameSettingsMessage) {
        logger.info("Setting fast AI development: " + gameSettingsMessage.fastAIDevelopment);
        this.model.getGameInfo().setFastAiDevelopment(gameSettingsMessage.fastAIDevelopment);
    }
}

