/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.controller.phase;

import com.turborilla.mule.Properties;
import com.turborilla.mule.ai.AbstractAI;
import com.turborilla.mule.controller.phase.PhaseController;
import com.turborilla.mule.model.Avatar;
import com.turborilla.mule.model.LandGrant;
import com.turborilla.mule.model.Phase;
import com.turborilla.mule.model.Player;
import com.turborilla.mule.model.User;
import com.turborilla.mule.model.map.PlanetMap;
import com.turborilla.mule.model.map.PlanetTile;
import com.turborilla.mule.model.util.NetworkTimer;
import com.turborilla.mule.model.util.Timer;
import com.turborilla.mule.network.TCPMessage;
import com.turborilla.mule.network.UDPMessage;
import com.turborilla.mule.sound.SoundPlayer;
import com.turborilla.mule.view.GameInput;
import com.turborilla.mule.view.LandPingEffect;
import com.turborilla.mule.view.Transition;
import java.util.HashMap;
import java.util.logging.Logger;

public final class LandGrantPhase
extends PhaseController {
    private static Logger logger = Logger.getLogger("mule");
    private byte landGrantId = 0;
    private long lastSendFrame = -1L;
    private boolean startedCountdown;
    private Player claimer;
    private boolean plotDone;
    private short plotFrame;
    private Player playerPressed;
    private int graceDuration;
    private int graceTime;
    private int overtime;
    private boolean sentContinue;
    private HashMap<Player, PlayerStatus> playerStatus = new HashMap();
    private boolean lockupDetected;
    private int lockupCounter;
    private Timer startBellTimer = new Timer(){

        public void finished() {
            SoundPlayer.get().playBeginPhase();
        }
    };
    private Timer startTimer = new Timer(){

        public void finished() {
            if (LandGrantPhase.this.controller.isServer()) {
                int n = LandGrantPhase.this.controller.getServer().getMaxSafeRoundtrip();
                int n2 = Properties.mule.landGrantGraceFrames;
                int n3 = n * Properties.mule.framesPerSecond / 1000;
                LandGrantPhase.this.graceDuration = n2 + n3;
                if (LandGrantPhase.this.graceDuration < Properties.mule.landGrantMinGraceDuration) {
                    LandGrantPhase.this.graceDuration = Properties.mule.landGrantMinGraceDuration;
                }
                logger.info("Grace duration " + n + "ms " + LandGrantPhase.this.graceDuration + " frames (" + n2 + " grace frames)");
                TCPMessage.LandGrantStartMessage landGrantStartMessage = new TCPMessage.LandGrantStartMessage(LandGrantPhase.this.graceDuration);
                TCPMessage.SynchronizedMessage synchronizedMessage = new TCPMessage.SynchronizedMessage(landGrantStartMessage);
                LandGrantPhase.this.controller.getClient().sendTCP(synchronizedMessage);
            }
        }
    };
    private Timer outroTimer = new Timer(){

        public void finished() {
            LandGrantPhase.this.goToNextPhase();
        }
    };

    public void begin() {
        PlanetMap planetMap = this.model.getMap();
        LandGrant landGrant = this.model.getLandGrant();
        this.landGrantId = (byte)((this.landGrantId + 1) % 64);
        landGrant.begin(planetMap);
        this.startedCountdown = false;
        this.resetPlotState();
        this.model.getDevelopment().setPlayerOrder();
        if (!landGrant.hasNextTile()) {
            this.goToNextPhase();
            return;
        }
        for (Player player : this.model.getPlayers()) {
            player.hasClaimedLand = false;
        }
        this.view.setTitle("Land Grant #" + this.model.getRound());
        this.view.setTerminalMessage("Press your Button to select a Plot");
        this.startBellTimer.reset();
        this.startTimer.reset();
        this.outroTimer.reset();
    }

    public void draw() {
        PlanetMap planetMap = this.model.getMap();
        this.view.getMapPainter().draw(planetMap, this.model.getPlayers(), this.model.getMyPlayer());
        this.view.getEffectPainter().draw();
        boolean bl = this.plotFrame == Properties.mule.landGrantPlotDuration && this.claimer == null;
        this.view.getLandGrantPainter().draw(bl);
    }

    public void timerFinished(NetworkTimer networkTimer) {
    }

    public void apply(TCPMessage.ContinueMessage continueMessage) {
        float f = Properties.mule.landGrantCountdown;
        this.startBellTimer.start(f - 1.0f);
        this.startTimer.start(f);
        this.startedCountdown = true;
    }

    public void apply(TCPMessage.LandGrantStartMessage landGrantStartMessage) {
        LandGrant landGrant = this.model.getLandGrant();
        this.graceDuration = landGrantStartMessage.roundtripFrames;
        if (!this.controller.isServer()) {
            logger.info("Grace duration " + this.graceDuration + " frames");
        }
        if (landGrant.isStarted()) {
            logger.warning("Land grant has already started!");
        } else {
            logger.info("Starting land grant");
            this.moveToNextTile();
        }
    }

    public void update(GameInput gameInput) {
        LandGrant landGrant = this.model.getLandGrant();
        if (this.outroTimer.isStarted()) {
            this.outroTimer.tick(Properties.mule.delta);
            if (this.isTimeToSend()) {
                this.sendServerState();
            }
        } else if (landGrant.isStarted()) {
            if (!this.lockupDetected) {
                ++this.lockupCounter;
                if (this.lockupCounter > Properties.mule.landGrantLockupTime) {
                    this.lockupDetected = true;
                    logger.severe("Land grant may be locked at plot=" + landGrant.getTileIndex() + " frame=" + this.plotFrame + " grace=" + this.graceTime + " grace-duration=" + this.graceDuration + " overtime=" + this.overtime + " pressed=" + this.playerPressed + " claimer=" + this.claimer + " plot-done=" + this.plotDone + " server=" + this.controller.isServer());
                }
            }
            if (this.plotFrame < Properties.mule.landGrantPlotDuration) {
                if (this.playerPressed == null) {
                    this.plotFrame = (short)(this.plotFrame + 1);
                    for (Player player : this.model.getLocalPlayers()) {
                        if (player.hasClaimedLand || !player.getController().isActionButtonDown() || this.playerPressed != null && player.getRank() <= this.playerPressed.getRank()) continue;
                        this.playerPressed = player;
                    }
                    if (this.playerPressed != null) {
                        logger.info(this.playerPressed + " pressed at plot " + landGrant.getTileIndex() + " frame " + this.plotFrame);
                        this.landPing(this.playerPressed);
                    }
                }
            } else if (this.graceTime > 0) {
                --this.graceTime;
            } else if (this.plotDone) {
                this.moveToNextTile();
            } else {
                ++this.overtime;
            }
            if (this.isTimeToSend()) {
                this.sendPlayerState();
                this.sendServerState();
            }
            if (this.controller.isServer()) {
                this.checkContinueAfterClaim();
            }
        } else if (!this.startedCountdown) {
            if (this.controller.isServer()) {
                boolean bl = false;
                for (AbstractAI object : this.model.getAiSystem().getAIs()) {
                    if (!object.isThinking()) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    this.startedCountdown = true;
                    TCPMessage.ContinueMessage continueMessage = new TCPMessage.ContinueMessage();
                    TCPMessage.SynchronizedMessage synchronizedMessage = new TCPMessage.SynchronizedMessage(continueMessage);
                    this.controller.getClient().sendTCP(synchronizedMessage);
                }
            }
        } else {
            this.startBellTimer.tick(Properties.mule.delta);
            this.startTimer.tick(Properties.mule.delta);
        }
    }

    private boolean isTimeToSend() {
        if (this.controller.getFrame() - this.lastSendFrame >= (long)Properties.mule.landGrantSendInterval) {
            this.lastSendFrame = this.controller.getFrame();
            return true;
        }
        return false;
    }

    private void sendPlayerState() {
        LandGrant landGrant = this.model.getLandGrant();
        for (Player player : this.model.getLocalPlayers()) {
            UDPMessage.PlayerLandGrantMessage playerLandGrantMessage = new UDPMessage.PlayerLandGrantMessage(this.landGrantId, (byte)landGrant.getTileIndex(), this.plotFrame, player == this.playerPressed, this.claimer != null);
            if (this.controller.isServer()) {
                this.handle(playerLandGrantMessage, player);
                continue;
            }
            player.sendToServer(this.controller.getClient(), playerLandGrantMessage);
        }
    }

    private void sendServerState() {
        if (this.controller.isServer()) {
            LandGrant landGrant = this.model.getLandGrant();
            int n = 0;
            if (this.claimer != null) {
                n = this.claimer.getUserNumber();
            }
            UDPMessage.ServerLandGrantMessage serverLandGrantMessage = new UDPMessage.ServerLandGrantMessage(this.landGrantId, (byte)landGrant.getTileIndex(), n, this.plotDone);
            this.model.getMyUser().sendToOthers(this.controller.getClient(), serverLandGrantMessage);
        }
    }

    private void checkContinueAfterClaim() {
        Object object;
        if (this.claimer == null || this.sentContinue) {
            return;
        }
        for (Player object22 : this.model.getPlayers()) {
            object = this.playerStatus.get(object22);
            if (((PlayerStatus)object).claimed) continue;
            return;
        }
        LandGrant landGrant = this.model.getLandGrant();
        TCPMessage.LandGrantContinueMessage landGrantContinueMessage = new TCPMessage.LandGrantContinueMessage(landGrant.getTileIndex() + 1);
        object = new TCPMessage.SynchronizedMessage(landGrantContinueMessage);
        this.controller.getClient().sendTCP((TCPMessage)object);
        this.sentContinue = true;
    }

    public void apply(UDPMessage.PlayerLandGrantMessage playerLandGrantMessage) {
        if (!this.controller.isServer()) {
            logger.severe("Got message to server");
            return;
        }
        if (playerLandGrantMessage.landGrantId != this.landGrantId) {
            return;
        }
        Player player = this.model.getPlayer(playerLandGrantMessage.getUserNumber());
        if (player == null) {
            return;
        }
        this.handle(playerLandGrantMessage, player);
    }

    private void handle(UDPMessage.PlayerLandGrantMessage playerLandGrantMessage, Player player) {
        PlayerStatus playerStatus = this.playerStatus.get(player);
        if (playerLandGrantMessage.plot < this.model.getLandGrant().getTileIndex() || playerLandGrantMessage.frame < playerStatus.frame) {
            return;
        }
        playerStatus.plot = playerLandGrantMessage.plot;
        playerStatus.frame = playerLandGrantMessage.frame;
        playerStatus.pressed = playerLandGrantMessage.pressed;
        playerStatus.claimed = playerLandGrantMessage.claimed;
        this.checkDone();
    }

    private boolean checkDone() {
        if (this.claimer != null || this.plotDone) {
            return true;
        }
        Player player = null;
        short s = Short.MAX_VALUE;
        short s2 = Short.MAX_VALUE;
        for (Player player2 : this.model.getPlayers()) {
            PlayerStatus playerStatus = this.playerStatus.get(player2);
            if (playerStatus.plot < this.model.getLandGrant().getTileIndex()) {
                return false;
            }
            if (playerStatus.frame < s2) {
                s2 = playerStatus.frame;
            }
            if (!playerStatus.pressed || player2.hasClaimedLand) continue;
            if (playerStatus.frame < s) {
                s = playerStatus.frame;
            }
            if (player != null && player2.getRank() < player.getRank()) continue;
            player = player2;
        }
        if (player != null) {
            if (s2 < s) {
                return false;
            }
            this.claimPlot(player);
            return true;
        }
        if (s2 >= Properties.mule.landGrantPlotDuration) {
            this.plotDone = true;
            return true;
        }
        return false;
    }

    public void apply(UDPMessage.ServerLandGrantMessage serverLandGrantMessage) {
        if (this.controller.isServer()) {
            logger.severe("Got message to client");
            return;
        }
        if (serverLandGrantMessage.landGrantId != this.landGrantId) {
            return;
        }
        LandGrant landGrant = this.model.getLandGrant();
        byte by = (byte)landGrant.getTileIndex();
        if (serverLandGrantMessage.plot < by) {
            return;
        }
        if (this.claimer != null) {
            return;
        }
        if (serverLandGrantMessage.plot > by) {
            this.plotDone = true;
            return;
        }
        if (serverLandGrantMessage.done) {
            this.plotDone = true;
        }
        if (serverLandGrantMessage.claimer != 0) {
            Player player = this.model.getPlayer(serverLandGrantMessage.claimer);
            this.claimPlot(player);
        }
    }

    private void claimPlot(Player player) {
        this.claimer = player;
        LandGrant landGrant = this.model.getLandGrant();
        PlanetTile planetTile = landGrant.getTile();
        this.model.claimLand(player, planetTile);
        SoundPlayer.get().playClaimLand();
        logger.info(player + " is granted tile " + landGrant.getTileIndex() + ": " + planetTile);
        this.view.getLandGrantPainter().hideFrame();
        if (!this.model.getLocalPlayers().contains(player)) {
            this.landPing(player);
        }
        if (player == this.model.getMyPlayer()) {
            this.view.fadeTerminalMessage();
        }
    }

    public void apply(TCPMessage.LandGrantContinueMessage landGrantContinueMessage) {
        this.plotFrame = Properties.mule.landGrantPlotDuration;
        this.graceTime = Properties.mule.landGrantClaimDuration;
        this.overtime = 0;
        this.plotDone = true;
    }

    private void moveToNextTile() {
        LandGrant landGrant = this.model.getLandGrant();
        if (this.overtime > 0) {
            logger.info("Overtime: " + this.overtime);
        }
        landGrant.checkFinished(this.model.getPlayers());
        if (!landGrant.hasNextTile()) {
            logger.info("Land grant ends");
            this.view.fadeTerminalMessage();
            this.view.getLandGrantPainter().hideFrame();
            this.outroTimer.start(Properties.mule.landGrantOutro);
            SoundPlayer.get().playAuctionEnded();
        } else {
            this.resetPlotState();
            landGrant.nextTile();
            PlanetTile planetTile = landGrant.getTile();
            this.view.getLandGrantPainter().moveFrameTo(planetTile);
            SoundPlayer.get().playMoveLandGrant();
        }
    }

    private void resetPlotState() {
        this.plotFrame = 0;
        this.graceTime = this.graceDuration;
        this.claimer = null;
        this.plotDone = false;
        this.playerPressed = null;
        this.overtime = 0;
        this.lockupDetected = false;
        this.lockupCounter = 0;
        this.sentContinue = false;
        if (this.controller.isServer()) {
            for (Player player : this.model.getPlayers()) {
                PlayerStatus playerStatus = this.playerStatus.get(player);
                if (playerStatus == null) {
                    this.playerStatus.put(player, new PlayerStatus());
                    continue;
                }
                playerStatus.clear();
            }
        }
    }

    private void landPing(Player player) {
        PlanetTile planetTile = this.model.getLandGrant().getTile();
        float f = ((float)planetTile.getPosX() + 0.5f) * 64.0f;
        float f2 = ((float)planetTile.getPosY() + 0.5f) * 64.0f;
        this.view.getEffectPainter().add(new LandPingEffect(player.getColorIndex(), f, f2));
    }

    private void goToNextPhase() {
        for (Player user : this.model.getPlayers()) {
            user.hasClaimedLand = true;
            Avatar avatar = user.getAvatar();
            avatar.setInShop(true);
            avatar.setPosition(this.model.getShop().getStartLocation());
        }
        this.model.setNextPhase(Phase.LAND_AUCTION);
        for (User user : this.model.getLocalUsers()) {
            user.send(this.controller.getClient(), new TCPMessage.ReadyMessage(this.controller.getFrame()));
        }
    }

    public Transition end() {
        return null;
    }

    private static class PlayerStatus {
        public byte plot;
        public short frame;
        public boolean pressed;
        public boolean claimed;

        public PlayerStatus() {
            this.clear();
        }

        public void clear() {
            this.plot = (byte)-1;
            this.frame = 0;
            this.pressed = false;
            this.claimed = false;
        }
    }
}

