/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.controller.phase;

import com.turborilla.mule.Properties;
import com.turborilla.mule.controller.AuctionController;
import com.turborilla.mule.controller.phase.AbstractLandAuctionPhase;
import com.turborilla.mule.model.AuctionLimits;
import com.turborilla.mule.view.AuctionPainter;
import com.turborilla.mule.view.BlobbyTransition;
import com.turborilla.mule.view.GameInput;
import com.turborilla.mule.view.Transition;
import com.turborilla.mule.view.Transitionable;
import java.util.logging.Logger;

public class LandAuctionPhase
extends AbstractLandAuctionPhase {
    private static Logger logger = Logger.getLogger("mule");
    private Transitionable prevView;
    private Transitionable currentView;
    private Transition transition;
    Transitionable mapPainter = new Transitionable(){

        public void draw() {
            LandAuctionPhase.this.view.getMapPainter().draw(LandAuctionPhase.this.model.getMap(), LandAuctionPhase.this.model.getPlayers(), LandAuctionPhase.this.model.getMyPlayer());
            if (LandAuctionPhase.this.showBuyTimer.isStarted()) {
                LandAuctionPhase.this.view.getEffectPainter().draw();
            } else if (LandAuctionPhase.this.currentView == LandAuctionPhase.this.mapPainter) {
                LandAuctionPhase.this.view.getMapPainter().drawSaleSign(LandAuctionPhase.this.model.getPlotSeller().getAuctionTile());
            }
        }
    };
    Transitionable auctionPainter = new Transitionable(){

        public void draw() {
            AuctionLimits auctionLimits = LandAuctionPhase.this.model.getAuction().getCurrentLimits();
            AuctionPainter auctionPainter = LandAuctionPhase.this.view.getAuctionPainter2();
            auctionPainter.drawAuction(null, LandAuctionPhase.this.model.getRound(), true);
            auctionPainter.drawLandAuctionPlayers(LandAuctionPhase.this.model.getPlayersInRankOrder(), auctionLimits);
            int n = auctionLimits.tickToPrice(auctionLimits.minTick);
            int n2 = LandAuctionPhase.this.model.getPlotSeller().getAuctionPrice();
            if (n > n2) {
                auctionPainter.drawBottomPrice(n, true);
            } else {
                auctionPainter.drawBottomPrice(n2, false);
            }
            if (!LandAuctionPhase.this.countdown.isFinished()) {
                String string = "";
                if (LandAuctionPhase.this.countdown.isStarted() && LandAuctionPhase.this.countdown.getTime() < Properties.mule.auctionCountdownTime) {
                    string = "" + LandAuctionPhase.this.countdown.getTimeAsInteger();
                }
                auctionPainter.drawLandAuctionLabel(string);
            } else {
                auctionPainter.drawGoText();
            }
            auctionPainter.drawTimer(LandAuctionPhase.this.model.getPhaseTimer());
        }
    };

    public LandAuctionPhase() {
        super(new AuctionController(null, true));
    }

    public void begin() {
        super.begin();
        this.prevView = null;
        this.currentView = this.mapPainter;
        this.transition = null;
    }

    public void update(GameInput gameInput) {
        super.update(gameInput);
        if (this.transition != null) {
            this.transition.update(Properties.mule.delta);
            if (this.transition.isComplete()) {
                this.transition = null;
            }
        }
    }

    public void draw() {
        if (this.transition == null) {
            this.currentView.draw();
        } else {
            this.view.drawTransition(this.transition, this.prevView, this.currentView);
        }
    }

    protected void showAuction() {
        this.prevView = this.mapPainter;
        this.currentView = this.auctionPainter;
        this.transition = BlobbyTransition.createPlayAreaTransition();
    }

    protected void showMap() {
        this.prevView = this.auctionPainter;
        this.currentView = this.mapPainter;
        this.transition = BlobbyTransition.createPlayAreaTransition();
    }
}

