/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.controller.phase;

import com.turborilla.mule.Properties;
import com.turborilla.mule.controller.phase.PhaseController;
import com.turborilla.mule.model.GameMode;
import com.turborilla.mule.model.Phase;
import com.turborilla.mule.model.User;
import com.turborilla.mule.model.map.PlanetTile;
import com.turborilla.mule.model.util.NetworkTimer;
import com.turborilla.mule.network.TCPMessage;
import com.turborilla.mule.view.BlobbyTransition;
import com.turborilla.mule.view.GameInput;
import com.turborilla.mule.view.IntroPainter;
import com.turborilla.mule.view.Transition;

public class IntroPhase
extends PhaseController {
    private boolean shipIsEntering;
    private boolean goingToNextPhase;

    public void begin() {
        this.shipIsEntering = this.model.getRound() == Properties.mule.firstRound;
        this.goingToNextPhase = false;
        if (this.shipIsEntering) {
            if (this.model.getGameInfo().getMode() == GameMode.TOURNAMENT) {
                this.view.setTerminalMessage("Landing on Planet Irata sector " + this.model.getGameInfo().getCoordinateString());
            } else {
                this.view.setTerminalMessage(this.model.getGameInfo().getCodeName() + " - Simulated Landing on Planet Irata");
            }
            this.view.getIntroPainter().startLanding();
            if (this.model.getGameInfo().isRiver()) {
                PlanetTile planetTile = this.model.getMap().getShopTile();
                PlanetTile planetTile2 = (PlanetTile)this.model.getMap().getTile(planetTile.getPosX(), planetTile.getPosY() + 1);
                planetTile.setIdentifier(PlanetTile.PlanetTileType.River.identifier, 1);
                planetTile2.setIdentifier(PlanetTile.PlanetTileType.River.identifier, 2);
            } else {
                this.model.getMap().getShopTile().setIdentifier(PlanetTile.PlanetTileType.Plain.identifier, 0);
            }
        } else {
            PlanetTile planetTile = this.model.getMap().getShopTile();
            planetTile.setIdentifier(PlanetTile.PlanetTileType.Shop.identifier, 0);
            if (this.model.getGameInfo().isRiver()) {
                PlanetTile planetTile3 = (PlanetTile)this.model.getMap().getTile(planetTile.getPosX(), planetTile.getPosY() + 1);
                planetTile3.setIdentifier(PlanetTile.PlanetTileType.River.identifier, 0);
            }
            this.view.setTerminalMessage("The Colonial Ship will be back in " + this.model.getGameInfo().getLastRound() + " months");
            this.view.getIntroPainter().startTakeoff();
        }
    }

    public void draw() {
        this.view.getMapPainter().draw(this.model.getMap(), this.model.getPlayers(), this.model.getMyPlayer());
        this.view.getIntroPainter().draw();
    }

    public Transition end() {
        this.view.fadeTitle();
        if (this.shipIsEntering) {
            return BlobbyTransition.createPlayAreaTransition();
        }
        return null;
    }

    public void timerFinished(NetworkTimer networkTimer) {
    }

    public void update(GameInput gameInput) {
        IntroPainter introPainter = this.view.getIntroPainter();
        introPainter.update();
        if (this.shipIsEntering) {
            if (introPainter.isLandingComplete()) {
                this.goToNextPhase();
            }
        } else if (introPainter.isTakeoffComplete()) {
            this.goToNextPhase();
        }
    }

    private void goToNextPhase() {
        if (!this.goingToNextPhase) {
            if (this.shipIsEntering) {
                this.view.fadeTitle();
                this.model.setNextPhase(Phase.SUMMARY);
            } else if (Properties.mule.enableHiring) {
                this.model.setNextPhase(Phase.HIRE);
            } else if (this.model.getGameInfo().isSingleDevelopment()) {
                this.model.setNextPhase(Phase.LAND_GRANT);
            } else {
                this.model.setNextPhase(Phase.LAND_RUSH);
            }
            for (User user : this.model.getLocalUsers()) {
                user.send(this.controller.getClient(), new TCPMessage.ReadyMessage(this.controller.getFrame()));
            }
            this.goingToNextPhase = true;
        }
    }
}

