/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.controller.phase;

import com.turborilla.mule.MuleUtil;
import com.turborilla.mule.Properties;
import com.turborilla.mule.ai.AIPlayerController;
import com.turborilla.mule.controller.GameController;
import com.turborilla.mule.controller.PlayerController;
import com.turborilla.mule.controller.phase.PhaseController;
import com.turborilla.mule.model.ColonyEvent;
import com.turborilla.mule.model.GameInfo;
import com.turborilla.mule.model.GameMode;
import com.turborilla.mule.model.GameModel;
import com.turborilla.mule.model.GameModelObserver;
import com.turborilla.mule.model.Phase;
import com.turborilla.mule.model.Player;
import com.turborilla.mule.model.Resource;
import com.turborilla.mule.model.Shop;
import com.turborilla.mule.model.Spectator;
import com.turborilla.mule.model.User;
import com.turborilla.mule.model.UserStatistics;
import com.turborilla.mule.model.map.Building;
import com.turborilla.mule.model.map.Factory;
import com.turborilla.mule.model.map.PlanetMap;
import com.turborilla.mule.model.map.PlanetTile;
import com.turborilla.mule.model.util.NetworkTimer;
import com.turborilla.mule.model.util.Timer;
import com.turborilla.mule.network.Client;
import com.turborilla.mule.network.MasterClient;
import com.turborilla.mule.network.MasterClientListener;
import com.turborilla.mule.network.MasterResponse;
import com.turborilla.mule.network.Server;
import com.turborilla.mule.network.TCPMessage;
import com.turborilla.mule.network.UDPMessage;
import com.turborilla.mule.sound.SoundPlayer;
import com.turborilla.mule.view.ActorSprite;
import com.turborilla.mule.view.BlobbyTransition;
import com.turborilla.mule.view.GameInput;
import com.turborilla.mule.view.LobbyPainter3;
import com.turborilla.mule.view.Transition;
import com.turborilla.mule.view.View;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Logger;

public class GameLobbyPhase
extends PhaseController {
    private Logger logger = Logger.getLogger("mule");
    private boolean gameInitialized;
    private boolean shownSameAddressWarning;
    private boolean shownNoUserAccountWarning;
    private MasterListener masterClientListener;
    private String masterServerError;
    private HashMap<Integer, Boolean> ready;
    private int connectionAttempt = 0;
    private MuleUtil.LineBreaker lineBreaker = new MuleUtil.LineBreaker(75);
    private boolean sentNewGame = false;
    LobbyPainter3.LobbyPainterListener lobbyListener = new LobbyPainter3.LobbyPainterListener(){

        public void finished() {
            GameLobbyPhase.this.model.setNextPhase(Phase.INTRO);
            for (User user : GameLobbyPhase.this.model.getLocalUsers()) {
                user.send(GameLobbyPhase.this.controller.getClient(), new TCPMessage.ReadyMessage(GameLobbyPhase.this.controller.getFrame()));
            }
        }
    };
    GameModelObserver modelObserver = new GameModelObserver(){

        public void notifyEvent(GameModelObserver.Event event, Object ... objectArray) {
            User user;
            if (event == GameModelObserver.Event.USER_ADDED) {
                User user2 = (User)objectArray[0];
                if (user2 instanceof Player) {
                    Player player = (Player)user2;
                    GameLobbyPhase.this.view.getLobbyPainter().addPlayer(player);
                }
            } else if (event == GameModelObserver.Event.USER_REMOVED && (user = (User)objectArray[0]) instanceof Player) {
                Player player = (Player)user;
                GameLobbyPhase.this.view.getLobbyPainter().removePlayer(player);
            }
        }
    };
    Timer testConnectionTimer = new Timer(){

        public void finished() {
            GameLobbyPhase.this.controller.getMasterClient().sendTestConnection();
        }
    };

    public void begin() {
        this.gameInitialized = false;
        this.shownSameAddressWarning = false;
        this.shownNoUserAccountWarning = false;
        this.masterClientListener = new MasterListener();
        this.ready = new HashMap();
        this.controller.getMasterClient().addObserver(this.masterClientListener);
        if (this.controller.isServer()) {
            this.testMasterConnection();
            for (User user : this.model.getUsers()) {
                this.getMasterUserInfo(user);
            }
            this.gameInitialized = true;
        }
        if (Properties.mule.testAI) {
            this.controller.getUserController().addAiPlayer();
        }
        if (Properties.mule.debugAutoJoin) {
            this.model.getMyUser().send(this.controller.getClient(), new TCPMessage.PlayerJoinMessage());
        }
        this.view.setHUDEnabled(false);
        this.view.getLobbyPainter().addListener(this.lobbyListener);
        this.controller.acceptPendingUsers();
        GameInfo gameInfo = this.model.getGameInfo();
        this.controller.sendSystemChatMessage(gameInfo.getMode().toString() + " Mode - " + gameInfo.getLastRound() + " Rounds");
        if (gameInfo.getMode() == GameMode.TOURNAMENT) {
            this.controller.sendSystemChatMessage("Need 4 players to start - Max 2 computer players allowed");
        }
        if (gameInfo.isFastAiDevelopment()) {
            this.controller.sendSystemChatMessage("Not showing computer player development");
        } else {
            this.controller.sendSystemChatMessage("Showing computer player development");
        }
    }

    public void set(GameModel gameModel, GameController gameController, View view) {
        super.set(gameModel, gameController, view);
        if (gameModel != null) {
            gameModel.addObserver(this.modelObserver);
            for (Player player : gameModel.getPlayers()) {
                this.modelObserver.notifyEvent(GameModelObserver.Event.USER_ADDED, player);
            }
        }
    }

    public void draw() {
        Server server = this.controller.getServer();
        boolean bl = !this.controller.getMasterClient().isClosed();
        this.view.getLobbyPainter().draw();
        this.view.getLobbyPainter().drawPlayers(this.model.getGameInfo(), bl && this.masterServerError == null);
        this.view.getLobbyPainter().drawSpectators(this.model.getSpectators(), this.ready);
        for (Player player : this.model.getPlayers()) {
            if (player == this.model.getMyPlayer() && !this.controller.getClient().isUDPInitialized()) {
                this.view.getLobbyPainter().printInitUdp(player);
            }
            if (!this.controller.isServer() || server.hasUDPAddress(player.getUserNumber())) continue;
            this.view.getLobbyPainter().printInitUdp(player);
        }
        if (this.model.getGameInfo().getGameID() == 0L) {
            this.view.getLobbyPainter().drawMasterServerStatus(bl, this.masterServerError);
        }
        if (!this.model.isGameStarted()) {
            int n = this.model.peekNextPlayerIndex();
            boolean bl2 = this.controller.isServer() && !this.isMaxAiPlayers();
            this.view.getHUDPainter().drawLobby(this.model.getPlayers(), this.ready, n, bl2);
        }
    }

    private boolean isMaxAiPlayers() {
        int n = 0;
        for (Player player : this.model.getLocalPlayers()) {
            if (!(player.getController() instanceof AIPlayerController)) continue;
            ++n;
        }
        return n >= this.model.getGameInfo().getMode().maxNumAi();
    }

    public void update(GameInput gameInput) {
        Client client = this.controller.getClient();
        if (!client.isConnected()) {
            this.controller.requestClose("You were disconnected", true);
            return;
        }
        if (this.controller.getClient().isUDPInitialized() && this.gameInitialized && !this.model.isGameStarted()) {
            Object object;
            if (gameInput.isPressed(4) && (object = this.model.getMyUser()) instanceof Spectator) {
                boolean bl = !this.isReadyLocal((User)object);
                ((User)object).send(client, new TCPMessage.ContinueMessage());
                this.setReadyLocal((User)object, bl);
                if (bl) {
                    SoundPlayer.get().playButtonPressSpectator();
                } else {
                    SoundPlayer.get().playButtonPressFailed();
                }
            }
            if (gameInput.isPressed(7) && this.model.getPlayers().size() < Properties.mule.maxNumPlayers && (object = this.model.getMyUser()) instanceof Spectator) {
                ((User)object).send(client, new TCPMessage.PlayerJoinMessage());
            }
            if (gameInput.isPressed(8) && (object = this.model.getMyUser()) instanceof Player) {
                ((User)object).send(client, new TCPMessage.PlayerUnjoinMessage());
            }
            if (gameInput.isPressed(9) && this.controller.isServer() && !this.isMaxAiPlayers()) {
                this.controller.getUserController().addAiPlayer();
            }
            for (Player player : this.model.getLocalPlayers()) {
                PlayerController playerController = player.getController();
                boolean bl = this.isReadyLocal(player);
                if (!playerController.isActionButtonPressed()) continue;
                player.send(client, new TCPMessage.ContinueMessage());
                bl = !bl;
                this.setReadyLocal(player, bl);
                if (bl) {
                    SoundPlayer.get().playButtonPress(player.getPlayerIndex());
                    continue;
                }
                SoundPlayer.get().playButtonPressFailed();
            }
        }
        this.view.getLobbyPainter().update();
        this.testConnectionTimer.tick(Properties.mule.delta);
    }

    private boolean isReadyLocal(User user) {
        Boolean bl = this.ready.get(user.getUserNumber());
        if (bl == null) {
            return user.isReady();
        }
        return bl;
    }

    private void setReadyLocal(User user, boolean bl) {
        this.ready.put(user.getUserNumber(), bl);
    }

    public void userRemoved(User user) {
        this.ready.remove(user.getUserNumber());
        if (user instanceof Player) {
            Player player = (Player)user;
            this.view.getLobbyPainter().removePlayer(player);
        }
        this.checkSameAddresses(null);
    }

    public Transition end() {
        this.view.getLobbyPainter().removeListener(this.lobbyListener);
        this.model.removeObserver(this.modelObserver);
        MasterClient masterClient = this.controller.getMasterClient();
        masterClient.removeObserver(this.masterClientListener);
        if (!this.controller.getClient().isUDPInitialized() || this.model.getMyUser() == null) {
            throw new RuntimeException("The game started before your UDP\nconnection could be initialized.");
        }
        if (this.controller.isServer()) {
            if (!masterClient.isClosed() && this.model.getGameInfo().getGameID() == 0L) {
                masterClient.close();
                this.controller.sendSystemChatMessage("Couldn't contact master server. Game scores will not be saved.");
            }
            this.controller.getServer().reserveUserNumbers();
        }
        this.setDebugStartup();
        return BlobbyTransition.createPlayAreaTransition();
    }

    public void apply(TCPMessage.JoinMessage joinMessage) {
        if (!this.model.isGameStarted()) {
            User user = this.model.getUser(joinMessage.getUserNumber());
            if (user.getUserId() != 0L) {
                for (User user2 : this.model.getUsers()) {
                    if (user == user2 || user2.getUserId() != user.getUserId()) continue;
                    this.controller.sendSystemChatMessage("%s is already in the game", user);
                    if (this.controller.isServer()) {
                        this.controller.kick(user.getUserNumber());
                    }
                    return;
                }
            }
            this.getMasterUserInfo(user);
            this.controller.acceptPendingUsers();
        }
    }

    private void checkSameAddresses(User user) {
        ArrayList<User> arrayList = this.model.getUsers();
        boolean bl = false;
        boolean bl2 = true;
        for (int i = 0; i < arrayList.size() - 1; ++i) {
            for (int j = i + 1; j < arrayList.size(); ++j) {
                User user2 = arrayList.get(i);
                User user3 = arrayList.get(j);
                if (user2.isAiPlayer() || user3.isAiPlayer()) continue;
                bl = true;
                String string = user2.getIpAddress();
                String string2 = user3.getIpAddress();
                if (string != null && string.equalsIgnoreCase(string2)) {
                    if (user2 != user && user3 != user) continue;
                    String string3 = user3.getName() + " has the same IP address as " + user2.getName();
                    this.controller.sendSystemChatMessage(string3);
                    continue;
                }
                bl2 = false;
            }
        }
        if (!this.shownSameAddressWarning && this.model.getGameInfo().getMode() == GameMode.TOURNAMENT && bl && bl2) {
            String string = "Games are ranked only if 2 or more players have different IP addresses";
            this.controller.sendSystemChatMessage(string);
            this.shownSameAddressWarning = true;
        }
    }

    public void apply(TCPMessage.PlayerJoinMessage playerJoinMessage) {
        User user = this.model.getMyUser();
        if (user != null && user.getUserNumber() == playerJoinMessage.getUserNumber()) {
            this.setReadyLocal(user, user.isContinue());
        }
        this.model.updatePlayerRankOrder();
        SoundPlayer.get().playJoinGame();
    }

    public void apply(TCPMessage.AIJoinMessage aIJoinMessage) {
        this.controller.acceptPendingUsers();
        this.model.updatePlayerRankOrder();
    }

    public void apply(TCPMessage.GameModelMessage gameModelMessage) {
        for (Spectator user : this.model.getSpectators()) {
            this.getMasterUserInfo(user);
        }
        for (Player player : this.model.getPlayers()) {
            this.getMasterUserInfo(player);
        }
        this.gameInitialized = true;
    }

    public void apply(TCPMessage.ContinueMessage continueMessage) {
        if (this.model.isGameStarted()) {
            return;
        }
        User user = this.model.getUser(continueMessage.getUserNumber());
        if (user == null) {
            this.logger.severe("User " + continueMessage.getUserNumber() + " has not yet joined and can't be ready.");
        } else {
            User user2;
            user.setContinue(!user.isContinue());
            this.model.notifyUserReady(user);
            if (user.isContinue() && !this.model.getLocalUsers().contains(user)) {
                if (user instanceof Player) {
                    Player player = (Player)user;
                    SoundPlayer.get().playButtonPress(player.getPlayerIndex());
                } else {
                    SoundPlayer.get().playButtonPressSpectator();
                }
            }
            boolean bl = false;
            if (this.model.getGameInfo().getMode() == GameMode.TOURNAMENT) {
                bl = this.model.getPlayers().size() == Properties.mule.maxNumPlayers;
            } else {
                boolean bl2 = bl = !this.model.getPlayers().isEmpty();
            }
            if (bl && this.model.allPlayersContinue() && (user2 = this.model.getServerUser()).isContinue() && this.model.getNextPhase() == null) {
                this.logger.info("Starting Game - All players want to continue");
                this.model.startGame();
                this.controller.gameStarted();
                if (this.controller.isServer()) {
                    this.controller.getMasterClient().sendStartGame(this.model.getPlayers());
                }
                this.view.setHUDEnabled(true);
                this.view.getLobbyPainter().startOutro();
            }
        }
    }

    public void apply(TCPMessage.ChooseDirectionMessage chooseDirectionMessage) {
        Player player = this.model.getPlayer(chooseDirectionMessage.getUserNumber());
        if (player == null) {
            return;
        }
        if (chooseDirectionMessage.direction == ActorSprite.Direction.North || chooseDirectionMessage.direction == ActorSprite.Direction.South) {
            int n = Properties.mule.minMoneyStep;
            if (chooseDirectionMessage.direction == ActorSprite.Direction.South) {
                player.setMoney(Math.min(player.getMoney() + n, Properties.mule.playerStartMoney));
            } else if (chooseDirectionMessage.direction == ActorSprite.Direction.North) {
                player.setMoney(Math.max(player.getMoney() - n, 0));
            }
        }
    }

    private void setDebugStartup() {
        Object object;
        int n;
        PlanetMap planetMap = this.model.getMap();
        if (Properties.mule.autoAssay) {
            for (Player player : this.model.getPlayers()) {
                for (n = 0; n < planetMap.getXSize(); ++n) {
                    for (int i = 0; i < planetMap.getYSize(); ++i) {
                        PlanetTile planetTile = (PlanetTile)planetMap.getTile(n, i);
                        this.model.assay(player, planetTile, false);
                    }
                }
            }
        }
        if (Properties.mule.skipIntro) {
            if (Properties.mule.enableHiring) {
                this.model.setNextPhase(Phase.HIRE);
            } else if (this.model.getGameInfo().isSingleDevelopment()) {
                this.model.setNextPhase(Phase.LAND_GRANT);
            } else {
                this.model.setNextPhase(Phase.LAND_RUSH);
            }
        }
        if (Properties.mule.testLandGrant) {
            int n2 = 0;
            for (int i = 0; i < planetMap.getXSize(); ++i) {
                for (n = 0; n < planetMap.getYSize(); ++n) {
                    if (n == 0 && i == 0 || n == 3 && (i == 1 || i == 5)) continue;
                    PlanetTile planetTile = (PlanetTile)planetMap.getTile(i, n);
                    planetTile.setOwner(planetMap, this.model.getPlayers().get(n2));
                    this.debugBuild(this.model.getPlayers().get(n2), i, n, Resource.Food);
                    n2 = (n2 + 1) % this.model.getPlayers().size();
                }
            }
        }
        if (Properties.mule.testLandRush) {
            object = this.model.getPlayersInRankOrder().get(0);
            if (object != null) {
                PlanetTile planetTile = (PlanetTile)planetMap.getTile(2, 1);
                planetTile.setOwner(planetMap, (Player)object);
            }
            this.model.setNextPhase(Phase.LAND_RUSH);
        }
        if (Properties.mule.testLandAuction) {
            this.model.setNextPhase(Phase.LAND_AUCTION);
            object = this.model.getPlayersInRankOrder().get(0);
            if (object != null) {
                ((Player)object).getOwnedTiles().clear();
                ((PlanetTile)planetMap.getTile(3, 4)).setOwner(planetMap, (Player)object);
            }
        }
        if (Properties.mule.testColonyEvent) {
            object = this.model.getPlayersInRankOrder().get(0);
            if (object != null) {
                ((Player)object).getOwnedTiles().clear();
                ((Player)object).setEnergy(4);
                this.debugBuild((Player)object, 0, 0, Resource.Food);
                this.debugBuild((Player)object, 0, 1, Resource.Energy);
                this.debugBuild((Player)object, 0, 2, Resource.Smithore);
                this.debugBuild((Player)object, 0, 3, Resource.Crystite);
                this.debugBuild((Player)object, 1, 0, Resource.Food);
                this.debugBuild((Player)object, 2, 0, Resource.Energy);
                Building.calcBonuses(object, this.model.getMap(), this.model.getHirelingManager());
            }
            this.model.getColonyEventGenerator().debugSetAllEvents(ColonyEvent.Type.METEORITE_STRIKE);
            this.model.setNextPhase(Phase.COLONY_EVENT_A);
        }
        if (Properties.mule.testProduction) {
            this.model.showFactoryYield();
            this.model.setNextPhase(Phase.PRODUCTION);
        }
        if (Properties.mule.testCollection) {
            object = this.model.getPlayersInRankOrder().get(0);
            ((Player)object).setSmithore(50);
            ((Player)object).getOwnedTiles().clear();
            this.debugBuild((Player)object, 0, 0, Resource.Smithore).getFactory().setProduction(5);
            this.model.setNextPhase(Phase.COLLECTION_SMITHORE);
        }
        if (Properties.mule.testPlayerEvent) {
            for (Player player : this.model.getPlayers()) {
                player.getAvatar().setPosition(this.model.getShop().getStartLocation());
            }
            this.model.setNextPhase(Phase.PLAYER_EVENT);
        }
        if (Properties.mule.testDevelopment || Properties.mule.testFastDevelopment) {
            this.model.setNextPhase(Phase.DEVELOPMENT);
            for (int i = 0; i < this.model.getPlayersInRankOrder().size(); ++i) {
                Player player = this.model.getPlayersInRankOrder().get(i);
                if (player == null) continue;
                player.getOwnedTiles().clear();
                this.debugBuild(player, 2, 1 + i, Resource.Crystite);
                this.debugBuild(player, 3, 1 + i, null);
                this.debugBuild(player, 4, i > 1 ? i + 1 : i, null);
                if (!Properties.mule.testFastDevelopment || i != 0 || !player.isAiPlayer()) continue;
                this.model.setNextPhase(Phase.FAST_DEVELOPMENT);
            }
        }
        if (Properties.mule.testAuction) {
            for (Player player : this.model.getPlayers()) {
                player.setCrystite(2 * (1 - player.getPlayerIndex()));
                player.setSmithore(25);
                player.setFood(20);
                player.setEnergy(25);
                player.setMoney(1000);
            }
            Shop shop = this.model.getShop();
            shop.setSmithore(1);
            shop.calcBuySellPrice(this.model.getRandom(), this.model.getMap(), this.model.getPlayers(), Resource.Crystite, this.model.getRound());
            this.model.setNextPhase(Phase.AUCTION_SMITHORE);
        }
        if (Properties.mule.testSummary) {
            this.model.setNextPhase(Phase.SUMMARY);
        }
        if (this.model.getNextPhase() != Phase.INTRO) {
            this.model.updatePlayerRankOrder();
            this.model.beginNextRound();
            for (Player player : this.model.getPlayers()) {
                n = player.getFood();
                player.useFood(this.model.getRound());
                player.setFood(n);
            }
        }
    }

    private PlanetTile debugBuild(Player player, int n, int n2, Resource resource) {
        PlanetMap planetMap = this.model.getMap();
        PlanetTile planetTile = (PlanetTile)planetMap.getTile(n, n2);
        planetTile.setOwner(planetMap, player);
        if (resource != null) {
            Factory factory = new Factory(resource, planetTile);
            planetTile.addBuilding(planetMap, this.model.getHirelingManager(), factory);
        }
        return planetTile;
    }

    public void timerFinished(NetworkTimer networkTimer) {
    }

    private void testMasterConnection() {
        this.controller.getMasterClient().sendTestConnection();
    }

    private void getMasterUserInfo(User user) {
        if (user != null) {
            if (user.getUserId() != 0L) {
                this.logger.info("Fetching user info for " + user.toString() + " (ID: " + user.getUserId() + ")");
                this.controller.getMasterClient().getUserInfo(user.getUserId(), this.model.getGameInfo().getMode().getIdentifier());
            } else {
                this.userNotLoggedIn(user);
            }
        }
    }

    private void userNotLoggedIn(User user) {
        this.controller.sendSystemChatMessage("%s is not logged in", user);
        if (this.model.getGameInfo().getMode() == GameMode.TOURNAMENT && !this.shownNoUserAccountWarning) {
            this.controller.sendSystemChatMessage("Games are ranked only if 2 or more players are logged in");
            this.shownNoUserAccountWarning = true;
        }
    }

    public void apply(UDPMessage.UDPInitMessage uDPInitMessage) {
        this.logger.info("My UDP connection is initialized");
    }

    private class MasterListener
    extends MasterClientListener {
        private MasterListener() {
        }

        public void apply(MasterResponse.TestConnection testConnection) {
            if (testConnection.isSuccess()) {
                if (!GameLobbyPhase.this.sentNewGame) {
                    GameInfo gameInfo = GameLobbyPhase.this.model.getGameInfo();
                    GameLobbyPhase.this.controller.getMasterClient().sendNewGame(gameInfo.getGameName(), gameInfo.getMode().getIdentifier(), gameInfo.isSingleDevelopment(), gameInfo.isRiver(), gameInfo.getLastRound(), gameInfo.isAllowSpectators());
                    GameLobbyPhase.this.sentNewGame = true;
                }
            } else {
                String string = "Players can't connect to your game. Please validate that you have forwarded port " + Properties.mule.SERVER_TCP_PORT + " to you local IP address.\n" + testConnection.getSocketError() + "\nRetrying connection... (" + GameLobbyPhase.this.connectionAttempt + ")";
                GameLobbyPhase.this.masterServerError = GameLobbyPhase.this.lineBreaker.breakLines(string);
                GameLobbyPhase.this.connectionAttempt = (GameLobbyPhase.this.connectionAttempt + 1) % 100;
                GameLobbyPhase.this.testConnectionTimer.start(10.0f);
            }
        }

        public void apply(MasterResponse.NewGame newGame) {
            if (newGame.isError()) {
                String string = "Connection Error: " + newGame.getError();
                GameLobbyPhase.this.masterServerError = GameLobbyPhase.this.lineBreaker.breakLines(string);
            } else {
                GameLobbyPhase.this.masterServerError = null;
                GameInfo gameInfo = GameLobbyPhase.this.model.getGameInfo();
                gameInfo.setGameID(newGame.getGameID());
                gameInfo.setCoordinate(newGame.getCoordinate());
                gameInfo.setServerAddress(newGame.getServerAddress());
                GameLobbyPhase.this.model.setGameInfo(gameInfo);
                GameLobbyPhase.this.logger.info("Master server gives game ID " + GameLobbyPhase.this.model.getGameInfo().getGameID());
                for (User user : GameLobbyPhase.this.model.getUsers()) {
                    GameLobbyPhase.this.controller.getMasterClient().sendUserJoin(user.getUserId(), user.getUserNumber(), user.getName());
                }
            }
        }

        public void apply(MasterResponse.UserInfo userInfo) {
            long l = userInfo.getUserId();
            User user = GameLobbyPhase.this.model.getUserById(l);
            if (user == null) {
                GameLobbyPhase.this.logger.warning("Got user info for user ID " + l + " who's not in the game");
                return;
            }
            if (userInfo.isError()) {
                GameLobbyPhase.this.logger.warning("Couldn't get user info for " + user.toString() + ": " + userInfo.getError());
                return;
            }
            if (!userInfo.exists()) {
                GameLobbyPhase.this.logger.warning("User ID " + l + " doesn't exist on the master server");
                GameLobbyPhase.this.userNotLoggedIn(user);
                return;
            }
            GameLobbyPhase.this.logger.info("Got user info for " + user.toString() + " (ID " + l + ")");
            user.setIpAddress(userInfo.getIpAddress());
            UserStatistics userStatistics = user.getStatistics();
            if (userStatistics == null) {
                userStatistics = new UserStatistics(userInfo.getRank());
                user.setStatistics(userStatistics);
            }
            GameMode gameMode = GameLobbyPhase.this.model.getGameInfo().getMode();
            UserStatistics.GameModeStatistics gameModeStatistics = userInfo.getStatistics();
            if (gameModeStatistics != null) {
                userStatistics.putGameModeStatistics(gameMode, gameModeStatistics);
                GameLobbyPhase.this.model.userStatistics(user);
            } else {
                GameLobbyPhase.this.logger.info("No statistics available for " + user.toString() + " (ID " + l + ")");
            }
            GameLobbyPhase.this.checkSameAddresses(user);
        }

        public void apply(MasterResponse.AvatarImage avatarImage) {
            long l = avatarImage.getUserId();
            User user = GameLobbyPhase.this.model.getUserById(l);
            if (user != null && user instanceof Player) {
                Player player = (Player)user;
                if (avatarImage.hasImage()) {
                    GameLobbyPhase.this.logger.info("Loading avatar image for " + player.toString());
                    GameLobbyPhase.this.view.getAvatarImageStore().putImage(l, avatarImage.getInputStream());
                } else {
                    GameLobbyPhase.this.logger.info(player.toString() + " has no avatar image");
                }
            } else {
                GameLobbyPhase.this.logger.warning("Got avatar image for player ID " + l + " who's not in the game.");
            }
        }
    }
}

