/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.controller.phase;

import com.turborilla.mule.MuleException;
import com.turborilla.mule.Properties;
import com.turborilla.mule.controller.phase.PhaseController;
import com.turborilla.mule.model.Phase;
import com.turborilla.mule.model.User;
import com.turborilla.mule.model.UserInfo;
import com.turborilla.mule.model.util.NetworkTimer;
import com.turborilla.mule.network.Client;
import com.turborilla.mule.network.Server;
import com.turborilla.mule.network.ServerMessageHandler;
import com.turborilla.mule.network.TCPMessage;
import com.turborilla.mule.view.GameInput;
import com.turborilla.mule.view.Transition;
import com.turborilla.mule.view.View;
import java.io.IOException;
import java.util.logging.Logger;
import org.lwjgl.opengl.GL11;
import org.newdawn.slick.Color;

public class ConnectPhase
extends PhaseController {
    private Logger logger = Logger.getLogger("mule");
    private TCPMessage.ServerInfoMessage serverInfo;
    private String connectFailure;

    public void begin() {
        this.serverInfo = null;
        UserInfo userInfo = this.controller.getUserInfo();
        if (userInfo.isServer()) {
            this.initializeGame();
            try {
                this.controller.setServer(new Server(new ServerMessageHandler()));
            }
            catch (MuleException muleException) {
                this.connectFailure = muleException.getMessage();
                this.logger.severe(muleException.getMessage());
            }
        }
        if (this.connectFailure == null) {
            try {
                this.controller.getClient().connect(this.model.getGameInfo().getServerAddress());
            }
            catch (MuleException muleException) {
                this.connectFailure = muleException.getMessage() != null ? muleException.getMessage() : muleException.getClass().getSimpleName();
                this.logger.warning("Client failed to connect to server: " + this.connectFailure);
            }
        }
        this.view.setHUDEnabled(false);
    }

    public void draw() {
        GL11.glClear(16384);
        View.TextStyle textStyle = View.TextStyle.BIG;
        View.TextStyle textStyle2 = View.TextStyle.DISPLAY;
        if (this.serverInfo == null) {
            long l = this.controller.getFrame() % 200L;
            String string = null;
            string = l < 40L ? "Connecting" : (l < 80L ? "Connecting." : (l < 120L ? "Connecting.." : (l < 160L ? "Connecting..." : "Connecting....")));
            textStyle.print(string, 320 - textStyle.getWidth("Connecting") / 2, 100);
        } else {
            textStyle.printCentered("Awaiting Game State", 320, 100);
            textStyle2.printCentered("PLAYERS: " + this.serverInfo.numPlayers, 320, 210);
            textStyle2.printCentered("VISITORS: " + this.serverInfo.numSpectators, 320, 230);
        }
        String string = this.model.getGameInfo().getServerAddress();
        textStyle2.printCentered("ADDRESS: " + string, 320, 150);
        if (this.connectFailure != null) {
            textStyle2.printCentered("CONNECTION FAILED", Color.red, 320, 170);
            textStyle2.printCentered(this.connectFailure, Color.red, 320, 190);
        }
    }

    public Transition end() {
        this.serverInfo = null;
        return null;
    }

    public void timerFinished(NetworkTimer networkTimer) {
    }

    public void update(GameInput gameInput) {
        Client client = this.controller.getClient();
        if (!client.isConnected()) {
            try {
                if (client.finishConnect()) {
                    this.sendJoin();
                }
            }
            catch (IOException iOException) {
                this.logger.severe(iOException.getMessage());
            }
        }
    }

    private void sendJoin() {
        Client client = this.controller.getClient();
        UserInfo userInfo = this.controller.getUserInfo();
        client.sendTCP(new TCPMessage.JoinMessage(userInfo.getUserId(), userInfo.getName(), userInfo.getRace()));
    }

    public void apply(TCPMessage.ServerInfoMessage serverInfoMessage) {
        if (serverInfoMessage.gameStarted && !serverInfoMessage.allowSpectators) {
            this.controller.requestClose("Game has started and visitors\nare not allowed to join.", false);
            return;
        }
        if (serverInfoMessage.numPlayers + serverInfoMessage.numSpectators >= Properties.mule.maxNumUsers) {
            this.controller.requestClose("Game is full", false);
            return;
        }
        this.serverInfo = serverInfoMessage;
    }

    public void apply(TCPMessage.JoinMessage joinMessage) {
        User user;
        if (this.controller.isServer() && (user = this.model.getMyUser()) != null) {
            this.model.setServerUser(this.model.getMyUser());
            this.model.setNextPhase(Phase.GAME_LOBBY);
            this.model.forceUsersReady();
            this.controller.beginNextPhase();
        }
    }

    private void initializeGame() {
        this.model.initializeGame();
    }
}

