/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.controller.phase;

import com.turborilla.mule.Properties;
import com.turborilla.mule.ai.AbstractAI;
import com.turborilla.mule.controller.AbstractAuctionController;
import com.turborilla.mule.controller.PlayerController;
import com.turborilla.mule.controller.phase.PhaseController;
import com.turborilla.mule.model.Auction;
import com.turborilla.mule.model.AuctionLimits;
import com.turborilla.mule.model.AuctionState;
import com.turborilla.mule.model.Phase;
import com.turborilla.mule.model.Player;
import com.turborilla.mule.model.Resource;
import com.turborilla.mule.model.Shop;
import com.turborilla.mule.model.User;
import com.turborilla.mule.model.util.NetworkTimer;
import com.turborilla.mule.model.util.Timer;
import com.turborilla.mule.network.Client;
import com.turborilla.mule.network.TCPMessage;
import com.turborilla.mule.network.UDPMessage;
import com.turborilla.mule.sound.SoundPlayer;
import com.turborilla.mule.view.ActorSprite;
import com.turborilla.mule.view.BlobbyTransition;
import com.turborilla.mule.view.GameInput;
import com.turborilla.mule.view.Transition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Logger;

public abstract class AbstractAuctionPhase
extends PhaseController
implements AbstractAuctionController.TransactionCountCallback {
    private static Logger logger = Logger.getLogger("mule");
    protected int shopBuyPrice;
    protected int shopSellPrice;
    protected AbstractAuctionController auctionController;
    private ArrayList<Integer> tradingBuyers;
    private ArrayList<Integer> tradingSellers;
    private int tradeTick;
    private boolean tradersLocked;
    private long transactionTime;
    private int unitsTraded;
    private long tradeCooldown;
    private float transactionPitch;
    private boolean startedTransaction;
    private long highestRoundtripTime;
    private int totalUnitsTraded;
    private int totalUnitsPrice;
    private boolean auctionStarted;
    private boolean skipAuction;
    private boolean storeClosed;
    private Timer introTimer = new Timer(){

        public void finished() {
            if (AbstractAuctionPhase.this.controller.isServer()) {
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
                for (Player object2 : AbstractAuctionPhase.this.model.getPlayers()) {
                    if (object2.isBuyer()) {
                        arrayList.add(object2.getUserNumber());
                        continue;
                    }
                    arrayList2.add(object2.getUserNumber());
                }
                TCPMessage.StartAuctionMessage startAuctionMessage = new TCPMessage.StartAuctionMessage(arrayList, arrayList2);
                TCPMessage.SynchronizedMessage synchronizedMessage = new TCPMessage.SynchronizedMessage(startAuctionMessage);
                AbstractAuctionPhase.this.controller.getClient().sendTCP(synchronizedMessage);
            }
        }
    };
    private Timer outroTimer = new Timer(){

        public void finished() {
            switch (AbstractAuctionPhase.this.auctionController.getResource()) {
                case Smithore: {
                    AbstractAuctionPhase.this.model.setNextPhase(Phase.COLLECTION_CRYSTITE);
                    break;
                }
                case Crystite: {
                    AbstractAuctionPhase.this.model.setNextPhase(Phase.COLLECTION_FOOD);
                    break;
                }
                case Food: {
                    AbstractAuctionPhase.this.model.setNextPhase(Phase.COLLECTION_ENERGY);
                    break;
                }
                case Energy: {
                    AbstractAuctionPhase.this.model.setNextPhase(Phase.SUMMARY);
                }
            }
            AbstractAuctionPhase.this.sendReady();
        }
    };

    protected AbstractAuctionPhase(AbstractAuctionController abstractAuctionController) {
        this.auctionController = abstractAuctionController;
        this.tradingBuyers = new ArrayList(4);
        this.tradingSellers = new ArrayList(4);
    }

    public void begin() {
        Resource resource = this.auctionController.getResource();
        Shop shop = this.model.getShop();
        this.auctionController.begin(this.model, this.controller, SoundPlayer.get(), shop.getBuyPrice(resource), shop.getSellPrice(resource));
        int n = this.model.getAuction().getCurrentLimits().getMaxOutOfAuctionTicks();
        for (Player player : this.model.getPlayers()) {
            int n2;
            int n3;
            player.getAvatar().setInShop(true);
            player.setBuyer(true, n);
            if (!this.model.isLastRound() && (n3 = player.getResource(resource)) > (n2 = player.getResourceCritical(resource, this.model))) {
                player.setBuyer(false, n);
            }
            player.resetAuctionTeleportCount();
        }
        this.auctionStarted = false;
        this.tradingBuyers.clear();
        this.tradingSellers.clear();
        this.tradersLocked = false;
        this.transactionTime = 0L;
        this.unitsTraded = 0;
        this.tradeCooldown = 0L;
        this.transactionPitch = 1.0f;
        this.startedTransaction = false;
        this.totalUnitsTraded = 0;
        this.totalUnitsPrice = 0;
        this.model.getCountdown().reset();
        this.model.getPhaseTimer().reset();
        this.introTimer.reset();
        this.outroTimer.reset();
        this.storeClosed = false;
        if (this.model.isLastRound()) {
            this.skipAuction = true;
            this.outroTimer.start(Properties.mule.skipAuctionTime);
        } else if (!this.model.isResourceAvailable(resource)) {
            this.skipAuction = true;
            this.outroTimer.start(Properties.mule.skipAuctionTime);
            SoundPlayer.get().playSkipAuction();
        } else {
            this.skipAuction = false;
            SoundPlayer.get().playStartAuction();
            float f = Properties.mule.auctionChooseBuySellTime + Properties.mule.auctionCountdownTime;
            this.model.getCountdown().start(f, this.controller.getClient());
            int n4 = (int)Properties.mule.auctionCountdownTime;
            SoundPlayer.get().trackCountdown(this.model.getCountdown(), n4);
        }
        this.view.fadeTitle();
        this.shopBuyPrice = this.model.getShop().getBuyPrice(resource);
        this.shopSellPrice = this.model.getShop().getSellPrice(resource);
    }

    private void calcRoundtripTime() {
        if (this.controller.isServer()) {
            this.highestRoundtripTime = this.controller.getServer().getMaxSafeRoundtrip();
            logger.info("Auction uses roundtrip: " + this.highestRoundtripTime + "ms");
        } else {
            this.highestRoundtripTime = 0L;
        }
    }

    public final void update(GameInput gameInput) {
        this.view.getAuctionPainter2().update();
        this.introTimer.tick(Properties.mule.delta);
        this.outroTimer.tick(Properties.mule.delta);
        Client client = this.controller.getClient();
        for (Player player : this.model.getPlayers()) {
            player.getAvatar().updateActor();
        }
        if (!this.skipAuction) {
            if (!this.auctionStarted) {
                if (this.model.getCountdown().getTime() > 0.0f) {
                    for (Player player : this.model.getLocalPlayers()) {
                        PlayerController playerController = player.getController();
                        if (playerController.isUpPressed()) {
                            player.sendUnordered(client, new TCPMessage.ChooseDirectionMessage(ActorSprite.Direction.North));
                            continue;
                        }
                        if (!playerController.isDownPressed()) continue;
                        player.sendUnordered(client, new TCPMessage.ChooseDirectionMessage(ActorSprite.Direction.South));
                    }
                }
            } else if (!this.model.getPhaseTimer().isFinished()) {
                this.auctionController.update(gameInput);
                if (!this.storeClosed) {
                    User user;
                    AuctionLimits auctionLimits = this.model.getAuction().getCurrentLimits();
                    int n = auctionLimits.priceToMaxTick(this.shopSellPrice);
                    if (auctionLimits.getMaxTick() > n && (user = this.model.getMyUser()) instanceof Player) {
                        user.sendToOthers(this.controller.getClient(), new TCPMessage.StoreClosedMessage());
                        this.storeClosed();
                    }
                }
                if (this.controller.isServer()) {
                    this.checkCancelTransactions();
                    this.doTransactions();
                }
            }
        }
    }

    public void apply(TCPMessage.StoreClosedMessage storeClosedMessage) {
        if (!this.storeClosed) {
            this.storeClosed();
        }
    }

    private void storeClosed() {
        AuctionLimits auctionLimits = this.model.getAuction().getCurrentLimits();
        AuctionLimits auctionLimits2 = this.model.getAuction().getTargetLimits();
        int n = auctionLimits.priceToMaxTick(this.shopSellPrice);
        auctionLimits.increaseMaxTick(n + 1);
        auctionLimits2.increaseMaxTick(n + 1);
        logger.info("Store closed. Current max tick: " + auctionLimits.getMaxTick());
        this.storeClosed = true;
    }

    protected boolean isStoreClosed() {
        return this.storeClosed;
    }

    public void apply(TCPMessage.StartAuctionMessage startAuctionMessage) {
        Player player;
        this.auctionStarted = true;
        this.model.getCountdown().stop();
        this.calcRoundtripTime();
        int n = this.model.getAuction().getCurrentLimits().getMaxOutOfAuctionTicks();
        for (Integer serializable : startAuctionMessage.buyers) {
            player = this.model.getPlayer(serializable);
            if (player == null) continue;
            player.setBuyer(true, n);
        }
        for (Integer n2 : startAuctionMessage.sellers) {
            player = this.model.getPlayer(n2);
            if (player == null) continue;
            player.setBuyer(false, n);
        }
        if (!this.goodsForSale()) {
            this.skipAuction = true;
            this.outroTimer.start(Properties.mule.noGoodsForSaleTime);
            SoundPlayer.get().playSkipAuction();
        } else {
            this.auctionController.startAuction(Properties.mule.auctionTime);
            this.view.getAuctionPainter2().startGoText();
            SoundPlayer.get().playCountdownGo();
            SoundPlayer.get().trackTimer(this.model.getPhaseTimer(), Properties.mule.auctionTickTime);
            for (AbstractAI abstractAI : this.model.getAiSystem().getAIs()) {
                abstractAI.beginAuction(this.model);
            }
        }
        this.view.fadeTerminalMessage();
    }

    public final void timerFinished(NetworkTimer networkTimer) {
        if (networkTimer == this.model.getCountdown()) {
            if (this.controller.isServer()) {
                float f = (float)this.controller.getServer().getMaxRoundtrip() / 1000.0f;
                float f2 = 1.0f - f;
                logger.info("Starting auction in " + f2 + " seconds");
                this.introTimer.start(f2);
            }
        } else if (networkTimer == this.model.getPhaseTimer()) {
            this.auctionController.auctionFinished();
            this.outroTimer.start(3.0f);
            SoundPlayer.get().stopTicking();
            SoundPlayer.get().playAuctionEnded();
        }
    }

    public void apply(TCPMessage.ChooseDirectionMessage chooseDirectionMessage) {
        Player player = this.model.getPlayer(chooseDirectionMessage.getUserNumber());
        if (player == null) {
            return;
        }
        if (this.auctionStarted) {
            return;
        }
        int n = this.model.getAuction().getCurrentLimits().getMaxOutOfAuctionTicks();
        if (chooseDirectionMessage.direction == ActorSprite.Direction.North) {
            if (player.getResource(this.auctionController.getResource()) > 0) {
                player.setBuyer(false, n);
            }
        } else if (chooseDirectionMessage.direction == ActorSprite.Direction.South) {
            player.setBuyer(true, n);
        }
        if (this.model.getCountdown().isFinished()) {
            logger.info("Choose direction arrived after countdown finished");
            this.model.getAuction().setBuyersAndSellers(this.model);
        }
    }

    private void stopTrading() {
        if (this.unitsTraded > 0) {
            this.tradeCooldown = Properties.mule.transactionTime;
        }
        this.tradeTick = 0;
        this.transactionTime = 0L;
        this.tradersLocked = false;
        this.unitsTraded = 0;
    }

    private void doTransactions() {
        Auction auction = this.model.getAuction();
        AuctionLimits auctionLimits = auction.getCurrentLimits();
        if (this.tradeCooldown != 0L) {
            this.tradeCooldown -= (long)(1000 / Properties.mule.framesPerSecond);
            if (this.tradeCooldown <= 0L) {
                this.tradeCooldown = 0L;
            }
        }
        if (auctionLimits.auctionBuyTick == auctionLimits.auctionSellTick) {
            if (this.tradeTick != auctionLimits.auctionBuyTick) {
                this.stopTrading();
                this.tradeTick = auctionLimits.auctionBuyTick;
            }
        } else {
            if (this.startedTransaction) {
                this.stopTrading();
                this.controller.getClient().sendTCP(new TCPMessage.EndTransactionMessage());
                this.startedTransaction = false;
            }
            return;
        }
        if (this.transactionTime == 0L) {
            long l;
            ArrayList<Player> arrayList = auction.getBuyers();
            ArrayList<Player> arrayList2 = auction.getSellers();
            if (!this.tradersLocked) {
                Collections.sort(arrayList, new AuctionLimits.PlayersByPriceBigFirst());
                Collections.sort(arrayList2, new AuctionLimits.PlayersByPriceSmallFirst());
                this.tradingBuyers.clear();
                this.tradingSellers.clear();
                if (!arrayList.isEmpty() && !arrayList2.isEmpty()) {
                    Player player = arrayList.get(0);
                    Player player2 = arrayList2.get(0);
                    if (player.getAuctionState().getTick() == this.tradeTick && player2.getAuctionState().getTick() == this.tradeTick) {
                        this.tradingBuyers.add(player.getUserNumber());
                        this.tradingSellers.add(player2.getUserNumber());
                    }
                }
                if (this.tradingBuyers.isEmpty() && this.tradingSellers.isEmpty()) {
                    int n = this.model.getShop().getBuyPrice(this.auctionController.getResource());
                    int n2 = this.model.getShop().getSellPrice(this.auctionController.getResource());
                    int n3 = auctionLimits.priceToMinTick(n);
                    int n4 = auctionLimits.priceToMaxTick(n2);
                    if (this.tradeTick == n4) {
                        Player player = arrayList.get(0);
                        if (player.getAuctionState().getTick() == this.tradeTick) {
                            this.tradingBuyers.add(player.getUserNumber());
                        }
                    } else if (this.tradeTick == n3 && !arrayList2.isEmpty()) {
                        for (Player player : arrayList2) {
                            if (player.getAuctionState().getTick() != this.tradeTick) continue;
                            this.tradingSellers.add(player.getUserNumber());
                        }
                    }
                }
            } else if (this.tradingBuyers.isEmpty()) {
                this.tradingSellers.clear();
                for (Player player : arrayList2) {
                    if (player.getAuctionState().getTick() != this.tradeTick) continue;
                    this.tradingSellers.add(player.getUserNumber());
                }
            }
            if (this.tradingBuyers.isEmpty() && this.tradingSellers.isEmpty()) {
                logger.severe("No players are in transaction even though a trade is going on!");
                return;
            }
            if (this.unitsTraded == 0) {
                l = Properties.mule.transactionTimeStart;
                if (this.tradeCooldown > l) {
                    l = this.tradeCooldown;
                }
                l += Math.min(this.highestRoundtripTime, 800L);
            } else {
                l = Properties.mule.transactionTime;
                long l2 = this.unitsTraded * Properties.mule.transactionTimeDecrease;
                l -= l2;
            }
            if (l <= (long)Properties.mule.transactionMinTime) {
                l = Properties.mule.transactionMinTime;
            }
            ++this.unitsTraded;
            this.transactionTime = System.currentTimeMillis() + l;
            if (!this.startedTransaction) {
                this.controller.getClient().sendTCP(new TCPMessage.BeginTransactionMessage());
                this.startedTransaction = true;
            }
        } else if (System.currentTimeMillis() >= this.transactionTime) {
            if (!this.readyForTransaction()) {
                return;
            }
            if (this.tradingBuyers.isEmpty() && this.tradingSellers.isEmpty()) {
                logger.severe("No buyer or seller in transaction.");
            } else {
                int n = auctionLimits.tickToPrice(this.tradeTick);
                TCPMessage.TransactionMessage transactionMessage = new TCPMessage.TransactionMessage(n, this.tradingBuyers, this.tradingSellers);
                this.controller.getClient().sendTCP(transactionMessage);
                this.auctionController.transaction();
                this.tradersLocked = true;
            }
            this.transactionTime = 0L;
        }
    }

    private boolean readyForTransaction() {
        short s = this.auctionController.getTransaction();
        for (Player player : this.model.getPlayers()) {
            if (s == player.getAuctionTransactionCount()) continue;
            return false;
        }
        return true;
    }

    public void playerTransactionCount() {
        if (this.transactionTime > 0L && this.readyForTransaction()) {
            long l;
            long l2 = Properties.mule.transactionGraceTime;
            if ((l2 -= (long)((this.unitsTraded - 1) * Properties.mule.transactionGraceDecrease)) < (long)Properties.mule.transactionGraceMin) {
                l2 = Properties.mule.transactionGraceMin;
            }
            if ((l = System.currentTimeMillis() + l2) > this.transactionTime) {
                logger.info("Adding transaction grace time " + l2 + "ms");
                this.transactionTime = l;
            }
        }
    }

    public void userRemoved(User user) {
        if (this.controller.isServer()) {
            logger.info("User taken over by AI. Setting local users transaction count to " + this.auctionController.getTransaction());
            for (Player player : this.model.getLocalPlayers()) {
                player.setAuctionTransactionCount(this.auctionController.getTransaction());
            }
        }
    }

    public void apply(TCPMessage.BeginTransactionMessage beginTransactionMessage) {
        this.model.getPhaseTimer().pause(true);
    }

    public void apply(TCPMessage.EndTransactionMessage endTransactionMessage) {
        this.model.getPhaseTimer().pause(false);
        this.calcRoundtripTime();
    }

    public void apply(TCPMessage.TransactionMessage transactionMessage) {
        boolean bl;
        Object object;
        int n;
        Resource resource = this.auctionController.getResource();
        Shop shop = this.model.getShop();
        int n2 = 0;
        if (transactionMessage.sellers.isEmpty()) {
            for (Integer serializable : transactionMessage.buyers) {
                Player player = this.model.getPlayer(serializable);
                n = shop.getResource(resource);
                int n3 = player.getMoney();
                if (n == 0 || transactionMessage.price > n3) continue;
                shop.setResource(resource, n - 1);
                player.setResource(resource, player.getResource(resource) + 1);
                player.setMoney(player.getMoney() - transactionMessage.price);
                player.getAvatar().getBlink().blink();
                ++n2;
            }
        } else if (transactionMessage.buyers.isEmpty()) {
            for (Integer bl2 : transactionMessage.sellers) {
                Player player = this.model.getPlayer(bl2);
                n = player.getResource(resource);
                if (n <= 0) continue;
                if (resource != Resource.Crystite) {
                    shop.setResource(resource, shop.getResource(resource) + 1);
                }
                player.setResource(resource, n - 1);
                player.setMoney(player.getMoney() + transactionMessage.price);
                player.getAvatar().getBlink().blink();
                ++n2;
            }
        } else {
            object = this.model.getPlayer(transactionMessage.buyers.get(0));
            Player player = this.model.getPlayer(transactionMessage.sellers.get(0));
            int n4 = player.getResource(resource);
            n = ((Player)object).getMoney();
            if (n4 > 0 && transactionMessage.price <= n) {
                player.setResource(resource, n4 - 1);
                player.setMoney(player.getMoney() + transactionMessage.price);
                ((Player)object).setResource(resource, ((Player)object).getResource(resource) + 1);
                ((Player)object).setMoney(((Player)object).getMoney() - transactionMessage.price);
                ((Player)object).getAvatar().getBlink().blink();
                player.getAvatar().getBlink().blink();
                ++n2;
            }
        }
        if (n2 == 0) {
            logger.severe("Transaction is not possible. Buyers: " + transactionMessage.buyers.size() + " Sellers: " + transactionMessage.sellers.size() + " Price: $" + transactionMessage.price);
        }
        this.totalUnitsTraded += n2;
        this.totalUnitsPrice += n2 * transactionMessage.price;
        if (!this.controller.isServer()) {
            this.auctionController.transaction();
        }
        for (Player player : this.model.getLocalPlayers()) {
            player.setAuctionTransactionCount(this.auctionController.getTransaction());
        }
        for (AbstractAI abstractAI : this.model.getAiSystem().getAIs()) {
            abstractAI.transaction(this.model, transactionMessage.buyers, transactionMessage.sellers);
        }
        object = this.model.getAuction().getCurrentLimits();
        boolean bl3 = false;
        if (transactionMessage.sellers.isEmpty() && shop.getResource(resource) == 0) {
            this.tradingBuyers.clear();
            boolean bl4 = true;
        }
        for (Integer n5 : transactionMessage.buyers) {
            Player player = this.model.getPlayer(n5);
            if (player.getMoney() >= transactionMessage.price) continue;
            AuctionState auctionState = player.getAuctionState();
            auctionState.setTick(auctionState.getTick(), (AuctionLimits)object, resource, player);
            player.getTargetAuctionState().copy(auctionState);
            player.increaseAuctionTeleportCount();
            this.tradingBuyers.remove((Object)player.getUserNumber());
            boolean bl5 = true;
            this.tradingSellers.clear();
        }
        for (Integer n6 : transactionMessage.sellers) {
            Player player = this.model.getPlayer(n6);
            int n7 = player.getResource(resource);
            int n8 = player.getResourceCritical(resource, this.model);
            if (n7 != 0 && n7 != n8) continue;
            this.tradingSellers.remove((Object)player.getUserNumber());
            int n9 = this.model.getAuction().getCurrentLimits().getMaxOutOfAuctionTicks();
            player.setBuyer(false, n9);
            player.increaseAuctionTeleportCount();
            bl = true;
            this.tradingBuyers.clear();
        }
        if (bl) {
            if (this.tradingBuyers.isEmpty() && this.tradingSellers.isEmpty()) {
                this.stopTrading();
            }
            SoundPlayer.get().playTransactionEnded();
        } else {
            SoundPlayer.get().playTransaction(this.transactionPitch);
        }
    }

    private void checkCancelTransactions() {
        AuctionLimits auctionLimits = this.model.getAuction().getCurrentLimits();
        if (auctionLimits.auctionBuyTick == auctionLimits.auctionSellTick) {
            for (Player player : this.model.getPlayers()) {
                Player player2;
                int n;
                boolean bl = player.isBuyer() ? this.tradingBuyers.contains(player.getUserNumber()) : this.tradingSellers.contains(player.getUserNumber());
                AuctionState auctionState = player.getTargetAuctionState();
                int n2 = n = auctionState.isInAuction() ? auctionState.getTick() : -1;
                if (bl && n != this.tradeTick) {
                    if (player.isBuyer()) {
                        logger.info("Buyer left auction line.");
                        this.stopTrading();
                        break;
                    }
                    this.tradingSellers.remove((Object)player.getUserNumber());
                    if (!this.tradingSellers.isEmpty()) continue;
                    this.stopTrading();
                    break;
                }
                if (bl || n != this.tradeTick) continue;
                if (player.isBuyer()) {
                    if (this.tradersLocked || this.tradingBuyers.isEmpty()) continue;
                    player2 = this.model.getPlayer(this.tradingBuyers.get(0));
                    if (player.getRank() <= player2.getRank()) continue;
                    logger.info("Buyer " + player.getName() + " rank " + player.getRank() + " takes over trade from buyer " + player2.getName() + " rank " + player2.getRank());
                    this.stopTrading();
                    break;
                }
                if (!this.tradersLocked) {
                    if (this.tradingBuyers.isEmpty() || this.tradingSellers.isEmpty()) {
                        this.stopTrading();
                        break;
                    }
                    player2 = this.model.getPlayer(this.tradingSellers.get(0));
                    if (player.getRank() <= player2.getRank()) continue;
                    logger.info("Seller " + player.getName() + " rank " + player.getRank() + " takes over trade from seller " + player2.getName() + " rank " + player2.getRank());
                    this.stopTrading();
                    break;
                }
                if (!this.tradingBuyers.isEmpty()) continue;
                logger.info("New seller enters shop line");
                this.stopTrading();
                this.tradersLocked = true;
                break;
            }
        }
    }

    private boolean goodsForSale() {
        Resource resource = this.auctionController.getResource();
        if (this.model.getShop().getResource(resource) > 0) {
            return true;
        }
        for (Player player : this.model.getPlayers()) {
            if (player.isBuyer() || player.getResource(resource) <= 0) continue;
            return true;
        }
        return false;
    }

    public void apply(UDPMessage.TotalAuctionStateMessage totalAuctionStateMessage) {
        this.auctionController.apply(totalAuctionStateMessage);
    }

    public void apply(UDPMessage.PlayerAuctionStateMessage playerAuctionStateMessage) {
        this.auctionController.apply(playerAuctionStateMessage, this);
    }

    private void sendReady() {
        for (User user : this.model.getLocalUsers()) {
            user.send(this.controller.getClient(), new TCPMessage.ReadyMessage(this.controller.getFrame()));
        }
    }

    public Transition end() {
        this.auctionController.end();
        if (!this.model.isLastRound()) {
            this.model.getShop().setAveragePrice(this.auctionController.getResource(), this.totalUnitsPrice, this.totalUnitsTraded);
        } else {
            logger.info("No average price on last round");
        }
        if (this.model.getNextPhase() == Phase.SUMMARY) {
            this.view.getHUDPainter().setResourceHighlight(null);
            return BlobbyTransition.createPlayAreaTransition();
        }
        return null;
    }

    protected boolean isSkipAuction() {
        return this.skipAuction;
    }

    protected final Resource getResource() {
        return this.auctionController.getResource();
    }
}

