/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.controller;

import com.turborilla.mule.MuleException;
import com.turborilla.mule.model.GameInfo;
import com.turborilla.mule.model.UserInfo;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReconnectFile
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger("mule");
    public int userNumber;
    public long clientId;
    public GameInfo gameInfo;
    public UserInfo userInfo;
    public HashMap<Long, Integer> reservedUserNumbers;

    public ReconnectFile(int n, long l, GameInfo gameInfo, UserInfo userInfo, HashMap<Long, Integer> hashMap) {
        this.userNumber = n;
        this.clientId = l;
        this.gameInfo = gameInfo;
        this.userInfo = userInfo;
        this.reservedUserNumbers = hashMap;
    }

    public static ReconnectFile read(String string) throws MuleException {
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(string));
            ReconnectFile reconnectFile = (ReconnectFile)objectInputStream.readObject();
            return reconnectFile;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new MuleException("Reconnect file not found. " + fileNotFoundException.getMessage());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new MuleException("Invalid reconnect file. " + classNotFoundException.getMessage());
        }
        catch (IOException iOException) {
            throw new MuleException("Reconnect file IO error. " + iOException.getMessage());
        }
    }

    public void write() {
        try {
            String string = this.userInfo.getReconnectFile();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(string));
            objectOutputStream.writeObject(this);
            objectOutputStream.flush();
        }
        catch (FileNotFoundException fileNotFoundException) {
            logger.warning("Failed to create reconnect file. " + fileNotFoundException.getMessage());
        }
        catch (IOException iOException) {
            logger.warning("Reconnect file IO error. " + iOException.getMessage());
        }
    }

    public static class ClientInfo
    implements Serializable {
        private static final long serialVersionUID = 5171012336167667023L;
        public final int userNumber;
        public final String hostAddress;

        public ClientInfo(int n, String string) {
            this.userNumber = n;
            this.hostAddress = string;
        }
    }
}

